/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.documentdata.list;

import androidx.recyclerview.widget.DiffUtil;
import io.scanbot.sdk.genericdocument.entity.CommonFieldType;
import io.scanbot.sdk.genericdocument.entity.OcrResult;
import io.scanbot.sdk.ui.view.documentdata.list.DocumentDataListViewModel;
import io.scanbot.sdk.ui.view.documentdata.list.FieldDataViewModel;
import io.scanbot.sdk.ui.view.documentdata.list.SectionDataViewModel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lio/scanbot/sdk/ui/view/documentdata/list/DocumentFieldDiffCallback;", "Landroidx/recyclerview/widget/DiffUtil$ItemCallback;", "Lio/scanbot/sdk/ui/view/documentdata/list/DocumentDataListViewModel;", "()V", "areContentsTheSame", "", "oldItem", "newItem", "areItemsTheSame", "rtu-ui-documentdata_release"})
final class DocumentFieldDiffCallback
extends DiffUtil.ItemCallback<DocumentDataListViewModel> {
    public boolean areItemsTheSame(@NotNull DocumentDataListViewModel oldItem, @NotNull DocumentDataListViewModel newItem) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)oldItem, (String)"oldItem");
        Intrinsics.checkNotNullParameter((Object)newItem, (String)"newItem");
        if (oldItem.getType() != newItem.getType()) {
            return false;
        }
        DocumentDataListViewModel documentDataListViewModel = oldItem;
        if (documentDataListViewModel instanceof FieldDataViewModel) {
            FieldDataViewModel cfr_ignored_0 = (FieldDataViewModel)newItem;
            bl = Intrinsics.areEqual((Object)((FieldDataViewModel)oldItem).getField().getType(), (Object)((FieldDataViewModel)newItem).getField().getType());
        } else if (documentDataListViewModel instanceof SectionDataViewModel) {
            SectionDataViewModel cfr_ignored_1 = (SectionDataViewModel)newItem;
            bl = Intrinsics.areEqual((Object)((SectionDataViewModel)oldItem).getHeader(), (Object)((SectionDataViewModel)newItem).getHeader());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean areContentsTheSame(@NotNull DocumentDataListViewModel oldItem, @NotNull DocumentDataListViewModel newItem) {
        Intrinsics.checkNotNullParameter((Object)oldItem, (String)"oldItem");
        Intrinsics.checkNotNullParameter((Object)newItem, (String)"newItem");
        if (oldItem.getType() != newItem.getType()) {
            return false;
        }
        DocumentDataListViewModel documentDataListViewModel = oldItem;
        if (documentDataListViewModel instanceof FieldDataViewModel) {
            FieldDataViewModel cfr_ignored_0 = (FieldDataViewModel)newItem;
            Object[] objectArray = new CommonFieldType[]{CommonFieldType.PHOTO, CommonFieldType.SIGNATURE};
            if (CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])objectArray), (Object)((FieldDataViewModel)oldItem).getField().getType().getCommonType())) {
                OcrResult ocrResult = ((FieldDataViewModel)oldItem).getField().getValue();
                OcrResult ocrResult2 = ((FieldDataViewModel)newItem).getField().getValue();
                return Intrinsics.areEqual((Double)(ocrResult != null ? Double.valueOf(ocrResult.getConfidence()) : null), (Double)(ocrResult2 != null ? Double.valueOf(ocrResult2.getConfidence()) : null));
            }
            OcrResult ocrResult = ((FieldDataViewModel)oldItem).getField().getValue();
            OcrResult ocrResult3 = ((FieldDataViewModel)newItem).getField().getValue();
            if (!Intrinsics.areEqual((Object)(ocrResult != null ? ocrResult.getText() : null), (Object)(ocrResult3 != null ? ocrResult3.getText() : null))) return false;
            OcrResult ocrResult4 = ((FieldDataViewModel)oldItem).getField().getValue();
            OcrResult ocrResult5 = ((FieldDataViewModel)newItem).getField().getValue();
            if (!Intrinsics.areEqual((Double)(ocrResult4 != null ? Double.valueOf(ocrResult4.getConfidence()) : null), (Double)(ocrResult5 != null ? Double.valueOf(ocrResult5.getConfidence()) : null))) return false;
            return true;
        }
        if (!(documentDataListViewModel instanceof SectionDataViewModel)) throw new NoWhenBranchMatchedException();
        SectionDataViewModel cfr_ignored_1 = (SectionDataViewModel)newItem;
        return Intrinsics.areEqual((Object)((SectionDataViewModel)oldItem).getHeader(), (Object)((SectionDataViewModel)newItem).getHeader());
    }
}

