/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.generictext.configuration;

import android.content.Context;
import android.util.DisplayMetrics;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.Px;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.scanbot.sdk.camera.CameraModule;
import io.scanbot.sdk.camera.CameraPreviewMode;
import io.scanbot.sdk.security.SapSingleton;
import io.scanbot.sdk.ui.configuration.json.CommonExtensionsKt;
import io.scanbot.sdk.ui.configuration.json.GsonHelper;
import io.scanbot.sdk.ui.configuration.json.JsonColorKt;
import io.scanbot.sdk.ui.view.base.configuration.CameraOrientationMode;
import io.scanbot.sdk.ui.view.generictext.configuration.json.TextDataScannerJsonConfiguration;
import io.scanbot.sdk.ui.view.generictext.configuration.json.TextDataScannerNativeConfiguration;
import io.scanbot.sdk.ui.view.generictext.entity.TextDataScannerStep;
import io.scanbot.sdk.util.JsonConfigUtilsKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Reader;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 ?2\u00020\u0001:\u0001?B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u000f2\b\b\u0001\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u000f2\b\b\u0001\u0010\u0019\u001a\u00020\u0014J\u000e\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001cJ\u000e\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u001cJ\u0010\u0010!\u001a\u00020\u000f2\b\b\u0001\u0010\"\u001a\u00020\u0014J\u0010\u0010#\u001a\u00020\u000f2\b\b\u0001\u0010$\u001a\u00020\u0014J\u0010\u0010%\u001a\u00020\u000f2\b\b\u0001\u0010&\u001a\u00020\u0014J\u000e\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020)J\u000e\u0010*\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020\u0014J\u000e\u0010,\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020\u0014J\u0010\u0010-\u001a\u00020\u000f2\b\b\u0001\u0010.\u001a\u00020\u0014J\u000e\u0010/\u001a\u00020\u000f2\u0006\u00100\u001a\u000201J\u0010\u00102\u001a\u00020\u000f2\b\b\u0001\u00103\u001a\u00020\u0014J\u0010\u00104\u001a\u00020\u000f2\b\b\u0001\u00105\u001a\u00020\u0014J\u0010\u00106\u001a\u00020\u000f2\b\b\u0001\u00107\u001a\u00020\u0014J\u000e\u00108\u001a\u00020\u000f2\u0006\u00109\u001a\u00020)J\u000e\u0010:\u001a\u00020\u000f2\u0006\u0010;\u001a\u00020)J\u0010\u0010<\u001a\u00020\u000f2\b\b\u0001\u0010=\u001a\u00020\u0014J\u000e\u0010>\u001a\u00020\u000f2\u0006\u00109\u001a\u00020)R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006@"}, d2={"Lio/scanbot/sdk/ui/view/generictext/configuration/TextDataScannerConfiguration;", "", "step", "Lio/scanbot/sdk/ui/view/generictext/entity/TextDataScannerStep;", "(Lio/scanbot/sdk/ui/view/generictext/entity/TextDataScannerStep;)V", "config", "Lio/scanbot/sdk/ui/view/generictext/configuration/json/TextDataScannerJsonConfiguration;", "nativeConfig", "Lio/scanbot/sdk/ui/view/generictext/configuration/json/TextDataScannerNativeConfiguration;", "(Lio/scanbot/sdk/ui/view/generictext/configuration/json/TextDataScannerJsonConfiguration;Lio/scanbot/sdk/ui/view/generictext/configuration/json/TextDataScannerNativeConfiguration;)V", "getConfig", "()Lio/scanbot/sdk/ui/view/generictext/configuration/json/TextDataScannerJsonConfiguration;", "getNativeConfig", "()Lio/scanbot/sdk/ui/view/generictext/configuration/json/TextDataScannerNativeConfiguration;", "setCameraModule", "", "cameraModule", "Lio/scanbot/sdk/camera/CameraModule;", "setCameraOverlayColor", "cameraOverlayColor", "", "setCameraPreviewMode", "cameraPreviewMode", "Lio/scanbot/sdk/camera/CameraPreviewMode;", "setCancelButtonIcon", "cancelButtonIcon", "setCancelButtonTitle", "cancelButtonTitle", "", "setEnableCameraButtonTitle", "enableCameraButtonTitle", "setEnableCameraExplanationText", "enableCameraExplanationText", "setFinderLineColor", "finderLineColor", "setFinderLineWidth", "finderLineWidth", "setFinderTextHintColor", "finderTextHintColor", "setFlashEnabled", "flashEnabled", "", "setMaximumNumberOfAccumulatedFrames", "numberOfFrames", "setMinimumNumberOfRequiredFramesWithEqualRecognitionResult", "setOcrResolutionLimit", "ocrResolutionLimit", "setOrientationLockMode", "cameraOrientationMode", "Lio/scanbot/sdk/ui/view/base/configuration/CameraOrientationMode;", "setTopBarBackgroundColor", "topBarBackgroundColor", "setTopBarButtonsColor", "topBarButtonsColor", "setTopBarButtonsInactiveColor", "topBarButtonsInactiveColor", "setTouchToFocusEnabled", "enabled", "setUseButtonsAllCaps", "allCaps", "setWordBoxHighlightColor", "color", "setWordBoxHighlightEnabled", "Companion", "rtu-ui-generictext_release"})
public final class TextDataScannerConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TextDataScannerJsonConfiguration config;
    @NotNull
    private final TextDataScannerNativeConfiguration nativeConfig;
    @NotNull
    private static final String assetFileJson = "TextDataScreen.json";

    public TextDataScannerConfiguration(@NotNull TextDataScannerJsonConfiguration config, @NotNull TextDataScannerNativeConfiguration nativeConfig) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)nativeConfig, (String)"nativeConfig");
        this.config = config;
        this.nativeConfig = nativeConfig;
    }

    public /* synthetic */ TextDataScannerConfiguration(TextDataScannerJsonConfiguration textDataScannerJsonConfiguration, TextDataScannerNativeConfiguration textDataScannerNativeConfiguration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            textDataScannerNativeConfiguration = new TextDataScannerNativeConfiguration(null, null, null, 7, null);
        }
        this(textDataScannerJsonConfiguration, textDataScannerNativeConfiguration);
    }

    @NotNull
    public final TextDataScannerJsonConfiguration getConfig() {
        return this.config;
    }

    @NotNull
    public final TextDataScannerNativeConfiguration getNativeConfig() {
        return this.nativeConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public TextDataScannerConfiguration(@NotNull TextDataScannerStep step) {
        Object it;
        Object object;
        void assetFileJson$iv;
        void context$iv;
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        Context context = SapSingleton.INSTANCE.getContext();
        String string = assetFileJson;
        Gson gson = GsonHelper.INSTANCE.prepareGson();
        Object var5_5 = null;
        TextDataScannerConfiguration textDataScannerConfiguration = this;
        boolean $i$f$getJsonConfig = false;
        BufferedReader reader$iv = JsonConfigUtilsKt.getJsonReader((Context)context$iv, (String)assetFileJson$iv);
        Closeable closeable = reader$iv;
        Throwable throwable = null;
        try {
            void gson$iv;
            BufferedReader reader$iv2 = (BufferedReader)closeable;
            boolean bl = false;
            String text$iv = TextStreamsKt.readText((Reader)reader$iv2);
            Object object2 = gson$iv.fromJson(text$iv, new TypeToken<Map<String, Object>>(){}.getType());
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"gson.fromJson(text, obje\u2026tring, Any?>?>() {}.type)");
            Map defaultJson$iv = (Map)object2;
            String fullJson$iv = gson$iv.toJson((Object)defaultJson$iv);
            object = gson$iv.fromJson(fullJson$iv, TextDataScannerJsonConfiguration.class);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Object jsonConfig$iv = object;
        textDataScannerConfiguration((TextDataScannerJsonConfiguration)jsonConfig$iv, new TextDataScannerNativeConfiguration(null, null, null, 7, null));
        TextDataScannerStep.CleanRecognitionResultCallback cleanRecognitionResultCallback = step.getCleanRecognitionResultCallback();
        if (cleanRecognitionResultCallback != null) {
            it = cleanRecognitionResultCallback;
            boolean bl = false;
            this.nativeConfig.setCleanRecognitionResultCallback(it.getClass());
        }
        TextDataScannerStep.GenericTextValidationCallback genericTextValidationCallback = step.getValidationCallback();
        if (genericTextValidationCallback != null) {
            it = genericTextValidationCallback;
            boolean bl = false;
            this.nativeConfig.setValidationCallback(it.getClass());
        }
        this.config.setTextDataScannerStep(TextDataScannerStep.Companion.toJson(step));
    }

    public final void setFlashEnabled(boolean flashEnabled) {
        this.config.setFlashEnabled(flashEnabled);
    }

    public final void setOrientationLockMode(@NotNull CameraOrientationMode cameraOrientationMode) {
        Intrinsics.checkNotNullParameter((Object)cameraOrientationMode, (String)"cameraOrientationMode");
        this.config.setOrientationLockMode(CommonExtensionsKt.toJson((CameraOrientationMode)cameraOrientationMode));
    }

    public final void setCameraModule(@NotNull CameraModule cameraModule) {
        Intrinsics.checkNotNullParameter((Object)cameraModule, (String)"cameraModule");
        this.config.setCameraModule(CommonExtensionsKt.toJson((CameraModule)cameraModule));
    }

    public final void setCameraPreviewMode(@NotNull CameraPreviewMode cameraPreviewMode) {
        Intrinsics.checkNotNullParameter((Object)cameraPreviewMode, (String)"cameraPreviewMode");
        this.config.setCameraPreviewMode(CommonExtensionsKt.toJson((CameraPreviewMode)cameraPreviewMode));
    }

    public final void setTopBarBackgroundColor(@ColorInt int topBarBackgroundColor) {
        this.config.setTopBarBackgroundColor(JsonColorKt.toJsonColor((int)topBarBackgroundColor));
    }

    public final void setTopBarButtonsColor(@ColorInt int topBarButtonsColor) {
        this.config.setTopBarButtonsActiveColor(JsonColorKt.toJsonColor((int)topBarButtonsColor));
    }

    public final void setTopBarButtonsInactiveColor(@ColorInt int topBarButtonsInactiveColor) {
        this.config.setTopBarButtonsInactiveColor(JsonColorKt.toJsonColor((int)topBarButtonsInactiveColor));
    }

    public final void setCameraOverlayColor(@ColorInt int cameraOverlayColor) {
        this.config.setCameraOverlayColor(JsonColorKt.toJsonColor((int)cameraOverlayColor));
    }

    public final void setFinderLineWidth(@Px int finderLineWidth) {
        Double d;
        Context context = SapSingleton.INSTANCE.getContext();
        if (context != null) {
            Context $this$pxToDp$iv = context;
            boolean $i$f$pxToDp = false;
            DisplayMetrics displayMetrics$iv = $this$pxToDp$iv.getResources().getDisplayMetrics();
            d = MathKt.roundToInt((float)((float)finderLineWidth / (displayMetrics$iv.xdpi / (float)160)));
        } else {
            d = null;
        }
        this.config.setFinderLineWidth(d);
    }

    public final void setFinderLineColor(@ColorInt int finderLineColor) {
        this.config.setFinderLineColor(JsonColorKt.toJsonColor((int)finderLineColor));
    }

    public final void setFinderTextHintColor(@ColorInt int finderTextHintColor) {
        this.config.setFinderTextHintColor(JsonColorKt.toJsonColor((int)finderTextHintColor));
    }

    public final void setCancelButtonTitle(@NotNull String cancelButtonTitle) {
        Intrinsics.checkNotNullParameter((Object)cancelButtonTitle, (String)"cancelButtonTitle");
        this.config.setCancelButtonTitle(cancelButtonTitle);
    }

    public final void setCancelButtonIcon(@DrawableRes int cancelButtonIcon) {
        this.nativeConfig.setCancelButtonIcon(cancelButtonIcon);
    }

    public final void setEnableCameraExplanationText(@NotNull String enableCameraExplanationText) {
        Intrinsics.checkNotNullParameter((Object)enableCameraExplanationText, (String)"enableCameraExplanationText");
        this.config.setEnableCameraExplanationText(enableCameraExplanationText);
    }

    public final void setEnableCameraButtonTitle(@NotNull String enableCameraButtonTitle) {
        Intrinsics.checkNotNullParameter((Object)enableCameraButtonTitle, (String)"enableCameraButtonTitle");
        this.config.setEnableCameraButtonTitle(enableCameraButtonTitle);
    }

    public final void setWordBoxHighlightColor(@ColorInt int color) {
        this.config.setWordBoxHighlightColor(JsonColorKt.toJsonColor((int)color));
    }

    public final void setWordBoxHighlightEnabled(boolean enabled) {
        this.config.setWordBoxHighlightEnabled(enabled);
    }

    public final void setMinimumNumberOfRequiredFramesWithEqualRecognitionResult(int numberOfFrames) {
        this.config.setMinimumNumberOfRequiredFramesWithEqualRecognitionResult(numberOfFrames);
    }

    public final void setMaximumNumberOfAccumulatedFrames(int numberOfFrames) {
        this.config.setMaximumNumberOfAccumulatedFrames(numberOfFrames);
    }

    public final void setOcrResolutionLimit(@Px int ocrResolutionLimit) {
        this.config.setOcrResolutionLimit(Long.valueOf(ocrResolutionLimit));
    }

    public final void setUseButtonsAllCaps(boolean allCaps) {
        this.config.setUseButtonsAllCaps(allCaps);
    }

    public final void setTouchToFocusEnabled(boolean enabled) {
        this.config.setTouchToFocusEnabled(enabled);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/scanbot/sdk/ui/view/generictext/configuration/TextDataScannerConfiguration$Companion;", "", "()V", "assetFileJson", "", "fromJson", "Lio/scanbot/sdk/ui/view/generictext/configuration/TextDataScannerConfiguration;", "input", "rtu-ui-generictext_release"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final TextDataScannerConfiguration fromJson(@NotNull String input) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Gson gson = GsonHelper.INSTANCE.prepareGson();
            Context context = SapSingleton.INSTANCE.getContext();
            String assetFileJson$iv = TextDataScannerConfiguration.assetFileJson;
            boolean $i$f$getJsonConfig = false;
            BufferedReader reader$iv = JsonConfigUtilsKt.getJsonReader((Context)context, (String)assetFileJson$iv);
            Closeable closeable = reader$iv;
            Throwable throwable = null;
            try {
                BufferedReader reader$iv2 = (BufferedReader)closeable;
                boolean bl = false;
                String text$iv = TextStreamsKt.readText((Reader)reader$iv2);
                Object object2 = gson.fromJson(text$iv, new TypeToken<Map<String, Object>>(){}.getType());
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"gson.fromJson(text, obje\u2026tring, Any?>?>() {}.type)");
                Map defaultJson$iv = (Map)object2;
                Object object3 = gson.fromJson(input, new TypeToken<Map<String, ? extends Object>>(){}.getType());
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"gson.fromJson(jsonToAppl\u2026String, Any>?>() {}.type)");
                Map partialJson$iv = (Map)object3;
                JsonConfigUtilsKt.updateParameters((Map)partialJson$iv, (Map)defaultJson$iv);
                String fullJson$iv = gson.toJson((Object)defaultJson$iv);
                object = gson.fromJson(fullJson$iv, TextDataScannerJsonConfiguration.class);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Object jsonConfig$iv = object;
            TextDataScannerJsonConfiguration jsonConfig = (TextDataScannerJsonConfiguration)jsonConfig$iv;
            return new TextDataScannerConfiguration(jsonConfig, null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

