/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.mrz.configuration;

import android.content.Context;
import android.util.DisplayMetrics;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.scanbot.sdk.camera.CameraModule;
import io.scanbot.sdk.camera.CameraPreviewMode;
import io.scanbot.sdk.common.AspectRatio;
import io.scanbot.sdk.security.SapSingleton;
import io.scanbot.sdk.ui.configuration.json.CommonExtensionsKt;
import io.scanbot.sdk.ui.configuration.json.GsonHelper;
import io.scanbot.sdk.ui.configuration.json.JsonColorKt;
import io.scanbot.sdk.ui.view.base.configuration.CameraOrientationMode;
import io.scanbot.sdk.ui.view.mrz.configuration.json.MrzScannerJsonConfiguration;
import io.scanbot.sdk.ui.view.mrz.configuration.json.MrzScannerNativeConfiguration;
import io.scanbot.sdk.util.JsonConfigUtilsKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Reader;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u000e\u0018\u0000 ;2\u00020\u0001:\u0001;B\u001b\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\t\b\u0016\u00a2\u0006\u0004\b\u0006\u0010\bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u0010J\u0010\u0010\u001c\u001a\u00020\u000e2\b\b\u0001\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020\u000e2\b\b\u0001\u0010 \u001a\u00020\u001eJ\u0010\u0010!\u001a\u00020\u000e2\b\b\u0001\u0010\"\u001a\u00020\u001eJ\u000e\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020%J\u000e\u0010&\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u001eJ\u0010\u0010(\u001a\u00020\u000e2\b\b\u0001\u0010)\u001a\u00020\u001eJ\u0010\u0010*\u001a\u00020\u000e2\b\b\u0001\u0010+\u001a\u00020\u001eJ\u000e\u0010,\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020.J\u0010\u0010/\u001a\u00020\u000e2\b\b\u0001\u00100\u001a\u00020\u001eJ\u000e\u00101\u001a\u00020\u000e2\u0006\u00102\u001a\u00020.J\u000e\u00103\u001a\u00020\u000e2\u0006\u00104\u001a\u00020.J\u000e\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u00020.J\u000e\u00107\u001a\u00020\u000e2\u0006\u00108\u001a\u00020\u0010J\u000e\u00109\u001a\u00020\u000e2\u0006\u0010:\u001a\u00020\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006<"}, d2={"Lio/scanbot/sdk/ui/view/mrz/configuration/MRZScannerConfiguration;", "", "params", "Lio/scanbot/sdk/ui/view/mrz/configuration/json/MrzScannerJsonConfiguration;", "nativeParams", "Lio/scanbot/sdk/ui/view/mrz/configuration/json/MrzScannerNativeConfiguration;", "<init>", "(Lio/scanbot/sdk/ui/view/mrz/configuration/json/MrzScannerJsonConfiguration;Lio/scanbot/sdk/ui/view/mrz/configuration/json/MrzScannerNativeConfiguration;)V", "()V", "getParams", "()Lio/scanbot/sdk/ui/view/mrz/configuration/json/MrzScannerJsonConfiguration;", "getNativeParams", "()Lio/scanbot/sdk/ui/view/mrz/configuration/json/MrzScannerNativeConfiguration;", "setFlashEnabled", "", "flashEnabled", "", "setOrientationLockMode", "cameraOrientationMode", "Lio/scanbot/sdk/ui/view/base/configuration/CameraOrientationMode;", "setCameraModule", "cameraModule", "Lio/scanbot/sdk/camera/CameraModule;", "setCameraPreviewMode", "cameraPreviewMode", "Lio/scanbot/sdk/camera/CameraPreviewMode;", "setSuccessBeepEnabled", "successBeepEnabled", "setTopBarBackgroundColor", "topBarBackgroundColor", "", "setTopBarButtonsColor", "topBarButtonsColor", "setCameraOverlayColor", "cameraOverlayColor", "setFinderAspectRatio", "finderAspectRatio", "Lio/scanbot/sdk/common/AspectRatio;", "setFinderLineWidth", "finderLineWidth", "setFinderLineColor", "finderLineColor", "setFinderTextHintColor", "finderTextHintColor", "setCancelButtonTitle", "cancelButtonTitle", "", "setCancelButtonIcon", "cancelButtonIcon", "setFinderTextHint", "finderTextHint", "setEnableCameraExplanationText", "enableCameraExplanationText", "setEnableCameraButtonTitle", "enableCameraButtonTitle", "setUseButtonsAllCaps", "allCaps", "setTouchToFocusEnabled", "enabled", "Companion", "rtu-ui-mrz_release"})
@SourceDebugExtension(value={"SMAP\nMRZScannerConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MRZScannerConfiguration.kt\nio/scanbot/sdk/ui/view/mrz/configuration/MRZScannerConfiguration\n+ 2 JsonConfigUtils.kt\nio/scanbot/sdk/util/JsonConfigUtilsKt\n+ 3 ThemeUtils.kt\nio/scanbot/sdk/ui/utils/ThemeUtilsKt\n*L\n1#1,151:1\n20#2,16:152\n32#3,2:168\n*S KotlinDebug\n*F\n+ 1 MRZScannerConfiguration.kt\nio/scanbot/sdk/ui/view/mrz/configuration/MRZScannerConfiguration\n*L\n28#1:152,16\n86#1:168,2\n*E\n"})
public final class MRZScannerConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MrzScannerJsonConfiguration params;
    @NotNull
    private final MrzScannerNativeConfiguration nativeParams;
    @NotNull
    private static final String assetFileJson = "MrzScreen.json";

    private MRZScannerConfiguration(MrzScannerJsonConfiguration params, MrzScannerNativeConfiguration nativeParams) {
        this.params = params;
        this.nativeParams = nativeParams;
    }

    /* synthetic */ MRZScannerConfiguration(MrzScannerJsonConfiguration mrzScannerJsonConfiguration, MrzScannerNativeConfiguration mrzScannerNativeConfiguration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            mrzScannerNativeConfiguration = new MrzScannerNativeConfiguration(null, 1, null);
        }
        this(mrzScannerJsonConfiguration, mrzScannerNativeConfiguration);
    }

    @NotNull
    public final MrzScannerJsonConfiguration getParams() {
        return this.params;
    }

    @NotNull
    public final MrzScannerNativeConfiguration getNativeParams() {
        return this.nativeParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public MRZScannerConfiguration() {
        Object object;
        void assetFileJson$iv;
        void context$iv;
        Context context = SapSingleton.INSTANCE.getContext();
        String string = assetFileJson;
        Gson gson = GsonHelper.INSTANCE.prepareGson();
        Object var4_4 = null;
        MRZScannerConfiguration mRZScannerConfiguration = this;
        boolean $i$f$getJsonConfig = false;
        BufferedReader reader$iv = JsonConfigUtilsKt.getJsonReader((Context)context$iv, (String)assetFileJson$iv);
        Closeable closeable = reader$iv;
        Throwable throwable = null;
        try {
            void gson$iv;
            BufferedReader reader$iv2 = (BufferedReader)closeable;
            boolean bl = false;
            String text$iv = TextStreamsKt.readText((Reader)reader$iv2);
            Object object2 = gson$iv.fromJson(text$iv, new TypeToken<Map<String, Object>>(){}.getType());
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"fromJson(...)");
            Map defaultJson$iv = (Map)object2;
            String fullJson$iv = gson$iv.toJson((Object)defaultJson$iv);
            object = gson$iv.fromJson(fullJson$iv, MrzScannerJsonConfiguration.class);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Object jsonConfig$iv = object;
        mRZScannerConfiguration((MrzScannerJsonConfiguration)jsonConfig$iv, null, 2, null);
    }

    public final void setFlashEnabled(boolean flashEnabled) {
        this.params.setFlashEnabled(flashEnabled);
    }

    public final void setOrientationLockMode(@NotNull CameraOrientationMode cameraOrientationMode) {
        Intrinsics.checkNotNullParameter((Object)cameraOrientationMode, (String)"cameraOrientationMode");
        this.params.setOrientationLockMode(CommonExtensionsKt.toJson((CameraOrientationMode)cameraOrientationMode));
    }

    public final void setCameraModule(@NotNull CameraModule cameraModule) {
        Intrinsics.checkNotNullParameter((Object)cameraModule, (String)"cameraModule");
        this.params.setCameraModule(CommonExtensionsKt.toJson((CameraModule)cameraModule));
    }

    public final void setCameraPreviewMode(@NotNull CameraPreviewMode cameraPreviewMode) {
        Intrinsics.checkNotNullParameter((Object)cameraPreviewMode, (String)"cameraPreviewMode");
        this.params.setCameraPreviewMode(CommonExtensionsKt.toJson((CameraPreviewMode)cameraPreviewMode));
    }

    public final void setSuccessBeepEnabled(boolean successBeepEnabled) {
        this.params.setSuccessBeepEnabled(successBeepEnabled);
    }

    public final void setTopBarBackgroundColor(@ColorInt int topBarBackgroundColor) {
        this.params.setTopBarBackgroundColor(JsonColorKt.toJsonColor((int)topBarBackgroundColor));
    }

    public final void setTopBarButtonsColor(@ColorInt int topBarButtonsColor) {
        this.params.setTopBarButtonsActiveColor(JsonColorKt.toJsonColor((int)topBarButtonsColor));
    }

    public final void setCameraOverlayColor(@ColorInt int cameraOverlayColor) {
        this.params.setCameraOverlayColor(JsonColorKt.toJsonColor((int)cameraOverlayColor));
    }

    public final void setFinderAspectRatio(@NotNull AspectRatio finderAspectRatio) {
        Intrinsics.checkNotNullParameter((Object)finderAspectRatio, (String)"finderAspectRatio");
        this.params.setFinderAspectRatio(CommonExtensionsKt.toJsonV1((AspectRatio)finderAspectRatio));
    }

    public final void setFinderLineWidth(int finderLineWidth) {
        Double d;
        Context context = SapSingleton.INSTANCE.getContext();
        if (context != null) {
            Context $this$pxToDp$iv = context;
            boolean $i$f$pxToDp = false;
            DisplayMetrics displayMetrics$iv = $this$pxToDp$iv.getResources().getDisplayMetrics();
            d = MathKt.roundToInt((float)((float)finderLineWidth / (displayMetrics$iv.xdpi / (float)160)));
        } else {
            d = null;
        }
        this.params.setFinderLineWidth(d);
    }

    public final void setFinderLineColor(@ColorInt int finderLineColor) {
        this.params.setFinderLineColor(JsonColorKt.toJsonColor((int)finderLineColor));
    }

    public final void setFinderTextHintColor(@ColorInt int finderTextHintColor) {
        this.params.setFinderTextHintColor(JsonColorKt.toJsonColor((int)finderTextHintColor));
    }

    public final void setCancelButtonTitle(@NotNull String cancelButtonTitle) {
        Intrinsics.checkNotNullParameter((Object)cancelButtonTitle, (String)"cancelButtonTitle");
        this.params.setCancelButtonTitle(cancelButtonTitle);
    }

    public final void setCancelButtonIcon(@DrawableRes int cancelButtonIcon) {
        this.nativeParams.setCancelButtonIcon(cancelButtonIcon);
    }

    public final void setFinderTextHint(@NotNull String finderTextHint) {
        Intrinsics.checkNotNullParameter((Object)finderTextHint, (String)"finderTextHint");
        this.params.setFinderTextHint(finderTextHint);
    }

    public final void setEnableCameraExplanationText(@NotNull String enableCameraExplanationText) {
        Intrinsics.checkNotNullParameter((Object)enableCameraExplanationText, (String)"enableCameraExplanationText");
        this.params.setEnableCameraExplanationText(enableCameraExplanationText);
    }

    public final void setEnableCameraButtonTitle(@NotNull String enableCameraButtonTitle) {
        Intrinsics.checkNotNullParameter((Object)enableCameraButtonTitle, (String)"enableCameraButtonTitle");
        this.params.setEnableCameraButtonTitle(enableCameraButtonTitle);
    }

    public final void setUseButtonsAllCaps(boolean allCaps) {
        this.params.setUseButtonsAllCaps(allCaps);
    }

    public final void setTouchToFocusEnabled(boolean enabled) {
        this.params.setTouchToFocusEnabled(enabled);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/scanbot/sdk/ui/view/mrz/configuration/MRZScannerConfiguration$Companion;", "", "<init>", "()V", "assetFileJson", "", "fromJson", "Lio/scanbot/sdk/ui/view/mrz/configuration/MRZScannerConfiguration;", "input", "rtu-ui-mrz_release"})
    @SourceDebugExtension(value={"SMAP\nMRZScannerConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MRZScannerConfiguration.kt\nio/scanbot/sdk/ui/view/mrz/configuration/MRZScannerConfiguration$Companion\n+ 2 JsonConfigUtils.kt\nio/scanbot/sdk/util/JsonConfigUtilsKt\n*L\n1#1,151:1\n20#2,16:152\n*S KotlinDebug\n*F\n+ 1 MRZScannerConfiguration.kt\nio/scanbot/sdk/ui/view/mrz/configuration/MRZScannerConfiguration$Companion\n*L\n145#1:152,16\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final MRZScannerConfiguration fromJson(@NotNull String input) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Gson gson = GsonHelper.INSTANCE.prepareGson();
            Context context = SapSingleton.INSTANCE.getContext();
            String assetFileJson$iv = MRZScannerConfiguration.assetFileJson;
            boolean $i$f$getJsonConfig = false;
            BufferedReader reader$iv = JsonConfigUtilsKt.getJsonReader((Context)context, (String)assetFileJson$iv);
            Closeable closeable = reader$iv;
            Throwable throwable = null;
            try {
                BufferedReader reader$iv2 = (BufferedReader)closeable;
                boolean bl = false;
                String text$iv = TextStreamsKt.readText((Reader)reader$iv2);
                Object object2 = gson.fromJson(text$iv, new TypeToken<Map<String, Object>>(){}.getType());
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"fromJson(...)");
                Map defaultJson$iv = (Map)object2;
                Object object3 = gson.fromJson(input, new TypeToken<Map<String, ? extends Object>>(){}.getType());
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"fromJson(...)");
                Map partialJson$iv = (Map)object3;
                JsonConfigUtilsKt.updateParameters((Map)partialJson$iv, (Map)defaultJson$iv);
                String fullJson$iv = gson.toJson((Object)defaultJson$iv);
                object = gson.fromJson(fullJson$iv, MrzScannerJsonConfiguration.class);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Object jsonConfig$iv = object;
            MrzScannerJsonConfiguration jsonConfig = (MrzScannerJsonConfiguration)jsonConfig$iv;
            return new MRZScannerConfiguration(jsonConfig, null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

