/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.mrz;

import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.LayoutRes;
import androidx.appcompat.widget.Toolbar;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleOwnerKt;
import androidx.lifecycle.ViewKt;
import io.scanbot.sdk.CameraViewType;
import io.scanbot.sdk.ScanbotCameraViewConfigurationProvider;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.camera.CameraModule;
import io.scanbot.sdk.camera.CameraPreviewMode;
import io.scanbot.sdk.camera.FrameHandlerResult;
import io.scanbot.sdk.common.AspectRatio;
import io.scanbot.sdk.mrz.MrzScanner;
import io.scanbot.sdk.mrz.MrzScannerFrameHandler;
import io.scanbot.sdk.mrz.MrzScannerResult;
import io.scanbot.sdk.ui.base.databinding.ScanbotSdkCameraViewPermissionPlaceholderBinding;
import io.scanbot.sdk.ui.camera.FinderOverlayView;
import io.scanbot.sdk.ui.camera.FinderOverlayViewKt;
import io.scanbot.sdk.ui.camera.IScanbotCameraView;
import io.scanbot.sdk.ui.camera.ScanbotCameraContainerView;
import io.scanbot.sdk.ui.mrz.R;
import io.scanbot.sdk.ui.mrz.databinding.ScanbotSdkMrzCameraViewBinding;
import io.scanbot.sdk.ui.mrz.databinding.ScanbotSdkMrzDescriptionViewBinding;
import io.scanbot.sdk.ui.view.base.IPermissionViewModel;
import io.scanbot.sdk.ui.view.base.configuration.CameraOrientationMode;
import io.scanbot.sdk.ui.view.mrz.IMRZCameraView;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u0000 F2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001FB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010$\u001a\u00020%H\u0015J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\b\u0010*\u001a\u00020'H\u0014J\b\u0010+\u001a\u00020'H\u0014J\u0010\u0010,\u001a\u00020'2\u0006\u0010-\u001a\u00020\u000bH\u0016J\u0010\u0010.\u001a\u00020'2\u0006\u0010-\u001a\u00020\u0011H\u0016J\u0010\u0010/\u001a\u00020'2\u0006\u0010-\u001a\u00020\u0011H\u0002J\u0010\u00100\u001a\u00020'2\u0006\u00101\u001a\u000202H\u0016J\u0010\u00103\u001a\u00020'2\u0006\u00104\u001a\u000205H\u0016J\u000e\u00106\u001a\u00020'2\u0006\u00107\u001a\u000208J\u001c\u00109\u001a\u00020:2\u0012\u0010;\u001a\u000e\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u00020>0<H\u0016J\u0006\u0010?\u001a\u00020'J\b\u0010@\u001a\u00020'H\u0002J\u0010\u0010A\u001a\u00020'2\u0006\u0010-\u001a\u00020\u000bH\u0002J\u0010\u0010B\u001a\u00020'2\u0006\u0010C\u001a\u00020:H\u0014J\u0010\u0010D\u001a\u00020'2\u0006\u0010E\u001a\u00020:H\u0002R\u001a\u0010\n\u001a\u00020\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006G"}, d2={"Lio/scanbot/sdk/ui/view/mrz/MRZCameraView;", "Landroid/widget/FrameLayout;", "Lio/scanbot/sdk/ui/view/mrz/IMRZCameraView;", "Lio/scanbot/sdk/mrz/MrzScannerFrameHandler$ResultHandler;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "cameraViewModel", "Lio/scanbot/sdk/ui/view/mrz/IMRZCameraView$ViewModel;", "getCameraViewModel", "()Lio/scanbot/sdk/ui/view/mrz/IMRZCameraView$ViewModel;", "setCameraViewModel", "(Lio/scanbot/sdk/ui/view/mrz/IMRZCameraView$ViewModel;)V", "permissionViewModel", "Lio/scanbot/sdk/ui/view/base/IPermissionViewModel;", "getPermissionViewModel", "()Lio/scanbot/sdk/ui/view/base/IPermissionViewModel;", "setPermissionViewModel", "(Lio/scanbot/sdk/ui/view/base/IPermissionViewModel;)V", "mrzScannerFrameHandler", "Lio/scanbot/sdk/mrz/MrzScannerFrameHandler;", "cameraBinding", "Lio/scanbot/sdk/ui/mrz/databinding/ScanbotSdkMrzCameraViewBinding;", "getCameraBinding", "()Lio/scanbot/sdk/ui/mrz/databinding/ScanbotSdkMrzCameraViewBinding;", "permissionBinding", "Lio/scanbot/sdk/ui/base/databinding/ScanbotSdkCameraViewPermissionPlaceholderBinding;", "getPermissionBinding", "()Lio/scanbot/sdk/ui/base/databinding/ScanbotSdkCameraViewPermissionPlaceholderBinding;", "descriptionBinding", "Lio/scanbot/sdk/ui/mrz/databinding/ScanbotSdkMrzDescriptionViewBinding;", "getDescriptionBinding", "()Lio/scanbot/sdk/ui/mrz/databinding/ScanbotSdkMrzDescriptionViewBinding;", "getLayoutRes", "", "setMrzScanner", "", "scanner", "Lio/scanbot/sdk/mrz/MrzScanner;", "onAttachedToWindow", "onDetachedFromWindow", "attachViewModel", "viewModel", "attachPermissionViewModel", "subscribePermissionViewModel", "setCameraOrientationMode", "cameraOrientationMode", "Lio/scanbot/sdk/ui/view/base/configuration/CameraOrientationMode;", "setCameraModule", "cameraModule", "Lio/scanbot/sdk/camera/CameraModule;", "setCameraPreviewMode", "cameraPreviewMode", "Lio/scanbot/sdk/camera/CameraPreviewMode;", "handle", "", "result", "Lio/scanbot/sdk/camera/FrameHandlerResult;", "Lio/scanbot/sdk/mrz/MrzScannerResult;", "Lio/scanbot/sdk/SdkLicenseError;", "initCameraView", "doOnCameraOpened", "subscribeViews", "updateCameraPermissionView", "cameraPermissionGranted", "updateFlashState", "flash", "Companion", "rtu-ui-mrz_release"})
@SourceDebugExtension(value={"SMAP\nMRZCameraView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MRZCameraView.kt\nio/scanbot/sdk/ui/view/mrz/MRZCameraView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,196:1\n1#2:197\n*E\n"})
public class MRZCameraView
extends FrameLayout
implements IMRZCameraView,
MrzScannerFrameHandler.ResultHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public IMRZCameraView.ViewModel cameraViewModel;
    public IPermissionViewModel permissionViewModel;
    private MrzScannerFrameHandler mrzScannerFrameHandler;
    @NotNull
    private final ScanbotSdkMrzCameraViewBinding cameraBinding;
    @NotNull
    private final ScanbotSdkCameraViewPermissionPlaceholderBinding permissionBinding;
    @NotNull
    private final ScanbotSdkMrzDescriptionViewBinding descriptionBinding;
    @NotNull
    private static final AspectRatio FINDER_ASPECT_RATIO = new AspectRatio(296.0, 60.0);

    public MRZCameraView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
        View view = LayoutInflater.from((Context)context).inflate(this.getLayoutRes(), (ViewGroup)this, true);
        ScanbotSdkMrzCameraViewBinding scanbotSdkMrzCameraViewBinding = ScanbotSdkMrzCameraViewBinding.bind(view.findViewById(R.id.cameraRootLayout));
        Intrinsics.checkNotNullExpressionValue((Object)scanbotSdkMrzCameraViewBinding, (String)"bind(...)");
        this.cameraBinding = scanbotSdkMrzCameraViewBinding;
        ScanbotSdkMrzDescriptionViewBinding scanbotSdkMrzDescriptionViewBinding = ScanbotSdkMrzDescriptionViewBinding.bind((View)this.cameraBinding.getRoot());
        Intrinsics.checkNotNullExpressionValue((Object)scanbotSdkMrzDescriptionViewBinding, (String)"bind(...)");
        this.descriptionBinding = scanbotSdkMrzDescriptionViewBinding;
        ScanbotSdkCameraViewPermissionPlaceholderBinding scanbotSdkCameraViewPermissionPlaceholderBinding = this.cameraBinding.cameraPermissionView;
        Intrinsics.checkNotNullExpressionValue((Object)scanbotSdkCameraViewPermissionPlaceholderBinding, (String)"cameraPermissionView");
        this.permissionBinding = scanbotSdkCameraViewPermissionPlaceholderBinding;
        this.cameraBinding.cancelView.setOnClickListener(arg_0 -> MRZCameraView._init_$lambda$0(this, arg_0));
        this.cameraBinding.flashBtn.setOnClickListener(arg_0 -> MRZCameraView._init_$lambda$1(this, arg_0));
        boolean hasCameraFlash = context.getPackageManager().hasSystemFeature("android.hardware.camera.flash");
        this.cameraBinding.flashBtn.setVisibility(hasCameraFlash ? 0 : 4);
        this.permissionBinding.enableCameraBtn.setOnClickListener(arg_0 -> MRZCameraView._init_$lambda$2(this, arg_0));
        this.cameraBinding.finderOverlay.setRequiredAspectRatios(CollectionsKt.listOf((Object)FINDER_ASPECT_RATIO));
        FinderOverlayView finderOverlayView = this.cameraBinding.finderOverlay;
        Intrinsics.checkNotNullExpressionValue((Object)finderOverlayView, (String)"finderOverlay");
        Toolbar toolbar = this.cameraBinding.cameraTopToolbar;
        Intrinsics.checkNotNullExpressionValue((Object)toolbar, (String)"cameraTopToolbar");
        FinderOverlayViewKt.setViewAsTopSafeArea((FinderOverlayView)finderOverlayView, (View)((View)toolbar));
    }

    @NotNull
    public final IMRZCameraView.ViewModel getCameraViewModel() {
        IMRZCameraView.ViewModel viewModel = this.cameraViewModel;
        if (viewModel != null) {
            return viewModel;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"cameraViewModel");
        return null;
    }

    public final void setCameraViewModel(@NotNull IMRZCameraView.ViewModel viewModel) {
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"<set-?>");
        this.cameraViewModel = viewModel;
    }

    @NotNull
    public final IPermissionViewModel getPermissionViewModel() {
        IPermissionViewModel iPermissionViewModel = this.permissionViewModel;
        if (iPermissionViewModel != null) {
            return iPermissionViewModel;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"permissionViewModel");
        return null;
    }

    public final void setPermissionViewModel(@NotNull IPermissionViewModel iPermissionViewModel) {
        Intrinsics.checkNotNullParameter((Object)iPermissionViewModel, (String)"<set-?>");
        this.permissionViewModel = iPermissionViewModel;
    }

    @NotNull
    public final ScanbotSdkMrzCameraViewBinding getCameraBinding() {
        return this.cameraBinding;
    }

    @NotNull
    public final ScanbotSdkCameraViewPermissionPlaceholderBinding getPermissionBinding() {
        return this.permissionBinding;
    }

    @NotNull
    public final ScanbotSdkMrzDescriptionViewBinding getDescriptionBinding() {
        return this.descriptionBinding;
    }

    @LayoutRes
    protected int getLayoutRes() {
        return R.layout.scanbot_sdk_mrz_camera_view;
    }

    private final void setMrzScanner(MrzScanner scanner) {
        ScanbotCameraContainerView scanbotCameraContainerView = this.cameraBinding.scanbotCameraView;
        Intrinsics.checkNotNullExpressionValue((Object)scanbotCameraContainerView, (String)"scanbotCameraView");
        this.mrzScannerFrameHandler = MrzScannerFrameHandler.Companion.attach((IScanbotCameraView)scanbotCameraContainerView, scanner);
        MrzScannerFrameHandler mrzScannerFrameHandler = this.mrzScannerFrameHandler;
        if (mrzScannerFrameHandler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mrzScannerFrameHandler");
            mrzScannerFrameHandler = null;
        }
        mrzScannerFrameHandler.addResultHandler((MrzScannerFrameHandler.ResultHandler)this);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (Build.VERSION.SDK_INT >= 35) {
            ViewCompat.setOnApplyWindowInsetsListener((View)((View)this), (arg_0, arg_1) -> MRZCameraView.onAttachedToWindow$lambda$3(this, arg_0, arg_1));
        }
    }

    protected void onDetachedFromWindow() {
        this.cameraBinding.scanbotCameraView.onCloseCamera();
        ViewCompat.setOnApplyWindowInsetsListener((View)((View)this), null);
        super.onDetachedFromWindow();
    }

    @Override
    public void attachViewModel(@NotNull IMRZCameraView.ViewModel viewModel) {
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        this.setCameraViewModel(viewModel);
        this.setMrzScanner(viewModel.getScanner());
        this.subscribeViews(viewModel);
    }

    @Override
    public void attachPermissionViewModel(@NotNull IPermissionViewModel viewModel) {
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        this.setPermissionViewModel(viewModel);
        this.subscribePermissionViewModel(viewModel);
    }

    private final void subscribePermissionViewModel(IPermissionViewModel viewModel) {
        block0: {
            LifecycleOwner lifecycleOwner;
            LifecycleOwner lifecycleOwner2 = ViewKt.findViewTreeLifecycleOwner((View)((View)this));
            if (lifecycleOwner2 == null || (lifecycleOwner2 = LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)lifecycleOwner2)) == null) break block0;
            LifecycleOwner $this$subscribePermissionViewModel_u24lambda_u244 = lifecycleOwner = lifecycleOwner2;
            boolean bl = false;
            FlowKt.launchIn((Flow)FlowKt.onEach((Flow)((Flow)viewModel.getCameraPermissionGranted()), (Function2)((Function2)new Function2<Boolean, Continuation<? super Unit>, Object>(this, null){
                int label;
                /* synthetic */ boolean Z$0;
                final /* synthetic */ MRZCameraView this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean granted = this.Z$0;
                            this.this$0.updateCameraPermissionView(granted);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.Z$0 = (Boolean)value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(boolean p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            })), (CoroutineScope)((CoroutineScope)$this$subscribePermissionViewModel_u24lambda_u244));
        }
    }

    @Override
    public void setCameraOrientationMode(@NotNull CameraOrientationMode cameraOrientationMode) {
        Intrinsics.checkNotNullParameter((Object)cameraOrientationMode, (String)"cameraOrientationMode");
        switch (WhenMappings.$EnumSwitchMapping$0[cameraOrientationMode.ordinal()]) {
            case 1: {
                this.cameraBinding.scanbotCameraView.lockToPortrait(true);
                break;
            }
            case 2: {
                this.cameraBinding.scanbotCameraView.lockToLandscape(true);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Override
    public void setCameraModule(@NotNull CameraModule cameraModule) {
        Intrinsics.checkNotNullParameter((Object)cameraModule, (String)"cameraModule");
        this.cameraBinding.scanbotCameraView.setCameraModule(cameraModule);
    }

    public final void setCameraPreviewMode(@NotNull CameraPreviewMode cameraPreviewMode) {
        Intrinsics.checkNotNullParameter((Object)cameraPreviewMode, (String)"cameraPreviewMode");
        this.cameraBinding.scanbotCameraView.setPreviewMode(cameraPreviewMode);
    }

    public boolean handle(@NotNull FrameHandlerResult<MrzScannerResult, SdkLicenseError> result) {
        Intrinsics.checkNotNullParameter(result, (String)"result");
        this.getCameraViewModel().mrzCodeScanned(result);
        return false;
    }

    public final void initCameraView() {
        if (Intrinsics.areEqual((Object)ScanbotCameraViewConfigurationProvider.INSTANCE.getCameraViewType(), (Object)CameraViewType.CameraX.INSTANCE)) {
            LifecycleOwner lifecycleOwner = ViewKt.findViewTreeLifecycleOwner((View)((View)this));
            if (lifecycleOwner != null) {
                LifecycleOwner it = lifecycleOwner;
                boolean bl = false;
                this.cameraBinding.scanbotCameraView.setLifecycleOwner(it);
            }
        }
        this.cameraBinding.scanbotCameraView.setPreviewMode(CameraPreviewMode.FILL_IN);
        this.cameraBinding.scanbotCameraView.setCameraOpenCallback(() -> MRZCameraView.initCameraView$lambda$6(this));
    }

    private final void doOnCameraOpened() {
        this.cameraBinding.scanbotCameraView.setShutterSound(false);
        this.updateFlashState((Boolean)this.getCameraViewModel().getFlash().getValue());
        this.cameraBinding.scanbotCameraView.continuousFocus();
    }

    private final void subscribeViews(IMRZCameraView.ViewModel viewModel) {
        block0: {
            LifecycleOwner lifecycleOwner;
            LifecycleOwner lifecycleOwner2 = ViewKt.findViewTreeLifecycleOwner((View)((View)this));
            if (lifecycleOwner2 == null || (lifecycleOwner2 = LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)lifecycleOwner2)) == null) break block0;
            LifecycleOwner $this$subscribeViews_u24lambda_u247 = lifecycleOwner = lifecycleOwner2;
            boolean bl = false;
            FlowKt.launchIn((Flow)FlowKt.onEach((Flow)((Flow)viewModel.getCameraOpened()), (Function2)((Function2)new Function2<Boolean, Continuation<? super Unit>, Object>(this, null){
                int label;
                /* synthetic */ boolean Z$0;
                final /* synthetic */ MRZCameraView this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean value = this.Z$0;
                            if (value) {
                                this.this$0.getCameraBinding().scanbotCameraView.onResume();
                            } else {
                                this.this$0.getCameraBinding().scanbotCameraView.onPause();
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.Z$0 = (Boolean)value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(boolean p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            })), (CoroutineScope)((CoroutineScope)$this$subscribeViews_u24lambda_u247));
            FlowKt.launchIn((Flow)FlowKt.onEach((Flow)((Flow)viewModel.getStopNewFrames()), (Function2)((Function2)new Function2<Boolean, Continuation<? super Unit>, Object>(this, null){
                int label;
                /* synthetic */ boolean Z$0;
                final /* synthetic */ MRZCameraView this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean value = this.Z$0;
                            MrzScannerFrameHandler mrzScannerFrameHandler = MRZCameraView.access$getMrzScannerFrameHandler$p(this.this$0);
                            if (mrzScannerFrameHandler == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"mrzScannerFrameHandler");
                                mrzScannerFrameHandler = null;
                            }
                            mrzScannerFrameHandler.setEnabled(!value);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.Z$0 = (Boolean)value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(boolean p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            })), (CoroutineScope)((CoroutineScope)$this$subscribeViews_u24lambda_u247));
            FlowKt.launchIn((Flow)FlowKt.onEach((Flow)((Flow)viewModel.getFlash()), (Function2)((Function2)new Function2<Boolean, Continuation<? super Unit>, Object>(this, null){
                int label;
                /* synthetic */ boolean Z$0;
                final /* synthetic */ MRZCameraView this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean value = this.Z$0;
                            MRZCameraView.access$updateFlashState(this.this$0, value);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.Z$0 = (Boolean)value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(boolean p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            })), (CoroutineScope)((CoroutineScope)$this$subscribeViews_u24lambda_u247));
        }
    }

    protected void updateCameraPermissionView(boolean cameraPermissionGranted) {
        if (cameraPermissionGranted) {
            this.permissionBinding.cameraPermissionView.setVisibility(8);
        } else {
            this.permissionBinding.cameraPermissionView.setVisibility(0);
        }
    }

    private final void updateFlashState(boolean flash) {
        if (((Boolean)this.getCameraViewModel().getCameraOpened().getValue()).booleanValue()) {
            this.cameraBinding.flashBtn.setChecked(flash);
            this.cameraBinding.scanbotCameraView.useFlash(flash);
        }
    }

    private static final void _init_$lambda$0(MRZCameraView this$0, View it) {
        this$0.getCameraViewModel().onCancelClicked();
    }

    private static final void _init_$lambda$1(MRZCameraView this$0, View it) {
        this$0.getCameraViewModel().onFlashClicked();
    }

    private static final void _init_$lambda$2(MRZCameraView this$0, View it) {
        this$0.getPermissionViewModel().onActivateCameraPermission();
    }

    private static final WindowInsetsCompat onAttachedToWindow$lambda$3(MRZCameraView this$0, View view, WindowInsetsCompat windowInsets) {
        Insets insets = windowInsets.getInsets(WindowInsetsCompat.Type.systemBars());
        Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"getInsets(...)");
        Insets insets2 = insets;
        this$0.cameraBinding.cameraTopToolbar.setPadding(0, insets2.top, 0, 0);
        return WindowInsetsCompat.CONSUMED;
    }

    private static final void initCameraView$lambda$6(MRZCameraView this$0) {
        this$0.doOnCameraOpened();
    }

    public static final /* synthetic */ MrzScannerFrameHandler access$getMrzScannerFrameHandler$p(MRZCameraView $this) {
        return $this.mrzScannerFrameHandler;
    }

    public static final /* synthetic */ void access$updateFlashState(MRZCameraView $this, boolean flash) {
        $this.updateFlashState(flash);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/scanbot/sdk/ui/view/mrz/MRZCameraView$Companion;", "", "<init>", "()V", "FINDER_ASPECT_RATIO", "Lio/scanbot/sdk/common/AspectRatio;", "rtu-ui-mrz_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CameraOrientationMode.values().length];
            try {
                nArray[CameraOrientationMode.PORTRAIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CameraOrientationMode.LANDSCAPE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

