/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.process;

import android.content.Context;
import android.net.Uri;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.docprocessing.DocumentProcessor;
import io.scanbot.sdk.docprocessing.compose.ComposerConfig;
import io.scanbot.sdk.docprocessing.compose.PdfConfig;
import io.scanbot.sdk.docprocessing.compose.PdfRendererInput;
import io.scanbot.sdk.docprocessing.compose.PdfRendererUriInput;
import io.scanbot.sdk.docprocessing.compose.SimpleComposer;
import io.scanbot.sdk.docprocessing.draft.DocumentDraftExtractor;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.DocumentDraft;
import io.scanbot.sdk.entity.SnappingDraft;
import io.scanbot.sdk.persistence.DocumentStoreStrategy;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.cleanup.Cleaner;
import io.scanbot.sdk.persistence.fileio.FileIOProcessor;
import io.scanbot.sdk.process.PDFPageSize;
import io.scanbot.sdk.process.PDFRenderer;
import io.scanbot.sdk.util.FileChooserUtils;
import io.scanbot.sdk.util.FileUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 &2\u00020\u0001:\u0001&BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0014H\u0002J(\u0010\u0018\u001a\u0004\u0018\u00010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J \u0010\u001d\u001a\u0004\u0018\u00010\u00152\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00142\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lio/scanbot/sdk/process/ScanbotPDFRenderer;", "Lio/scanbot/sdk/process/PDFRenderer;", "context", "Landroid/content/Context;", "fileIOProcessor", "Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;", "documentDraftExtractor", "Lio/scanbot/sdk/docprocessing/draft/DocumentDraftExtractor;", "documentStoreStrategy", "Lio/scanbot/sdk/persistence/DocumentStoreStrategy;", "documentProcessor", "Lio/scanbot/sdk/docprocessing/DocumentProcessor;", "simpleComposer", "Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;", "cleaner", "Lio/scanbot/sdk/persistence/cleanup/Cleaner;", "sapManager", "Lio/scanbot/sap/SapManager;", "(Landroid/content/Context;Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;Lio/scanbot/sdk/docprocessing/draft/DocumentDraftExtractor;Lio/scanbot/sdk/persistence/DocumentStoreStrategy;Lio/scanbot/sdk/docprocessing/DocumentProcessor;Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;Lio/scanbot/sdk/persistence/cleanup/Cleaner;Lio/scanbot/sap/SapManager;)V", "getFilesFromContentUri", "", "Ljava/io/File;", "imageFileUris", "Landroid/net/Uri;", "renderDocumentFromImages", "sourceFilesEncrypted", "", "pageSize", "Lio/scanbot/sdk/process/PDFPageSize;", "renderDocumentFromPages", "pages", "Lio/scanbot/sdk/persistence/Page;", "saveStreamToFile", "", "fileOutputStream", "Ljava/io/OutputStream;", "inputSteam", "Ljava/io/InputStream;", "Companion", "sdk-bundle_release"})
public final class ScanbotPDFRenderer
implements PDFRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String CACHE_DIR = "scanbotPdfRenderer";
    @NotNull
    private final Context context;
    @NotNull
    private final FileIOProcessor fileIOProcessor;
    @NotNull
    private final DocumentDraftExtractor documentDraftExtractor;
    @NotNull
    private final DocumentStoreStrategy documentStoreStrategy;
    @NotNull
    private final DocumentProcessor documentProcessor;
    @NotNull
    private final SimpleComposer simpleComposer;
    @NotNull
    private final Cleaner cleaner;
    @NotNull
    private final SapManager sapManager;

    /*
     * WARNING - void declaration
     */
    public ScanbotPDFRenderer(@NotNull Context context, @NotNull FileIOProcessor fileIOProcessor, @NotNull DocumentDraftExtractor documentDraftExtractor, @NotNull DocumentStoreStrategy documentStoreStrategy, @NotNull DocumentProcessor documentProcessor, @NotNull SimpleComposer simpleComposer, @NotNull Cleaner cleaner, @NotNull SapManager sapManager) {
        void var8_8;
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"context");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"fileIOProcessor");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"documentDraftExtractor");
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"documentStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)var5_5, (String)"documentProcessor");
        Intrinsics.checkNotNullParameter((Object)var6_6, (String)"simpleComposer");
        Intrinsics.checkNotNullParameter((Object)var7_7, (String)"cleaner");
        Intrinsics.checkNotNullParameter((Object)var8_8, (String)"sapManager");
        this.context = var1_1;
        this.fileIOProcessor = var2_2;
        this.documentDraftExtractor = var3_3;
        this.documentStoreStrategy = var4_4;
        this.documentProcessor = var5_5;
        this.simpleComposer = var6_6;
        this.cleaner = var7_7;
        this.sapManager = var8_8;
    }

    private final List<File> getFilesFromContentUri(List<? extends Uri> imageFileUris) {
        ArrayList arrayList;
        ArrayList arrayList2;
        Object object = arrayList2;
        arrayList2 = new ArrayList();
        for (Object object2 : imageFileUris) {
            if (!StringsKt.equals$default((String)((Uri)object2).getScheme(), (String)"content", (boolean)false, (int)2, null)) continue;
            object.add(object2);
        }
        ArrayList arrayList3 = arrayList;
        arrayList = new ArrayList(CollectionsKt.collectionSizeOrDefault(object, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            Uri uri = (Uri)object.next();
            InputStream inputStream = this.context.getContentResolver().openInputStream(uri);
            if (inputStream != null) {
                File file;
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"context.contentResolver.\u2026 content uri ${it.path}\")");
                File file2 = file;
                new File(FileUtils.getExternalCacheDirOrShowError((Context)this.context, (String)CACHE_DIR), UUID.randomUUID().toString() + ".jpg").createNewFile();
                OutputStream outputStream = this.fileIOProcessor.openFileOutputStream(file2);
                if (outputStream != null) {
                    this.saveStreamToFile(outputStream, inputStream);
                    arrayList3.add(file2);
                    continue;
                }
                throw new IOException("Can't create output stream for temporary image file " + file2.getPath());
            }
            throw new IOException("Can't get input stream from content uri " + uri.getPath());
        }
        return arrayList3;
    }

    /*
     * WARNING - void declaration
     */
    private final void saveStreamToFile(OutputStream fileOutputStream, InputStream inputSteam) {
        ScanbotPDFRenderer scanbotPDFRenderer;
        OutputStream outputStream = fileOutputStream;
        ScanbotPDFRenderer scanbotPDFRenderer2 = null;
        try {
            void var2_3;
            outputStream.write(ByteStreamsKt.readBytes((InputStream)var2_3));
            scanbotPDFRenderer = scanbotPDFRenderer2;
        }
        catch (Throwable throwable) {
            try {
                throw throwable;
            }
            catch (Throwable throwable2) {
                void var1_2;
                CloseableKt.closeFinally((Closeable)var1_2, (Throwable)throwable);
                throw throwable2;
            }
        }
        CloseableKt.closeFinally((Closeable)outputStream, (Throwable)((Object)scanbotPDFRenderer));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public File renderDocumentFromImages(@NotNull List<? extends Uri> imageFileUris, boolean sourceFilesEncrypted, @NotNull PDFPageSize pageSize) {
        PdfConfig pdfConfig;
        void var2_2;
        PdfRendererUriInput pdfRendererUriInput;
        ArrayList arrayList;
        Document document;
        Object object3;
        ArrayList arrayList2;
        Document document2;
        void var3_4;
        Iterator iterator;
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"imageFileUris");
        Intrinsics.checkNotNullParameter((Object)var3_4, (String)"pageSize");
        if (!((ScanbotPDFRenderer)((Object)this_)).sapManager.checkLicenseStatus(SdkFeature.PDFCreation).booleanValue()) {
            return null;
        }
        List<File> list = ((ScanbotPDFRenderer)((Object)this_)).getFilesFromContentUri((List<? extends Uri>)((Object)iterator));
        Document document3 = document2;
        document2 = new ArrayList(CollectionsKt.collectionSizeOrDefault(list, (int)10));
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            document3.add(Uri.fromFile((File)((File)object2.next())));
        }
        void v1 = iterator;
        iterator = arrayList2;
        arrayList2 = new ArrayList();
        for (Object object3 : v1) {
            if (!StringsKt.equals$default((String)((Uri)object3).getScheme(), (String)"file", (boolean)false, (int)2, null)) continue;
            iterator.add(object3);
        }
        iterator = CollectionsKt.plus(document3, iterator);
        document3 = document;
        document3();
        object2 = UUID.randomUUID().toString() + ".pdf";
        document3.id = object2;
        document3.name = object2;
        document.pagesCount = iterator.size();
        object2 = ((ScanbotPDFRenderer)((Object)this_)).simpleComposer;
        object3 = arrayList;
        arrayList = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterator, (int)10));
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Uri uri;
            Uri uri2 = uri = (Uri)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"it");
            Uri uri3 = Uri.fromFile((File)new File(FileChooserUtils.getPath((Context)((ScanbotPDFRenderer)((Object)this_)).context, (Uri)uri2)));
            Intrinsics.checkExpressionValueIsNotNull((Object)uri3, (String)"Uri.fromFile(this)");
            object3.add((Uri)uri3);
        }
        iterator = pdfRendererUriInput;
        pdfRendererUriInput = new PdfRendererUriInput(object3, (boolean)var2_2);
        PdfConfig pdfConfig2 = pdfConfig;
        pdfConfig = new PdfConfig((PDFPageSize)var3_4);
        object2.composeDocument(document3, (PdfRendererInput)iterator, (ComposerConfig)pdfConfig2);
        iterator = list.iterator();
        while (iterator.hasNext()) {
            ((File)iterator.next()).delete();
        }
        Document document4 = document3;
        String this_ = document4.id;
        return ((ScanbotPDFRenderer)((Object)this_)).documentStoreStrategy.getDocumentFile(this_, document4.name);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public File renderDocumentFromPages(@NotNull List<Page> pages, @NotNull PDFPageSize pageSize) {
        DocumentDraft documentDraft;
        block5: {
            SnappingDraft snappingDraft;
            void var2_2;
            Intrinsics.checkNotNullParameter((Object)documentDraft, (String)"pages");
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"pageSize");
            if (!this.sapManager.checkLicenseStatus(SdkFeature.PDFCreation).booleanValue()) {
                return null;
            }
            ScanbotPDFRenderer scanbotPDFRenderer = this;
            ScanbotPDFRenderer scanbotPDFRenderer2 = scanbotPDFRenderer;
            ScanbotPDFRenderer scanbotPDFRenderer3 = scanbotPDFRenderer;
            SnappingDraft snappingDraft2 = snappingDraft;
            new SnappingDraft((List)CollectionsKt.toMutableList((Collection)documentDraft), null, (boolean)false, null, (int)14, null).documentName = UUID.randomUUID().toString();
            documentDraft = scanbotPDFRenderer2.documentDraftExtractor.extract(snappingDraft2)[0];
            v5.pageSize = var2_2;
            documentDraft = scanbotPDFRenderer3.documentProcessor.processDocument(documentDraft);
            if (documentDraft == null) break block5;
            this.cleaner.cleanUpDocumentThumbnail(documentDraft.getDocument());
        }
        return documentDraft != null ? documentDraft.getDocumentFile() : null;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/scanbot/sdk/process/ScanbotPDFRenderer$Companion;", "", "()V", "CACHE_DIR", "", "sdk-bundle_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

