/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui;

import android.animation.Animator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewPropertyAnimator;
import android.widget.FrameLayout;
import androidx.appcompat.widget.AppCompatImageView;
import io.scanbot.sdk.ScanbotSDKInitializer;
import io.scanbot.sdk.bundle.R;
import io.scanbot.sdk.core.contourdetector.Line2D;
import io.scanbot.sdk.ui.EditPolygonImageView;
import io.scanbot.sdk.ui.MagnifierView;
import io.scanbot.sdk.util.EditPolygonViewHelper;
import io.scanbot.sdk.util.PolygonHelper;
import io.scanbot.sdk.util.bitmap.BitmapUtils;
import io.scanbot.sdk.util.view.PolygonViewHelper;
import io.scanbot.sdk.utils.ViewUtils;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00d6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b \u0018\u0000 \u0094\u00012\u00020\u0001:\b\u0094\u0001\u0095\u0001\u0096\u0001\u0097\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010W\u001a\u00020XH\u0002J\u0010\u0010Y\u001a\u00020Z2\u0006\u0010[\u001a\u00020\tH\u0002J\b\u0010\\\u001a\u00020XH\u0002J\b\u0010]\u001a\u00020XH\u0002J\b\u0010^\u001a\u00020XH\u0002J\u0010\u0010_\u001a\u00020X2\u0006\u0010`\u001a\u00020aH\u0014J*\u0010b\u001a\u00020X2\u0006\u0010`\u001a\u00020a2\u0006\u0010[\u001a\u00020\t2\b\u0010c\u001a\u0004\u0018\u00010\r2\u0006\u0010d\u001a\u000207H\u0002J\b\u0010e\u001a\u00020!H\u0002J\b\u0010f\u001a\u00020XH\u0002J\b\u0010g\u001a\u00020XH\u0002J(\u0010h\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010-\u0012\u0004\u0012\u00020j0i2\u0006\u0010k\u001a\u00020\u00182\b\u0010\u001f\u001a\u0004\u0018\u00010\tH\u0002J\u0018\u0010l\u001a\u0002072\u0006\u0010m\u001a\u0002072\u0006\u0010n\u001a\u000207H\u0002J\u0010\u0010o\u001a\u00020X2\u0006\u0010[\u001a\u00020\tH\u0002J\b\u0010p\u001a\u00020XH\u0014J\b\u0010q\u001a\u00020XH\u0014J\b\u0010r\u001a\u00020XH\u0002J\u0018\u0010s\u001a\u00020X2\u0006\u0010t\u001a\u00020)2\u0006\u0010u\u001a\u00020)H\u0014J\u0010\u0010v\u001a\u00020!2\u0006\u0010w\u001a\u00020xH\u0016J\b\u0010y\u001a\u00020XH\u0002J\b\u0010z\u001a\u00020XH\u0002J\u0006\u0010{\u001a\u00020XJ\u0006\u0010|\u001a\u00020XJ\u001a\u0010}\u001a\u00020X2\u0006\u0010~\u001a\u0002072\b\b\u0002\u0010\u007f\u001a\u00020!H\u0002J\u0010\u0010\u0080\u0001\u001a\u00020X2\u0007\u0010\u0081\u0001\u001a\u00020)J\u0010\u0010\u0082\u0001\u001a\u00020X2\u0007\u0010\u0081\u0001\u001a\u00020)J\u0010\u0010\u0083\u0001\u001a\u00020X2\u0007\u0010\u0081\u0001\u001a\u00020)J\u0010\u0010\u0084\u0001\u001a\u00020X2\u0007\u0010\u0085\u0001\u001a\u000207J\u0011\u0010\u0086\u0001\u001a\u00020X2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u0011\u0010\u0087\u0001\u001a\u00020X2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\u0011\u0010\u0088\u0001\u001a\u00020X2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\u0012\u0010\u0089\u0001\u001a\u00020X2\t\u0010\u008a\u0001\u001a\u0004\u0018\u00010\rJ#\u0010\u008b\u0001\u001a\u00020X2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020-0\b2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020-0\bJ%\u0010\u008c\u0001\u001a\u00020X2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020-0\b2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020-0\bH\u0002J\u0012\u0010\u008d\u0001\u001a\u00020X2\t\u0010\u008e\u0001\u001a\u0004\u0018\u00010:J\u0017\u0010\u008f\u0001\u001a\u00020X2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0012\u0010\u0090\u0001\u001a\u00020X2\u0007\u0010\u0091\u0001\u001a\u000207H\u0016J\u0010\u0010\u0092\u0001\u001a\u00020X2\u0007\u0010\u0091\u0001\u001a\u000207J\t\u0010\u0093\u0001\u001a\u00020XH\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00102\u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010#\"\u0004\b3\u0010%R\u000e\u00104\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u000207X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u000207X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00109\u001a\u0004\u0018\u00010:X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u000207X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u000207X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u000207X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u000207X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010A\u001a\u0010\u0012\f\u0012\n C*\u0004\u0018\u00010\t0\t0BX\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010E\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\t0\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bF\u0010G\"\u0004\bH\u0010IR\u000e\u0010J\u001a\u00020KX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010L\u001a\u000207X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010M\u001a\u000207X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010N\u001a\u000207X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010O\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010P\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010Q\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010R\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010S\u001a\u00020TX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010U\u001a\b\u0012\u0004\u0012\u00020+0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010V\u001a\b\u0012\u0004\u0012\u00020-0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0098\u0001"}, d2={"Lio/scanbot/sdk/ui/EditPolygonImageView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "_polygon", "", "Landroid/graphics/PointF;", "animator", "Landroid/view/ViewPropertyAnimator;", "cornerBitmap", "Landroid/graphics/Bitmap;", "cornerDrawable", "Landroid/graphics/drawable/Drawable;", "corners", "", "drawable", "getDrawable", "()Landroid/graphics/drawable/Drawable;", "edgeBitmap", "edgeDrawable", "edges", "Lio/scanbot/sdk/util/view/PolygonViewHelper$Edge;", "editPolygonAnimationEndListener", "Lio/scanbot/sdk/ui/EditPolygonImageView$EditPolygonAnimationEndListener;", "editPolygonDragListener", "Lio/scanbot/sdk/ui/EditPolygonImageView$EditPolygonDragListener;", "editPolygonDragStateListener", "Lio/scanbot/sdk/ui/EditPolygonImageView$EditPolygonDragStateListener;", "finger", "fullPolygonSelected", "", "getFullPolygonSelected", "()Z", "setFullPolygonSelected", "(Z)V", "handlePaint", "Landroid/graphics/Paint;", "handleSize", "", "horizontalLines", "Lio/scanbot/sdk/util/view/PolygonViewHelper$Line;", "horizontalLines2D", "Lio/scanbot/sdk/core/contourdetector/Line2D;", "imageMatrix", "", "imageView", "Landroidx/appcompat/widget/AppCompatImageView;", "isPointsDraggable", "setPointsDraggable", "lastKnownImageHeight", "lastKnownImageWidth", "lastTargetRotation", "", "magneticLineTreshold", "magnifierView", "Lio/scanbot/sdk/ui/MagnifierView;", "medianX", "medianY", "offsetX", "offsetY", "paint", "paintOnLine", "pointsQueue", "Ljava/util/PriorityQueue;", "kotlin.jvm.PlatformType", "newPolygon", "polygon", "getPolygon", "()Ljava/util/List;", "setPolygon", "(Ljava/util/List;)V", "polygonHelper", "Lio/scanbot/sdk/util/EditPolygonViewHelper;", "polygonStrokeWidth", "scaleLandscape", "scalePortrait", "selectedCorner", "selectedEdge", "tmpPointA", "tmpPointB", "touchRect", "Landroid/graphics/RectF;", "verticalLines", "verticalLines2D", "applySystemGestureExclusions", "", "calculateExclusionRectForPoint", "Landroid/graphics/Rect;", "point", "calculateMedian", "checkPolygonSelection", "checkWhetherImageSizeUpdated", "dispatchDraw", "canvas", "Landroid/graphics/Canvas;", "drawHandle", "handle", "degrees", "ensureCornersOrder", "ensureEdgesOrder", "ensureNoPolygonIntersection", "findClosestEdge", "Lkotlin/Pair;", "", "edge", "getRotationScale", "currentRotation", "rotateBy", "keepInsideView", "onAttachedToWindow", "onDetachedFromWindow", "onImageSizeUpdated", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "recolorLinesOnNewPolygonValue", "restoreSelectedEdge", "rotateClockwise", "rotateCounterClockwise", "rotateInternalTo", "targetDegree", "animate", "setAnchorPointsColor", "color", "setEdgeColor", "setEdgeColorOnLine", "setEdgeWidth", "width", "setEditPolygonAnimationEndListener", "setEditPolygonDragListener", "setEditPolygonDragStateListener", "setImageBitmap", "bitmap", "setLines", "setLinesSync", "setMagnifier", "magnifier", "setPolygonSync", "setRotation", "rotation", "setRotationAnimated", "updateEdges", "Companion", "EditPolygonAnimationEndListener", "EditPolygonDragListener", "EditPolygonDragStateListener", "sdk-bundle_release"})
@SourceDebugExtension(value={"SMAP\nEditPolygonImageView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditPolygonImageView.kt\nio/scanbot/sdk/ui/EditPolygonImageView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 View.kt\nandroidx/core/view/ViewKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,836:1\n1#2:837\n168#3,2:838\n1549#4:840\n1620#4,3:841\n1864#4,3:844\n1864#4,3:847\n766#4:850\n857#4,2:851\n1549#4:853\n1620#4,3:854\n1549#4:857\n1620#4,3:858\n1726#4,2:861\n1747#4,3:863\n1728#4:866\n*S KotlinDebug\n*F\n+ 1 EditPolygonImageView.kt\nio/scanbot/sdk/ui/EditPolygonImageView\n*L\n198#1:838,2\n582#1:840\n582#1:841,3\n612#1:844,3\n620#1:847,3\n633#1:850\n633#1:851,2\n633#1:853\n633#1:854,3\n636#1:857\n636#1:858,3\n655#1:861,2\n656#1:863,3\n655#1:866\n*E\n"})
public final class EditPolygonImageView
extends FrameLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int CORNERS_COUNT = 4;
    private static final double FULL_POLYGON_THRESHOLD = 0.01;
    private static final int FULL_CIRCLE = 360;
    private static final int GESTURE_EXCLUSION_OFFSET = 360;
    @Nullable
    private EditPolygonAnimationEndListener editPolygonAnimationEndListener;
    @Nullable
    private EditPolygonDragListener editPolygonDragListener;
    @Nullable
    private EditPolygonDragStateListener editPolygonDragStateListener;
    private float magneticLineTreshold;
    @Nullable
    private Drawable cornerDrawable;
    @Nullable
    private Drawable edgeDrawable;
    @NotNull
    private final Paint paint;
    @NotNull
    private final Paint paintOnLine;
    @NotNull
    private final Paint handlePaint;
    @NotNull
    private final EditPolygonViewHelper polygonHelper;
    private float lastTargetRotation;
    @Nullable
    private ViewPropertyAnimator animator;
    @NotNull
    private final AppCompatImageView imageView;
    private boolean isPointsDraggable;
    @NotNull
    private final List<Line2D> horizontalLines2D;
    @NotNull
    private final List<Line2D> verticalLines2D;
    @NotNull
    private final List<PolygonViewHelper.Line> horizontalLines;
    @NotNull
    private final List<PolygonViewHelper.Line> verticalLines;
    @NotNull
    private final PointF finger;
    @NotNull
    private List<? extends PointF> _polygon;
    @NotNull
    private final List<PointF> corners;
    @NotNull
    private final List<PolygonViewHelper.Edge> edges;
    private float offsetX;
    private float offsetY;
    @Nullable
    private Bitmap cornerBitmap;
    @Nullable
    private Bitmap edgeBitmap;
    private int handleSize;
    @Nullable
    private PointF selectedCorner;
    @Nullable
    private PolygonViewHelper.Edge selectedEdge;
    @NotNull
    private final PointF tmpPointA;
    @NotNull
    private final PointF tmpPointB;
    private float medianX;
    private float medianY;
    @NotNull
    private final PriorityQueue<PointF> pointsQueue;
    @Nullable
    private MagnifierView magnifierView;
    @NotNull
    private final float[] imageMatrix;
    @NotNull
    private final RectF touchRect;
    private float polygonStrokeWidth;
    private int lastKnownImageWidth;
    private int lastKnownImageHeight;
    private float scaleLandscape;
    private float scalePortrait;
    private boolean fullPolygonSelected;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EditPolygonImageView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Throwable throwable2;
        TypedArray typedArray;
        block7: {
            ArrayList arrayList;
            EditPolygonViewHelper editPolygonViewHelper;
            Paint paint;
            Paint paint2;
            Paint paint3;
            Paint paint4;
            int n;
            Object object;
            block6: {
                RectF rectF;
                PriorityQueue priorityQueue;
                PointF pointF;
                PointF pointF2;
                PointF pointF3;
                ArrayList arrayList2;
                ArrayList arrayList3;
                ArrayList arrayList4;
                ArrayList arrayList5;
                AppCompatImageView appCompatImageView;
                void var2_6;
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                super((Context)typedArray, (AttributeSet)var2_6);
                this.lastTargetRotation = this.getRotation();
                object = appCompatImageView;
                appCompatImageView = new AppCompatImageView((Context)typedArray, (AttributeSet)var2_6);
                this.addView((View)object);
                this.imageView = object;
                this.isPointsDraggable = true;
                object = arrayList5;
                arrayList5 = new ArrayList();
                this.horizontalLines2D = object;
                object = arrayList4;
                arrayList4 = new ArrayList();
                this.verticalLines2D = object;
                object = arrayList3;
                arrayList3 = new ArrayList();
                this.horizontalLines = object;
                object = arrayList2;
                arrayList2 = new ArrayList();
                this.verticalLines = object;
                object = pointF3;
                pointF3 = new PointF();
                this.finger = object;
                object = pointF2;
                pointF2 = new PointF();
                this.tmpPointA = object;
                object = pointF;
                pointF = new PointF();
                this.tmpPointB = object;
                object = priorityQueue;
                priorityQueue = new PriorityQueue(4, (arg_0, arg_1) -> EditPolygonImageView.pointsQueue$lambda$2(this, arg_0, arg_1));
                this.pointsQueue = object;
                this.imageMatrix = new float[9];
                object = rectF;
                rectF = new RectF();
                this.touchRect = object;
                this.lastKnownImageWidth = -1;
                this.lastKnownImageHeight = -1;
                this.scaleLandscape = 1.0f;
                this.scalePortrait = 1.0f;
                object = null;
                if (!this.isInEditMode() && !ScanbotSDKInitializer.Companion.isInitialized()) {
                    throw new IllegalStateException("Scanbot SDK is not initialized. Please use ScanbotSDKInitializer for the first SDK initialization.".toString());
                }
                typedArray = typedArray.getTheme().obtainStyledAttributes((AttributeSet)var2_6, R.styleable.EditPolygonImageView, 0, 0);
                Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
                try {
                    n = typedArray.getColor(R.styleable.EditPolygonImageView_edgeColor, 0);
                    if (!typedArray.hasValue(R.styleable.EditPolygonImageView_anchorPointColor)) break block6;
                    object = typedArray.getColor(R.styleable.EditPolygonImageView_anchorPointColor, 0);
                }
                catch (Throwable throwable2) {
                    break block7;
                }
            }
            TypedArray typedArray2 = typedArray;
            int n2 = typedArray2.getColor(R.styleable.EditPolygonImageView_edgeColorOnLine, n);
            this.cornerDrawable = this.getResources().getDrawable(typedArray.getResourceId(R.styleable.EditPolygonImageView_cornerImageSrc, R.drawable.ui_crop_handle_corner));
            this.edgeDrawable = this.getResources().getDrawable(typedArray.getResourceId(R.styleable.EditPolygonImageView_edgeImageSrc, R.drawable.ui_crop_handle_horizontal));
            this.magneticLineTreshold = typedArray2.getDimension(R.styleable.EditPolygonImageView_magneticLineTreshold, this.getResources().getDimension(R.dimen.magnetic_line_treshold));
            this.polygonStrokeWidth = typedArray2.getDimension(R.styleable.EditPolygonImageView_editPolygonStrokeWidth, this.getResources().getDimension(R.dimen.polygon_stroke_width));
            this.handleSize = typedArray2.getDimensionPixelSize(R.styleable.EditPolygonImageView_editPolygonHandleSize, this.getResources().getDimensionPixelSize(R.dimen.edit_polygon_handle_size));
            typedArray2.recycle();
            this._polygon = CollectionsKt.emptyList();
            typedArray = paint4;
            super();
            this.paint = typedArray;
            paint4.setColor(n);
            typedArray = Paint.Style.STROKE;
            paint4.setStyle((Paint.Style)typedArray);
            paint4.setStrokeWidth(this.polygonStrokeWidth);
            paint4.setAntiAlias(true);
            Paint.Cap cap = Paint.Cap.SQUARE;
            paint4.setStrokeCap(cap);
            Paint paint5 = paint3 = paint2;
            paint3();
            this.paintOnLine = paint3;
            paint3.setColor(n2);
            paint5.setStyle((Paint.Style)typedArray);
            paint5.setStrokeWidth(this.polygonStrokeWidth);
            paint5.setAntiAlias(true);
            paint2.setStrokeCap(cap);
            typedArray = paint;
            this.handlePaint = typedArray;
            new Paint().setAntiAlias(true);
            typedArray.setFilterBitmap(true);
            if (object != null) {
                PorterDuffColorFilter porterDuffColorFilter;
                int n3 = ((Number)object).intValue();
                cap = porterDuffColorFilter;
                porterDuffColorFilter = new PorterDuffColorFilter(n3, PorterDuff.Mode.MULTIPLY);
                typedArray.setColorFilter((ColorFilter)cap);
            }
            Object object2 = editPolygonViewHelper;
            editPolygonViewHelper = new EditPolygonViewHelper();
            this.polygonHelper = object2;
            object2 = arrayList;
            arrayList = new ArrayList();
            this.corners = object2;
            int n4 = 0;
            while (true) {
                if (n4 >= 4) {
                    ArrayList<PolygonViewHelper.Edge> arrayList6;
                    ArrayList<PolygonViewHelper.Edge> arrayList7 = arrayList6;
                    arrayList6 = new ArrayList<PolygonViewHelper.Edge>();
                    this.edges = arrayList7;
                    this.updateEdges();
                    this.imageView.setPadding(0, 0, 0, 0);
                    return;
                }
                this.corners.add(new PointF());
                ++n4;
            }
        }
        typedArray.recycle();
        throw throwable2;
    }

    private final void updateEdges() {
        EditPolygonImageView editPolygonImageView = this;
        editPolygonImageView.edges.clear();
        int n = 0;
        int n2 = editPolygonImageView.corners.size();
        while (n < n2) {
            PolygonViewHelper.Edge edge;
            PolygonViewHelper.Edge edge2 = edge;
            edge2();
            edge2.pointA = this.corners.get(n);
            int n3 = n + 1;
            edge2.pointB = this.corners.get(n3 % 4);
            edge2.pointFarA = this.corners.get((n + 3) % 4);
            edge.pointFarB = this.corners.get((n + 2) % 4);
            this.edges.add(edge2);
            n = n3;
        }
    }

    private final void ensureEdgesOrder() {
        int n = 0;
        while (n < 4) {
            PolygonViewHelper.Edge edge = this.edges.get(n);
            edge.pointA = this.corners.get(n);
            int n2 = n + 1;
            edge.pointB = this.corners.get(n2 % 4);
            edge.pointFarA = this.corners.get((n + 3) % 4);
            this.edges.get(n).pointFarB = this.corners.get((n + 2) % 4);
            n = n2;
        }
    }

    private final void setLinesSync(List<Line2D> horizontalLines, List<Line2D> verticalLines) {
        PointF pointF;
        ArrayList arrayList;
        PointF pointF2;
        Iterator<Line2D> iterator;
        PointF pointF3;
        PointF pointF4 = pointF3;
        pointF3 = new ArrayList(iterator.size());
        for (Line2D line2D : horizontalLines) {
            PointF pointF5;
            pointF2 = line2D.component1();
            PointF pointF6 = line2D.component2();
            PointF pointF7 = pointF2;
            float f = pointF7.x;
            pointF2 = pointF5;
            PointF pointF8 = pointF6;
            float f2 = pointF8.x;
            pointF5 = new PointF(f2, pointF8.y);
            pointF4.add(new Line2D(new PointF(f, pointF7.y), pointF2));
        }
        EditPolygonImageView editPolygonImageView = this;
        editPolygonImageView.horizontalLines2D.clear();
        editPolygonImageView.horizontalLines2D.addAll(this.polygonHelper.scaleLines((List<Line2D>)pointF4));
        editPolygonImageView.horizontalLines.clear();
        for (Line2D line2D : pointF4) {
            PolygonViewHelper.Line line;
            pointF4 = line2D.component1();
            pointF2 = line2D.component2();
            PolygonViewHelper.Line line2 = line;
            line2();
            line.calculateLine(pointF4, pointF2);
            this.horizontalLines.add(line2);
        }
        iterator = arrayList;
        arrayList = new ArrayList(pointF.size());
        for (Line2D line2D : pointF) {
            PointF pointF9;
            pointF4 = line2D.component1();
            PointF pointF10 = line2D.component2();
            PointF pointF11 = pointF4;
            float f = pointF11.x;
            pointF4 = pointF9;
            PointF pointF12 = pointF10;
            float f3 = pointF12.x;
            pointF9 = new PointF(f3, pointF12.y);
            iterator.add(new Line2D(new PointF(f, pointF11.y), pointF4));
        }
        EditPolygonImageView editPolygonImageView2 = this;
        editPolygonImageView2.verticalLines2D.clear();
        editPolygonImageView2.verticalLines2D.addAll(this.polygonHelper.scaleLines((List<Line2D>)((Object)iterator)));
        editPolygonImageView2.verticalLines.clear();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            PolygonViewHelper.Line line;
            Line2D line2D = (Line2D)iterator.next();
            pointF = line2D.component1();
            pointF4 = line2D.component2();
            PolygonViewHelper.Line line3 = line;
            line3();
            line.calculateLine(pointF, pointF4);
            this.verticalLines.add(line3);
        }
        EditPolygonImageView editPolygonImageView3 = this;
        editPolygonImageView3.updateEdges();
        editPolygonImageView3.recolorLinesOnNewPolygonValue();
        editPolygonImageView3.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    private final void rotateInternalTo(float targetDegree, boolean animate) {
        void var2_4;
        void var1_1;
        EditPolygonImageView editPolygonImageView = this;
        float f = 360;
        void var4_6 = var1_1 % f;
        EditPolygonImageView editPolygonImageView2 = this;
        float f2 = editPolygonImageView2.getRotation();
        f2 = editPolygonImageView.getRotationScale(f2, (float)(var4_6 - editPolygonImageView2.getRotation()));
        editPolygonImageView.lastTargetRotation = var4_6;
        ViewPropertyAnimator viewPropertyAnimator = editPolygonImageView.animator;
        if (viewPropertyAnimator != null) {
            viewPropertyAnimator.cancel();
        }
        if (var2_4 != false) {
            ViewPropertyAnimator viewPropertyAnimator2;
            if (var1_1 >= 360.0f) {
                EditPolygonImageView editPolygonImageView3 = this;
                super.setRotation(editPolygonImageView3.getRotation() - f);
            }
            if (var1_1 <= -360.0f) {
                EditPolygonImageView editPolygonImageView4 = this;
                super.setRotation(editPolygonImageView4.getRotation() + f);
            }
            this.animator = viewPropertyAnimator2 = this.animate().rotation((float)var4_6).scaleX(f2).scaleY(f2).setListener((Animator.AnimatorListener)new ViewUtils.DefaultAnimationListener(this){
                final /* synthetic */ EditPolygonImageView this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                public void onAnimationEnd(@NotNull Animator animation) {
                    Object object;
                    rotateInternalTo.1 v0 = this;
                    Intrinsics.checkNotNullParameter((Object)object, (String)"animation");
                    EditPolygonImageView.access$setAnimator$p(v0.this$0, null);
                    object = EditPolygonImageView.access$getMagnifierView$p(v0.this$0);
                    if (object != null) {
                        ((MagnifierView)((Object)object)).setImageRotation(this.this$0.getRotation());
                    }
                    if ((object = EditPolygonImageView.access$getEditPolygonAnimationEndListener$p(this.this$0)) != null) {
                        object.onAnimationEnded();
                    }
                    this.this$0.invalidate();
                }
            });
            if (viewPropertyAnimator2 != null) {
                viewPropertyAnimator2.start();
            }
        } else {
            MagnifierView magnifierView = this.magnifierView;
            if (magnifierView != null) {
                magnifierView.setImageRotation((float)var4_6);
            }
            EditPolygonImageView editPolygonImageView5 = this;
            editPolygonImageView5.setScaleX(f2);
            editPolygonImageView5.setScaleY(f2);
            editPolygonImageView5.invalidate();
            super.setRotation((float)var4_6);
        }
    }

    static /* synthetic */ void rotateInternalTo$default(EditPolygonImageView editPolygonImageView, float f, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        editPolygonImageView.rotateInternalTo(f, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final float getRotationScale(float currentRotation, float rotateBy) {
        void var2_2;
        return Math.abs((currentRotation + var2_2) % (float)360) / (float)90 % (float)2 == 0.0f ? this.scalePortrait : this.scaleLandscape;
    }

    private final void checkWhetherImageSizeUpdated() {
        Drawable drawable2 = this.imageView.getDrawable();
        if (drawable2 == null) {
            return;
        }
        if (drawable2.getIntrinsicWidth() != this.lastKnownImageWidth || drawable2.getIntrinsicHeight() != this.lastKnownImageHeight) {
            this.lastKnownImageWidth = drawable2.getIntrinsicWidth();
            this.lastKnownImageHeight = drawable2.getIntrinsicHeight();
            this.onImageSizeUpdated();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void drawHandle(Canvas canvas, PointF point, Bitmap handle, float degrees) {
        if (handle != null) {
            void var3_7;
            void var2_4;
            void var4_8;
            void var1_2;
            var1_2.save();
            if (var4_8 != 0.0f) {
                void v0 = var2_4;
                float f = v0.x;
                float f2 = v0.y;
                var1_2.rotate((float)var4_8, f, f2);
            }
            void v1 = var1_2;
            void v2 = var2_4;
            void v3 = var2_4;
            EditPolygonImageView editPolygonImageView = this;
            float f = 1.0f / editPolygonImageView.getRotationScale(editPolygonImageView.getRotation(), 0.0f);
            float f3 = v3.x;
            float f4 = v3.y;
            float f5 = f;
            var1_2.scale(f5, f5, f3, f4);
            f = v2.x - (float)(var3_7.getWidth() >> 1);
            f3 = v2.y - (float)(var3_7.getHeight() >> 1);
            Paint paint = this.handlePaint;
            v1.drawBitmap((Bitmap)var3_7, f, f3, paint);
            v1.restore();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void keepInsideView(PointF point) {
        void var1_1;
        PointF pointF = point;
        float f = 2;
        pointF.set(RangesKt.coerceIn((float)pointF.x, (float)0.0f, (float)((float)this.getWidth() - f * this.offsetX)), RangesKt.coerceIn((float)var1_1.y, (float)0.0f, (float)((float)this.getHeight() - f * this.offsetY)));
    }

    /*
     * WARNING - void declaration
     */
    private final void setPolygonSync(List<? extends PointF> newPolygon) {
        if (newPolygon.isEmpty() ^ true) {
            void var1_1;
            ArrayList<? extends PointF> arrayList;
            ArrayList<? extends PointF> arrayList2 = arrayList;
            arrayList = new ArrayList<PointF>(CollectionsKt.collectionSizeOrDefault((Iterable)var1_1, (int)10));
            Iterator iterator = var1_1.iterator();
            while (iterator.hasNext()) {
                PointF pointF;
                PointF pointF2 = pointF = (PointF)iterator.next();
                float f = pointF2.x;
                arrayList2.add((PointF)new PointF(f, pointF2.y));
            }
            this._polygon = arrayList2;
            if (this.corners.isEmpty() ^ true) {
                this.polygonHelper.getDrawingPolygon((List)var1_1, this.corners);
            }
            EditPolygonImageView editPolygonImageView = this;
            editPolygonImageView.checkPolygonSelection();
            if (editPolygonImageView.verticalLines.isEmpty() ^ true || this.horizontalLines.isEmpty() ^ true) {
                EditPolygonImageView editPolygonImageView2 = this;
                editPolygonImageView2.updateEdges();
                editPolygonImageView2.recolorLinesOnNewPolygonValue();
            }
            EditPolygonImageView editPolygonImageView3 = this;
            editPolygonImageView3.applySystemGestureExclusions();
            editPolygonImageView3.invalidate();
        }
    }

    private final void recolorLinesOnNewPolygonValue() {
        for (PolygonViewHelper.Edge edge : this.edges) {
            Pair<Line2D, Double> pair = this.findClosestEdge(edge, edge.getHandle());
            double d = ((Number)pair.component2()).doubleValue();
            boolean bl = (Line2D)pair.component1() != null && d < (double)this.magneticLineTreshold;
            edge.isDetectedLine = bl;
        }
    }

    private final Pair<Line2D, Double> findClosestEdge(PolygonViewHelper.Edge edge, PointF finger) {
        Line2D line2D = null;
        double d = Double.MAX_VALUE;
        if (edge.isHorizontal()) {
            int n = 0;
            for (Object t : this.horizontalLines) {
                double d2;
                int n2 = n + 1;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                double d3 = ((PolygonViewHelper.Line)t).getDistanceToPoint((PointF)var2_2);
                if (d2 < d) {
                    line2D = this.horizontalLines2D.get(n);
                    d = d3;
                }
                n = n2;
            }
        } else {
            int n = 0;
            for (Object t : this.verticalLines) {
                double d3;
                int n3 = n + 1;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                double d5 = ((PolygonViewHelper.Line)t).getDistanceToPoint((PointF)var2_2);
                if (d3 < d) {
                    line2D = this.verticalLines2D.get(n);
                    d = d5;
                }
                n = n3;
            }
        }
        return new Pair(line2D, (Object)d);
    }

    private final void applySystemGestureExclusions() {
        if (Build.VERSION.SDK_INT >= 29) {
            ArrayList<Rect> arrayList;
            ArrayList arrayList2;
            ArrayList arrayList3;
            Object object2 = arrayList3;
            arrayList3 = new ArrayList();
            for (Object object3 : this.edges) {
                if (!(((PolygonViewHelper.Edge)object3).isHorizontal() ^ true)) continue;
                object2.add(object3);
            }
            ArrayList arrayList4 = arrayList2;
            arrayList2 = new ArrayList(CollectionsKt.collectionSizeOrDefault(object2, (int)10));
            object2 = object2.iterator();
            while (object2.hasNext()) {
                PointF pointF = ((PolygonViewHelper.Edge)object2.next()).getHandle();
                Intrinsics.checkNotNullExpressionValue((Object)pointF, (String)"getHandle(...)");
                arrayList4.add(this.calculateExclusionRectForPoint(pointF));
            }
            object2 = this.corners;
            ArrayList<Rect> arrayList5 = arrayList;
            arrayList = new ArrayList<Rect>(CollectionsKt.collectionSizeOrDefault(object2, (int)10));
            object2 = object2.iterator();
            while (object2.hasNext()) {
                arrayList5.add(this.calculateExclusionRectForPoint((PointF)object2.next()));
            }
            this.setSystemGestureExclusionRects(CollectionsKt.plus(arrayList5, (Iterable)arrayList4));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Rect calculateExclusionRectForPoint(PointF point) {
        void var1_2;
        int n = this.handleSize / 2;
        float f = n;
        void v0 = var1_2;
        int n2 = RangesKt.coerceIn((int)((int)(v0.y - f + this.offsetY)), (int)0, (int)this.getHeight());
        int n3 = RangesKt.coerceIn((int)((int)(v0.x + f + this.offsetX)), (int)0, (int)this.getWidth());
        int n4 = RangesKt.coerceIn((int)((int)(v0.y + f + this.offsetY)), (int)0, (int)this.getHeight());
        return new Rect(RangesKt.coerceIn((int)((int)(var1_2.x - f + this.offsetX)), (int)0, (int)this.getWidth()), n2, n3, n4);
    }

    /*
     * Unable to fully structure code
     */
    private final void checkPolygonSelection() {
        var1_1 = PolygonHelper.Companion.getFullPolygon();
        if (var1_1 instanceof Collection && var1_1.isEmpty()) {
            while (true) {
                var1_2 = true;
                break;
            }
        } else {
            var1_1 = var1_1.iterator();
            block1: while (true) lbl-1000:
            // 2 sources

            {
                if (!var1_1.hasNext()) ** continue;
                var2_3 = (PointF)var1_1.next();
                var3_4 = this.getPolygon();
                if (var3_4 instanceof Collection && var3_4.isEmpty()) break;
                for (PointF var4_5 : var3_4) {
                    if (!((double)Math.abs(var2_3.x - var4_5.x) < 0.01) || !((double)Math.abs(var2_3.y - var4_5.y) < 0.01)) continue;
                    continue block1;
                    ** continue;
                }
                break;
            }
            var1_2 = false;
        }
        if (this.fullPolygonSelected != var1_2) {
            var2_3 = this.editPolygonDragListener;
            if (var2_3 != null) {
                v0 = var2_3;
                Intrinsics.checkNotNull((Object)v0);
                v0.onPolygonSelectedStateChanged(var1_2);
            }
            this.fullPolygonSelected = var1_2;
        }
    }

    private final void restoreSelectedEdge() {
        PolygonViewHelper.Edge edge = this_.selectedEdge;
        if (edge != null) {
            PolygonViewHelper.Edge edge2 = edge;
            edge2.pointA.set(this_.tmpPointA);
            edge2.pointB.set(this_.tmpPointB);
            PolygonViewHelper.Edge edge3 = edge;
            EditPolygonImageView this_ = edge3.pointA;
            edge2.edgeLine.calculateLine((PointF)this_, edge3.pointB);
        }
    }

    private final void ensureNoPolygonIntersection() {
        EditPolygonImageView editPolygonImageView = this;
        editPolygonImageView.calculateMedian();
        if (editPolygonImageView.ensureCornersOrder()) {
            this.ensureEdgesOrder();
        }
    }

    private final boolean ensureCornersOrder() {
        boolean bl = false;
        ((AbstractCollection)this.pointsQueue).addAll(this.corners);
        for (int i = 0; i < 4; ++i) {
            PointF pointF = (PointF)this.pointsQueue.remove();
            if (!Intrinsics.areEqual((Object)pointF, (Object)this.corners.get(i))) {
                bl = true;
            }
            Intrinsics.checkNotNull((Object)pointF);
            this.corners.set(i, pointF);
        }
        return bl;
    }

    private final void calculateMedian() {
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < 4; ++i) {
            float f3 = f2;
            PointF pointF = this.corners.get(i);
            f2 = f + pointF.x;
            f = f3 + pointF.y;
            float f4 = f2;
            f2 = f;
            f = f4;
        }
        this.medianX = f / 4.0f;
        this.medianY = f2 / 4.0f;
    }

    private final void onImageSizeUpdated() {
        Drawable drawable2 = this.imageView.getDrawable();
        if (drawable2 != null) {
            float f;
            this.offsetX = 0.0f;
            this.offsetY = 0.0f;
            this.imageView.getImageMatrix().getValues(this.imageMatrix);
            int n = drawable2.getIntrinsicWidth();
            int n2 = drawable2.getIntrinsicHeight();
            float f2 = n;
            float f3 = f2 * this.getScaleX();
            float f4 = n2;
            float f5 = f4 * this.getScaleY();
            RectF rectF = new RectF(0.0f, 0.0f, f3, f5);
            this.scalePortrait = ViewUtils.fitRectToView((View)this, 0.0f, rectF) * this.getScaleX();
            this.scaleLandscape = ViewUtils.fitRectToView((View)this, 90.0f, rectF) * this.getScaleY();
            if (f * this.scalePortrait < (float)this.getWidth()) {
                this.offsetX = this.getWidth() - (int)(f2 * this.scalePortrait) >> 1;
            }
            if (f4 * this.scalePortrait < (float)this.getHeight()) {
                this.offsetY = this.getHeight() - (int)(f4 * this.scalePortrait) >> 1;
            }
            this.polygonHelper.setImageSize((int)Math.ceil((double)n * (double)this.scalePortrait), (int)Math.ceil((double)n2 * (double)this.scalePortrait));
            this.scaleLandscape /= this.scalePortrait;
            this.scalePortrait = 1.0f;
            if (this.getRotation() / (float)90 % (float)2 == 1.0f) {
                this.setScaleX(this.scaleLandscape);
                this.setScaleY(this.scaleLandscape);
            }
            if (this._polygon.isEmpty() ^ true) {
                this.polygonHelper.getDrawingPolygon(this._polygon, this.corners);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void _set_polygon_$lambda$1(EditPolygonImageView this$0, List $newPolygon) {
        void var1_1;
        EditPolygonImageView editPolygonImageView;
        Intrinsics.checkNotNullParameter((Object)((Object)editPolygonImageView), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"$newPolygon");
        this$0.setPolygonSync((List<? extends PointF>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static final int pointsQueue$lambda$2(EditPolygonImageView this$0, PointF lhs, PointF rhs) {
        void var2_2;
        void var1_1;
        EditPolygonImageView editPolygonImageView;
        Intrinsics.checkNotNullParameter((Object)((Object)editPolygonImageView), (String)"this$0");
        return Double.compare(Math.atan2((double)lhs.y - (double)editPolygonImageView.medianY, (double)var1_1.x - (double)editPolygonImageView.medianX), Math.atan2((double)var2_2.y - (double)editPolygonImageView.medianY, (double)var2_2.x - (double)editPolygonImageView.medianX));
    }

    /*
     * WARNING - void declaration
     */
    private static final void setLines$lambda$7(EditPolygonImageView this$0, List $horizontalLines, List $verticalLines) {
        void var2_2;
        void var1_1;
        EditPolygonImageView editPolygonImageView;
        Intrinsics.checkNotNullParameter((Object)((Object)editPolygonImageView), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"$horizontalLines");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"$verticalLines");
        this$0.setLinesSync((List<Line2D>)var1_1, (List<Line2D>)var2_2);
    }

    @NotNull
    public static final List<PointF> getDefaultPolygon() {
        return Companion.getDefaultPolygon();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setAnimator$p(EditPolygonImageView $this, ViewPropertyAnimator viewPropertyAnimator) {
        void var1_1;
        $this.animator = var1_1;
    }

    public static final /* synthetic */ MagnifierView access$getMagnifierView$p(EditPolygonImageView $this) {
        return $this.magnifierView;
    }

    public static final /* synthetic */ EditPolygonAnimationEndListener access$getEditPolygonAnimationEndListener$p(EditPolygonImageView $this) {
        return $this.editPolygonAnimationEndListener;
    }

    @NotNull
    public final Drawable getDrawable() {
        Drawable drawable2 = this.imageView.getDrawable();
        Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"getDrawable(...)");
        return drawable2;
    }

    public final boolean isPointsDraggable() {
        return this.isPointsDraggable;
    }

    /*
     * WARNING - void declaration
     */
    public final void setPointsDraggable(boolean bl) {
        void var1_1;
        this.isPointsDraggable = var1_1;
    }

    @NotNull
    public final List<PointF> getPolygon() {
        if (this.corners.isEmpty() ^ true && this._polygon.isEmpty() ^ true) {
            EditPolygonImageView editPolygonImageView = this;
            List<PointF> list = editPolygonImageView.corners;
            this.polygonHelper.getPolygonFromDrawingPolygon(list, editPolygonImageView._polygon);
        }
        return this._polygon;
    }

    /*
     * WARNING - void declaration
     */
    public final void setPolygon(@NotNull List<? extends PointF> newPolygon) {
        void var1_1;
        EditPolygonImageView editPolygonImageView = this;
        void v1 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v1, (String)"newPolygon");
        editPolygonImageView.post(() -> EditPolygonImageView._set_polygon_$lambda$1(editPolygonImageView, (List)v1));
    }

    public final boolean getFullPolygonSelected() {
        return this.fullPolygonSelected;
    }

    /*
     * WARNING - void declaration
     */
    public final void setFullPolygonSelected(boolean bl) {
        void var1_1;
        this.fullPolygonSelected = var1_1;
    }

    protected void onAttachedToWindow() {
        EditPolygonImageView editPolygonImageView = this;
        super.onAttachedToWindow();
        Drawable drawable2 = editPolygonImageView.cornerDrawable;
        if (drawable2 != null) {
            this.cornerBitmap = BitmapUtils.drawableToBitmap((Drawable)drawable2);
        }
        if ((drawable2 = this.edgeDrawable) != null) {
            this.edgeBitmap = BitmapUtils.drawableToBitmap((Drawable)drawable2);
        }
    }

    protected void onDetachedFromWindow() {
        EditPolygonImageView editPolygonImageView = this;
        super.onDetachedFromWindow();
        Bitmap bitmap = editPolygonImageView.cornerBitmap;
        if (bitmap != null) {
            bitmap.recycle();
        }
        if ((bitmap = this.edgeBitmap) != null) {
            bitmap.recycle();
        }
        EditPolygonImageView editPolygonImageView2 = this;
        editPolygonImageView2.editPolygonAnimationEndListener = null;
        editPolygonImageView2.editPolygonDragListener = null;
    }

    /*
     * WARNING - void declaration
     */
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        void var2_2;
        void var1_1;
        EditPolygonImageView editPolygonImageView = this;
        super.onMeasure((int)var1_1, (int)var2_2);
        editPolygonImageView.onImageSizeUpdated();
    }

    /*
     * WARNING - void declaration
     */
    public void setRotation(float rotation) {
        void var1_1;
        this.rotateInternalTo((float)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public final void setRotationAnimated(float rotation) {
        void var1_1;
        this.rotateInternalTo((float)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public final void setLines(@NotNull List<Line2D> horizontalLines, @NotNull List<Line2D> verticalLines) {
        void var2_2;
        void var1_1;
        EditPolygonImageView editPolygonImageView = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"horizontalLines");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"verticalLines");
        editPolygonImageView.post(() -> EditPolygonImageView.setLines$lambda$7(editPolygonImageView, (List)var1_1, (List)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final void setEdgeColor(int color) {
        void var1_1;
        this.paint.setColor((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setAnchorPointsColor(int color) {
        void var1_1;
        this.handlePaint.setColorFilter((ColorFilter)new PorterDuffColorFilter((int)var1_1, PorterDuff.Mode.MULTIPLY));
    }

    /*
     * WARNING - void declaration
     */
    public final void setEdgeColorOnLine(int color) {
        void var1_1;
        this.paintOnLine.setColor((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setEdgeWidth(float width) {
        void var1_1;
        EditPolygonImageView editPolygonImageView = this;
        editPolygonImageView.polygonStrokeWidth = var1_1;
        editPolygonImageView.paint.setStrokeWidth((float)var1_1);
        editPolygonImageView.paintOnLine.setStrokeWidth(this.polygonStrokeWidth);
    }

    public final void rotateClockwise() {
        EditPolygonImageView editPolygonImageView = this;
        editPolygonImageView.rotateInternalTo(editPolygonImageView.lastTargetRotation + 90.0f, true);
    }

    public final void rotateCounterClockwise() {
        EditPolygonImageView editPolygonImageView = this;
        editPolygonImageView.rotateInternalTo(editPolygonImageView.lastTargetRotation - 90.0f, true);
    }

    /*
     * WARNING - void declaration
     */
    protected void dispatchDraw(@NotNull Canvas canvas) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.dispatchDraw((Canvas)var1_1);
        this.checkWhetherImageSizeUpdated();
        if (this._polygon.isEmpty() ^ true) {
            float f;
            float f2;
            void v0 = var1_1;
            v0.save();
            v0.translate(this.offsetX, this.offsetY);
            for (PolygonViewHelper.Edge edge : this.edges) {
                PointF pointF = edge.pointA;
                float f3 = pointF.x;
                f2 = pointF.y;
                PointF pointF2 = edge.pointB;
                f = pointF2.x;
                float f4 = pointF2.y;
                Paint paint = edge.isDetectedLine ? this.paintOnLine : this.paint;
                var1_1.drawLine(f3, f2, f, f4, paint);
            }
            Object object = this.selectedCorner;
            if (object != null) {
                void v4 = var1_1;
                Intrinsics.checkNotNull((Object)object);
                Bitmap bitmap = this.cornerBitmap;
                this.drawHandle((Canvas)var1_1, (PointF)object, bitmap, 0.0f);
                v4.save();
                v4.translate(-this.offsetX, -this.offsetY);
                if (this.magnifierView != null) {
                    PointF pointF;
                    object = pointF;
                    PointF pointF3 = this.selectedCorner;
                    Intrinsics.checkNotNull((Object)pointF3);
                    float f5 = 2;
                    float f6 = pointF3.x / ((float)this.getWidth() - f5 * this.offsetX);
                    PointF pointF4 = this.selectedCorner;
                    Intrinsics.checkNotNull((Object)pointF4);
                    pointF = new PointF(f6, pointF4.y / ((float)this.getHeight() - f5 * this.offsetY));
                    MagnifierView magnifierView = this.magnifierView;
                    Intrinsics.checkNotNull((Object)((Object)magnifierView));
                    magnifierView.drawMagnifier((PointF)object);
                }
                var1_1.restore();
            } else {
                object = this.selectedEdge;
                if (object != null) {
                    PointF pointF = object;
                    Intrinsics.checkNotNull((Object)pointF);
                    object = pointF.getHandle();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getHandle(...)");
                    Bitmap bitmap = this.edgeBitmap;
                    PolygonViewHelper.Edge edge = this.selectedEdge;
                    Intrinsics.checkNotNull((Object)edge);
                    f2 = edge.getAngleInDegrees();
                    this.drawHandle((Canvas)var1_1, (PointF)object, bitmap, f2);
                } else {
                    for (PolygonViewHelper.Edge edge : this.edges) {
                        PointF pointF = edge.getHandle();
                        Intrinsics.checkNotNullExpressionValue((Object)pointF, (String)"getHandle(...)");
                        Bitmap bitmap = this.edgeBitmap;
                        f = edge.getAngleInDegrees();
                        this.drawHandle((Canvas)var1_1, pointF, bitmap, f);
                    }
                    for (PointF pointF : this.corners) {
                        Bitmap bitmap = this.cornerBitmap;
                        this.drawHandle((Canvas)var1_1, pointF, bitmap, 0.0f);
                    }
                }
            }
            var1_1.restore();
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isPointsDraggable) {
            return true;
        }
        switch (var1_1.getAction()) {
            default: {
                return super.onTouchEvent((MotionEvent)var1_1);
            }
            case 2: {
                var2_2 = this.selectedCorner;
                if (var2_2 == null) ** GOTO lbl18
                Intrinsics.checkNotNull((Object)var2_2);
                var2_2.set(var1_1.getX() - this.offsetX, var1_1.getY() - this.offsetY);
                var1_1 = this.selectedCorner;
                Intrinsics.checkNotNull((Object)var1_1);
                this.keepInsideView((PointF)var1_1);
                this.ensureNoPolygonIntersection();
                this.invalidate();
                ** GOTO lbl114
lbl18:
                // 1 sources

                if (this.selectedEdge == null) ** GOTO lbl114
                v0 = var1_1;
                v1 = v0.getX();
                v2 = this.selectedEdge;
                Intrinsics.checkNotNull((Object)v2);
                var2_3 = v1 - v2.prevX;
                v3 = v0.getY();
                v4 = this.selectedEdge;
                Intrinsics.checkNotNull((Object)v4);
                var3_10 = v3 - v4.prevY;
                this.finger.offset(var2_3, var3_10);
                v5 = this.selectedEdge;
                Intrinsics.checkNotNull((Object)v5);
                this.tmpPointA.set(v5.pointA);
                v6 = this.selectedEdge;
                Intrinsics.checkNotNull((Object)v6);
                this.tmpPointB.set(v6.pointB);
                var2_4 = this.selectedEdge;
                Intrinsics.checkNotNull((Object)var2_4);
                var3_11 = this.finger;
                var2_4 = this.findClosestEdge((PolygonViewHelper.Edge)var2_4, var3_11);
                var3_11 = (Line2D)var2_4.component1();
                var4_16 = ((Number)var2_4.component2()).doubleValue();
                if (var3_11 != null && var4_16 < (double)this.magneticLineTreshold) {
                    v7 = this.selectedEdge;
                    Intrinsics.checkNotNull((Object)v7);
                    v7.pointA.set(var3_11.start);
                    v8 = this.selectedEdge;
                    Intrinsics.checkNotNull((Object)v8);
                    v8.pointB.set(var3_11.end);
                    Intrinsics.checkNotNull((Object)this.selectedEdge);
                    this.selectedEdge.isDetectedLine = true;
                } else {
                    Intrinsics.checkNotNull((Object)this.selectedEdge);
                    this.selectedEdge.isDetectedLine = false;
                    v9 = this.selectedEdge;
                    Intrinsics.checkNotNull((Object)v9);
                    var2_4 = v9.getHandle();
                    v10 = this.finger;
                    var3_12 = v10.x - var2_4.x;
                    var2_5 = v10.y - var2_4.y;
                    v11 = this.selectedEdge;
                    Intrinsics.checkNotNull((Object)v11);
                    v11.pointA.offset(var3_12, var2_5);
                    v12 = this.selectedEdge;
                    Intrinsics.checkNotNull((Object)v12);
                    v12.pointB.offset(var3_12, var2_5);
                }
                v13 = this.selectedEdge;
                Intrinsics.checkNotNull((Object)v13);
                v14 = v13.edgeLine;
                v15 = this.selectedEdge;
                Intrinsics.checkNotNull((Object)v15);
                v16 = v15.pointA;
                v17 = this.selectedEdge;
                Intrinsics.checkNotNull((Object)v17);
                v14.calculateLine(v16, v17.pointB);
                v18 = this.selectedEdge;
                Intrinsics.checkNotNull((Object)v18);
                v19 = v18.edgeLine;
                v20 = this.selectedEdge;
                Intrinsics.checkNotNull((Object)v20);
                var2_6 = v19.getIntersectionPoint(v20.lineA);
                if (Float.isNaN(var2_6.x) || Float.isNaN(var2_6.y)) ** GOTO lbl112
                v21 = this.selectedEdge;
                Intrinsics.checkNotNull((Object)v21);
                v21.pointA.set(var2_6);
                v22 = this.selectedEdge;
                Intrinsics.checkNotNull((Object)v22);
                v23 = v22.edgeLine;
                v24 = this.selectedEdge;
                Intrinsics.checkNotNull((Object)v24);
                var2_6 = v23.getIntersectionPoint(v24.lineB);
                if (!Float.isNaN(var2_6.x) && !Float.isNaN(var2_6.y)) {
                    v25 = this.selectedEdge;
                    Intrinsics.checkNotNull((Object)v25);
                    v25.pointB.set(var2_6);
                    v26 = this.selectedEdge;
                    Intrinsics.checkNotNull((Object)v26);
                    var2_6 = v26.pointA;
                    Intrinsics.checkNotNullExpressionValue((Object)var2_6, (String)"pointA");
                    super.keepInsideView(var2_6);
                    v27 = this.selectedEdge;
                    Intrinsics.checkNotNull((Object)v27);
                    var2_6 = v27.pointB;
                    Intrinsics.checkNotNullExpressionValue((Object)var2_6, (String)"pointB");
                    super.keepInsideView(var2_6);
                    Intrinsics.checkNotNull((Object)this.selectedEdge);
                    this.selectedEdge.prevX = var1_1.getX();
                    Intrinsics.checkNotNull((Object)this.selectedEdge);
                    this.selectedEdge.prevY = var1_1.getY();
                    this.invalidate();
                } else {
                    super.restoreSelectedEdge();
                    return false;
lbl112:
                    // 1 sources

                    super.restoreSelectedEdge();
                    return false;
                }
lbl114:
                // 3 sources

                this.checkPolygonSelection();
                return true;
            }
            case 1: 
            case 3: {
                this.selectedCorner = null;
                this.selectedEdge = null;
                var1_1 = this.magnifierView;
                if (var1_1 != null) {
                    v28 = var1_1;
                    Intrinsics.checkNotNull((Object)v28);
                    v28.eraseMagnifier();
                }
                if ((var1_1 = this.editPolygonDragStateListener) != null) {
                    var1_1.onPolygonDragStateChanged(false);
                }
                this.applySystemGestureExclusions();
                this.invalidate();
                return true;
            }
            case 0: 
        }
        var2_7 = this.handleSize >> 1;
        v29 = var2_7;
        var2_8 = v29;
        v30 = var1_1;
        var3_13 = v30.getY() - this.offsetY - var2_8;
        var4_17 = v30.getX() - this.offsetX + var2_8;
        var2_8 = v30.getY() - this.offsetY + var2_8;
        this.touchRect.set(var1_1.getX() - this.offsetX - v29, var3_13, var4_17, var2_8);
        var2_9 = this.corners.iterator();
        while (var2_9.hasNext()) {
            v31 = var3_14 = var2_9.next();
            var4_17 = v31.x;
            if (!this.touchRect.contains(var4_17, v31.y)) continue;
            this.selectedCorner = var3_14;
            this.invalidate();
            this = this.editPolygonDragStateListener;
            if (this != null) {
                this.onPolygonDragStateChanged(true);
            }
            return true;
        }
        for (PolygonViewHelper.Edge var3_15 : this.edges) {
            v32 = var4_18 = var3_15.getHandle();
            var5_19 = v32.x;
            if (!this.touchRect.contains(var5_19, v32.y)) continue;
            v33 = this.selectedEdge = var3_15;
            var3_15.prevX = var1_1.getX();
            v33.prevY = var1_1.getY();
            v34 = var3_15;
            var1_1 = v34.pointA;
            v33.lineA.calculateLine((PointF)var1_1, v34.pointFarA);
            v35 = var3_15;
            var1_1 = v35.pointB;
            v33.lineB.calculateLine((PointF)var1_1, v35.pointFarB);
            this.finger.set(var4_18);
            this.invalidate();
            this = this.editPolygonDragStateListener;
            if (this != null) {
                this.onPolygonDragStateChanged(true);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final void setImageBitmap(@Nullable Bitmap bitmap) {
        void var1_1;
        this.imageView.setImageBitmap((Bitmap)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setMagnifier(@Nullable MagnifierView magnifier) {
        void var1_1;
        this.magnifierView = var1_1;
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public final void setEditPolygonAnimationEndListener(@Nullable EditPolygonAnimationEndListener editPolygonAnimationEndListener) {
        void var1_1;
        this.editPolygonAnimationEndListener = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setEditPolygonDragListener(@Nullable EditPolygonDragListener editPolygonDragListener) {
        void var1_1;
        this.editPolygonDragListener = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setEditPolygonDragStateListener(@Nullable EditPolygonDragStateListener editPolygonDragStateListener) {
        void var1_1;
        this.editPolygonDragStateListener = var1_1;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lio/scanbot/sdk/ui/EditPolygonImageView$Companion;", "", "()V", "CORNERS_COUNT", "", "FULL_CIRCLE", "FULL_POLYGON_THRESHOLD", "", "GESTURE_EXCLUSION_OFFSET", "defaultPolygon", "", "Landroid/graphics/PointF;", "getDefaultPolygon$annotations", "getDefaultPolygon", "()Ljava/util/List;", "sdk-bundle_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public static /* synthetic */ void getDefaultPolygon$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @NotNull
        public final List<PointF> getDefaultPolygon() {
            return new ArrayList<PointF>(){
                {
                    PointF pointF;
                    PointF pointF2;
                    PointF pointF3;
                    PointF pointF4;
                    defaultPolygon.1 v0 = this_;
                    defaultPolygon.1 this_ = pointF4;
                    pointF4 = new PointF(0.0f, 0.0f);
                    ((AbstractCollection)v0).add(this_);
                    this_ = pointF3;
                    pointF3 = new PointF(1.0f, 0.0f);
                    ((AbstractCollection)v0).add(this_);
                    this_ = pointF2;
                    pointF2 = new PointF(1.0f, 1.0f);
                    ((AbstractCollection)v0).add(this_);
                    this_ = pointF;
                    pointF = new PointF(0.0f, 1.0f);
                    ((AbstractCollection)v0).add(this_);
                }
            };
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lio/scanbot/sdk/ui/EditPolygonImageView$EditPolygonAnimationEndListener;", "", "onAnimationEnded", "", "sdk-bundle_release"})
    public static interface EditPolygonAnimationEndListener {
        public void onAnimationEnded();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lio/scanbot/sdk/ui/EditPolygonImageView$EditPolygonDragListener;", "", "onPolygonSelectedStateChanged", "", "isFullPolygonSelected", "", "sdk-bundle_release"})
    public static interface EditPolygonDragListener {
        public void onPolygonSelectedStateChanged(boolean var1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lio/scanbot/sdk/ui/EditPolygonImageView$EditPolygonDragStateListener;", "", "onPolygonDragStateChanged", "", "isDragging", "", "sdk-bundle_release"})
    public static interface EditPolygonDragStateListener {
        public void onPolygonDragStateChanged(boolean var1);
    }
}

