/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.di;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.AssetManager;
import dagger.Lazy;
import dagger.Module;
import dagger.Provides;
import dagger.multibindings.IntoSet;
import io.scanbot.common.Result;
import io.scanbot.sap.SapManager;
import io.scanbot.sdk.analytics.IScanbotAnalyticsManager;
import io.scanbot.sdk.analytics.IScanbotAnalyticsTracker;
import io.scanbot.sdk.analytics.ScanbotAnalyticsManager;
import io.scanbot.sdk.barcode.BarcodeDocumentParserFactory;
import io.scanbot.sdk.barcode.BarcodeScannerFactory;
import io.scanbot.sdk.barcode.IBarcodeDocumentParserFactory;
import io.scanbot.sdk.barcode.IBarcodeScannerFactory;
import io.scanbot.sdk.barcode.ui.result.BarcodeScannerUiResultInternalLruStorage;
import io.scanbot.sdk.barcode.ui.result.BarcodeScannerUiResultInternalRepository;
import io.scanbot.sdk.barcode.ui.result.model.BarcodeScannerUiResultInternal;
import io.scanbot.sdk.blob.BlobFactory;
import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.check.CheckScannerFactory;
import io.scanbot.sdk.check.ICheckScannerFactory;
import io.scanbot.sdk.connectivity.BlobsStorage;
import io.scanbot.sdk.creditcard.CreditCardScannerFactory;
import io.scanbot.sdk.creditcard.ICreditCardScannerFactory;
import io.scanbot.sdk.di.BundleDependencyCheck;
import io.scanbot.sdk.di.DependencyCheckUtils;
import io.scanbot.sdk.di.RequiredDependency;
import io.scanbot.sdk.di.ScanbotSdkModule;
import io.scanbot.sdk.docprocessing.DefaultDraftDocumentProcessor;
import io.scanbot.sdk.docprocessing.DefaultPdfPagesExtractor;
import io.scanbot.sdk.docprocessing.DocumentApi;
import io.scanbot.sdk.docprocessing.DocumentProcessingResult;
import io.scanbot.sdk.docprocessing.DocumentProcessorMonitor;
import io.scanbot.sdk.docprocessing.DocumentRepository;
import io.scanbot.sdk.docprocessing.DraftDocumentProcessor;
import io.scanbot.sdk.docprocessing.PdfPagesExtractor;
import io.scanbot.sdk.docprocessing.ProcessorMonitor;
import io.scanbot.sdk.docprocessing.compose.BaseComposerFactory;
import io.scanbot.sdk.docprocessing.compose.ComposerCache;
import io.scanbot.sdk.docprocessing.compose.ComposerFactory;
import io.scanbot.sdk.docprocessing.compose.InternalComposerCache;
import io.scanbot.sdk.docprocessing.compose.JpegComposer;
import io.scanbot.sdk.docprocessing.compose.SimpleComposer;
import io.scanbot.sdk.docprocessing.draft.CombinedDocumentDraftExtractor;
import io.scanbot.sdk.docprocessing.draft.CompositeDraftExtractor;
import io.scanbot.sdk.docprocessing.draft.DocumentDraftExtractor;
import io.scanbot.sdk.docprocessing.draft.MultipleDocumentsDraftExtractor;
import io.scanbot.sdk.docprocessing.legacy.DraftPageProcessor;
import io.scanbot.sdk.docprocessing.legacy.PageProcessor;
import io.scanbot.sdk.documentdata.DocumentDataExtractorFactory;
import io.scanbot.sdk.documentdata.IDocumentDataExtractorFactory;
import io.scanbot.sdk.documentqualityanalyzer.DocumentQualityAnalyzerFactory;
import io.scanbot.sdk.documentqualityanalyzer.IDocumentQualityAnalyzerFactory;
import io.scanbot.sdk.documentscanner.DocumentScannerEngineMode;
import io.scanbot.sdk.documentscanner.DocumentScannerFactory;
import io.scanbot.sdk.documentscanner.IDocumentScannerFactory;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.DocumentDraft;
import io.scanbot.sdk.intelligence.ImageProcessorBitmapBinarizer;
import io.scanbot.sdk.licensing.Feature;
import io.scanbot.sdk.mc.IMcScannerFactory;
import io.scanbot.sdk.mc.McScannerFactory;
import io.scanbot.sdk.mrz.IMrzScannerFactory;
import io.scanbot.sdk.mrz.MrzScannerFactory;
import io.scanbot.sdk.ocr.OcrEngineExtension;
import io.scanbot.sdk.ocr.ScanbotOcrEngine;
import io.scanbot.sdk.ocr.intelligence.OcrPdfGenerator;
import io.scanbot.sdk.ocr.intelligence.OcrSettings;
import io.scanbot.sdk.ocr.process.compose.OcrComposer;
import io.scanbot.sdk.pdf.DefaultPdfImagesExtractor;
import io.scanbot.sdk.pdf.PdfImagesExtractor;
import io.scanbot.sdk.pdf.PdfImagesExtractorSettings;
import io.scanbot.sdk.pdf.PdfiumPdfImagesExtractor;
import io.scanbot.sdk.pdf.PdfiumPdfPagesExtractor;
import io.scanbot.sdk.persistence.BarcodeFileStorage;
import io.scanbot.sdk.persistence.BlobStoreStrategy;
import io.scanbot.sdk.persistence.cleanup.Cleaner;
import io.scanbot.sdk.persistence.document.DocumentStorage;
import io.scanbot.sdk.persistence.document.DocumentStoreStrategy;
import io.scanbot.sdk.persistence.fileio.FileIOProcessor;
import io.scanbot.sdk.persistence.fileio.ImageFileIOProcessor;
import io.scanbot.sdk.persistence.page.DocumentPageStorage;
import io.scanbot.sdk.persistence.page.DocumentPageStorageProcessor;
import io.scanbot.sdk.persistence.page.PageFileStorage;
import io.scanbot.sdk.persistence.page.PageStorageSettings;
import io.scanbot.sdk.persistence.page.legacy.LegacyPageStorage;
import io.scanbot.sdk.persistence.page.legacy.PageStorageProcessor;
import io.scanbot.sdk.persistence.page.legacy.draft.DraftPageFileStorage;
import io.scanbot.sdk.persistence.page.legacy.draft.DraftPageStorage;
import io.scanbot.sdk.persistence.page.legacy.draft.DraftPageStorageProcessor;
import io.scanbot.sdk.process.PdfGenerator;
import io.scanbot.sdk.process.ScanbotPdfGenerator;
import io.scanbot.sdk.process.compose.P2ComposerFactory;
import io.scanbot.sdk.security.SapProvider;
import io.scanbot.sdk.textpattern.ITextPatternScannerFactory;
import io.scanbot.sdk.textpattern.TextPatternScannerFactory;
import io.scanbot.sdk.tiff.TiffGeneratorExtension;
import io.scanbot.sdk.ui.result.ResultRepository;
import io.scanbot.sdk.ui.result.ResultStorage;
import io.scanbot.sdk.vin.IVinScannerFactory;
import io.scanbot.sdk.vin.VinScannerFactory;
import java.io.File;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Module
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c2\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u009f\u00012\u00020\u0001:\u0002\u009f\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JH\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007JH\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00010!H\u0007J'\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00010#2\u0017\u0010$\u001a\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010!0%\u00a2\u0006\u0002\b&H\u0007J\u0018\u0010'\u001a\u00020(2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020*H\u0007J\u0010\u0010+\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020,H\u0007J \u0010-\u001a\u00020.2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0007J \u00103\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u00101\u001a\u0002022\u0006\u00104\u001a\u00020.H\u0007J\u0018\u00105\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00106\u001a\u000207H\u0007J\u0010\u00108\u001a\u0002002\u0006\u00106\u001a\u000207H\u0007J\u0010\u00109\u001a\u00020:2\u0006\u0010\u0007\u001a\u00020\bH\u0007J \u0010;\u001a\u00020<2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0007J\u0018\u0010A\u001a\u00020B2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010C\u001a\u000207H\u0007J\u0010\u0010D\u001a\u00020E2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J,\u0010F\u001a\u00020G2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020(0I2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020K0IH\u0007J\b\u0010L\u001a\u00020MH\u0007J(\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020Q2\u0006\u0010\u000b\u001a\u00020R2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010S\u001a\u00020TH\u0007J\b\u0010U\u001a\u00020VH\u0007J\u0018\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020B2\u0006\u0010Z\u001a\u00020[H\u0007J \u0010\\\u001a\u00020]2\u0006\u0010^\u001a\u00020_2\u0006\u0010`\u001a\u00020a2\u0006\u0010\r\u001a\u00020\u000eH\u0007J.\u0010b\u001a\u00020c2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010d\u001a\u00020G2\f\u0010e\u001a\b\u0012\u0004\u0012\u00020g0fH\u0007J\u0016\u0010h\u001a\b\u0012\u0004\u0012\u00020g0f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\b\u0010i\u001a\u00020jH\u0007J!\u0010k\u001a\u00020T2\u0017\u0010$\u001a\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010!0%\u00a2\u0006\u0002\b&H\u0007J\b\u0010l\u001a\u00020mH\u0007J\u000e\u0010n\u001a\b\u0012\u0004\u0012\u00020\u00010!H\u0007J\u0018\u0010o\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u00106\u001a\u000207H\u0007J \u0010p\u001a\u00020q2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010r\u001a\u00020s2\u0006\u0010t\u001a\u00020mH\u0007J0\u0010u\u001a\u00020@2\u0006\u0010t\u001a\u00020m2\u0006\u0010v\u001a\u00020w2\u0006\u0010x\u001a\u00020y2\u0006\u0010`\u001a\u00020a2\u0006\u0010z\u001a\u00020{H\u0007J\u0018\u0010|\u001a\u00020*2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\fH\u0007J\b\u0010}\u001a\u00020~H\u0007J\t\u0010\u007f\u001a\u00030\u0080\u0001H\u0007J\u0011\u0010\u0081\u0001\u001a\u00020[2\u0006\u0010C\u001a\u000207H\u0007J2\u0010\u0082\u0001\u001a\u00030\u0083\u00012\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J:\u0010\u0084\u0001\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0007\u0010\u0085\u0001\u001a\u00020EH\u0007J\t\u0010\u0086\u0001\u001a\u00020\u0010H\u0007J\"\u0010\u0087\u0001\u001a\u00030\u0088\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010t\u001a\u00020mH\u0007J*\u0010\u0089\u0001\u001a\u00020>2\u0006\u0010t\u001a\u00020m2\u0007\u0010\u008a\u0001\u001a\u00020y2\u0006\u0010`\u001a\u00020a2\u0006\u0010z\u001a\u00020{H\u0007J\u001a\u0010\u008b\u0001\u001a\u00030\u008c\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\"\u0010\u008d\u0001\u001a\u00030\u008e\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u0011\u0010\u008f\u0001\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\n\u0010\u0090\u0001\u001a\u00030\u0091\u0001H\u0007J\n\u0010\u0092\u0001\u001a\u00030\u0093\u0001H\u0007J!\u0010\u0094\u0001\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\n\u0010\u0095\u0001\u001a\u00030\u0096\u0001H\u0007J\u001a\u0010\u0097\u0001\u001a\u00030\u0098\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0007J\n\u0010\u0099\u0001\u001a\u00030\u009a\u0001H\u0007J\n\u0010\u009b\u0001\u001a\u00030\u009c\u0001H\u0007J\n\u0010\u009d\u0001\u001a\u00030\u009e\u0001H\u0007\u00a8\u0006\u00a0\u0001"}, d2={"Lio/scanbot/sdk/di/ScanbotSdkModule;", "", "()V", "ocrEngineExtension", "Lio/scanbot/sdk/ocr/OcrEngineExtension;", "context", "Landroid/content/Context;", "sapManager", "Lio/scanbot/sap/SapManager;", "blobStoreStrategy", "Lio/scanbot/sdk/persistence/BlobStoreStrategy;", "pageFileStorage", "Lio/scanbot/sdk/persistence/page/legacy/PageFileStorage;", "fileIOProcessor", "Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;", "ocrSettings", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "bitmapBinarizer", "Lio/scanbot/sdk/ocr/intelligence/OcrPdfGenerator$BitmapBinarizer;", "blobManager", "Lio/scanbot/sdk/blob/BlobManager;", "pdfGenerator", "Lio/scanbot/sdk/process/PdfGenerator;", "documentStoreStrategy", "Lio/scanbot/sdk/persistence/document/DocumentStoreStrategy;", "simpleComposer", "Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;", "Lio/scanbot/sdk/ocr/intelligence/OcrPdfGenerator;", "provideBarcodeFileStorage", "Lio/scanbot/sdk/persistence/BarcodeFileStorage;", "application", "Landroid/app/Application;", "provideBarcodeScannerUiResultInternalLruStorage", "Lio/scanbot/sdk/ui/result/ResultStorage;", "provideBarcodeScannerUiResultInternalRepository", "Lio/scanbot/sdk/ui/result/ResultRepository;", "storages", "", "Lkotlin/jvm/JvmSuppressWildcards;", "provideBaseComposerFactory", "Lio/scanbot/sdk/docprocessing/compose/BaseComposerFactory;", "jpegComposer", "Lio/scanbot/sdk/docprocessing/compose/JpegComposer;", "provideBitmapBinarizer", "Lio/scanbot/sdk/intelligence/ImageProcessorBitmapBinarizer;", "provideBlobFactory", "Lio/scanbot/sdk/blob/BlobFactory;", "blobsStorage", "Lio/scanbot/sdk/connectivity/BlobsStorage;", "assetManager", "Landroid/content/res/AssetManager;", "provideBlobManager", "blobFactory", "provideBlobStoreStrategy", "preferences", "Landroid/content/SharedPreferences;", "provideBlobsStorage", "provideCheckScannerFactory", "Lio/scanbot/sdk/check/ICheckScannerFactory;", "provideCleaner", "Lio/scanbot/sdk/persistence/cleanup/Cleaner;", "pageStorageProcessor", "Lio/scanbot/sdk/persistence/page/legacy/PageStorageProcessor;", "draftPageStorageProcessor", "Lio/scanbot/sdk/persistence/page/legacy/draft/DraftPageStorageProcessor;", "provideCombinedDocumentDraftExtractor", "Lio/scanbot/sdk/docprocessing/draft/CombinedDocumentDraftExtractor;", "sharedPreferences", "provideComposerCache", "Lio/scanbot/sdk/docprocessing/compose/ComposerCache;", "provideComposerFactory", "Lio/scanbot/sdk/docprocessing/compose/ComposerFactory;", "baseComposerFactory", "Ldagger/Lazy;", "p2ComposerFactory", "Lio/scanbot/sdk/process/compose/P2ComposerFactory;", "provideCreditCardScannerFactory", "Lio/scanbot/sdk/creditcard/ICreditCardScannerFactory;", "provideDocumentApi", "Lio/scanbot/sdk/docprocessing/DocumentApi;", "documentStorage", "Lio/scanbot/sdk/persistence/document/DocumentStorage;", "Lio/scanbot/sdk/persistence/page/PageFileStorage;", "documentRepository", "Lio/scanbot/sdk/docprocessing/DocumentRepository;", "provideDocumentDataExtractorFactory", "Lio/scanbot/sdk/documentdata/IDocumentDataExtractorFactory;", "provideDocumentDraftExtractor", "Lio/scanbot/sdk/docprocessing/draft/DocumentDraftExtractor;", "combinedDocumentDraftExtractor", "multipleDocumentsDraftExtractor", "Lio/scanbot/sdk/docprocessing/draft/MultipleDocumentsDraftExtractor;", "provideDocumentPageStorageProcessor", "Lio/scanbot/sdk/persistence/page/DocumentPageStorageProcessor;", "documentPageStorage", "Lio/scanbot/sdk/persistence/page/DocumentPageStorage;", "pageStorageSettings", "Lio/scanbot/sdk/persistence/page/PageStorageSettings;", "provideDocumentProcessor", "Lio/scanbot/sdk/docprocessing/DraftDocumentProcessor;", "composerFactory", "documentProcessorMonitor", "Lio/scanbot/sdk/docprocessing/ProcessorMonitor;", "Lio/scanbot/sdk/entity/Document;", "provideDocumentProcessorMonitor", "provideDocumentQualityAnalyzerFactory", "Lio/scanbot/sdk/documentqualityanalyzer/IDocumentQualityAnalyzerFactory;", "provideDocumentRepository", "provideDocumentScannerFactory", "Lio/scanbot/sdk/documentscanner/IDocumentScannerFactory;", "provideDocumentStorage", "provideDocumentStoreStrategy", "provideDraftPageProcessor", "Lio/scanbot/sdk/docprocessing/legacy/DraftPageProcessor;", "draftPageFileStorage", "Lio/scanbot/sdk/persistence/page/legacy/draft/DraftPageFileStorage;", "documentScannerFactory", "provideDraftPageStorageProcessor", "draftPageStorage", "Lio/scanbot/sdk/persistence/page/legacy/draft/DraftPageStorage;", "mainPageStorage", "Lio/scanbot/sdk/persistence/page/legacy/LegacyPageStorage;", "imageFileIOProcessor", "Lio/scanbot/sdk/persistence/fileio/ImageFileIOProcessor;", "provideJpegComposer", "provideMedicalCertificateScannerFactory", "Lio/scanbot/sdk/mc/IMcScannerFactory;", "provideMrzScannerFactory", "Lio/scanbot/sdk/mrz/IMrzScannerFactory;", "provideMultipleDocumentsDraftExtractor", "provideOcrComposer", "Lio/scanbot/sdk/ocr/process/compose/OcrComposer;", "provideOcrPdfGenerator", "composerCache", "provideOcrSettings", "providePageProcessor", "Lio/scanbot/sdk/docprocessing/legacy/PageProcessor;", "providePageStorageProcessor", "pageStorage", "providePdfImagesExtractor", "Lio/scanbot/sdk/pdf/PdfImagesExtractor;", "providePdfPagesExtractor", "Lio/scanbot/sdk/docprocessing/PdfPagesExtractor;", "provideSapManager", "provideScanbotAnalyticsManager", "Lio/scanbot/sdk/analytics/IScanbotAnalyticsManager;", "provideScanbotAnalyticsTracker", "Lio/scanbot/sdk/analytics/IScanbotAnalyticsTracker;", "provideSimpleComposer", "provideTextPatternScannerFactory", "Lio/scanbot/sdk/textpattern/ITextPatternScannerFactory;", "provideTiffGeneratorExtension", "Lio/scanbot/sdk/tiff/TiffGeneratorExtension;", "provideVinScannerFactory", "Lio/scanbot/sdk/vin/IVinScannerFactory;", "scanbotBarcodeDocumentParserFactory", "Lio/scanbot/sdk/barcode/IBarcodeDocumentParserFactory;", "scanbotBarcodeScannerFactory", "Lio/scanbot/sdk/barcode/IBarcodeScannerFactory;", "Companion", "sdk-bundle_release"})
@SourceDebugExtension(value={"SMAP\nScanbotSdkModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScanbotSdkModule.kt\nio/scanbot/sdk/di/ScanbotSdkModule\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,641:1\n223#2,2:642\n223#2,2:644\n*S KotlinDebug\n*F\n+ 1 ScanbotSdkModule.kt\nio/scanbot/sdk/di/ScanbotSdkModule\n*L\n601#1:642,2\n607#1:644,2\n*E\n"})
public final class ScanbotSdkModule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private static DocumentDraftExtractor a;
    @Nullable
    private static OcrSettings b;
    @Nullable
    private static DocumentScannerEngineMode c;
    @Nullable
    private static PdfImagesExtractorSettings d;
    @NotNull
    private static final Object e;

    public static final /* synthetic */ Object access$getGLOBAL_DOCUMENT_API_LOCK$cp() {
        return e;
    }

    static {
        e = new Object();
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final BarcodeFileStorage provideBarcodeFileStorage(@NotNull Application application) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        return new BarcodeFileStorage((Application)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final BlobStoreStrategy provideBlobStoreStrategy(@NotNull Application application, @NotNull SharedPreferences preferences) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"application");
        Intrinsics.checkNotNullParameter((Object)preferences, (String)"preferences");
        return new BlobStoreStrategy((Application)var1_1, (SharedPreferences)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final BlobsStorage provideBlobsStorage(@NotNull SharedPreferences preferences) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)preferences, (String)"preferences");
        return new BlobsStorage((SharedPreferences)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final BlobFactory provideBlobFactory(@NotNull BlobStoreStrategy blobStoreStrategy, @NotNull BlobsStorage blobsStorage, @NotNull AssetManager assetManager) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"blobStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"blobsStorage");
        Intrinsics.checkNotNullParameter((Object)assetManager, (String)"assetManager");
        return new BlobFactory((BlobStoreStrategy)var1_1, (BlobsStorage)var2_2, (AssetManager)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final BlobManager provideBlobManager(@NotNull BlobStoreStrategy blobStoreStrategy, @NotNull AssetManager assetManager, @NotNull BlobFactory blobFactory) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"blobStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"assetManager");
        Intrinsics.checkNotNullParameter((Object)blobFactory, (String)"blobFactory");
        return new BlobManager((BlobStoreStrategy)var1_1, (AssetManager)var2_2, (BlobFactory)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final ProcessorMonitor<Document> provideDocumentProcessorMonitor(@NotNull DocumentStoreStrategy documentStoreStrategy) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)documentStoreStrategy, (String)"documentStoreStrategy");
        return new DocumentProcessorMonitor((DocumentStoreStrategy)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final DocumentDraftExtractor provideDocumentDraftExtractor(@NotNull CombinedDocumentDraftExtractor combinedDocumentDraftExtractor, @NotNull MultipleDocumentsDraftExtractor multipleDocumentsDraftExtractor) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"combinedDocumentDraftExtractor");
        Intrinsics.checkNotNullParameter((Object)multipleDocumentsDraftExtractor, (String)"multipleDocumentsDraftExtractor");
        ScanbotSdkModule scanbotSdkModule = a;
        if (scanbotSdkModule == null) {
            void var2_2;
            CompositeDraftExtractor compositeDraftExtractor;
            scanbotSdkModule = compositeDraftExtractor;
            compositeDraftExtractor = new CompositeDraftExtractor((CombinedDocumentDraftExtractor)var1_1, (MultipleDocumentsDraftExtractor)var2_2);
        }
        return scanbotSdkModule;
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @Singleton
    @NotNull
    public final SapManager provideSapManager(@NotNull Application application) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        return new SapProvider((Application)var1_1).get();
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final DraftDocumentProcessor provideDocumentProcessor(@NotNull SapManager sapManager, @NotNull DocumentStoreStrategy documentStoreStrategy, @NotNull ComposerFactory composerFactory, @NotNull ProcessorMonitor<Document> documentProcessorMonitor) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"sapManager");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"documentStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"composerFactory");
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"documentProcessorMonitor");
        if (!sapManager.isLicenseActive()) {
            DraftDocumentProcessor draftDocumentProcessor;
            this = draftDocumentProcessor;
            draftDocumentProcessor = new DraftDocumentProcessor(){

                @NotNull
                public DocumentProcessingResult processDocument(@NotNull DocumentDraft documentDraft) {
                    File file;
                    File file2;
                    Intrinsics.checkNotNullParameter((Object)documentDraft, (String)"documentDraft");
                    void v0 = file2;
                    provideDocumentProcessor.1 this_ = v0.document;
                    file2 = file;
                    file = new File("/");
                    return new DocumentProcessingResult((Document)this_, v0.pages, file2);
                }
            };
        } else {
            DefaultDraftDocumentProcessor defaultDraftDocumentProcessor;
            this = defaultDraftDocumentProcessor;
            defaultDraftDocumentProcessor = new DefaultDraftDocumentProcessor((DocumentStoreStrategy)var2_2, (ComposerFactory)var3_3, (ProcessorMonitor)var4_4);
        }
        return this;
    }

    @Provides
    @Singleton
    @NotNull
    public final IScanbotAnalyticsManager provideScanbotAnalyticsManager() {
        return ScanbotAnalyticsManager.INSTANCE;
    }

    @Provides
    @Singleton
    @NotNull
    public final IScanbotAnalyticsTracker provideScanbotAnalyticsTracker() {
        return ScanbotAnalyticsManager.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final DocumentApi provideDocumentApi(@NotNull DocumentStorage documentStorage, @NotNull PageFileStorage pageFileStorage, @NotNull FileIOProcessor fileIOProcessor, @NotNull DocumentRepository documentRepository) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"documentStorage");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"pageFileStorage");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"fileIOProcessor");
        Intrinsics.checkNotNullParameter((Object)documentRepository, (String)"documentRepository");
        return new DocumentApi((DocumentStorage)var1_1, (PageFileStorage)var2_2, (FileIOProcessor)var3_3, (DocumentRepository)var4_4){
            final /* synthetic */ DocumentStorage a;
            final /* synthetic */ PageFileStorage b;
            final /* synthetic */ FileIOProcessor c;
            final /* synthetic */ DocumentRepository d;
            {
                void var4_4;
                void var3_3;
                void var2_2;
                void var1_1;
                this.a = var1_1;
                this.b = var2_2;
                this.c = var3_3;
                this.d = var4_4;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public io.scanbot.sdk.docprocessing.Document createDocument(int documentImageSizeLimit) {
                Object object = ScanbotSdkModule.access$getGLOBAL_DOCUMENT_API_LOCK$cp();
                provideDocumentApi.1 v0 = this_;
                provideDocumentApi.1 this_ = v0.a;
                PageFileStorage pageFileStorage = v0.b;
                FileIOProcessor fileIOProcessor = v0.c;
                DocumentRepository documentRepository = v0.d;
                synchronized (object) {
                    void var1_1;
                    io.scanbot.sdk.docprocessing.Document document;
                    io.scanbot.sdk.docprocessing.Document document2 = document;
                    Object object2 = object;
                    io.scanbot.sdk.docprocessing.Document document3 = document2;
                    io.scanbot.sdk.docprocessing.Document document4 = document2;
                    document4((DocumentStorage)this_, pageFileStorage, fileIOProcessor, (int)var1_1);
                    documentRepository.addResult(document4);
                    document3.saveSync();
                    return document;
                }
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public io.scanbot.sdk.docprocessing.Document loadDocument(@NotNull String documentId) {
                void var1_2;
                provideDocumentApi.1 v0 = this_;
                void v1 = var1_2;
                Intrinsics.checkNotNullParameter((Object)v1, (String)"documentId");
                Object object = ScanbotSdkModule.access$getGLOBAL_DOCUMENT_API_LOCK$cp();
                provideDocumentApi.1 v2 = this_;
                provideDocumentApi.1 this_ = v2.d;
                DocumentStorage documentStorage = v2.a;
                PageFileStorage pageFileStorage = v2.b;
                FileIOProcessor fileIOProcessor = v2.c;
                synchronized (object) {
                    Throwable throwable2;
                    block8: {
                        io.scanbot.sdk.docprocessing.Document document;
                        block7: {
                            io.scanbot.sdk.docprocessing.Document document2;
                            try {
                                if (!v0.isDocumentExist((String)v1)) return null;
                            }
                            catch (Throwable throwable2) {}
                            document = this_.getResult((String)var1_2);
                            if (document != null) return document;
                            provideDocumentApi.1 v4 = this_;
                            document = document2;
                            boolean bl = false;
                            int n = io.scanbot.sdk.docprocessing.Document.Companion.getDEFAULT_DOCUMENT_IMAGE_SIZE_LIMIT();
                            v4.addResult(new io.scanbot.sdk.docprocessing.Document(documentStorage, pageFileStorage, fileIOProcessor, (String)var1_2, bl, n));
                            break block7;
                            break block8;
                        }
                        return document;
                    }
                    throw throwable2;
                }
            }

            @NotNull
            public List<String> storedDocumentIds() {
                Object object = ScanbotSdkModule.access$getGLOBAL_DOCUMENT_API_LOCK$cp();
                provideDocumentApi.1 this_ = this_.a;
                synchronized (object) {
                    return this_.getStoredDocuments();
                }
            }

            /*
             * WARNING - void declaration
             */
            public boolean deleteDocument(@NotNull String uuid) {
                void var1_1;
                provideDocumentApi.1 v0 = this_;
                Intrinsics.checkNotNullParameter((Object)var1_1, (String)"uuid");
                Object this_ = ScanbotSdkModule.access$getGLOBAL_DOCUMENT_API_LOCK$cp();
                DocumentRepository documentRepository = v0.d;
                DocumentStorage documentStorage = v0.a;
                synchronized (this_) {
                    documentRepository.removeResult((String)var1_1);
                    return documentStorage.delete((String)var1_1);
                }
            }

            public boolean deleteAllDocuments() {
                Object object = ScanbotSdkModule.access$getGLOBAL_DOCUMENT_API_LOCK$cp();
                provideDocumentApi.1 this_ = this_.a;
                synchronized (object) {
                    this_.d.clear();
                    return this_.deleteAll();
                }
            }

            /*
             * WARNING - void declaration
             */
            public boolean isDocumentExist(@NotNull String documentId) {
                void var1_1;
                provideDocumentApi.1 v0 = this_;
                Intrinsics.checkNotNullParameter((Object)var1_1, (String)"documentId");
                Object this_ = ScanbotSdkModule.access$getGLOBAL_DOCUMENT_API_LOCK$cp();
                synchronized (this_) {
                    return v0.storedDocumentIds().contains(var1_1);
                }
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final SimpleComposer provideSimpleComposer(@NotNull DocumentStoreStrategy documentStoreStrategy, @NotNull io.scanbot.sdk.persistence.page.legacy.PageFileStorage pageFileStorage, @NotNull FileIOProcessor fileIOProcessor) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"documentStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"pageFileStorage");
        Intrinsics.checkNotNullParameter((Object)fileIOProcessor, (String)"fileIOProcessor");
        return new SimpleComposer((DocumentStoreStrategy)var1_1, (io.scanbot.sdk.persistence.page.legacy.PageFileStorage)var2_2, (FileIOProcessor)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final ComposerCache provideComposerCache(@NotNull Context context) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new InternalComposerCache((Context)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final JpegComposer provideJpegComposer(@NotNull DocumentStoreStrategy documentStoreStrategy, @NotNull io.scanbot.sdk.persistence.page.legacy.PageFileStorage pageFileStorage) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"documentStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)pageFileStorage, (String)"pageFileStorage");
        return new JpegComposer((DocumentStoreStrategy)var1_1, (io.scanbot.sdk.persistence.page.legacy.PageFileStorage)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final DocumentStoreStrategy provideDocumentStoreStrategy(@NotNull Context context, @NotNull SharedPreferences preferences) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"context");
        Intrinsics.checkNotNullParameter((Object)preferences, (String)"preferences");
        return new DocumentStoreStrategy((Context)var1_1, (SharedPreferences)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final OcrPdfGenerator provideOcrPdfGenerator(@NotNull DocumentStoreStrategy documentStoreStrategy, @NotNull BlobStoreStrategy blobStoreStrategy, @NotNull io.scanbot.sdk.persistence.page.legacy.PageFileStorage pageFileStorage, @NotNull OcrPdfGenerator.BitmapBinarizer bitmapBinarizer, @NotNull FileIOProcessor fileIOProcessor, @NotNull ComposerCache composerCache) {
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"documentStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"blobStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"pageFileStorage");
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"bitmapBinarizer");
        Intrinsics.checkNotNullParameter((Object)var5_5, (String)"fileIOProcessor");
        Intrinsics.checkNotNullParameter((Object)composerCache, (String)"composerCache");
        return new OcrPdfGenerator((DocumentStoreStrategy)var1_1, (io.scanbot.sdk.persistence.page.legacy.PageFileStorage)var3_3, (BlobStoreStrategy)var2_2, (OcrPdfGenerator.BitmapBinarizer)var4_4, (FileIOProcessor)var5_5, (ComposerCache)var6_6);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final OcrComposer provideOcrComposer(@NotNull BlobManager blobManager, @NotNull OcrPdfGenerator pdfGenerator, @NotNull SimpleComposer simpleComposer, @NotNull SapManager sapManager, @NotNull OcrSettings ocrSettings) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"blobManager");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"pdfGenerator");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"simpleComposer");
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"sapManager");
        Intrinsics.checkNotNullParameter((Object)ocrSettings, (String)"ocrSettings");
        return new OcrComposer((BlobManager)var1_1, (OcrPdfGenerator)var2_2, (SimpleComposer)var3_3, (SapManager)var4_4, (OcrSettings)var5_5);
    }

    @Provides
    @NotNull
    public final IDocumentScannerFactory provideDocumentScannerFactory() {
        DependencyCheckUtils.INSTANCE.checkDependency((RequiredDependency)BundleDependencyCheck.DOCUMENT_SCANNER);
        return new DocumentScannerFactory(c);
    }

    @Provides
    @NotNull
    public final IBarcodeScannerFactory scanbotBarcodeScannerFactory() {
        return new BarcodeScannerFactory();
    }

    @Provides
    @NotNull
    public final IBarcodeDocumentParserFactory scanbotBarcodeDocumentParserFactory() {
        return new BarcodeDocumentParserFactory();
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final CombinedDocumentDraftExtractor provideCombinedDocumentDraftExtractor(@NotNull DocumentStoreStrategy documentStoreStrategy, @NotNull SharedPreferences sharedPreferences) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"documentStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)sharedPreferences, (String)"sharedPreferences");
        return new CombinedDocumentDraftExtractor((DocumentStoreStrategy)var1_1, (SharedPreferences)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final MultipleDocumentsDraftExtractor provideMultipleDocumentsDraftExtractor(@NotNull SharedPreferences sharedPreferences) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)sharedPreferences, (String)"sharedPreferences");
        return new MultipleDocumentsDraftExtractor((SharedPreferences)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final BaseComposerFactory provideBaseComposerFactory(@NotNull SimpleComposer simpleComposer, @NotNull JpegComposer jpegComposer) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"simpleComposer");
        Intrinsics.checkNotNullParameter((Object)jpegComposer, (String)"jpegComposer");
        return new BaseComposerFactory((SimpleComposer)var1_1, (JpegComposer)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final Cleaner provideCleaner(@NotNull DocumentStoreStrategy documentStoreStrategy, @NotNull PageStorageProcessor pageStorageProcessor, @NotNull DraftPageStorageProcessor draftPageStorageProcessor) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"documentStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"pageStorageProcessor");
        Intrinsics.checkNotNullParameter((Object)draftPageStorageProcessor, (String)"draftPageStorageProcessor");
        return new Cleaner((DocumentStoreStrategy)var1_1, (PageStorageProcessor)var2_2, (DraftPageStorageProcessor)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final PdfGenerator pdfGenerator(@NotNull Context context, @NotNull FileIOProcessor fileIOProcessor, @NotNull DocumentStoreStrategy documentStoreStrategy, @NotNull SimpleComposer simpleComposer, @NotNull SapManager sapManager, @NotNull OcrPdfGenerator pdfGenerator, @NotNull BlobManager blobManager, @NotNull OcrSettings ocrSettings) {
        void var8_8;
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"context");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"fileIOProcessor");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"documentStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"simpleComposer");
        Intrinsics.checkNotNullParameter((Object)var5_5, (String)"sapManager");
        Intrinsics.checkNotNullParameter((Object)var6_6, (String)"pdfGenerator");
        Intrinsics.checkNotNullParameter((Object)var7_7, (String)"blobManager");
        Intrinsics.checkNotNullParameter((Object)ocrSettings, (String)"ocrSettings");
        return new ScanbotPdfGenerator((Context)var1_1, (FileIOProcessor)var2_2, (OcrPdfGenerator)var6_6, (DocumentStoreStrategy)var3_3, (BlobManager)var7_7, (SimpleComposer)var4_4, (OcrSettings)var8_8, (SapManager)var5_5);
    }

    @Provides
    @Singleton
    @NotNull
    public final OcrSettings provideOcrSettings() {
        ScanbotSdkModule scanbotSdkModule = b;
        if (scanbotSdkModule == null) {
            scanbotSdkModule = new OcrSettings.Builder().build();
        }
        return scanbotSdkModule;
    }

    @Provides
    @NotNull
    public final OcrPdfGenerator.BitmapBinarizer provideBitmapBinarizer(@NotNull ImageProcessorBitmapBinarizer bitmapBinarizer) {
        ImageProcessorBitmapBinarizer imageProcessorBitmapBinarizer = bitmapBinarizer;
        Intrinsics.checkNotNullParameter((Object)imageProcessorBitmapBinarizer, (String)"bitmapBinarizer");
        return imageProcessorBitmapBinarizer;
    }

    @Provides
    @NotNull
    public final IDocumentQualityAnalyzerFactory provideDocumentQualityAnalyzerFactory() {
        DependencyCheckUtils.INSTANCE.checkDependency((RequiredDependency)BundleDependencyCheck.DQA);
        return new DocumentQualityAnalyzerFactory();
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final TiffGeneratorExtension provideTiffGeneratorExtension(@NotNull Context context, @NotNull FileIOProcessor fileIOProcessor) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fileIOProcessor, (String)"fileIOProcessor");
        return new TiffGeneratorExtension((Context)var1_1, (FileIOProcessor)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final DraftPageProcessor provideDraftPageProcessor(@NotNull FileIOProcessor fileIOProcessor, @NotNull DraftPageFileStorage draftPageFileStorage, @NotNull IDocumentScannerFactory documentScannerFactory) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"fileIOProcessor");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"draftPageFileStorage");
        Intrinsics.checkNotNullParameter((Object)documentScannerFactory, (String)"documentScannerFactory");
        ScanbotSdkModule scanbotSdkModule = IDocumentScannerFactory.DefaultImpls.create$default((IDocumentScannerFactory)var3_3, null, (int)1, null);
        return new DraftPageProcessor((FileIOProcessor)var1_1, (DraftPageFileStorage)var2_2, (Result)scanbotSdkModule);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final PageProcessor providePageProcessor(@NotNull FileIOProcessor fileIOProcessor, @NotNull io.scanbot.sdk.persistence.page.legacy.PageFileStorage pageFileStorage, @NotNull IDocumentScannerFactory documentScannerFactory) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"fileIOProcessor");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"pageFileStorage");
        Intrinsics.checkNotNullParameter((Object)documentScannerFactory, (String)"documentScannerFactory");
        ScanbotSdkModule scanbotSdkModule = IDocumentScannerFactory.DefaultImpls.create$default((IDocumentScannerFactory)var3_3, null, (int)1, null);
        return new PageProcessor((FileIOProcessor)var1_1, (io.scanbot.sdk.persistence.page.legacy.PageFileStorage)var2_2, (Result)scanbotSdkModule);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final PageStorageProcessor providePageStorageProcessor(@NotNull IDocumentScannerFactory documentScannerFactory, @NotNull LegacyPageStorage pageStorage, @NotNull PageStorageSettings pageStorageSettings, @NotNull ImageFileIOProcessor imageFileIOProcessor) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"documentScannerFactory");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"pageStorage");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"pageStorageSettings");
        Intrinsics.checkNotNullParameter((Object)imageFileIOProcessor, (String)"imageFileIOProcessor");
        return new PageStorageProcessor(IDocumentScannerFactory.DefaultImpls.create$default((IDocumentScannerFactory)var1_1, null, (int)1, null), (LegacyPageStorage)var2_2, (PageStorageSettings)var3_3, (ImageFileIOProcessor)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final DraftPageStorageProcessor provideDraftPageStorageProcessor(@NotNull IDocumentScannerFactory documentScannerFactory, @NotNull DraftPageStorage draftPageStorage, @NotNull LegacyPageStorage mainPageStorage, @NotNull PageStorageSettings pageStorageSettings, @NotNull ImageFileIOProcessor imageFileIOProcessor) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"documentScannerFactory");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"draftPageStorage");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"mainPageStorage");
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"pageStorageSettings");
        Intrinsics.checkNotNullParameter((Object)imageFileIOProcessor, (String)"imageFileIOProcessor");
        return new DraftPageStorageProcessor(IDocumentScannerFactory.DefaultImpls.create$default((IDocumentScannerFactory)var1_1, null, (int)1, null), (DraftPageStorage)var2_2, (LegacyPageStorage)var3_3, (PageStorageSettings)var4_4, (ImageFileIOProcessor)var5_5);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final DocumentPageStorageProcessor provideDocumentPageStorageProcessor(@NotNull DocumentPageStorage documentPageStorage, @NotNull PageStorageSettings pageStorageSettings, @NotNull FileIOProcessor fileIOProcessor) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"documentPageStorage");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"pageStorageSettings");
        Intrinsics.checkNotNullParameter((Object)fileIOProcessor, (String)"fileIOProcessor");
        return new DocumentPageStorageProcessor((DocumentPageStorage)var1_1, (PageStorageSettings)var2_2, (ImageFileIOProcessor)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final ComposerFactory provideComposerFactory(@NotNull SapManager sapManager, @NotNull Lazy<BaseComposerFactory> baseComposerFactory, @NotNull Lazy<P2ComposerFactory> p2ComposerFactory) {
        ComposerFactory composerFactory;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"sapManager");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"baseComposerFactory");
        Intrinsics.checkNotNullParameter(p2ComposerFactory, (String)"p2ComposerFactory");
        if (DependencyCheckUtils.INSTANCE.isSdkP2() && var1_1.checkLicenseStatusSilently(Feature.OCR)) {
            void var3_3;
            Object object = var3_3.get();
            Intrinsics.checkNotNull((Object)object);
            composerFactory = (ComposerFactory)object;
        } else {
            Object object = var2_2.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            composerFactory = (ComposerFactory)object;
        }
        return composerFactory;
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final OcrEngineExtension ocrEngineExtension(@NotNull Context context, @NotNull SapManager sapManager, @NotNull BlobStoreStrategy blobStoreStrategy, @NotNull io.scanbot.sdk.persistence.page.legacy.PageFileStorage pageFileStorage, @NotNull FileIOProcessor fileIOProcessor, @NotNull OcrSettings ocrSettings, @NotNull OcrPdfGenerator.BitmapBinarizer bitmapBinarizer, @NotNull BlobManager blobManager) {
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"context");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"sapManager");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"blobStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"pageFileStorage");
        Intrinsics.checkNotNullParameter((Object)var5_5, (String)"fileIOProcessor");
        Intrinsics.checkNotNullParameter((Object)var6_6, (String)"ocrSettings");
        Intrinsics.checkNotNullParameter((Object)var7_7, (String)"bitmapBinarizer");
        Intrinsics.checkNotNullParameter((Object)blobManager, (String)"blobManager");
        if (DependencyCheckUtils.INSTANCE.isSdkP2() && var2_2.checkLicenseStatusSilently(Feature.OCR)) {
            ScanbotOcrEngine scanbotOcrEngine;
            this = scanbotOcrEngine;
            scanbotOcrEngine = new ScanbotOcrEngine((Context)var1_1, (BlobManager)var8_8, (SapManager)var2_2, (BlobStoreStrategy)var3_3, (io.scanbot.sdk.persistence.page.legacy.PageFileStorage)var4_4, (FileIOProcessor)var5_5, (OcrSettings)var6_6, (OcrPdfGenerator.BitmapBinarizer)var7_7);
        } else {
            ScanbotOcrEngine scanbotOcrEngine;
            this = scanbotOcrEngine;
            scanbotOcrEngine = new ScanbotOcrEngine((Context)var1_1, (BlobManager)var8_8, (SapManager)var2_2, (BlobStoreStrategy)var3_3, (io.scanbot.sdk.persistence.page.legacy.PageFileStorage)var4_4, (FileIOProcessor)var5_5, (OcrSettings)var6_6, (OcrPdfGenerator.BitmapBinarizer)var7_7);
        }
        return this;
    }

    @Provides
    @NotNull
    public final ITextPatternScannerFactory provideTextPatternScannerFactory() {
        DependencyCheckUtils dependencyCheckUtils = DependencyCheckUtils.INSTANCE;
        dependencyCheckUtils.checkDependency((RequiredDependency)BundleDependencyCheck.COMMON_OCR);
        dependencyCheckUtils.checkDependency((RequiredDependency)BundleDependencyCheck.TEXT_PATTERN);
        return new TextPatternScannerFactory();
    }

    @Provides
    @NotNull
    public final IVinScannerFactory provideVinScannerFactory() {
        DependencyCheckUtils dependencyCheckUtils = DependencyCheckUtils.INSTANCE;
        dependencyCheckUtils.checkDependency((RequiredDependency)BundleDependencyCheck.COMMON_OCR);
        dependencyCheckUtils.checkDependency((RequiredDependency)BundleDependencyCheck.TEXT_PATTERN);
        return new VinScannerFactory();
    }

    @Provides
    @NotNull
    public final IMrzScannerFactory provideMrzScannerFactory() {
        DependencyCheckUtils.INSTANCE.checkDependency((RequiredDependency)BundleDependencyCheck.MRZ);
        return new MrzScannerFactory();
    }

    @Provides
    @NotNull
    public final IMcScannerFactory provideMedicalCertificateScannerFactory() {
        DependencyCheckUtils.INSTANCE.checkDependency((RequiredDependency)BundleDependencyCheck.MC);
        return new McScannerFactory();
    }

    @Provides
    @NotNull
    public final ICheckScannerFactory provideCheckScannerFactory(@NotNull SapManager sapManager) {
        Intrinsics.checkNotNullParameter((Object)sapManager, (String)"sapManager");
        DependencyCheckUtils.INSTANCE.checkDependency((RequiredDependency)BundleDependencyCheck.CHECK);
        return new CheckScannerFactory();
    }

    @Provides
    @NotNull
    public final IDocumentDataExtractorFactory provideDocumentDataExtractorFactory() {
        DependencyCheckUtils dependencyCheckUtils = DependencyCheckUtils.INSTANCE;
        dependencyCheckUtils.checkDependency((RequiredDependency)BundleDependencyCheck.DOCUMENT_DATA);
        dependencyCheckUtils.checkDependency((RequiredDependency)BundleDependencyCheck.COMMON_OCR);
        return new DocumentDataExtractorFactory();
    }

    @Provides
    @NotNull
    public final ICreditCardScannerFactory provideCreditCardScannerFactory() {
        DependencyCheckUtils dependencyCheckUtils = DependencyCheckUtils.INSTANCE;
        dependencyCheckUtils.checkDependency((RequiredDependency)BundleDependencyCheck.COMMON_OCR);
        dependencyCheckUtils.checkDependency((RequiredDependency)BundleDependencyCheck.CREDIT_CARD);
        return new CreditCardScannerFactory();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Provides
    @NotNull
    public final PdfImagesExtractor providePdfImagesExtractor(@NotNull FileIOProcessor fileIOProcessor, @NotNull Application application) {
        DefaultPdfImagesExtractor defaultPdfImagesExtractor;
        void var0_10;
        void var0_7;
        void var0_4;
        void var1_11;
        Intrinsics.checkNotNullParameter((Object)var1_11, (String)"fileIOProcessor");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        PdfImagesExtractorSettings pdfImagesExtractorSettings = d;
        if (pdfImagesExtractorSettings != null) {
            PdfImagesExtractor.Type type = pdfImagesExtractorSettings.getExtractorType();
        } else {
            Object var0_3 = null;
        }
        if (var0_4 == null) {
            int n = -1;
        } else {
            int n = WhenMappings.$EnumSwitchMapping$0[var0_4.ordinal()];
        }
        if (var0_7 != -1) {
            if (var0_7 == true) {
                void var2_12;
                PdfiumPdfImagesExtractor pdfiumPdfImagesExtractor;
                DependencyCheckUtils.INSTANCE.checkDependency((RequiredDependency)BundleDependencyCheck.PDFIUM_PAGES);
                PdfiumPdfImagesExtractor pdfiumPdfImagesExtractor2 = pdfiumPdfImagesExtractor;
                pdfiumPdfImagesExtractor = new PdfiumPdfImagesExtractor((FileIOProcessor)var1_11, (Context)var2_12);
                return var0_10;
            }
            if (var0_7 != 2) throw new NoWhenBranchMatchedException();
        }
        DefaultPdfImagesExtractor defaultPdfImagesExtractor2 = defaultPdfImagesExtractor;
        defaultPdfImagesExtractor = new DefaultPdfImagesExtractor((FileIOProcessor)var1_11);
        return var0_10;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Provides
    @NotNull
    public final PdfPagesExtractor providePdfPagesExtractor(@NotNull io.scanbot.sdk.persistence.page.legacy.PageFileStorage pageFileStorage, @NotNull FileIOProcessor fileIOProcessor, @NotNull Application application) {
        DefaultPdfPagesExtractor defaultPdfPagesExtractor;
        void var0_10;
        void var0_7;
        void var0_4;
        void var2_12;
        void var1_11;
        Intrinsics.checkNotNullParameter((Object)var1_11, (String)"pageFileStorage");
        Intrinsics.checkNotNullParameter((Object)var2_12, (String)"fileIOProcessor");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        PdfImagesExtractorSettings pdfImagesExtractorSettings = d;
        if (pdfImagesExtractorSettings != null) {
            PdfImagesExtractor.Type type = pdfImagesExtractorSettings.getExtractorType();
        } else {
            Object var0_3 = null;
        }
        if (var0_4 == null) {
            int n = -1;
        } else {
            int n = WhenMappings.$EnumSwitchMapping$0[var0_4.ordinal()];
        }
        if (var0_7 != -1) {
            if (var0_7 == true) {
                void var3_13;
                PdfiumPdfPagesExtractor pdfiumPdfPagesExtractor;
                DependencyCheckUtils.INSTANCE.checkDependency((RequiredDependency)BundleDependencyCheck.PDFIUM_PAGES);
                PdfiumPdfPagesExtractor pdfiumPdfPagesExtractor2 = pdfiumPdfPagesExtractor;
                pdfiumPdfPagesExtractor = new PdfiumPdfPagesExtractor((io.scanbot.sdk.persistence.page.legacy.PageFileStorage)var1_11, (FileIOProcessor)var2_12, (Context)var3_13);
                return var0_10;
            }
            if (var0_7 != 2) throw new NoWhenBranchMatchedException();
        }
        DefaultPdfPagesExtractor defaultPdfPagesExtractor2 = defaultPdfPagesExtractor;
        defaultPdfPagesExtractor = new DefaultPdfPagesExtractor((io.scanbot.sdk.persistence.page.legacy.PageFileStorage)var1_11, (FileIOProcessor)var2_12);
        return var0_10;
    }

    @Provides
    @IntoSet
    @NotNull
    public final ResultRepository<Object> provideBarcodeScannerUiResultInternalRepository(@NotNull Set<ResultStorage<Object>> storages) {
        Set<ResultStorage<Object>> set = storages;
        Intrinsics.checkNotNullParameter(set, (String)"storages");
        for (Object e2 : set) {
            ResultStorage resultStorage = (ResultStorage)e2;
            if (!Intrinsics.areEqual((Object)resultStorage.getAcceptedType(), BarcodeScannerUiResultInternal.class)) continue;
            Intrinsics.checkNotNull(e2, (String)"null cannot be cast to non-null type io.scanbot.sdk.ui.result.ResultStorage<io.scanbot.sdk.barcode.ui.result.model.BarcodeScannerUiResultInternal>");
            return new BarcodeScannerUiResultInternalRepository(resultStorage);
        }
        throw new NoSuchElementException("Collection contains no element matching the predicate.");
    }

    @Provides
    @NotNull
    public final DocumentRepository provideDocumentRepository(@NotNull Set<ResultStorage<Object>> storages) {
        Set<ResultStorage<Object>> set = storages;
        Intrinsics.checkNotNullParameter(set, (String)"storages");
        for (Object e2 : set) {
            ResultStorage resultStorage = (ResultStorage)e2;
            if (!Intrinsics.areEqual((Object)resultStorage.getAcceptedType(), io.scanbot.sdk.docprocessing.Document.class)) continue;
            Intrinsics.checkNotNull(e2, (String)"null cannot be cast to non-null type io.scanbot.sdk.ui.result.ResultStorage<io.scanbot.sdk.docprocessing.Document>");
            return new DocumentRepository(resultStorage);
        }
        throw new NoSuchElementException("Collection contains no element matching the predicate.");
    }

    @Provides
    @Singleton
    @IntoSet
    @NotNull
    public final ResultStorage<Object> provideDocumentStorage() {
        return new io.scanbot.sdk.docprocessing.DocumentStorage();
    }

    @Provides
    @Singleton
    @IntoSet
    @NotNull
    public final ResultStorage<Object> provideBarcodeScannerUiResultInternalLruStorage() {
        return new BarcodeScannerUiResultInternalLruStorage();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lio/scanbot/sdk/di/ScanbotSdkModule$Companion;", "", "()V", "GLOBAL_DOCUMENT_API_LOCK", "documentDraftExtractor", "Lio/scanbot/sdk/docprocessing/draft/DocumentDraftExtractor;", "getDocumentDraftExtractor", "()Lio/scanbot/sdk/docprocessing/draft/DocumentDraftExtractor;", "setDocumentDraftExtractor", "(Lio/scanbot/sdk/docprocessing/draft/DocumentDraftExtractor;)V", "documentScannerEngineMode", "Lio/scanbot/sdk/documentscanner/DocumentScannerEngineMode;", "getDocumentScannerEngineMode", "()Lio/scanbot/sdk/documentscanner/DocumentScannerEngineMode;", "setDocumentScannerEngineMode", "(Lio/scanbot/sdk/documentscanner/DocumentScannerEngineMode;)V", "ocrSettings", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "getOcrSettings", "()Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "setOcrSettings", "(Lio/scanbot/sdk/ocr/intelligence/OcrSettings;)V", "pdfImagesExtractorSettings", "Lio/scanbot/sdk/pdf/PdfImagesExtractorSettings;", "getPdfImagesExtractorSettings", "()Lio/scanbot/sdk/pdf/PdfImagesExtractorSettings;", "setPdfImagesExtractorSettings", "(Lio/scanbot/sdk/pdf/PdfImagesExtractorSettings;)V", "sdk-bundle_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Nullable
        public final DocumentDraftExtractor getDocumentDraftExtractor() {
            return a;
        }

        public final void setDocumentDraftExtractor(@Nullable DocumentDraftExtractor documentDraftExtractor) {
            a = documentDraftExtractor;
        }

        @Nullable
        public final OcrSettings getOcrSettings() {
            return b;
        }

        public final void setOcrSettings(@Nullable OcrSettings ocrSettings) {
            b = ocrSettings;
        }

        @Nullable
        public final DocumentScannerEngineMode getDocumentScannerEngineMode() {
            return c;
        }

        public final void setDocumentScannerEngineMode(@Nullable DocumentScannerEngineMode documentScannerEngineMode) {
            c = documentScannerEngineMode;
        }

        @Nullable
        public final PdfImagesExtractorSettings getPdfImagesExtractorSettings() {
            return d;
        }

        public final void setPdfImagesExtractorSettings(@Nullable PdfImagesExtractorSettings pdfImagesExtractorSettings) {
            d = pdfImagesExtractorSettings;
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PdfImagesExtractor.Type.values().length];
            int[] nArray2 = nArray;
            try {
                nArray[PdfImagesExtractor.Type.PDFIUM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[PdfImagesExtractor.Type.ANDROID_PDF_WRITER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray2;
        }
    }
}

