/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.persistence.fileio;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import androidx.security.crypto.EncryptedFile;
import androidx.security.crypto.MasterKey;
import io.scanbot.sdk.exceptions.crypto.SourceFileDoesNotExistException;
import io.scanbot.sdk.persistence.fileio.FileIOProcessor;
import io.scanbot.sdk.util.FileUtilsKt;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0019\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0019\u001a\u00020\u0017H\u0016J\u0018\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010$\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010%\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0017H\u0016J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lio/scanbot/sdk/persistence/fileio/EncryptedFileIOProcessor;", "Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "useEncryption", "", "getUseEncryption", "()Z", "mainKey", "Landroidx/security/crypto/MasterKey;", "writeImage", "", "bitmap", "Landroid/graphics/Bitmap;", "compressFormat", "Landroid/graphics/Bitmap$CompressFormat;", "quality", "", "destination", "Ljava/io/File;", "readImage", "source", "options", "Landroid/graphics/BitmapFactory$Options;", "sourceUri", "Landroid/net/Uri;", "read", "", "write", "byteArray", "copyRaw", "encryptedSource", "copy", "move", "openFileOutputStream", "Ljava/io/OutputStream;", "destinationFile", "openFileInputStream", "Ljava/io/InputStream;", "sourceFile", "scanbot-sdk-crypto-persistence_release"})
public final class EncryptedFileIOProcessor
implements FileIOProcessor {
    @NotNull
    private final Context context;
    private final boolean useEncryption;
    @NotNull
    private final MasterKey mainKey;

    public EncryptedFileIOProcessor(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.useEncryption = true;
        MasterKey masterKey = new MasterKey.Builder(this.context).setKeyScheme(MasterKey.KeyScheme.AES256_GCM).build();
        Intrinsics.checkNotNullExpressionValue((Object)masterKey, (String)"build(...)");
        this.mainKey = masterKey;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public boolean getUseEncryption() {
        return this.useEncryption;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void writeImage(@NotNull Bitmap bitmap, @NotNull Bitmap.CompressFormat compressFormat, int quality, @NotNull File destination) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Intrinsics.checkNotNullParameter((Object)compressFormat, (String)"compressFormat");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream out = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            bitmap.compress(compressFormat, quality, (OutputStream)out);
            byte[] byArray = out.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
            this.write(byArray, destination);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Nullable
    public synchronized Bitmap readImage(@NotNull File source, @Nullable BitmapFactory.Options options) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Uri uri = Uri.fromFile((File)source);
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"fromFile(...)");
        return this.readImage(uri, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public synchronized Bitmap readImage(@NotNull Uri sourceUri, @Nullable BitmapFactory.Options options) {
        Intrinsics.checkNotNullParameter((Object)sourceUri, (String)"sourceUri");
        if (!new File(sourceUri.getPath()).exists()) {
            throw new SourceFileDoesNotExistException();
        }
        Closeable closeable = this.openFileInputStream(new File(sourceUri.getPath()));
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)it, null, (BitmapFactory.Options)options);
            return bitmap;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public synchronized byte[] read(@NotNull File source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!source.exists()) {
            throw new SourceFileDoesNotExistException();
        }
        Closeable closeable = this.openFileInputStream(new File(source.getPath()));
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            byte[] byArray = ByteStreamsKt.readBytes((InputStream)it);
            return byArray;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public synchronized void write(@NotNull byte[] byteArray, @NotNull File destination) {
        OutputStream outputStream;
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        if (destination.exists()) {
            destination.delete();
        }
        OutputStream $this$write_u24lambda_u243 = outputStream = this.openFileOutputStream(destination);
        boolean bl = false;
        $this$write_u24lambda_u243.write(byteArray);
        $this$write_u24lambda_u243.flush();
        $this$write_u24lambda_u243.close();
    }

    public synchronized void copyRaw(@NotNull File encryptedSource, @NotNull File destination) {
        Intrinsics.checkNotNullParameter((Object)encryptedSource, (String)"encryptedSource");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        if (!encryptedSource.exists()) {
            throw new SourceFileDoesNotExistException();
        }
        FileUtilsKt.copyToFileAndClose((InputStream)this.openFileInputStream(encryptedSource), (File)destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(@NotNull File source, @NotNull File destination) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        if (!source.exists()) {
            throw new IOException("Source file does not exist");
        }
        try {
            InputStream input = this.openFileInputStream(source);
            OutputStream output = this.openFileOutputStream(destination);
            Closeable closeable = input;
            Throwable throwable = null;
            try {
                long l;
                InputStream input2 = (InputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = output;
                Throwable throwable2 = null;
                try {
                    OutputStream output2 = (OutputStream)closeable2;
                    boolean bl2 = false;
                    l = ByteStreamsKt.copyTo$default((InputStream)input2, (OutputStream)output2, (int)0, (int)2, null);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                long l2 = l;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (NoSuchAlgorithmException e) {
            LoggerProvider.getLogger().logException((Throwable)e);
        }
    }

    public void move(@NotNull File source, @NotNull File destination) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        this.copy(source, destination);
        source.delete();
    }

    @NotNull
    public synchronized OutputStream openFileOutputStream(@NotNull File destinationFile) {
        Intrinsics.checkNotNullParameter((Object)destinationFile, (String)"destinationFile");
        EncryptedFile encryptedFile = new EncryptedFile.Builder(this.context, destinationFile, this.mainKey, EncryptedFile.FileEncryptionScheme.AES256_GCM_HKDF_4KB).build();
        Intrinsics.checkNotNullExpressionValue((Object)encryptedFile, (String)"build(...)");
        EncryptedFile encryptedFile2 = encryptedFile;
        FileOutputStream fileOutputStream = encryptedFile2.openFileOutput();
        Intrinsics.checkNotNullExpressionValue((Object)fileOutputStream, (String)"openFileOutput(...)");
        return fileOutputStream;
    }

    @NotNull
    public synchronized InputStream openFileInputStream(@NotNull File sourceFile) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        EncryptedFile encryptedFile = new EncryptedFile.Builder(this.context, sourceFile, this.mainKey, EncryptedFile.FileEncryptionScheme.AES256_GCM_HKDF_4KB).build();
        Intrinsics.checkNotNullExpressionValue((Object)encryptedFile, (String)"build(...)");
        EncryptedFile encryptedFile2 = encryptedFile;
        return new BufferedInputStream(encryptedFile2.openFileInput());
    }
}

