/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.core.JavaPsiBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IconLayerProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.ui.IconManager;
import com.intellij.ui.IconWithToolTip;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.BitUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.VisibilityIcons;
import gnu.trove.TIntObjectHashMap;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;

public final class ElementPresentationUtil
implements PlatformIcons {
    public static final int CLASS_KIND_CLASS = 30;
    public static final int CLASS_KIND_JSP = 70;
    public static final int CLASS_KIND_EXCEPTION = 80;
    public static final int FLAGS_RUNNABLE = 16384;
    private static final Key<CachedValue<Integer>> CLASS_KIND_KEY = new Key("CLASS_KIND_KEY");
    private static final TIntObjectHashMap<Icon> BASE_ICON = new TIntObjectHashMap(20);

    private ElementPresentationUtil() {
    }

    public static int getFlags(PsiModifierListOwner element, boolean isLocked) {
        boolean isEnum = element instanceof PsiClass && ((PsiClass)element).isEnum();
        int flags = (element.hasModifierProperty("final") && !isEnum ? 1024 : 0) | (element.hasModifierProperty("static") && !isEnum ? 512 : 0) | (isLocked ? 2048 : 0);
        if (element instanceof PsiClass) {
            int kind;
            PsiClass aClass2 = (PsiClass)element;
            if (element.hasModifierProperty("abstract") && !((PsiClass)element).isInterface()) {
                flags |= 0x100;
            }
            if ((kind = ElementPresentationUtil.getClassKind(aClass2)) == 90) {
                flags |= 0x2000;
            } else if (kind == 100) {
                flags |= 0x4000;
            }
        }
        return flags;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static com.intellij.ui.RowIcon createLayeredIcon(Icon baseIcon, PsiModifierListOwner element, boolean isLocked) {
        return (com.intellij.ui.RowIcon)IconManager.getInstance().createLayeredIcon(element, baseIcon, ElementPresentationUtil.getFlags(element, isLocked));
    }

    public static int getBasicClassKind(PsiClass aClass2) {
        if (!aClass2.isValid()) {
            return 30;
        }
        if (aClass2.isAnnotationType()) {
            return 20;
        }
        if (aClass2.isEnum()) {
            return 50;
        }
        if (aClass2.isRecord()) {
            return 110;
        }
        if (aClass2.isInterface()) {
            return 10;
        }
        if (aClass2 instanceof PsiAnonymousClass) {
            return 40;
        }
        return 30;
    }

    public static int getClassKind(PsiClass aClass2) {
        if (!aClass2.isValid()) {
            aClass2.putUserData(CLASS_KIND_KEY, null);
            return 30;
        }
        CachedValue<Integer> value2 = aClass2.getUserData(CLASS_KIND_KEY);
        if (value2 == null) {
            value2 = CachedValuesManager.getManager(aClass2.getProject()).createCachedValue(() -> CachedValueProvider.Result.createSingleDependency(ElementPresentationUtil.getClassKindImpl(aClass2), aClass2), false);
            aClass2.putUserData(CLASS_KIND_KEY, value2);
        }
        return value2.getValue();
    }

    private static int getClassKindImpl(PsiClass aClass2) {
        if (!aClass2.isValid()) {
            return 30;
        }
        if (aClass2.isAnnotationType()) {
            return 20;
        }
        if (aClass2.isEnum()) {
            return 50;
        }
        if (aClass2.isRecord()) {
            return 110;
        }
        if (aClass2.isInterface()) {
            return 10;
        }
        if (aClass2 instanceof PsiAnonymousClass) {
            return 40;
        }
        if (!DumbService.getInstance(aClass2.getProject()).isDumb()) {
            boolean isException;
            PsiManager manager = aClass2.getManager();
            PsiClass javaLangTrowable = JavaPsiFacade.getInstance(manager.getProject()).findClass("java.lang.Throwable", aClass2.getResolveScope());
            boolean bl = isException = javaLangTrowable != null && InheritanceUtil.isInheritorOrSelf(aClass2, javaLangTrowable, true);
            if (isException) {
                return 80;
            }
            if (TestFrameworks.getInstance().isTestClass(aClass2)) {
                return 90;
            }
            if (PsiClassUtil.isRunnableClass(aClass2, false) && PsiMethodUtil.findMainMethod(aClass2) != null) {
                return 100;
            }
        }
        return 30;
    }

    public static Icon getClassIconOfKind(PsiClass aClass2, int classKind) {
        boolean isAbstract = aClass2.hasModifierProperty("abstract");
        return BASE_ICON.get(classKind | (isAbstract ? 256 : 0));
    }

    public static String getDescription(PsiModifierListOwner member2) {
        String noun;
        if (member2 instanceof PsiClass) {
            noun = ElementPresentationUtil.getClassNoun((PsiClass)member2);
        } else if (member2 instanceof PsiMethod) {
            noun = JavaPsiBundle.message("node.method.tooltip", new Object[0]);
        } else if (member2 instanceof PsiField) {
            noun = JavaPsiBundle.message("node.field.tooltip", new Object[0]);
        } else {
            return null;
        }
        String adj = ElementPresentationUtil.getFlagsDescription(member2);
        return (adj + " " + noun).trim();
    }

    private static String getClassNoun(PsiClass aClass2) {
        String noun;
        int kind = ElementPresentationUtil.getClassKind(aClass2);
        switch (kind) {
            case 20: {
                noun = JavaPsiBundle.message("node.annotation.tooltip", new Object[0]);
                break;
            }
            case 40: {
                noun = JavaPsiBundle.message("node.anonymous.class.tooltip", new Object[0]);
                break;
            }
            case 50: {
                noun = JavaPsiBundle.message("node.enum.tooltip", new Object[0]);
                break;
            }
            case 110: {
                noun = JavaPsiBundle.message("node.record.tooltip", new Object[0]);
                break;
            }
            case 80: {
                noun = JavaPsiBundle.message("node.exception.tooltip", new Object[0]);
                break;
            }
            case 10: {
                noun = JavaPsiBundle.message("node.interface.tooltip", new Object[0]);
                break;
            }
            case 90: {
                noun = JavaPsiBundle.message("node.junit.test.tooltip", new Object[0]);
                break;
            }
            case 100: {
                noun = JavaPsiBundle.message("node.runnable.class.tooltip", new Object[0]);
                break;
            }
            default: {
                noun = JavaPsiBundle.message("node.class.tooltip", new Object[0]);
            }
        }
        return noun;
    }

    private static String getFlagsDescription(PsiModifierListOwner aClass2) {
        int level;
        PsiModifierList list2;
        int flags = ElementPresentationUtil.getFlags(aClass2, false);
        StringBuilder adj = new StringBuilder();
        for (IconLayerProvider provider : IconLayerProvider.EP_NAME.getExtensionList()) {
            if (provider.getLayerIcon(aClass2, false) == null) continue;
            adj.append(" ").append(provider.getLayerDescription());
        }
        if (BitUtil.isSet(flags, 256)) {
            adj.append(" ").append(JavaPsiBundle.message("node.abstract.flag.tooltip", new Object[0]));
        }
        if (BitUtil.isSet(flags, 1024)) {
            adj.append(" ").append(JavaPsiBundle.message("node.final.flag.tooltip", new Object[0]));
        }
        if (BitUtil.isSet(flags, 512)) {
            adj.append(" ").append(JavaPsiBundle.message("node.static.flag.tooltip", new Object[0]));
        }
        if ((list2 = aClass2.getModifierList()) != null && (level = PsiUtil.getAccessLevel(list2)) != 4) {
            adj.append(" ").append(StringUtil.capitalize(JavaPsiBundle.visibilityPresentation(PsiUtil.getAccessModifier(level))));
        }
        return adj.toString();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static Icon addVisibilityIcon(PsiModifierListOwner element, int flags, com.intellij.ui.RowIcon baseIcon) {
        return ElementPresentationUtil.addVisibilityIcon(element, flags, (RowIcon)baseIcon);
    }

    public static Icon addVisibilityIcon(PsiModifierListOwner element, int flags, RowIcon baseIcon) {
        if (BitUtil.isSet(flags, 1)) {
            VisibilityIcons.setVisibilityIcon(element.getModifierList(), baseIcon);
        }
        return baseIcon;
    }

    static {
        BASE_ICON.put(30, (Icon)IconWithToolTip.tooltipOnlyIfComposite((Icon)CLASS_ICON));
        BASE_ICON.put(286, ABSTRACT_CLASS_ICON);
        BASE_ICON.put(20, ANNOTATION_TYPE_ICON);
        BASE_ICON.put(276, ANNOTATION_TYPE_ICON);
        BASE_ICON.put(40, ANONYMOUS_CLASS_ICON);
        BASE_ICON.put(296, ANONYMOUS_CLASS_ICON);
        BASE_ICON.put(60, ASPECT_ICON);
        BASE_ICON.put(316, ASPECT_ICON);
        BASE_ICON.put(50, ENUM_ICON);
        BASE_ICON.put(306, ENUM_ICON);
        BASE_ICON.put(80, EXCEPTION_CLASS_ICON);
        BASE_ICON.put(336, AllIcons.Nodes.AbstractException);
        BASE_ICON.put(10, (Icon)IconWithToolTip.tooltipOnlyIfComposite((Icon)INTERFACE_ICON));
        BASE_ICON.put(266, (Icon)IconWithToolTip.tooltipOnlyIfComposite((Icon)INTERFACE_ICON));
        BASE_ICON.put(90, (Icon)IconWithToolTip.tooltipOnlyIfComposite((Icon)CLASS_ICON));
        BASE_ICON.put(346, ABSTRACT_CLASS_ICON);
        BASE_ICON.put(110, RECORD_ICON);
        BASE_ICON.put(100, CLASS_ICON);
        IconManager iconManager = IconManager.getInstance();
        iconManager.registerIconLayer(512, AllIcons.Nodes.StaticMark);
        iconManager.registerIconLayer(1024, AllIcons.Nodes.FinalMark);
        iconManager.registerIconLayer(8192, AllIcons.Nodes.JunitTestMark);
        iconManager.registerIconLayer(16384, AllIcons.Nodes.RunnableMark);
    }
}

