/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.TDoubleHashingStrategy;
import gnu.trove.TDoubleProcedure;
import gnu.trove.TPrimitiveHash;

public abstract class TDoubleHash
extends TPrimitiveHash
implements TDoubleHashingStrategy {
    protected transient double[] _set;
    protected final TDoubleHashingStrategy _hashingStrategy;

    public TDoubleHash() {
        this._hashingStrategy = this;
    }

    public TDoubleHash(int initialCapacity) {
        super(initialCapacity);
        this._hashingStrategy = this;
    }

    public TDoubleHash(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = this;
    }

    public TDoubleHash(TDoubleHashingStrategy strategy) {
        this._hashingStrategy = strategy;
    }

    public TDoubleHash(int initialCapacity, TDoubleHashingStrategy strategy) {
        super(initialCapacity);
        this._hashingStrategy = strategy;
    }

    public TDoubleHash(int initialCapacity, float loadFactor, TDoubleHashingStrategy strategy) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = strategy;
    }

    public Object clone() {
        TDoubleHash h = (TDoubleHash)super.clone();
        h._set = this._set == null ? null : (double[])this._set.clone();
        return h;
    }

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._set = initialCapacity == -1 ? null : new double[capacity];
        return capacity;
    }

    public boolean contains(double val) {
        return this.index(val) >= 0;
    }

    public boolean forEach(TDoubleProcedure procedure) {
        byte[] states = this._states;
        double[] set = this._set;
        if (states != null) {
            int i = states.length;
            while (i-- > 0) {
                if (states[i] != 1 || procedure.execute(set[i])) continue;
                return false;
            }
        }
        return true;
    }

    protected void removeAt(int index2) {
        this._set[index2] = 0.0;
        super.removeAt(index2);
    }

    protected int index(double val) {
        byte[] states = this._states;
        if (states == null) {
            return -1;
        }
        double[] set = this._set;
        int length = states.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index2 = hash % length;
        if (states[index2] != 0 && (states[index2] == 2 || set[index2] != val)) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index2 -= probe) >= 0) continue;
                index2 += length;
            } while (states[index2] != 0 && (states[index2] == 2 || set[index2] != val));
        }
        return states[index2] == 0 ? -1 : index2;
    }

    protected int insertionIndex(double val) {
        if (this._set == null) {
            this.setUp(6);
        }
        byte[] states = this._states;
        double[] set = this._set;
        int length = states.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index2 = hash % length;
        if (states[index2] == 0) {
            return index2;
        }
        if (states[index2] == 1 && set[index2] == val) {
            return -index2 - 1;
        }
        int probe = 1 + hash % (length - 2);
        do {
            if ((index2 -= probe) >= 0) continue;
            index2 += length;
        } while (states[index2] == 1 && set[index2] != val);
        if (states[index2] == 2) {
            int firstRemoved = index2;
            while (states[index2] != 0 && (states[index2] == 2 || set[index2] != val)) {
                if ((index2 -= probe) >= 0) continue;
                index2 += length;
            }
            return states[index2] == 1 ? -index2 - 1 : firstRemoved;
        }
        return states[index2] == 1 ? -index2 - 1 : index2;
    }

    public final int computeHashCode(double val) {
        return HashFunctions.hash(val);
    }
}

