/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.EmptyPackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectKotlinClass;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectKotlinClassFinder;
import kotlin.reflect.jvm.internal.impl.load.kotlin.DeserializedDescriptorResolver;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinClassFinder;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinClassFinderKt;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.load.kotlin.header.KotlinClassHeader;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmClassName;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.ChainedMemberScope;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import org.jetbrains.annotations.NotNull;

public final class PackagePartScopeCache {
    @NotNull
    private final DeserializedDescriptorResolver resolver;
    @NotNull
    private final ReflectKotlinClassFinder kotlinClassFinder;
    @NotNull
    private final ConcurrentHashMap<ClassId, MemberScope> cache;

    public PackagePartScopeCache(@NotNull DeserializedDescriptorResolver resolver2, @NotNull ReflectKotlinClassFinder kotlinClassFinder) {
        Intrinsics.checkNotNullParameter(resolver2, "resolver");
        Intrinsics.checkNotNullParameter(kotlinClassFinder, "kotlinClassFinder");
        this.resolver = resolver2;
        this.kotlinClassFinder = kotlinClassFinder;
        this.cache = new ConcurrentHashMap();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MemberScope getPackagePartScope(@NotNull ReflectKotlinClass fileClass) {
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter(fileClass, "fileClass");
        ConcurrentMap concurrentMap = this.cache;
        ClassId key$iv = fileClass.getClassId();
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            void $this$mapNotNullTo$iv$iv;
            List list2;
            boolean bl;
            Object it$iv$iv;
            Object object2;
            boolean bl2;
            boolean bl3;
            boolean bl4 = false;
            FqName fqName2 = fileClass.getClassId().getPackageFqName();
            Intrinsics.checkNotNullExpressionValue(fqName2, "fileClass.classId.packageFqName");
            FqName fqName3 = fqName2;
            if (fileClass.getClassHeader().getKind() == KotlinClassHeader.Kind.MULTIFILE_CLASS) {
                void $this$mapNotNullTo$iv$iv2;
                Iterable $this$mapNotNull$iv = fileClass.getClassHeader().getMultifilePartNames();
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl5 = false;
                    String partName = (String)element$iv$iv;
                    boolean bl6 = false;
                    ClassId classId = ClassId.topLevel(JvmClassName.byInternalName(partName).getFqNameForTopLevelClassMaybeWithDollars());
                    Intrinsics.checkNotNullExpressionValue(classId, "topLevel(JvmClassName.byInternalName(partName).fqNameForTopLevelClassMaybeWithDollars)");
                    ClassId classId2 = classId;
                    if (KotlinClassFinderKt.findKotlinClass((KotlinClassFinder)this.kotlinClassFinder, classId2) == null) continue;
                    bl3 = false;
                    bl2 = false;
                    it$iv$iv = object2;
                    bl = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = CollectionsKt.listOf(fileClass);
            }
            List parts2 = list2;
            EmptyPackageFragmentDescriptor packageFragment = new EmptyPackageFragmentDescriptor(this.resolver.getComponents().getModuleDescriptor(), fqName3);
            Iterable $this$mapNotNull$iv = parts2;
            boolean $i$f$mapNotNull = false;
            Iterable $i$f$mapNotNullTo = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator3.next();
                boolean bl7 = false;
                KotlinJvmBinaryClass part = (KotlinJvmBinaryClass)element$iv$iv;
                boolean bl8 = false;
                if (this.resolver.createKotlinPackagePartScope(packageFragment, part) == null) continue;
                bl3 = false;
                bl2 = false;
                it$iv$iv = object2;
                bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List scopes = CollectionsKt.toList((List)destination$iv$iv);
            MemberScope memberScope2 = ChainedMemberScope.Companion.create("package " + fqName3 + " (" + fileClass + ')', scopes);
            boolean bl9 = false;
            boolean bl10 = false;
            MemberScope default$iv = memberScope2;
            boolean bl11 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Object v = object;
        Intrinsics.checkNotNullExpressionValue(v, "cache.getOrPut(fileClass.classId) {\n        val fqName = fileClass.classId.packageFqName\n\n        val parts =\n            if (fileClass.classHeader.kind == KotlinClassHeader.Kind.MULTIFILE_CLASS)\n                fileClass.classHeader.multifilePartNames.mapNotNull { partName ->\n                    val classId = ClassId.topLevel(JvmClassName.byInternalName(partName).fqNameForTopLevelClassMaybeWithDollars)\n                    kotlinClassFinder.findKotlinClass(classId)\n                }\n            else listOf(fileClass)\n\n        val packageFragment = EmptyPackageFragmentDescriptor(resolver.components.moduleDescriptor, fqName)\n\n        val scopes = parts.mapNotNull { part ->\n            resolver.createKotlinPackagePartScope(packageFragment, part)\n        }.toList()\n\n        ChainedMemberScope.create(\"package $fqName ($fileClass)\", scopes)\n    }");
        return (MemberScope)v;
    }
}

