/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.expressions.impl;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLabel;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeStubDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirErrorLoop;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirEmptyExpressionBlock;
import org.jetbrains.kotlin.fir.expressions.impl.FirErrorExpressionImpl;
import org.jetbrains.kotlin.fir.visitors.FirTransformer;
import org.jetbrains.kotlin.fir.visitors.FirTransformerUtilKt;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B/\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ5\u0010\"\u001a\u00020#\"\u0004\b\u0000\u0010$\"\u0004\b\u0001\u0010%2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u0002H$\u0012\u0004\u0012\u0002H%0'2\u0006\u0010(\u001a\u0002H%H\u0016\u00a2\u0006\u0002\u0010)J)\u0010*\u001a\u00020\u0000\"\u0004\b\u0000\u0010%2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H%0,2\u0006\u0010(\u001a\u0002H%H\u0016\u00a2\u0006\u0002\u0010-J)\u0010.\u001a\u00020\u0000\"\u0004\b\u0000\u0010%2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H%0,2\u0006\u0010(\u001a\u0002H%H\u0016\u00a2\u0006\u0002\u0010-J)\u0010/\u001a\u00020\u0000\"\u0004\b\u0000\u0010%2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H%0,2\u0006\u0010(\u001a\u0002H%H\u0016\u00a2\u0006\u0002\u0010-J)\u00100\u001a\u00020\u0000\"\u0004\b\u0000\u0010%2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H%0,2\u0006\u0010(\u001a\u0002H%H\u0016\u00a2\u0006\u0002\u0010-J)\u00101\u001a\u00020\u0000\"\u0004\b\u0000\u0010%2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H%0,2\u0006\u0010(\u001a\u0002H%H\u0016\u00a2\u0006\u0002\u0010-R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/fir/expressions/impl/FirErrorLoopImpl;", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorLoop;", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "annotations", "", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "label", "Lorg/jetbrains/kotlin/fir/FirLabel;", "diagnostic", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "(Lorg/jetbrains/kotlin/fir/FirSourceElement;Ljava/util/List;Lorg/jetbrains/kotlin/fir/FirLabel;Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;)V", "getAnnotations", "()Ljava/util/List;", "block", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "getBlock", "()Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "setBlock", "(Lorg/jetbrains/kotlin/fir/expressions/FirBlock;)V", "condition", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getCondition", "()Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "setCondition", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)V", "getDiagnostic", "()Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "getLabel", "()Lorg/jetbrains/kotlin/fir/FirLabel;", "setLabel", "(Lorg/jetbrains/kotlin/fir/FirLabel;)V", "getSource", "()Lorg/jetbrains/kotlin/fir/FirSourceElement;", "acceptChildren", "", "R", "D", "visitor", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitor;", "data", "(Lorg/jetbrains/kotlin/fir/visitors/FirVisitor;Ljava/lang/Object;)V", "transformAnnotations", "transformer", "Lorg/jetbrains/kotlin/fir/visitors/FirTransformer;", "(Lorg/jetbrains/kotlin/fir/visitors/FirTransformer;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/expressions/impl/FirErrorLoopImpl;", "transformBlock", "transformChildren", "transformCondition", "transformOtherChildren", "tree"})
public final class FirErrorLoopImpl
extends FirErrorLoop {
    @Nullable
    private final FirSourceElement source;
    @NotNull
    private final List<FirAnnotationCall> annotations;
    @Nullable
    private FirLabel label;
    @NotNull
    private final ConeDiagnostic diagnostic;
    @NotNull
    private FirBlock block;
    @NotNull
    private FirExpression condition;

    public FirErrorLoopImpl(@Nullable FirSourceElement source, @NotNull List<FirAnnotationCall> annotations2, @Nullable FirLabel label, @NotNull ConeDiagnostic diagnostic) {
        Intrinsics.checkNotNullParameter(annotations2, "annotations");
        Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
        this.source = source;
        this.annotations = annotations2;
        this.label = label;
        this.diagnostic = diagnostic;
        this.block = new FirEmptyExpressionBlock();
        this.condition = new FirErrorExpressionImpl(this.getSource(), new ConeStubDiagnostic(this.getDiagnostic()));
    }

    @Override
    @Nullable
    public FirSourceElement getSource() {
        return this.source;
    }

    @Override
    @NotNull
    public List<FirAnnotationCall> getAnnotations() {
        return this.annotations;
    }

    @Override
    @Nullable
    public FirLabel getLabel() {
        return this.label;
    }

    public void setLabel(@Nullable FirLabel firLabel) {
        this.label = firLabel;
    }

    @Override
    @NotNull
    public ConeDiagnostic getDiagnostic() {
        return this.diagnostic;
    }

    @Override
    @NotNull
    public FirBlock getBlock() {
        return this.block;
    }

    public void setBlock(@NotNull FirBlock firBlock) {
        Intrinsics.checkNotNullParameter(firBlock, "<set-?>");
        this.block = firBlock;
    }

    @Override
    @NotNull
    public FirExpression getCondition() {
        return this.condition;
    }

    public void setCondition(@NotNull FirExpression firExpression2) {
        Intrinsics.checkNotNullParameter(firExpression2, "<set-?>");
        this.condition = firExpression2;
    }

    @Override
    public <R, D> void acceptChildren(@NotNull FirVisitor<? extends R, ? super D> visitor2, D data2) {
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        Iterable $this$forEach$iv = this.getAnnotations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirAnnotationCall it = (FirAnnotationCall)element$iv;
            boolean bl = false;
            it.accept(visitor2, data2);
        }
        this.getBlock().accept(visitor2, data2);
        this.getCondition().accept(visitor2, data2);
        FirLabel firLabel = this.getLabel();
        if (firLabel != null) {
            firLabel.accept(visitor2, data2);
        }
    }

    @Override
    @NotNull
    public <D> FirErrorLoopImpl transformChildren(@NotNull FirTransformer<? super D> transformer2, D data2) {
        Intrinsics.checkNotNullParameter(transformer2, "transformer");
        this.transformBlock((FirTransformer)transformer2, (Object)data2);
        this.transformCondition((FirTransformer)transformer2, (Object)data2);
        this.transformOtherChildren((FirTransformer)transformer2, (Object)data2);
        return this;
    }

    @Override
    @NotNull
    public <D> FirErrorLoopImpl transformAnnotations(@NotNull FirTransformer<? super D> transformer2, D data2) {
        Intrinsics.checkNotNullParameter(transformer2, "transformer");
        FirTransformerUtilKt.transformInplace(this.getAnnotations(), transformer2, data2);
        return this;
    }

    @Override
    @NotNull
    public <D> FirErrorLoopImpl transformBlock(@NotNull FirTransformer<? super D> transformer2, D data2) {
        Intrinsics.checkNotNullParameter(transformer2, "transformer");
        this.setBlock((FirBlock)FirTransformerUtilKt.transformSingle((FirElement)this.getBlock(), transformer2, data2));
        return this;
    }

    @Override
    @NotNull
    public <D> FirErrorLoopImpl transformCondition(@NotNull FirTransformer<? super D> transformer2, D data2) {
        Intrinsics.checkNotNullParameter(transformer2, "transformer");
        this.setCondition((FirExpression)FirTransformerUtilKt.transformSingle((FirElement)this.getCondition(), transformer2, data2));
        return this;
    }

    @Override
    @NotNull
    public <D> FirErrorLoopImpl transformOtherChildren(@NotNull FirTransformer<? super D> transformer2, D data2) {
        Intrinsics.checkNotNullParameter(transformer2, "transformer");
        this.transformAnnotations((FirTransformer)transformer2, (Object)data2);
        FirLabel firLabel = this.getLabel();
        this.setLabel(firLabel == null ? null : (FirLabel)FirTransformerUtilKt.transformSingle((FirElement)firLabel, transformer2, data2));
        return this;
    }
}

