/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.serialization;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.serialization.FirAnnotationArgumentVisitorData;
import org.jetbrains.kotlin.fir.serialization.FirElementAwareStringTable;
import org.jetbrains.kotlin.fir.serialization.constant.AnnotationArgumentVisitor;
import org.jetbrains.kotlin.fir.serialization.constant.AnnotationValue;
import org.jetbrains.kotlin.fir.serialization.constant.ArrayValue;
import org.jetbrains.kotlin.fir.serialization.constant.BooleanValue;
import org.jetbrains.kotlin.fir.serialization.constant.ByteValue;
import org.jetbrains.kotlin.fir.serialization.constant.CharValue;
import org.jetbrains.kotlin.fir.serialization.constant.ConstantValue;
import org.jetbrains.kotlin.fir.serialization.constant.DoubleValue;
import org.jetbrains.kotlin.fir.serialization.constant.EnumValue;
import org.jetbrains.kotlin.fir.serialization.constant.ErrorValue;
import org.jetbrains.kotlin.fir.serialization.constant.FloatValue;
import org.jetbrains.kotlin.fir.serialization.constant.IntValue;
import org.jetbrains.kotlin.fir.serialization.constant.KClassValue;
import org.jetbrains.kotlin.fir.serialization.constant.LongValue;
import org.jetbrains.kotlin.fir.serialization.constant.NullValue;
import org.jetbrains.kotlin.fir.serialization.constant.ShortValue;
import org.jetbrains.kotlin.fir.serialization.constant.StringValue;
import org.jetbrains.kotlin.fir.serialization.constant.UByteValue;
import org.jetbrains.kotlin.fir.serialization.constant.UIntValue;
import org.jetbrains.kotlin.fir.serialization.constant.ULongValue;
import org.jetbrains.kotlin.fir.serialization.constant.UShortValue;
import org.jetbrains.kotlin.fir.types.ArrayUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\r\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u001e2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020 2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010!\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\"2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010#\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020$2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010%\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020&2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010'\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020(2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010)\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020*2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010+\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020,2\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/fir/serialization/FirAnnotationArgumentVisitor;", "Lorg/jetbrains/kotlin/fir/serialization/constant/AnnotationArgumentVisitor;", "", "Lorg/jetbrains/kotlin/fir/serialization/FirAnnotationArgumentVisitorData;", "()V", "visitAnnotationValue", "value", "Lorg/jetbrains/kotlin/fir/serialization/constant/AnnotationValue;", "data", "visitArrayValue", "Lorg/jetbrains/kotlin/fir/serialization/constant/ArrayValue;", "visitBooleanValue", "Lorg/jetbrains/kotlin/fir/serialization/constant/BooleanValue;", "visitByteValue", "Lorg/jetbrains/kotlin/fir/serialization/constant/ByteValue;", "visitCharValue", "Lorg/jetbrains/kotlin/fir/serialization/constant/CharValue;", "visitDoubleValue", "Lorg/jetbrains/kotlin/fir/serialization/constant/DoubleValue;", "visitEnumValue", "Lorg/jetbrains/kotlin/fir/serialization/constant/EnumValue;", "visitErrorValue", "Lorg/jetbrains/kotlin/fir/serialization/constant/ErrorValue;", "visitFloatValue", "Lorg/jetbrains/kotlin/fir/serialization/constant/FloatValue;", "visitIntValue", "Lorg/jetbrains/kotlin/fir/serialization/constant/IntValue;", "visitKClassValue", "Lorg/jetbrains/kotlin/fir/serialization/constant/KClassValue;", "visitLongValue", "Lorg/jetbrains/kotlin/fir/serialization/constant/LongValue;", "visitNullValue", "Lorg/jetbrains/kotlin/fir/serialization/constant/NullValue;", "visitShortValue", "Lorg/jetbrains/kotlin/fir/serialization/constant/ShortValue;", "visitStringValue", "Lorg/jetbrains/kotlin/fir/serialization/constant/StringValue;", "visitUByteValue", "Lorg/jetbrains/kotlin/fir/serialization/constant/UByteValue;", "visitUIntValue", "Lorg/jetbrains/kotlin/fir/serialization/constant/UIntValue;", "visitULongValue", "Lorg/jetbrains/kotlin/fir/serialization/constant/ULongValue;", "visitUShortValue", "Lorg/jetbrains/kotlin/fir/serialization/constant/UShortValue;", "fir-serialization"})
public final class FirAnnotationArgumentVisitor
extends AnnotationArgumentVisitor<Unit, FirAnnotationArgumentVisitorData> {
    @NotNull
    public static final FirAnnotationArgumentVisitor INSTANCE = new FirAnnotationArgumentVisitor();

    private FirAnnotationArgumentVisitor() {
    }

    @Override
    public void visitAnnotationValue(@NotNull AnnotationValue value2, @NotNull FirAnnotationArgumentVisitorData data2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(data2, "data");
        data2.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.ANNOTATION);
    }

    @Override
    public void visitArrayValue(@NotNull ArrayValue value2, @NotNull FirAnnotationArgumentVisitorData data2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(data2, "data");
        data2.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.ARRAY);
        for (ConstantValue element : (List)value2.getValue()) {
            data2.getBuilder().addArrayElement(data2.getSerializer().valueProto$fir_serialization(element).build());
        }
    }

    @Override
    public void visitBooleanValue(@NotNull BooleanValue value2, @NotNull FirAnnotationArgumentVisitorData data2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(data2, "data");
        data2.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.BOOLEAN);
        data2.getBuilder().setIntValue((Boolean)value2.getValue() != false ? 1L : 0L);
    }

    @Override
    public void visitByteValue(@NotNull ByteValue value2, @NotNull FirAnnotationArgumentVisitorData data2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(data2, "data");
        data2.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.BYTE);
        data2.getBuilder().setIntValue(((Number)value2.getValue()).byteValue());
    }

    @Override
    public void visitCharValue(@NotNull CharValue value2, @NotNull FirAnnotationArgumentVisitorData data2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(data2, "data");
        data2.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.CHAR);
        data2.getBuilder().setIntValue(((Character)value2.getValue()).charValue());
    }

    @Override
    public void visitDoubleValue(@NotNull DoubleValue value2, @NotNull FirAnnotationArgumentVisitorData data2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(data2, "data");
        data2.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.DOUBLE);
        data2.getBuilder().setDoubleValue(((Number)value2.getValue()).doubleValue());
    }

    @Override
    public void visitEnumValue(@NotNull EnumValue value2, @NotNull FirAnnotationArgumentVisitorData data2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(data2, "data");
        data2.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.ENUM);
        data2.getBuilder().setClassId(data2.getStringTable().getQualifiedClassNameIndex(value2.getEnumClassId()));
        ProtoBuf.Annotation.Argument.Value.Builder builder2 = data2.getBuilder();
        FirElementAwareStringTable firElementAwareStringTable = data2.getStringTable();
        String string2 = value2.getEnumEntryName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "value.enumEntryName.asString()");
        builder2.setEnumValueId(firElementAwareStringTable.getStringIndex(string2));
    }

    @Override
    public void visitErrorValue(@NotNull ErrorValue value2, @NotNull FirAnnotationArgumentVisitorData data2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(data2, "data");
        throw new UnsupportedOperationException(Intrinsics.stringPlus("Error value: ", value2));
    }

    @Override
    public void visitFloatValue(@NotNull FloatValue value2, @NotNull FirAnnotationArgumentVisitorData data2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(data2, "data");
        data2.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.FLOAT);
        data2.getBuilder().setFloatValue(((Number)value2.getValue()).floatValue());
    }

    @Override
    public void visitIntValue(@NotNull IntValue value2, @NotNull FirAnnotationArgumentVisitorData data2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(data2, "data");
        data2.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.INT);
        data2.getBuilder().setIntValue(((Number)value2.getValue()).intValue());
    }

    @Override
    public void visitKClassValue(@NotNull KClassValue value2, @NotNull FirAnnotationArgumentVisitorData data2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(data2, "data");
        data2.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.CLASS);
        KClassValue.Value classValue = (KClassValue.Value)value2.getValue();
        if (classValue instanceof KClassValue.Value.NormalClass) {
            data2.getBuilder().setClassId(data2.getStringTable().getQualifiedClassNameIndex(((KClassValue.Value.NormalClass)classValue).getClassId()));
            if (((KClassValue.Value.NormalClass)classValue).getArrayDimensions() > 0) {
                data2.getBuilder().setArrayDimensionCount(((KClassValue.Value.NormalClass)classValue).getArrayDimensions());
            }
        } else if (classValue instanceof KClassValue.Value.LocalClass) {
            ConeKotlinType coneKotlinType;
            int arrayDimensions = 0;
            ConeKotlinType type2 = ((KClassValue.Value.LocalClass)classValue).getType();
            while ((coneKotlinType = ArrayUtilsKt.arrayElementType(type2)) != null) {
                type2 = coneKotlinType;
                int n = arrayDimensions;
                arrayDimensions = n + 1;
            }
            if (arrayDimensions > 0) {
                data2.getBuilder().setArrayDimensionCount(arrayDimensions);
            }
        }
    }

    @Override
    public void visitLongValue(@NotNull LongValue value2, @NotNull FirAnnotationArgumentVisitorData data2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(data2, "data");
        data2.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.LONG);
        data2.getBuilder().setIntValue(((Number)value2.getValue()).longValue());
    }

    @Override
    public void visitNullValue(@NotNull NullValue value2, @NotNull FirAnnotationArgumentVisitorData data2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(data2, "data");
        throw new UnsupportedOperationException("Null should not appear in annotation arguments");
    }

    @Override
    public void visitShortValue(@NotNull ShortValue value2, @NotNull FirAnnotationArgumentVisitorData data2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(data2, "data");
        data2.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.SHORT);
        data2.getBuilder().setIntValue(((Number)value2.getValue()).shortValue());
    }

    @Override
    public void visitStringValue(@NotNull StringValue value2, @NotNull FirAnnotationArgumentVisitorData data2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(data2, "data");
        data2.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.STRING);
        data2.getBuilder().setStringValue(data2.getStringTable().getStringIndex((String)value2.getValue()));
    }

    @Override
    public void visitUByteValue(@NotNull UByteValue value2, @NotNull FirAnnotationArgumentVisitorData data2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(data2, "data");
        data2.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.BYTE);
        data2.getBuilder().setIntValue(((Number)value2.getValue()).byteValue());
        data2.getBuilder().setFlags(Flags.IS_UNSIGNED.toFlags(true));
    }

    @Override
    public void visitUShortValue(@NotNull UShortValue value2, @NotNull FirAnnotationArgumentVisitorData data2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(data2, "data");
        data2.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.SHORT);
        data2.getBuilder().setIntValue(((Number)value2.getValue()).shortValue());
        data2.getBuilder().setFlags(Flags.IS_UNSIGNED.toFlags(true));
    }

    @Override
    public void visitUIntValue(@NotNull UIntValue value2, @NotNull FirAnnotationArgumentVisitorData data2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(data2, "data");
        data2.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.INT);
        data2.getBuilder().setIntValue(((Number)value2.getValue()).intValue());
        data2.getBuilder().setFlags(Flags.IS_UNSIGNED.toFlags(true));
    }

    @Override
    public void visitULongValue(@NotNull ULongValue value2, @NotNull FirAnnotationArgumentVisitorData data2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(data2, "data");
        data2.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.LONG);
        data2.getBuilder().setIntValue(((Number)value2.getValue()).longValue());
        data2.getBuilder().setFlags(Flags.IS_UNSIGNED.toFlags(true));
    }
}

