/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import com.intellij.openapi.project.Project;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Substitutable;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.reference.CallableReferenceTranslator;
import org.jetbrains.kotlin.js.translate.reference.CallableReferenceTranslator$isSetterVisible$;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.DelegatingResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VarargValueArgument;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rJ*\u0010\u0011\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0002J*\u0010\u0013\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0002Jr\u0010\u0014\u001a\u00020\u00042\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u00162\u0006\u0010\u000f\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0018\u001a\u00020\t2.\u0010\u0019\u001a*\u0012\u0004\u0012\u00020\r\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0016\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u00040\u001aH\u0002J&\u0010\u001b\u001a\u00020\u0004*\u00020\r2\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J8\u0010\u001e\u001a\u00020\u0004*\u00020\r2\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u00042\b\u0010 \u001a\u0004\u0018\u00010\u0004H\u0002\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/js/translate/reference/CallableReferenceTranslator;", "", "()V", "bindIfNecessary", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "receiver", "isSetterVisible", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "translate", "expression", "Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;", "translateForFunction", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "translateForProperty", "translateForPropertyAccessor", "call", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isSetter", "translator", "Lkotlin/Function4;", "wrapFunctionCallableRef", "name", "", "wrapPropertyCallableRef", "getter", "setter", "js.translator"})
public final class CallableReferenceTranslator {
    @NotNull
    public static final CallableReferenceTranslator INSTANCE = new CallableReferenceTranslator();

    private CallableReferenceTranslator() {
    }

    @NotNull
    public final JsExpression translate(@NotNull KtCallableReferenceExpression expression2, @NotNull TranslationContext context2) {
        JsExpression jsExpression;
        JsExpression jsExpression2;
        Object object;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Object object2 = expression2.getCallableReference();
        Intrinsics.checkNotNullExpressionValue(object2, "expression.callableReference");
        KtElement ktElement = (KtElement)object2;
        object2 = context2.bindingContext();
        Intrinsics.checkNotNullExpressionValue(object2, "context.bindingContext()");
        ResolvedCall<? extends CallableDescriptor> referencedFunction = CallUtilKt.getResolvedCallWithAssert(ktElement, (BindingContext)object2);
        CallableDescriptor descriptor2 = referencedFunction.getResultingDescriptor();
        ReceiverValue extensionReceiver = referencedFunction.getExtensionReceiver();
        ReceiverValue dispatchReceiver = referencedFunction.getDispatchReceiver();
        boolean bl = dispatchReceiver == null || extensionReceiver == null;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = Intrinsics.stringPlus("Cannot generate reference with both receivers: ", descriptor2);
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        ReceiverValue receiverValue = dispatchReceiver;
        Object object3 = object = receiverValue == null ? extensionReceiver : receiverValue;
        if (object == null) {
            jsExpression2 = null;
        } else {
            receiverValue = object;
            boolean bl4 = false;
            boolean bl5 = false;
            ReceiverValue it = receiverValue;
            boolean bl6 = false;
            ReceiverValue receiverValue2 = it;
            if (receiverValue2 instanceof TransientReceiver) {
                jsExpression2 = null;
            } else if (receiverValue2 instanceof ImplicitClassReceiver ? true : receiverValue2 instanceof ExtensionReceiver) {
                jsExpression2 = context2.getDispatchReceiver(JsDescriptorUtils.getReceiverParameterForReceiver(it));
            } else if (receiverValue2 instanceof ExpressionReceiver) {
                jsExpression2 = Translation.translateAsExpression(((ExpressionReceiver)it).getExpression(), context2);
            } else {
                throw new UnsupportedOperationException(Intrinsics.stringPlus("Unsupported receiver value: ", it));
            }
        }
        JsExpression receiver = jsExpression2;
        object = descriptor2;
        if (object instanceof PropertyDescriptor) {
            jsExpression = this.translateForProperty((PropertyDescriptor)descriptor2, context2, expression2, receiver);
        } else if (object instanceof FunctionDescriptor) {
            jsExpression = this.translateForFunction((FunctionDescriptor)descriptor2, context2, expression2, receiver);
        } else {
            throw new IllegalArgumentException("Expected property or function: " + descriptor2 + ", expression=" + expression2.getText());
        }
        return jsExpression;
    }

    private final JsExpression translateForFunction(FunctionDescriptor descriptor2, TranslationContext context2, KtCallableReferenceExpression expression2, JsExpression receiver) {
        Object index22;
        Object object;
        JsNameRef jsNameRef;
        boolean bl;
        SimpleFunctionDescriptor simpleFunctionDescriptor;
        Object object2 = expression2.getCallableReference();
        Intrinsics.checkNotNullExpressionValue(object2, "expression.callableReference");
        KtExpression ktExpression = (KtExpression)object2;
        object2 = context2.bindingContext();
        Intrinsics.checkNotNullExpressionValue(object2, "context.bindingContext()");
        ResolvedCall<? extends FunctionDescriptor> realResolvedCall = CallUtilKt.getFunctionResolvedCallWithAssert(ktExpression, (BindingContext)object2);
        SimpleFunctionDescriptor simpleFunctionDescriptor2 = (SimpleFunctionDescriptor)context2.bindingContext().get(BindingContext.FUNCTION, expression2);
        Intrinsics.checkNotNull(simpleFunctionDescriptor2);
        SimpleFunctionDescriptor functionDescriptor = simpleFunctionDescriptor = simpleFunctionDescriptor2;
        int receivers = receiver == null && (descriptor2.getDispatchReceiverParameter() != null || descriptor2.getExtensionReceiverParameter() != null) ? 1 : 0;
        int fakeArgCount = functionDescriptor.getValueParameters().size() - receivers;
        Project project = expression2.getProject();
        Intrinsics.checkNotNullExpressionValue(project, "expression.project");
        KtCallExpression fakeExpression = CodegenUtil.constructFakeFunctionCall(project, fakeArgCount);
        List<KtValueArgument> list2 = fakeExpression.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(list2, "fakeExpression.valueArguments");
        List<KtValueArgument> fakeArguments = list2;
        Call call2 = CallMaker.makeCall(fakeExpression, null, null, fakeExpression, fakeArguments);
        Intrinsics.checkNotNullExpressionValue(call2, "makeCall(fakeExpression, null, null, fakeExpression, fakeArguments)");
        Call fakeCall = call2;
        DelegatingResolvedCall<FunctionDescriptor> fakeResolvedCall2 = new DelegatingResolvedCall<FunctionDescriptor>(descriptor2, fakeArgCount, functionDescriptor, receivers, fakeArguments, fakeCall, receiver, realResolvedCall){
            @NotNull
            private final Map<ValueParameterDescriptor, ResolvedValueArgument> valueArgumentMap;
            @NotNull
            private final List<ResolvedValueArgument> valueArgumentList;
            final /* synthetic */ FunctionDescriptor $descriptor;
            final /* synthetic */ int $fakeArgCount;
            final /* synthetic */ SimpleFunctionDescriptor $functionDescriptor;
            final /* synthetic */ int $receivers;
            final /* synthetic */ List<KtValueArgument> $fakeArguments;
            final /* synthetic */ Call $fakeCall;
            final /* synthetic */ JsExpression $receiver;
            final /* synthetic */ ResolvedCall<? extends FunctionDescriptor> $realResolvedCall;
            {
                this.$descriptor = $descriptor;
                this.$fakeArgCount = $fakeArgCount;
                this.$functionDescriptor = $functionDescriptor;
                this.$receivers = $receivers;
                this.$fakeArguments = $fakeArguments;
                this.$fakeCall = $fakeCall;
                this.$receiver = $receiver;
                this.$realResolvedCall = $realResolvedCall;
                super($realResolvedCall);
                boolean bl = false;
                Map map = new LinkedHashMap<K, V>();
                FunctionDescriptor functionDescriptor = this.$descriptor;
                int n = this.$fakeArgCount;
                SimpleFunctionDescriptor simpleFunctionDescriptor = this.$functionDescriptor;
                int n2 = this.$receivers;
                List<KtValueArgument> list2 = this.$fakeArguments;
                boolean bl2 = false;
                boolean bl3 = false;
                Map map2 = map;
                translateForFunction.fakeResolvedCall.1 var26_19 = this;
                boolean bl4 = false;
                int i = 0;
                for (ValueParameterDescriptor parameter : functionDescriptor.getValueParameters()) {
                    boolean bl5;
                    ResolvedValueArgument resolvedValueArgument;
                    ValueParameterDescriptor valueParameterDescriptor;
                    void var22_24;
                    void argumentMap;
                    if (parameter.getVarargElementType() != null) {
                        if (i == n) {
                            var22_24 = argumentMap;
                            Intrinsics.checkNotNullExpressionValue(parameter, "parameter");
                            valueParameterDescriptor = parameter;
                            resolvedValueArgument = ArgumentsUtilsKt.hasDefaultValue(parameter) ? (ResolvedValueArgument)DefaultValueArgument.DEFAULT : (ResolvedValueArgument)new VarargValueArgument();
                            Intrinsics.checkNotNullExpressionValue(resolvedValueArgument, "if (parameter.hasDefaultValue()) DefaultValueArgument.DEFAULT else VarargValueArgument()");
                            bl5 = false;
                            var22_24.put(valueParameterDescriptor, resolvedValueArgument);
                            continue;
                        }
                        if (Intrinsics.areEqual(simpleFunctionDescriptor.getValueParameters().get(n2 + i).getType(), parameter.getVarargElementType())) {
                            var22_24 = argumentMap;
                            Intrinsics.checkNotNullExpressionValue(parameter, "parameter");
                            valueParameterDescriptor = parameter;
                            resolvedValueArgument = new VarargValueArgument(list2.subList(i, n));
                            bl5 = false;
                            var22_24.put(valueParameterDescriptor, resolvedValueArgument);
                            i = n;
                            continue;
                        }
                    }
                    if (i < n) {
                        var22_24 = argumentMap;
                        Intrinsics.checkNotNullExpressionValue(parameter, "parameter");
                        valueParameterDescriptor = parameter;
                        int n3 = i;
                        i = n3 + 1;
                        resolvedValueArgument = new ExpressionValueArgument(list2.get(n3));
                        bl5 = false;
                        var22_24.put(valueParameterDescriptor, resolvedValueArgument);
                        continue;
                    }
                    Intrinsics.checkNotNullExpressionValue(parameter, "parameter");
                    boolean bl6 = ArgumentsUtilsKt.hasDefaultValue(parameter);
                    boolean bl7 = false;
                    if (_Assertions.ENABLED && !bl6) {
                        boolean bl8 = false;
                        String string2 = "Parameter should be either vararg or expression or default: " + parameter + " (reference in: " + simpleFunctionDescriptor.getContainingDeclaration() + ')';
                        throw (Throwable)((Object)new AssertionError((Object)string2));
                    }
                    var22_24 = argumentMap;
                    valueParameterDescriptor = parameter;
                    resolvedValueArgument = DefaultValueArgument.DEFAULT;
                    Intrinsics.checkNotNullExpressionValue(resolvedValueArgument, "DEFAULT");
                    bl5 = false;
                    var22_24.put(valueParameterDescriptor, resolvedValueArgument);
                }
                Unit unit = Unit.INSTANCE;
                var26_19.valueArgumentMap = map;
                this.valueArgumentList = CollectionsKt.toList((Iterable)this.valueArgumentMap.values());
            }

            @NotNull
            public final Map<ValueParameterDescriptor, ResolvedValueArgument> getValueArgumentMap() {
                return this.valueArgumentMap;
            }

            @NotNull
            public final List<ResolvedValueArgument> getValueArgumentList() {
                return this.valueArgumentList;
            }

            @NotNull
            public Call getCall() {
                return this.$fakeCall;
            }

            @NotNull
            public List<ResolvedValueArgument> getValueArgumentsByIndex() {
                return this.valueArgumentList;
            }

            @NotNull
            public Map<ValueParameterDescriptor, ResolvedValueArgument> getValueArguments() {
                return this.valueArgumentMap;
            }

            @NotNull
            public ExplicitReceiverKind getExplicitReceiverKind() {
                if (this.$receiver != null) {
                    return DescriptorUtilsKt.isExtension(this.$descriptor) ? ExplicitReceiverKind.EXTENSION_RECEIVER : ExplicitReceiverKind.DISPATCH_RECEIVER;
                }
                ExplicitReceiverKind explicitReceiverKind = super.getExplicitReceiverKind();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)explicitReceiverKind), "super.getExplicitReceiverKind()");
                return explicitReceiverKind;
            }
        };
        JsFunction function2 = new JsFunction(context2.scope(), new JsBlock(), "");
        function2.setSource(expression2);
        if (descriptor2.getDispatchReceiverParameter() != null || descriptor2.getExtensionReceiverParameter() != null || receiver != null) {
            HasMetadata hasMetadata = JsScope.declareTemporaryName(Namer.getReceiverParameterName());
            Intrinsics.checkNotNullExpressionValue(hasMetadata, "declareTemporaryName(Namer.getReceiverParameterName())");
            JsName paramName = hasMetadata;
            hasMetadata = function2;
            Collection<JsParameter> collection = ((JsFunction)hasMetadata).getParameters();
            Intrinsics.checkNotNullExpressionValue(collection, "function.parameters");
            collection = collection;
            JsParameter jsParameter = new JsParameter(paramName);
            bl = false;
            collection.add(jsParameter);
            jsNameRef = paramName.makeRef();
        } else {
            jsNameRef = null;
        }
        JsNameRef receiverParam = jsNameRef;
        boolean bl2 = false;
        Map aliases = new LinkedHashMap();
        Iterator<? extends ValueArgument> iterator2 = fakeCall.getValueArguments().iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index22 = n++;
            ValueArgument valueArg = iterator2.next();
            HasMetadata hasMetadata = JsScope.declareTemporaryName(functionDescriptor.getValueParameters().get(index22).getName().asString());
            Intrinsics.checkNotNullExpressionValue(hasMetadata, "declareTemporaryName(functionDescriptor.valueParameters[index].name.asString())");
            JsName paramName = hasMetadata;
            hasMetadata = function2;
            Object object3 = ((JsFunction)hasMetadata).getParameters();
            Intrinsics.checkNotNullExpressionValue(object3, "function.parameters");
            object3 = (Collection)object3;
            object = new JsParameter(paramName);
            boolean bl3 = false;
            object3.add((JsParameter)object);
            object3 = paramName.makeRef();
            Intrinsics.checkNotNullExpressionValue(object3, "paramName.makeRef()");
            Object paramRef = object3;
            MetadataProperties.setType((JsExpression)paramRef, context2.getCurrentModule().getBuiltIns().getAnyType());
            object3 = aliases;
            object = valueArg.getArgumentExpression();
            Intrinsics.checkNotNull(object);
            bl3 = false;
            object3.put(object, paramRef);
        }
        Object functionContext = null;
        Object object4 = context2.innerBlock(function2.getBody()).innerContextWithAliasesForExpressions(aliases).inner(descriptor2);
        Intrinsics.checkNotNullExpressionValue(object4, "context.innerBlock(function.body).innerContextWithAliasesForExpressions(aliases).inner(descriptor)");
        functionContext = object4;
        object4 = ((TranslationContext)functionContext).getContinuationParameterDescriptor();
        if (object4 != null) {
            index22 = object4;
            bl = false;
            boolean bl4 = false;
            Object continuationDescriptor = index22;
            boolean bl5 = false;
            object = function2;
            Collection<JsParameter> collection = ((JsFunction)object).getParameters();
            Intrinsics.checkNotNullExpressionValue(collection, "function.parameters");
            collection = collection;
            JsParameter jsParameter = new JsParameter(context2.getNameForDescriptor((DeclarationDescriptor)continuationDescriptor));
            boolean bl6 = false;
            collection.add(jsParameter);
            object = ((TranslationContext)functionContext).innerContextWithDescriptorsAliased(MapsKt.mapOf(TuplesKt.to(continuationDescriptor, JsAstUtils.stateMachineReceiver())));
            Intrinsics.checkNotNullExpressionValue(object, "functionContext.innerContextWithDescriptorsAliased(mapOf(continuationDescriptor to JsAstUtils.stateMachineReceiver()))");
            functionContext = object;
        }
        if (descriptor2.isSuspend()) {
            UtilsKt.fillCoroutineMetadata(function2, (TranslationContext)functionContext, functionDescriptor, false);
        }
        JsExpression invocation = CallTranslator.translate((TranslationContext)functionContext, (ResolvedCall<? extends FunctionDescriptor>)fakeResolvedCall2, receiverParam);
        index22 = function2.getBody();
        Collection<JsStatement> collection = ((JsBlock)index22).getStatements();
        Intrinsics.checkNotNullExpressionValue(collection, "function.body.statements");
        collection = collection;
        JsReturn jsReturn = new JsReturn(TranslationUtils.coerce(context2, invocation, context2.getCurrentModule().getBuiltIns().getAnyType()));
        boolean bl7 = false;
        collection.add(jsReturn);
        JsExpression rawCallableRef = this.bindIfNecessary(function2, receiver);
        return this.wrapFunctionCallableRef(context2, receiver, expression2.getCallableReference().getReferencedName(), rawCallableRef);
    }

    private final JsExpression translateForProperty(PropertyDescriptor descriptor2, TranslationContext context2, KtCallableReferenceExpression expression2, JsExpression receiver) {
        Object object = expression2.getCallableReference();
        Intrinsics.checkNotNullExpressionValue(object, "expression.callableReference");
        KtExpression ktExpression = (KtExpression)object;
        object = context2.bindingContext();
        Intrinsics.checkNotNullExpressionValue(object, "context.bindingContext()");
        ResolvedCall<? extends PropertyDescriptor> realCall = CallUtilKt.getPropertyResolvedCallWithAssert(ktExpression, (BindingContext)object);
        DelegatingResolvedCall<PropertyDescriptor> call2 = new DelegatingResolvedCall<PropertyDescriptor>(receiver, descriptor2, realCall){
            final /* synthetic */ JsExpression $receiver;
            final /* synthetic */ PropertyDescriptor $descriptor;
            final /* synthetic */ ResolvedCall<? extends PropertyDescriptor> $realCall;
            {
                this.$receiver = $receiver;
                this.$descriptor = $descriptor;
                this.$realCall = $realCall;
                super($realCall);
            }

            @NotNull
            public ExplicitReceiverKind getExplicitReceiverKind() {
                if (this.$receiver != null) {
                    return DescriptorUtilsKt.isExtension(this.$descriptor) ? ExplicitReceiverKind.EXTENSION_RECEIVER : ExplicitReceiverKind.DISPATCH_RECEIVER;
                }
                ExplicitReceiverKind explicitReceiverKind = super.getExplicitReceiverKind();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)explicitReceiverKind), "super.getExplicitReceiverKind()");
                return explicitReceiverKind;
            }
        };
        JsExpression getter2 = this.translateForPropertyAccessor((ResolvedCall<? extends PropertyDescriptor>)call2, expression2, descriptor2, context2, receiver, false, translateForProperty.getter.1.INSTANCE);
        JsExpression setter2 = this.isSetterVisible(descriptor2, context2) ? this.translateForPropertyAccessor((ResolvedCall<? extends PropertyDescriptor>)call2, expression2, descriptor2, context2, receiver, true, (Function4<? super TranslationContext, ? super ResolvedCall<? extends PropertyDescriptor>, ? super JsExpression, ? super JsExpression, ? extends JsExpression>)new Function4<TranslationContext, ResolvedCall<? extends VariableDescriptor>, JsExpression, JsExpression, JsExpression>(CallTranslator.INSTANCE){

            @NotNull
            public final JsExpression invoke(@NotNull TranslationContext p0, @NotNull ResolvedCall<? extends VariableDescriptor> p1, @NotNull JsExpression p2, @Nullable JsExpression p3) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                Intrinsics.checkNotNullParameter(p1, "p1");
                Intrinsics.checkNotNullParameter(p2, "p2");
                return ((CallTranslator)this.receiver).translateSet(p0, p1, p2, p3);
            }

            @NotNull
            public final String getSignature() {
                return "translateSet(Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;)Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;";
            }

            @NotNull
            public final String getName() {
                return "translateSet";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(CallTranslator.class);
            }
        }) : (JsExpression)null;
        return this.wrapPropertyCallableRef(context2, receiver, descriptor2, expression2.getCallableReference().getReferencedName(), getter2, setter2);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isSetterVisible(PropertyDescriptor descriptor2, TranslationContext context2) {
        void $this$filterIsInstance$iv;
        Substitutable<CallableDescriptor> substitutable = descriptor2.getSetter();
        if (substitutable == null) {
            return false;
        }
        PropertySetterDescriptor propertySetterDescriptor = substitutable;
        PropertySetterDescriptor setter2 = propertySetterDescriptor;
        if (!Intrinsics.areEqual(setter2.getVisibility(), DescriptorVisibilities.PRIVATE)) {
            return true;
        }
        Object object = context2.getClassDescriptor();
        if (object == null) {
            return false;
        }
        Substitutable<CallableDescriptor> classDescriptor2 = substitutable = object;
        object = SequencesKt.generateSequence(classDescriptor2, (Function1)isSetterVisible.outerClasses.1.INSTANCE);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence2 = SequencesKt.filter($this$filterIsInstance$iv, isSetterVisible$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        Sequence outerClasses2 = sequence2;
        return SequencesKt.contains(outerClasses2, descriptor2.getContainingDeclaration());
    }

    private final JsExpression translateForPropertyAccessor(ResolvedCall<? extends PropertyDescriptor> call2, KtExpression expression2, PropertyDescriptor descriptor2, TranslationContext context2, JsExpression receiver, boolean isSetter, Function4<? super TranslationContext, ? super ResolvedCall<? extends PropertyDescriptor>, ? super JsExpression, ? super JsExpression, ? extends JsExpression> translator) {
        JsExpression jsExpression;
        JsNameRef receiverParam;
        JsNameRef jsNameRef;
        Object object;
        Object object2;
        HasMetadata hasMetadata;
        JsFunction accessorFunction = new JsFunction(context2.scope(), new JsBlock(), "");
        accessorFunction.setSource(expression2);
        TranslationContext translationContext = context2.innerBlock(accessorFunction.getBody());
        Intrinsics.checkNotNullExpressionValue(translationContext, "context.innerBlock(accessorFunction.body)");
        TranslationContext accessorContext = translationContext;
        if (descriptor2.getDispatchReceiverParameter() != null || descriptor2.getExtensionReceiverParameter() != null) {
            hasMetadata = JsScope.declareTemporaryName(Namer.getReceiverParameterName());
            Intrinsics.checkNotNullExpressionValue(hasMetadata, "declareTemporaryName(Namer.getReceiverParameterName())");
            JsName name = hasMetadata;
            hasMetadata = accessorFunction;
            object2 = ((JsFunction)hasMetadata).getParameters();
            Intrinsics.checkNotNullExpressionValue(object2, "accessorFunction.parameters");
            object2 = (Collection)object2;
            object = new JsParameter(name);
            boolean bl = false;
            object2.add(object);
            jsNameRef = name.makeRef();
        } else {
            jsNameRef = receiverParam = (JsNameRef)null;
        }
        if (isSetter) {
            object = JsScope.declareTemporaryName("value");
            Intrinsics.checkNotNullExpressionValue(object, "declareTemporaryName(\"value\")");
            JsName name = object;
            object = accessorFunction;
            Collection<JsParameter> collection = ((JsFunction)object).getParameters();
            Intrinsics.checkNotNullExpressionValue(collection, "accessorFunction.parameters");
            collection = collection;
            JsParameter jsParameter = new JsParameter(name);
            boolean bl = false;
            collection.add(jsParameter);
            hasMetadata = name.makeRef();
            Intrinsics.checkNotNullExpressionValue(hasMetadata, "{\n            val name = JsScope.declareTemporaryName(\"value\")\n            accessorFunction.parameters += JsParameter(name)\n            name.makeRef()\n        }");
            jsExpression = (JsExpression)hasMetadata;
        } else {
            jsExpression = new JsNullLiteral();
        }
        JsExpression valueParam = jsExpression;
        JsExpression accessorResult = translator.invoke(accessorContext, call2, valueParam, receiverParam);
        object2 = accessorFunction.getBody();
        object = ((JsBlock)object2).getStatements();
        Intrinsics.checkNotNullExpressionValue(object, "accessorFunction.body.statements");
        object = (Collection)object;
        JsStatement jsStatement = isSetter ? accessorResult.makeStmt() : (JsStatement)new JsReturn(accessorResult);
        boolean bl = false;
        object.add(jsStatement);
        object2 = UtilsKt.getFinalElement(expression2);
        accessorFunction.getBody().setSource(object2 instanceof LeafPsiElement ? (LeafPsiElement)object2 : null);
        return this.bindIfNecessary(accessorFunction, receiver);
    }

    private final JsExpression bindIfNecessary(JsFunction function2, JsExpression receiver) {
        JsExpression jsExpression;
        if (receiver != null) {
            JsExpression[] jsExpressionArray = new JsExpression[]{new JsNullLiteral(), receiver};
            jsExpression = new JsInvocation((JsExpression)new JsNameRef("bind", (JsExpression)function2), jsExpressionArray);
        } else {
            jsExpression = function2;
        }
        return jsExpression;
    }

    private final JsExpression wrapPropertyCallableRef(TranslationContext $this$wrapPropertyCallableRef, JsExpression receiver, PropertyDescriptor descriptor2, String name, JsExpression getter2, JsExpression setter2) {
        int argCount;
        int n = argCount = descriptor2.getContainingDeclaration() instanceof ClassDescriptor || descriptor2.getExtensionReceiverParameter() != null ? 1 : 0;
        if (receiver != null) {
            int n2 = argCount;
            argCount = n2 + -1;
        }
        JsStringLiteral nameLiteral = new JsStringLiteral(name);
        JsIntLiteral argCountLiteral = new JsIntLiteral(argCount);
        JsExpression jsExpression = $this$wrapPropertyCallableRef.getReferenceToIntrinsic("getPropertyCallableRef");
        Intrinsics.checkNotNullExpressionValue(jsExpression, "getReferenceToIntrinsic(Namer.PROPERTY_CALLABLE_REF)");
        JsExpression invokeFun = jsExpression;
        Object object = new JsExpression[]{nameLiteral, argCountLiteral, getter2};
        JsInvocation invocation = new JsInvocation(invokeFun, (JsExpression[])object);
        if (setter2 != null) {
            object = invocation;
            Collection<JsExpression> collection = ((JsInvocation)object).getArguments();
            Intrinsics.checkNotNullExpressionValue(collection, "invocation.arguments");
            collection = collection;
            boolean bl = false;
            collection.add(setter2);
        }
        MetadataProperties.setCallableReferenceReceiver(invocation, receiver);
        return invocation;
    }

    private final JsExpression wrapFunctionCallableRef(TranslationContext $this$wrapFunctionCallableRef, JsExpression receiver, String name, JsExpression function2) {
        JsStringLiteral nameLiteral = new JsStringLiteral(name);
        JsExpression jsExpression = $this$wrapFunctionCallableRef.getReferenceToIntrinsic("getCallableRef");
        Intrinsics.checkNotNullExpressionValue(jsExpression, "getReferenceToIntrinsic(Namer.FUNCTION_CALLABLE_REF)");
        JsExpression invokeFun = jsExpression;
        MetadataProperties.setSideEffects(invokeFun, SideEffectKind.PURE);
        JsExpression[] jsExpressionArray = new JsExpression[]{nameLiteral, function2};
        JsInvocation invocation = new JsInvocation(invokeFun, jsExpressionArray);
        MetadataProperties.setCallableReference(invocation, true);
        MetadataProperties.setSideEffects(invocation, SideEffectKind.PURE);
        MetadataProperties.setCallableReferenceReceiver(invocation, receiver);
        return invocation;
    }
}

