/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl.jna.win;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;

public class AnsiOutputStream
extends FilterOutputStream {
    public static final byte[] RESET_CODE = "\u001b[0m".getBytes();
    @Deprecated
    public static final byte[] REST_CODE = RESET_CODE;
    private final byte[] buffer = new byte[100];
    private int pos = 0;
    private int startOfValue;
    private final ArrayList<Object> options = new ArrayList();
    int state = 0;

    public AnsiOutputStream(OutputStream os) {
        super(os);
    }

    @Override
    public synchronized void write(int data2) throws IOException {
        switch (this.state) {
            case 0: {
                if (data2 == 27) {
                    this.buffer[this.pos++] = (byte)data2;
                    this.state = 1;
                    break;
                }
                this.out.write(data2);
                break;
            }
            case 1: {
                this.buffer[this.pos++] = (byte)data2;
                if (data2 == 91) {
                    this.state = 2;
                    break;
                }
                if (data2 == 93) {
                    this.state = 5;
                    break;
                }
                this.reset(false);
                break;
            }
            case 2: {
                this.buffer[this.pos++] = (byte)data2;
                if (34 == data2) {
                    this.startOfValue = this.pos - 1;
                    this.state = 3;
                    break;
                }
                if (48 <= data2 && data2 <= 57) {
                    this.startOfValue = this.pos - 1;
                    this.state = 4;
                    break;
                }
                if (59 == data2) {
                    this.options.add(null);
                    break;
                }
                if (63 == data2) {
                    this.options.add(Character.valueOf('?'));
                    break;
                }
                if (61 == data2) {
                    this.options.add(Character.valueOf('='));
                    break;
                }
                this.reset(this.processEscapeCommand(this.options, data2));
                break;
            }
            default: {
                break;
            }
            case 4: {
                this.buffer[this.pos++] = (byte)data2;
                if (48 <= data2 && data2 <= 57) break;
                String strValue = new String(this.buffer, this.startOfValue, this.pos - 1 - this.startOfValue, Charset.defaultCharset());
                Integer value2 = new Integer(strValue);
                this.options.add(value2);
                if (data2 == 59) {
                    this.state = 2;
                    break;
                }
                this.reset(this.processEscapeCommand(this.options, data2));
                break;
            }
            case 3: {
                this.buffer[this.pos++] = (byte)data2;
                if (34 == data2) break;
                String value3 = new String(this.buffer, this.startOfValue, this.pos - 1 - this.startOfValue, Charset.defaultCharset());
                this.options.add(value3);
                if (data2 == 59) {
                    this.state = 2;
                    break;
                }
                this.reset(this.processEscapeCommand(this.options, data2));
                break;
            }
            case 5: {
                this.buffer[this.pos++] = (byte)data2;
                if (48 <= data2 && data2 <= 57) {
                    this.startOfValue = this.pos - 1;
                    this.state = 6;
                    break;
                }
                this.reset(false);
                break;
            }
            case 6: {
                this.buffer[this.pos++] = (byte)data2;
                if (59 == data2) {
                    String strValue = new String(this.buffer, this.startOfValue, this.pos - 1 - this.startOfValue, Charset.defaultCharset());
                    Integer value4 = new Integer(strValue);
                    this.options.add(value4);
                    this.startOfValue = this.pos;
                    this.state = 7;
                    break;
                }
                if (48 <= data2 && data2 <= 57) break;
                this.reset(false);
                break;
            }
            case 7: {
                this.buffer[this.pos++] = (byte)data2;
                if (7 == data2) {
                    String value5 = new String(this.buffer, this.startOfValue, this.pos - 1 - this.startOfValue, Charset.defaultCharset());
                    this.options.add(value5);
                    this.reset(this.processOperatingSystemCommand(this.options));
                    break;
                }
                if (27 != data2) break;
                this.state = 8;
                break;
            }
            case 8: {
                this.buffer[this.pos++] = (byte)data2;
                if (92 == data2) {
                    String value6 = new String(this.buffer, this.startOfValue, this.pos - 2 - this.startOfValue, Charset.defaultCharset());
                    this.options.add(value6);
                    this.reset(this.processOperatingSystemCommand(this.options));
                    break;
                }
                this.state = 7;
            }
        }
        if (this.pos >= this.buffer.length) {
            this.reset(false);
        }
    }

    private void reset(boolean skipBuffer) throws IOException {
        if (!skipBuffer) {
            this.out.write(this.buffer, 0, this.pos);
        }
        this.pos = 0;
        this.startOfValue = 0;
        this.options.clear();
        this.state = 0;
    }

    private int getNextOptionInt(Iterator<Object> optionsIterator) throws IOException {
        Object arg;
        do {
            if (optionsIterator.hasNext()) continue;
            throw new IllegalArgumentException();
        } while ((arg = optionsIterator.next()) == null);
        return (Integer)arg;
    }

    private boolean processEscapeCommand(ArrayList<Object> options, int command) throws IOException {
        try {
            switch (command) {
                case 65: {
                    this.processCursorUp(this.optionInt(options, 0, 1));
                    return true;
                }
                case 66: {
                    this.processCursorDown(this.optionInt(options, 0, 1));
                    return true;
                }
                case 67: {
                    this.processCursorRight(this.optionInt(options, 0, 1));
                    return true;
                }
                case 68: {
                    this.processCursorLeft(this.optionInt(options, 0, 1));
                    return true;
                }
                case 69: {
                    this.processCursorDownLine(this.optionInt(options, 0, 1));
                    return true;
                }
                case 70: {
                    this.processCursorUpLine(this.optionInt(options, 0, 1));
                    return true;
                }
                case 71: {
                    this.processCursorToColumn(this.optionInt(options, 0));
                    return true;
                }
                case 72: 
                case 102: {
                    this.processCursorTo(this.optionInt(options, 0, 1), this.optionInt(options, 1, 1));
                    return true;
                }
                case 74: {
                    this.processEraseScreen(this.optionInt(options, 0, 0));
                    return true;
                }
                case 75: {
                    this.processEraseLine(this.optionInt(options, 0, 0));
                    return true;
                }
                case 76: {
                    this.processInsertLine(this.optionInt(options, 0, 1));
                    return true;
                }
                case 77: {
                    this.processDeleteLine(this.optionInt(options, 0, 1));
                    return true;
                }
                case 83: {
                    this.processScrollUp(this.optionInt(options, 0, 1));
                    return true;
                }
                case 84: {
                    this.processScrollDown(this.optionInt(options, 0, 1));
                    return true;
                }
                case 109: {
                    for (Object next : options) {
                        if (next == null || next.getClass() == Integer.class) continue;
                        throw new IllegalArgumentException();
                    }
                    int count = 0;
                    Iterator<Object> optionsIterator = options.iterator();
                    block27: while (optionsIterator.hasNext()) {
                        Object next = optionsIterator.next();
                        if (next == null) continue;
                        ++count;
                        int value2 = (Integer)next;
                        if (30 <= value2 && value2 <= 37) {
                            this.processSetForegroundColor(value2 - 30);
                            continue;
                        }
                        if (40 <= value2 && value2 <= 47) {
                            this.processSetBackgroundColor(value2 - 40);
                            continue;
                        }
                        if (90 <= value2 && value2 <= 97) {
                            this.processSetForegroundColor(value2 - 90, true);
                            continue;
                        }
                        if (100 <= value2 && value2 <= 107) {
                            this.processSetBackgroundColor(value2 - 100, true);
                            continue;
                        }
                        if (value2 == 38 || value2 == 48) {
                            int arg2or5 = this.getNextOptionInt(optionsIterator);
                            if (arg2or5 == 2) {
                                int r = this.getNextOptionInt(optionsIterator);
                                int g = this.getNextOptionInt(optionsIterator);
                                int b = this.getNextOptionInt(optionsIterator);
                                if (r >= 0 && r <= 255 && g >= 0 && g <= 255 && b >= 0 && b <= 255) {
                                    if (value2 == 38) {
                                        this.processSetForegroundColorExt(r, g, b);
                                        continue;
                                    }
                                    this.processSetBackgroundColorExt(r, g, b);
                                    continue;
                                }
                                throw new IllegalArgumentException();
                            }
                            if (arg2or5 == 5) {
                                int paletteIndex = this.getNextOptionInt(optionsIterator);
                                if (paletteIndex >= 0 && paletteIndex <= 255) {
                                    if (value2 == 38) {
                                        this.processSetForegroundColorExt(paletteIndex);
                                        continue;
                                    }
                                    this.processSetBackgroundColorExt(paletteIndex);
                                    continue;
                                }
                                throw new IllegalArgumentException();
                            }
                            throw new IllegalArgumentException();
                        }
                        switch (value2) {
                            case 39: {
                                this.processDefaultTextColor();
                                continue block27;
                            }
                            case 49: {
                                this.processDefaultBackgroundColor();
                                continue block27;
                            }
                            case 0: {
                                this.processAttributeRest();
                                continue block27;
                            }
                        }
                        this.processSetAttribute(value2);
                    }
                    if (count == 0) {
                        this.processAttributeRest();
                    }
                    return true;
                }
                case 115: {
                    this.processSaveCursorPosition();
                    return true;
                }
                case 117: {
                    this.processRestoreCursorPosition();
                    return true;
                }
            }
            if (97 <= command && 122 <= command) {
                this.processUnknownExtension(options, command);
                return true;
            }
            if (65 <= command && 90 <= command) {
                this.processUnknownExtension(options, command);
                return true;
            }
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    private boolean processOperatingSystemCommand(ArrayList<Object> options) throws IOException {
        int command = this.optionInt(options, 0);
        String label = (String)options.get(1);
        try {
            switch (command) {
                case 0: {
                    this.processChangeIconNameAndWindowTitle(label);
                    return true;
                }
                case 1: {
                    this.processChangeIconName(label);
                    return true;
                }
                case 2: {
                    this.processChangeWindowTitle(label);
                    return true;
                }
            }
            this.processUnknownOperatingSystemCommand(command, label);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    protected void processRestoreCursorPosition() throws IOException {
    }

    protected void processSaveCursorPosition() throws IOException {
    }

    protected void processInsertLine(int optionInt) throws IOException {
    }

    protected void processDeleteLine(int optionInt) throws IOException {
    }

    protected void processScrollDown(int optionInt) throws IOException {
    }

    protected void processScrollUp(int optionInt) throws IOException {
    }

    protected void processEraseScreen(int eraseOption) throws IOException {
    }

    protected void processEraseLine(int eraseOption) throws IOException {
    }

    protected void processSetAttribute(int attribute) throws IOException {
    }

    protected void processSetForegroundColor(int color) throws IOException {
        this.processSetForegroundColor(color, false);
    }

    protected void processSetForegroundColor(int color, boolean bright) throws IOException {
    }

    protected void processSetForegroundColorExt(int paletteIndex) throws IOException {
    }

    protected void processSetForegroundColorExt(int r, int g, int b) throws IOException {
    }

    protected void processSetBackgroundColor(int color) throws IOException {
        this.processSetBackgroundColor(color, false);
    }

    protected void processSetBackgroundColor(int color, boolean bright) throws IOException {
    }

    protected void processSetBackgroundColorExt(int paletteIndex) throws IOException {
    }

    protected void processSetBackgroundColorExt(int r, int g, int b) throws IOException {
    }

    protected void processDefaultTextColor() throws IOException {
    }

    protected void processDefaultBackgroundColor() throws IOException {
    }

    protected void processAttributeRest() throws IOException {
    }

    protected void processCursorTo(int row, int col) throws IOException {
    }

    protected void processCursorToColumn(int x) throws IOException {
    }

    protected void processCursorUpLine(int count) throws IOException {
    }

    protected void processCursorDownLine(int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            this.out.write(10);
        }
    }

    protected void processCursorLeft(int count) throws IOException {
    }

    protected void processCursorRight(int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            this.out.write(32);
        }
    }

    protected void processCursorDown(int count) throws IOException {
    }

    protected void processCursorUp(int count) throws IOException {
    }

    protected void processUnknownExtension(ArrayList<Object> options, int command) {
    }

    protected void processChangeIconNameAndWindowTitle(String label) {
        this.processChangeIconName(label);
        this.processChangeWindowTitle(label);
    }

    protected void processChangeIconName(String label) {
    }

    protected void processChangeWindowTitle(String label) {
    }

    protected void processUnknownOperatingSystemCommand(int command, String param) {
    }

    private int optionInt(ArrayList<Object> options, int index2) {
        if (options.size() <= index2) {
            throw new IllegalArgumentException();
        }
        Object value2 = options.get(index2);
        if (value2 == null) {
            throw new IllegalArgumentException();
        }
        if (!value2.getClass().equals(Integer.class)) {
            throw new IllegalArgumentException();
        }
        return (Integer)value2;
    }

    private int optionInt(ArrayList<Object> options, int index2, int defaultValue2) {
        if (options.size() > index2) {
            Object value2 = options.get(index2);
            if (value2 == null) {
                return defaultValue2;
            }
            return (Integer)value2;
        }
        return defaultValue2;
    }

    @Override
    public void close() throws IOException {
        this.write(RESET_CODE);
        this.flush();
        super.close();
    }
}

