/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.dynawrapper;

import android.graphics.Bitmap;
import io.scanbot.dynawrapper.AnnotationIcon;
import io.scanbot.dynawrapper.DocumentInfoField;
import io.scanbot.dynawrapper.PDFException;
import io.scanbot.dynawrapper.PageBoundary;

public class DynaPDF {
    public static final int psFitWidth = 0;
    public static final int psFitHeight = 1;
    public static final int psFitBest = 2;
    public static final int psFitZoom = 3;
    public static final int ptOpen = 0;
    public static final int ptOwner = 1;
    public static final int ptForceRepair = 2;
    public static final int rfDefault = 0;
    public static final int rfScaleToMediaBox = 1;
    public static final int rfIgnoreCropBox = 2;
    public static final int rfClipToArtBox = 4;
    public static final int rfClipToBleedBox = 8;
    public static final int rfClipToTrimBox = 16;
    public static final int rfExclAnnotations = 32;
    public static final int rfExclFormFields = 64;
    public static final int rfSkipUpdateBG = 128;
    public static final int rfRotate90 = 256;
    public static final int rfRotate180 = 512;
    public static final int rfRotate270 = 1024;
    private Bitmap m_Bitmap = null;
    private int m_DefScale = 0;
    private int m_Flags = 0;
    private long m_Instance = DynaPDF.CreateInstance();
    private float m_Scale = 1.0f;

    public DynaPDF() throws PDFException {
        if (this.m_Instance == 0L) {
            throw new OutOfMemoryError("Out of memory!");
        }
    }

    public void onDestroy() {
        if (this.m_Instance != 0L) {
            DynaPDF.DeleteInstance(this.m_Instance);
            this.m_Instance = 0L;
        }
    }

    public void abort() {
        DynaPDF.Abort(this.m_Instance);
    }

    public Bitmap getBitmap() {
        return this.m_Bitmap;
    }

    public int openFile(String fileName, int pwdType, String password) {
        this.m_Scale = 1.0f;
        return DynaPDF.OpenPDFFile(this.m_Instance, fileName, pwdType, password);
    }

    public boolean renderPage(int pageNum, int screenWidth, int screenHeight) {
        int[] size = new int[2];
        if (!DynaPDF.PrepareForRender(this.m_Instance, pageNum, this.m_DefScale, this.m_Scale, screenWidth, screenHeight, this.m_Flags, size)) {
            return false;
        }
        if (this.m_Bitmap == null || this.m_Bitmap.getWidth() != size[0] || this.m_Bitmap.getHeight() != size[1]) {
            this.m_Bitmap = Bitmap.createBitmap((int)size[0], (int)size[1], (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        return DynaPDF.RenderPage(this.m_Instance, pageNum, 0, 0, this.m_Scale, this.m_DefScale, this.m_Bitmap);
    }

    public String[] getPageAnnotations(int pageNum) {
        return null;
    }

    public void createNewPdf(String filePath) throws PDFException {
        if (!DynaPDF.CreateNewPdf(this.m_Instance, filePath)) {
            throw new PDFException();
        }
    }

    public void setDocumentInfoField(DocumentInfoField field, String value) throws PDFException {
        if (!DynaPDF.SetDocInfo(this.m_Instance, field.ordinal(), value)) {
            throw new PDFException();
        }
    }

    public void appendPage() throws PDFException {
        if (!DynaPDF.Append(this.m_Instance)) {
            throw new PDFException();
        }
    }

    public void setBoundingBox(PageBoundary pageBoundary, double left, double top, double right, double bottom) throws PDFException {
        if (!DynaPDF.SetBBox(this.m_Instance, pageBoundary.ordinal(), left, top, right, bottom)) {
            throw new PDFException();
        }
    }

    public void insertImage(double x, double y, double scaleWidth, double scaleHeight, String filePath) throws PDFException {
        if (!DynaPDF.InsertImageEx(this.m_Instance, x, y, scaleWidth, scaleHeight, filePath)) {
            throw new PDFException();
        }
    }

    public void applyMatrix(double a, double b, double c, double d, double x, double y) throws PDFException {
        if (!DynaPDF.SetMatrix(this.m_Instance, a, b, c, d, x, y)) {
            throw new PDFException();
        }
    }

    public void saveGraphicsState() throws PDFException {
        if (!DynaPDF.SaveGraphicsState(this.m_Instance)) {
            throw new PDFException();
        }
    }

    public void restoreGraphicsState() throws PDFException {
        if (!DynaPDF.RestoreGraphicsState(this.m_Instance)) {
            throw new PDFException();
        }
    }

    public void endPage() throws PDFException {
        if (!DynaPDF.EndPage(this.m_Instance)) {
            throw new PDFException();
        }
    }

    public void closeFile() throws PDFException {
        if (!DynaPDF.CloseFile(this.m_Instance)) {
            throw new PDFException();
        }
    }

    public void importPDF(int destPage, double scaleX, double scaleY) throws PDFException {
        if (!DynaPDF.ImportPDFFile(this.m_Instance, destPage, scaleX, scaleY)) {
            throw new PDFException();
        }
    }

    public void closeImportedFile() {
        DynaPDF.CloseImportFile(this.m_Instance);
    }

    public void editPage(int pageNumber) throws PDFException {
        if (!DynaPDF.EditPage(this.m_Instance, pageNumber)) {
            throw new PDFException();
        }
    }

    public int createTextAnnotation(double posX, double posY, double width, double height, String author, String text, AnnotationIcon icon, boolean open) throws PDFException {
        int annotationHandle = DynaPDF.TextAnnot(this.m_Instance, posX, posY, width, height, author, text, icon.ordinal(), open);
        if (annotationHandle < 0) {
            throw new PDFException();
        }
        return annotationHandle;
    }

    public void openOutputFile(String path) throws PDFException {
        if (!DynaPDF.OpenOutputFile(this.m_Instance, path)) {
            throw new PDFException();
        }
    }

    public int getCurrentPageWidth() {
        return DynaPDF.GetPageWidth(this.m_Instance);
    }

    public int getCurrentPageHeight() {
        return DynaPDF.GetPageHeight(this.m_Instance);
    }

    public static void copyText(DynaPDF src, DynaPDF dst, String fontLookupPath, String fontFamilyName) throws PDFException {
        if (!DynaPDF.CopyText(src.m_Instance, dst.m_Instance, fontLookupPath, fontFamilyName)) {
            throw new PDFException();
        }
    }

    private static native void Abort(long var0);

    private static native long CreateInstance();

    private static native void DeleteInstance(long var0);

    private static native boolean PrepareForRender(long var0, int var2, int var3, float var4, int var5, int var6, int var7, int[] var8);

    private static native int OpenPDFFile(long var0, String var2, int var3, String var4);

    private static native boolean RenderPage(long var0, int var2, int var3, int var4, float var5, int var6, Bitmap var7);

    private static native boolean CreateNewPdf(long var0, String var2);

    private static native boolean SetDocInfo(long var0, int var2, String var3);

    private static native boolean Append(long var0);

    private static native boolean SetBBox(long var0, int var2, double var3, double var5, double var7, double var9);

    private static native boolean InsertImageEx(long var0, double var2, double var4, double var6, double var8, String var10);

    private static native boolean SetMatrix(long var0, double var2, double var4, double var6, double var8, double var10, double var12);

    private static native boolean SaveGraphicsState(long var0);

    private static native boolean RestoreGraphicsState(long var0);

    private static native boolean EndPage(long var0);

    private static native boolean CloseFile(long var0);

    private static native boolean ImportPDFFile(long var0, int var2, double var3, double var5);

    private static native int TextAnnot(long var0, double var2, double var4, double var6, double var8, String var10, String var11, int var12, boolean var13);

    private static native void CloseImportFile(long var0);

    private static native boolean EditPage(long var0, int var2);

    private static native boolean OpenOutputFile(long var0, String var2);

    private static native int GetPageWidth(long var0);

    private static native int GetPageHeight(long var0);

    private static native boolean CopyText(long var0, long var2, String var4, String var5);

    static {
        try {
            System.loadLibrary("dynapdf");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }
}

