package io.scanbot.dynawrapper;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.os.Environment;
import android.util.Log;
import android.view.Gravity;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import java.io.File;

public class PDFViewActivity extends Activity {
    boolean m_Down;
    PDFView m_PDFView;
    float m_dx;
    float m_dy;
    float m_x;
    float m_y;

    @SuppressWarnings("deprecation")
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
//            LinearLayout bar;
//            RelativeLayout layout;
//
//            requestWindowFeature(Window.FEATURE_NO_TITLE);
//
//            m_PDFView = new PDFView(this);
//
//            // A path that works with the Emulator.
//            this.getApplicationContext().getFilesDir().mkdirs();
//
//            File f = new File(Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_DCIM), "temp.pdf");
//            //File f = new File(this.getApplicationContext().getFilesDir(),"temp.pdf");
//
//            // On a real Tablet PC files are usually located on the sdcard.
//            //File f = new File("/mnt/sdcard/Android/data/com.dynaforms.dynapdf/files/temp.pdf");
//
//            Log.d(PDFViewActivity.class.getSimpleName(), f.getAbsolutePath() + "" + f.exists());
//
//            m_PDFView.OpenFile(f.getAbsolutePath(), DynaPDF.ptOpen, "");
//
//            MyButtonHandler bh = new MyButtonHandler(m_PDFView);
//
//            bar = new LinearLayout(this);
//            bar.setOrientation(LinearLayout.HORIZONTAL);
//            bar.setHorizontalGravity(Gravity.CENTER_HORIZONTAL);
//            bh.m_First = new Button(this);
//            bh.m_First.setText("<<");
//            bh.m_First.setOnClickListener(bh);
//            bar.addView(bh.m_First);
//
//            bh.m_Prev = new Button(this);
//            bh.m_Prev.setText(" < ");
//            bh.m_Prev.setOnClickListener(bh);
//            bar.addView(bh.m_Prev);
//
//            bh.m_Text = new TextView(this);
//            bh.m_Text.setText("1/" + m_PDFView.GetPageCount());
//            bar.addView(bh.m_Text);
//            m_PDFView.SetTextView(bh.m_Text);
//
//            bh.m_Next = new Button(this);
//            bh.m_Next.setText(" > ");
//            bh.m_Next.setOnClickListener(bh);
//            bar.addView(bh.m_Next);
//
//            bh.m_Last = new Button(this);
//            bh.m_Last.setText(">>");
//            bh.m_Last.setOnClickListener(bh);
//            bar.addView(bh.m_Last);
//
//            layout = new RelativeLayout(this);
//            layout.setLayoutParams(new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.FILL_PARENT, RelativeLayout.LayoutParams.FILL_PARENT));
//            layout.setGravity(Gravity.FILL);
//
//            RelativeLayout.LayoutParams barParams = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.FILL_PARENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
//            barParams.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
//            bar.setId(100);
//            layout.addView(bar, barParams);
//
//            RelativeLayout.LayoutParams pixmapParams = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.FILL_PARENT, RelativeLayout.LayoutParams.FILL_PARENT);
//            pixmapParams.addRule(RelativeLayout.ABOVE, 100);
//            layout.addView(m_PDFView, pixmapParams);
//            setContentView(layout);

//			writePdf();
            copyTextFromPdf();
        } catch (Exception e) {
            System.out.print("Instantion failed: " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private void copyTextFromPdf() throws Exception {
        File dir = getExternalFilesDir("pdf");
        File in = new File(dir, "in.pdf");
        File out = new File(dir, "out.pdf");
        File res = new File(dir, "res.pdf");

        DynaPDF inPdf = new DynaPDF();
        inPdf.openFile(in.getPath(), DynaPDF.ptOpen, "");
        inPdf.importPDF(1, 1.0, 1.0);
        inPdf.closeImportedFile();

        DynaPDF outPdf = new DynaPDF();
        outPdf.openFile(out.getPath(), DynaPDF.ptOpen, "");
        outPdf.importPDF(1, 1.0, 1.0);
        outPdf.closeImportedFile();
        outPdf.openOutputFile(res.getPath());

        DynaPDF.copyText(
                inPdf,
                outPdf,
                "/sdcard/Android/data/io.scanbot.dynawrapper/files/pdf",
                "Roboto"
        );

        inPdf.closeFile();
        outPdf.closeFile();

        inPdf.onDestroy();
        outPdf.onDestroy();
    }

    private void writePdf() throws Exception {
        File dir = getExternalFilesDir("pdf");
        File pdfFile = new File(dir, "generated.pdf");
        File pdfFile2 = new File(dir, "generated2.pdf");
        File imageFile = new File(Environment.getExternalStorageDirectory(), "ic_launcher.png");

        pdfFile.delete();

        Bitmap bmp = BitmapFactory.decodeFile(imageFile.getPath());
//    	Bitmap bmp = BitmapFactory.decodeResource(getResources(), R.drawable.ic_launcher);
//    	bmp.compress(CompressFormat.JPEG, 100, new FileOutputStream(imageFile));

        DynaPDF pdf = new DynaPDF();
        pdf.createNewPdf(pdfFile.getAbsolutePath());
        pdf.appendPage();
        pdf.setBoundingBox(PageBoundary.MEDIA_BOX, 0d, 0d, bmp.getWidth(), bmp.getHeight());
        pdf.saveGraphicsState();
        pdf.applyMatrix(
                2, 0,
                0, 2,
                0, 0
        );
        pdf.insertImage(0d, 0d, bmp.getWidth(), bmp.getHeight(), imageFile.getPath());
        pdf.restoreGraphicsState();
        pdf.endPage();

        pdf.appendPage();
        pdf.setBoundingBox(PageBoundary.MEDIA_BOX, 0d, 0d, bmp.getWidth(), bmp.getHeight());
        pdf.insertImage(0d, 0d, bmp.getWidth(), bmp.getHeight(), imageFile.getPath());
        pdf.endPage();

        pdf.closeFile();

        pdf.openFile(pdfFile.getPath(), DynaPDF.ptOpen, "");
        pdf.importPDF(1, 1.0, 1.0);
        pdf.closeImportedFile();

        pdf.editPage(2);
        pdf.createTextAnnotation(0d, 0d, 100d, 100d, null, "text", AnnotationIcon.COMMENT, false);
        pdf.endPage();

        pdf.appendPage();
        pdf.endPage();

        pdf.openOutputFile(pdfFile2.getPath());
        pdf.closeFile();

        pdf.onDestroy();
    }

    @Override
    public void onDestroy() {
        if (m_PDFView != null)
            m_PDFView.onDestroy();
        m_PDFView = null;
        super.onDestroy();
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        float curX, curY;
        switch (event.getAction()) {
            case MotionEvent.ACTION_DOWN: {
                m_x = m_dx = event.getX();
                m_y = m_dy = event.getY();
                m_Down = true;
                break;
            }
            case MotionEvent.ACTION_MOVE: {
                curX = event.getX();
                curY = event.getY();
                if (m_Down) m_PDFView.scrollBy((int) (m_x - curX), (int) (m_y - curY));
                m_x = curX;
                m_y = curY;
                break;
            }
            case MotionEvent.ACTION_UP: {
                curX = event.getX();
                curY = event.getY();
                if (m_Down) {
                    if (m_dx - curX > 30f)
                        m_PDFView.RenderPage(PDFView.TPageAction.paNextPage, 1);
                    else if (m_dx - curX < -30f)
                        m_PDFView.RenderPage(PDFView.TPageAction.paPrevPage, 1);
                }
                m_Down = false;
                break;
            }
            default:
                return false;
        }
        return true;
    }

    @Override
    public boolean onTrackballEvent(MotionEvent event) {
        float curX, curY;
        switch (event.getAction()) {
            case MotionEvent.ACTION_DOWN: {
                m_x = m_dx = event.getX();
                m_y = m_dy = event.getY();
                m_Down = true;
                break;
            }
            case MotionEvent.ACTION_MOVE: {
                curX = event.getX();
                curY = event.getY();
                if (m_Down) m_PDFView.scrollBy((int) (m_x - curX), (int) (m_y - curY));
                m_x = curX;
                m_y = curY;
                break;
            }
            case MotionEvent.ACTION_UP: {
                curX = event.getX();
                curY = event.getY();
                if (m_Down) {
                    if (m_dx - curX > 30f)
                        m_PDFView.RenderPage(PDFView.TPageAction.paNextPage, 1);
                    else if (m_dx - curX < -30f)
                        m_PDFView.RenderPage(PDFView.TPageAction.paPrevPage, 1);
                }
                m_Down = false;
                break;
            }
            default:
                return false;
        }
        return true;
    }

    private class MyButtonHandler implements android.view.View.OnClickListener {
        Button m_First;
        Button m_Last;
        Button m_Next;
        Button m_Prev;
        TextView m_Text;
        PDFView m_PDFView;

        public MyButtonHandler(PDFView PDFInst) {
            m_PDFView = PDFInst;
        }

        public void onClick(View view) {
            if (view == m_First)
                m_PDFView.RenderPage(PDFView.TPageAction.paFirstPage, 1);
            else if (view == m_Next)
                m_PDFView.RenderPage(PDFView.TPageAction.paNextPage, 1);
            else if (view == m_Prev)
                m_PDFView.RenderPage(PDFView.TPageAction.paPrevPage, 1);
            else if (view == m_Last)
                m_PDFView.RenderPage(PDFView.TPageAction.paLastPage, 1);
        }
    }
}