/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.dynawrapper;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.os.Environment;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import io.scanbot.dynawrapper.AnnotationIcon;
import io.scanbot.dynawrapper.DynaPDF;
import io.scanbot.dynawrapper.PDFView;
import io.scanbot.dynawrapper.PageBoundary;
import java.io.File;

public class PDFViewActivity
extends Activity {
    boolean m_Down;
    PDFView m_PDFView;
    float m_dx;
    float m_dy;
    float m_x;
    float m_y;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            this.copyTextFromPdf();
            this.requestWindowFeature(1);
            this.m_PDFView = new PDFView((Context)this);
            this.getApplicationContext().getFilesDir().mkdirs();
            File f = new File(this.getExternalFilesDir("pdf"), "res.pdf");
            Log.d((String)PDFViewActivity.class.getSimpleName(), (String)(f.getAbsolutePath() + "" + f.exists()));
            this.m_PDFView.OpenFile(f.getAbsolutePath(), 0, "");
            MyButtonHandler bh = new MyButtonHandler(this.m_PDFView);
            LinearLayout bar = new LinearLayout((Context)this);
            bar.setOrientation(0);
            bar.setHorizontalGravity(1);
            bh.m_First = new Button((Context)this);
            bh.m_First.setText((CharSequence)"<<");
            bh.m_First.setOnClickListener((View.OnClickListener)bh);
            bar.addView((View)bh.m_First);
            bh.m_Prev = new Button((Context)this);
            bh.m_Prev.setText((CharSequence)" < ");
            bh.m_Prev.setOnClickListener((View.OnClickListener)bh);
            bar.addView((View)bh.m_Prev);
            bh.m_Text = new TextView((Context)this);
            bh.m_Text.setText((CharSequence)("1/" + this.m_PDFView.GetPageCount()));
            bar.addView((View)bh.m_Text);
            this.m_PDFView.SetTextView(bh.m_Text);
            bh.m_Next = new Button((Context)this);
            bh.m_Next.setText((CharSequence)" > ");
            bh.m_Next.setOnClickListener((View.OnClickListener)bh);
            bar.addView((View)bh.m_Next);
            bh.m_Last = new Button((Context)this);
            bh.m_Last.setText((CharSequence)">>");
            bh.m_Last.setOnClickListener((View.OnClickListener)bh);
            bar.addView((View)bh.m_Last);
            RelativeLayout layout = new RelativeLayout((Context)this);
            layout.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
            layout.setGravity(119);
            RelativeLayout.LayoutParams barParams = new RelativeLayout.LayoutParams(-1, -2);
            barParams.addRule(12);
            bar.setId(100);
            layout.addView((View)bar, (ViewGroup.LayoutParams)barParams);
            RelativeLayout.LayoutParams pixmapParams = new RelativeLayout.LayoutParams(-1, -1);
            pixmapParams.addRule(2, 100);
            layout.addView((View)this.m_PDFView, (ViewGroup.LayoutParams)pixmapParams);
            this.setContentView((View)layout);
        }
        catch (Exception e) {
            System.out.print("Instantion failed: " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private void copyTextFromPdf() throws Exception {
        File dir = this.getExternalFilesDir("pdf");
        File in = new File(dir, "in.pdf");
        File out = new File(dir, "out.pdf");
        File res = new File(dir, "res.pdf");
        DynaPDF inPdf = new DynaPDF();
        inPdf.openFile(in.getPath(), 0, "");
        inPdf.importPDF(1, 1.0, 1.0);
        inPdf.closeImportedFile();
        DynaPDF outPdf = new DynaPDF();
        outPdf.openFile(out.getPath(), 0, "");
        outPdf.importPDF(1, 1.0, 1.0);
        outPdf.closeImportedFile();
        outPdf.openOutputFile(res.getPath());
        DynaPDF.copyText(inPdf, outPdf, "/sdcard/Android/data/io.scanbot.dynawrapper/files/pdf", "Roboto");
        inPdf.closeFile();
        outPdf.closeFile();
        inPdf.onDestroy();
        outPdf.onDestroy();
    }

    private void writePdf() throws Exception {
        File dir = this.getExternalFilesDir("pdf");
        File pdfFile = new File(dir, "generated.pdf");
        File pdfFile2 = new File(dir, "generated2.pdf");
        File imageFile = new File(Environment.getExternalStorageDirectory(), "ic_launcher.png");
        pdfFile.delete();
        Bitmap bmp = BitmapFactory.decodeFile((String)imageFile.getPath());
        DynaPDF pdf = new DynaPDF();
        pdf.createNewPdf(pdfFile.getAbsolutePath());
        pdf.appendPage();
        pdf.setBoundingBox(PageBoundary.MEDIA_BOX, 0.0, 0.0, bmp.getWidth(), bmp.getHeight());
        pdf.saveGraphicsState();
        pdf.applyMatrix(2.0, 0.0, 0.0, 2.0, 0.0, 0.0);
        pdf.insertImage(0.0, 0.0, bmp.getWidth(), bmp.getHeight(), imageFile.getPath());
        pdf.restoreGraphicsState();
        pdf.endPage();
        pdf.appendPage();
        pdf.setBoundingBox(PageBoundary.MEDIA_BOX, 0.0, 0.0, bmp.getWidth(), bmp.getHeight());
        pdf.insertImage(0.0, 0.0, bmp.getWidth(), bmp.getHeight(), imageFile.getPath());
        pdf.endPage();
        pdf.closeFile();
        pdf.openFile(pdfFile.getPath(), 0, "");
        pdf.importPDF(1, 1.0, 1.0);
        pdf.closeImportedFile();
        pdf.editPage(2);
        pdf.createTextAnnotation(0.0, 0.0, 100.0, 100.0, null, "text", AnnotationIcon.COMMENT, false);
        pdf.endPage();
        pdf.appendPage();
        pdf.endPage();
        pdf.openOutputFile(pdfFile2.getPath());
        pdf.closeFile();
        pdf.onDestroy();
    }

    public void onDestroy() {
        if (this.m_PDFView != null) {
            this.m_PDFView.onDestroy();
        }
        this.m_PDFView = null;
        super.onDestroy();
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.m_x = this.m_dx = event.getX();
                this.m_y = this.m_dy = event.getY();
                this.m_Down = true;
                break;
            }
            case 2: {
                float curX = event.getX();
                float curY = event.getY();
                if (this.m_Down) {
                    this.m_PDFView.scrollBy((int)(this.m_x - curX), (int)(this.m_y - curY));
                }
                this.m_x = curX;
                this.m_y = curY;
                break;
            }
            case 1: {
                float curX = event.getX();
                float curY = event.getY();
                if (this.m_Down) {
                    if (this.m_dx - curX > 30.0f) {
                        this.m_PDFView.RenderPage(PDFView.TPageAction.paNextPage, 1);
                    } else if (this.m_dx - curX < -30.0f) {
                        this.m_PDFView.RenderPage(PDFView.TPageAction.paPrevPage, 1);
                    }
                }
                this.m_Down = false;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean onTrackballEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.m_x = this.m_dx = event.getX();
                this.m_y = this.m_dy = event.getY();
                this.m_Down = true;
                break;
            }
            case 2: {
                float curX = event.getX();
                float curY = event.getY();
                if (this.m_Down) {
                    this.m_PDFView.scrollBy((int)(this.m_x - curX), (int)(this.m_y - curY));
                }
                this.m_x = curX;
                this.m_y = curY;
                break;
            }
            case 1: {
                float curX = event.getX();
                float curY = event.getY();
                if (this.m_Down) {
                    if (this.m_dx - curX > 30.0f) {
                        this.m_PDFView.RenderPage(PDFView.TPageAction.paNextPage, 1);
                    } else if (this.m_dx - curX < -30.0f) {
                        this.m_PDFView.RenderPage(PDFView.TPageAction.paPrevPage, 1);
                    }
                }
                this.m_Down = false;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private class MyButtonHandler
    implements View.OnClickListener {
        Button m_First;
        Button m_Last;
        Button m_Next;
        Button m_Prev;
        TextView m_Text;
        PDFView m_PDFView;

        public MyButtonHandler(PDFView PDFInst) {
            this.m_PDFView = PDFInst;
        }

        public void onClick(View view) {
            if (view == this.m_First) {
                this.m_PDFView.RenderPage(PDFView.TPageAction.paFirstPage, 1);
            } else if (view == this.m_Next) {
                this.m_PDFView.RenderPage(PDFView.TPageAction.paNextPage, 1);
            } else if (view == this.m_Prev) {
                this.m_PDFView.RenderPage(PDFView.TPageAction.paPrevPage, 1);
            } else if (view == this.m_Last) {
                this.m_PDFView.RenderPage(PDFView.TPageAction.paLastPage, 1);
            }
        }
    }
}

