package io.scanbot.tools.utils.kotlin

/** A shortcut for `myCollection.takeIf { it.isNotEmpty() }?.let { doStuff(it) }`.
 *
 * @return  `this` (after [block] was applied) to chain calls, or `null` if collection was empty.
 *          The result of [block] is not returned.
 */
fun <T> Collection<T>.takeIfNotEmpty(block: (Collection<T>) -> Unit): Collection<T>? {
   return takeIf { it.isNotEmpty() }?.also { block(it) }
}
