package io.scanbot.tools.utils.kotlin

import kotlin.reflect.KClass

@Deprecated("Use `KClass<*>.lT` instead", level = DeprecationLevel.ERROR)
val KClass<*>.logTag: String
   get() = java.simpleName.take(23) // LogCat's TAG is 23 symbols maximum

/** Sometimes you want to log class name without hardcoding it (e.g. for in case of renaming or whatnot),
 * but writing `this::class.simpleName` is too verbose (yet alone `MyNotEvenVeryLongClassName::class.simpleName`).
 * This one is shorter 😉 */
val KClass<*>.sN: String? get() = simpleName

/** An alias for [KClass.sN] to use with your object straight away. A sweeter, more concentrated sugar for your Kotlin code . */
val Any?.sN: String? get() = this?.let { it::class.sN }

/** Similar to [KClass.sN], but limited to 22 characters (as Android's Log tag limit is 23, and one is used by logger internally).
 * If the class is anonymous (thus has no simple name), a placeholder string is returned. */
val KClass<*>.lT: String get() = sN?.take(23) ?: "anonymous-class-logTag"

/** An alias for [KClass.lT] to use with your object straight away. If the object is `null`, a placeholder string is returned. */
val Any?.lT: String get() = this?.let { it::class.lT } ?: "null-object-logTag"
