package io.scanbot.tools.mediafpsplayer

import io.scanbot.sdk.image.ImageRef

data class VideoFrame(
    val frameImage: ImageRef,
    val imageOrientation: Int,
    val frameIndex: Int,
    val frameTimestamp: Long,
) {
    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as VideoFrame

        if (frameImage.uniqueId != other.frameImage.uniqueId) return false
        if (imageOrientation != other.imageOrientation) return false

        return true
    }

    override fun hashCode(): Int {
        var result = frameImage.uniqueId.hashCode()
        result = 31 * result + imageOrientation
        return result
    }
}
