package io.scanbot.tools.mediafpsplayer

interface VideoProcessor : AutoCloseable {

    /** Returns next frame of the given video.
     *
     * @throws FrameExtractionException in case of extraction failure (`null` was extracted or a crash has occurred).
     * @throws IllegalStateException if last frame was already extracted (video ended). Check [hasMoreFrames] prior to calling.
     */
    fun nextFrame(): VideoFrame

    val hasMoreFrames: Boolean
}
