/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.tools.mediafpsplayer;

import android.graphics.Bitmap;
import android.media.MediaMetadataRetriever;
import io.scanbot.sdk.image.ImageRef;
import io.scanbot.tools.mediafpsplayer.FrameExtractionException;
import io.scanbot.tools.mediafpsplayer.FrameExtractorListener;
import io.scanbot.tools.mediafpsplayer.VideoFrame;
import io.scanbot.tools.mediafpsplayer.VideoProcessor;
import io.scanbot.tools.mediafpsplayer.VideoProcessorV2;
import java.io.File;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.TimeoutKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 $2\u00020\u0001:\u0001$BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u000e\u0010\u001e\u001a\u00020\u001dH\u0082@\u00a2\u0006\u0002\u0010\u001fJ\u000e\u0010 \u001a\u00020\u001dH\u0082@\u00a2\u0006\u0002\u0010\u001fJ\b\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\"H\u0016R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006%"}, d2={"Lio/scanbot/tools/mediafpsplayer/VideoProcessorV2;", "Lio/scanbot/tools/mediafpsplayer/VideoProcessor;", "input", "Ljava/io/File;", "fps", "", "frameExtractionOption", "extractorListener", "Lio/scanbot/tools/mediafpsplayer/FrameExtractorListener;", "extractionTimeoutMs", "", "extractionFailureMaxRetry", "<init>", "(Ljava/io/File;IILio/scanbot/tools/mediafpsplayer/FrameExtractorListener;JI)V", "fpsPlayer", "Landroid/media/MediaMetadataRetriever;", "videoDuration", "oneFrameTimeStep", "totalFrames", "videoOrientation", "lastFrameIndex", "lastFrameTimestamp", "currentFrameIsBad", "", "frameExtractFailureCount", "hasMoreFrames", "getHasMoreFrames", "()Z", "nextFrame", "Lio/scanbot/tools/mediafpsplayer/VideoFrame;", "extractFrameErrorsWrapped", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "extractFrame", "moveToNextFramePosition", "", "close", "Companion", "media-fps-player_release"})
public final class VideoProcessorV2
implements VideoProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int frameExtractionOption;
    @Nullable
    private final FrameExtractorListener extractorListener;
    private final long extractionTimeoutMs;
    private final int extractionFailureMaxRetry;
    @NotNull
    private final MediaMetadataRetriever fpsPlayer;
    private long videoDuration;
    private final long oneFrameTimeStep;
    private final int totalFrames;
    private final int videoOrientation;
    private int lastFrameIndex;
    private long lastFrameTimestamp;
    private boolean currentFrameIsBad;
    private int frameExtractFailureCount;
    public static final long EXTRACTION_TIMEOUT_MS = 3000L;
    public static final int EXTRACTION_FAILURE_MAX_RETRY_DEFAULT = 2;

    public VideoProcessorV2(@NotNull File input, int fps, int frameExtractionOption, @Nullable FrameExtractorListener extractorListener, long extractionTimeoutMs, int extractionFailureMaxRetry) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            this.frameExtractionOption = frameExtractionOption;
            this.extractorListener = extractorListener;
            this.extractionTimeoutMs = extractionTimeoutMs;
            this.extractionFailureMaxRetry = extractionFailureMaxRetry;
            this.fpsPlayer = new MediaMetadataRetriever();
            this.oneFrameTimeStep = (long)(1000.0 / (double)fps);
            this.fpsPlayer.setDataSource(input.getPath());
            String string = this.fpsPlayer.extractMetadata(9);
            if (string == null) {
                throw new IllegalStateException("Could not retrieve video duration");
            }
            this.videoDuration = Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((long)Long.parseLong(string), (DurationUnit)DurationUnit.MILLISECONDS));
            this.totalFrames = (int)(this.videoDuration / this.oneFrameTimeStep) + 1;
            String string2 = this.fpsPlayer.extractMetadata(24);
            this.videoOrientation = string2 != null ? Integer.parseInt(string2) : 0;
            FrameExtractorListener frameExtractorListener = this.extractorListener;
            if (frameExtractorListener == null) break block1;
            String string3 = input.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAbsolutePath(...)");
            frameExtractorListener.onFrameExtractorInit(string3, this.videoDuration, this.oneFrameTimeStep, this.totalFrames, this.videoOrientation);
        }
    }

    public /* synthetic */ VideoProcessorV2(File file, int n, int n2, FrameExtractorListener frameExtractorListener, long l, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 4) != 0) {
            n2 = 1;
        }
        if ((n4 & 8) != 0) {
            frameExtractorListener = null;
        }
        if ((n4 & 0x10) != 0) {
            l = 3000L;
        }
        if ((n4 & 0x20) != 0) {
            n3 = 2;
        }
        this(file, n, n2, frameExtractorListener, l, n3);
    }

    @Override
    public boolean getHasMoreFrames() {
        boolean moreFrames;
        boolean bl = moreFrames = this.lastFrameIndex < this.totalFrames;
        if (!moreFrames && this.extractorListener != null) {
            this.extractorListener.onNoMoreFrames("No more frames to extract: video ended (lastFrameTimestamp=" + this.lastFrameTimestamp + ", totalDuration=" + this.videoDuration + ", lastFrameIndex=" + this.lastFrameIndex + ", totalFrames=" + this.totalFrames + ").");
        }
        return moreFrames;
    }

    @Override
    @NotNull
    public VideoFrame nextFrame() {
        if (!this.getHasMoreFrames()) {
            throw new IllegalStateException("Video is ended. Check if more frames are available before calling for the next frame!");
        }
        return (VideoFrame)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super VideoFrame>, Object>(this, null){
            int label;
            final /* synthetic */ VideoProcessorV2 this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = VideoProcessorV2.access$extractFrameErrorsWrapped(this.this$0, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super VideoFrame> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    /*
     * Unable to fully structure code
     */
    private final Object extractFrameErrorsWrapped(Continuation<? super VideoFrame> $completion) {
        if (!($completion instanceof extractFrameErrorsWrapped.1)) ** GOTO lbl-1000
        var5_2 = $completion;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ VideoProcessorV2 this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return VideoProcessorV2.access$extractFrameErrorsWrapped(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
lbl12:
                // 3 sources

                while (this.frameExtractFailureCount < this.extractionFailureMaxRetry) {
                    $continuation.L$0 = this;
                    $continuation.label = 1;
                    v0 = this.extractFrame((Continuation<? super VideoFrame>)$continuation);
                    ** if (v0 != var6_4) goto lbl20
lbl19:
                    // 1 sources

                    return var6_4;
lbl20:
                    // 1 sources

                    ** GOTO lbl28
                }
                break;
            }
            case 1: {
                this = (VideoProcessorV2)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl28:
                    // 2 sources

                    return v0;
                }
                catch (Exception var2_5) {
                    if (this.currentFrameIsBad) ** GOTO lbl33
                    this.currentFrameIsBad = true;
                    ** GOTO lbl12
lbl33:
                    // 1 sources

                    var3_7 = this.frameExtractFailureCount;
                    this.frameExtractFailureCount = var3_7 + 1;
                    this.moveToNextFramePosition();
                    this.currentFrameIsBad = false;
                    ** GOTO lbl12
                }
            }
        }
        message = "No more frames to extract: too many errors (errors " + this.frameExtractFailureCount + "/" + this.extractionFailureMaxRetry + ", lastFrameTimestamp=" + this.lastFrameTimestamp + ", totalDuration=" + this.videoDuration + ", lastFrameIndex=" + this.lastFrameIndex + ", estimated totalFrames=" + this.totalFrames + ").";
        v1 = this.extractorListener;
        if (v1 != null) {
            v1.onNoMoreFrames(message);
        }
        throw new FrameExtractionException(message, null, 2, null);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object extractFrame(Continuation<? super VideoFrame> $completion) {
        if (!($completion instanceof extractFrame.1)) ** GOTO lbl-1000
        var6_2 = $completion;
        if ((var6_2.label & -2147483648) != 0) {
            var6_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ VideoProcessorV2 this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return VideoProcessorV2.access$extractFrame(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = TimeoutKt.withTimeoutOrNull((long)this.extractionTimeoutMs, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ImageRef>, Object>(this, null){
                    int label;
                    final /* synthetic */ VideoProcessorV2 this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * WARNING - void declaration
                     */
                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                Bitmap bitmap;
                                ImageRef imageRef2;
                                ResultKt.throwOnFailure((Object)object);
                                FrameExtractorListener frameExtractorListener = VideoProcessorV2.access$getExtractorListener$p(this.this$0);
                                if (frameExtractorListener != null) {
                                    frameExtractorListener.onFrameExtractionStart(VideoProcessorV2.access$getLastFrameIndex$p(this.this$0), VideoProcessorV2.access$getTotalFrames$p(this.this$0));
                                }
                                Bitmap bmp = null;
                                try {
                                    bmp = VideoProcessorV2.access$getFpsPlayer$p(this.this$0).getFrameAtTime(VideoProcessorV2.access$getLastFrameTimestamp$p(this.this$0) * (long)1000, VideoProcessorV2.access$getFrameExtractionOption$p(this.this$0));
                                    imageRef2 = bmp != null ? ImageRef.CREATOR.fromBitmap$default((ImageRef.CREATOR)ImageRef.CREATOR, (Bitmap)bmp, null, (int)2, null) : null;
                                    bitmap = bmp;
                                }
                                catch (Exception e) {
                                    try {
                                        FrameExtractorListener frameExtractorListener2 = VideoProcessorV2.access$getExtractorListener$p(this.this$0);
                                        if (frameExtractorListener2 != null) {
                                            frameExtractorListener2.onFrameExtractionException("Frame extraction failed at " + VideoProcessorV2.access$getLastFrameTimestamp$p(this.this$0) + "ms with some cause.", e);
                                        }
                                        throw new FrameExtractionException("Frame extraction failed!", e);
                                    }
                                    catch (Throwable throwable) {
                                        void var2_2;
                                        void v3 = var2_2;
                                        if (v3 != null) {
                                            v3.recycle();
                                        }
                                        throw throwable;
                                    }
                                }
                                if (bitmap != null) {
                                    bitmap.recycle();
                                }
                                return imageRef2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super ImageRef> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var7_4) {
                    return var7_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                this = (VideoProcessorV2)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                if ((imageRef = (ImageRef)v0) == null) {
                    message = "Frame extraction failed at " + this.lastFrameTimestamp + "ms: got null or timeout.";
                    v1 = this.extractorListener;
                    if (v1 != null) {
                        FrameExtractorListener.DefaultImpls.onFrameExtractionException$default(v1, message, null, 2, null);
                    }
                    throw new FrameExtractionException(message, null, 2, null);
                }
                v2 = this.extractorListener;
                if (v2 != null) {
                    v2.onFrameExtractedDebug(imageRef);
                }
                v3 = this.extractorListener;
                if (v3 != null) {
                    v3.onFrameExtractionEnd(this.lastFrameIndex, this.totalFrames);
                }
                var3_7 = new VideoFrame(imageRef, this.videoOrientation, this.lastFrameIndex, this.lastFrameTimestamp);
                $i$a$-apply-VideoProcessorV2$extractFrame$2 = false;
                this.moveToNextFramePosition();
                return var3_7;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void moveToNextFramePosition() {
        int n = this.lastFrameIndex;
        this.lastFrameIndex = n + 1;
        this.lastFrameTimestamp += this.oneFrameTimeStep;
    }

    @Override
    public void close() {
        this.fpsPlayer.release();
    }

    public static final /* synthetic */ Object access$extractFrameErrorsWrapped(VideoProcessorV2 $this, Continuation $completion) {
        return $this.extractFrameErrorsWrapped((Continuation<? super VideoFrame>)$completion);
    }

    public static final /* synthetic */ Object access$extractFrame(VideoProcessorV2 $this, Continuation $completion) {
        return $this.extractFrame((Continuation<? super VideoFrame>)$completion);
    }

    public static final /* synthetic */ FrameExtractorListener access$getExtractorListener$p(VideoProcessorV2 $this) {
        return $this.extractorListener;
    }

    public static final /* synthetic */ int access$getLastFrameIndex$p(VideoProcessorV2 $this) {
        return $this.lastFrameIndex;
    }

    public static final /* synthetic */ int access$getTotalFrames$p(VideoProcessorV2 $this) {
        return $this.totalFrames;
    }

    public static final /* synthetic */ MediaMetadataRetriever access$getFpsPlayer$p(VideoProcessorV2 $this) {
        return $this.fpsPlayer;
    }

    public static final /* synthetic */ long access$getLastFrameTimestamp$p(VideoProcessorV2 $this) {
        return $this.lastFrameTimestamp;
    }

    public static final /* synthetic */ int access$getFrameExtractionOption$p(VideoProcessorV2 $this) {
        return $this.frameExtractionOption;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/scanbot/tools/mediafpsplayer/VideoProcessorV2$Companion;", "", "<init>", "()V", "EXTRACTION_TIMEOUT_MS", "", "EXTRACTION_FAILURE_MAX_RETRY_DEFAULT", "", "media-fps-player_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

