/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui_v2.barcode.di.components;

import android.content.Context;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.MapBuilder;
import dagger.internal.Preconditions;
import io.scanbot.sdk.barcode.ScanbotBarcodeDetector;
import io.scanbot.sdk.ui_v2.barcode.common.MultipleScanningUseCaseViewModel;
import io.scanbot.sdk.ui_v2.barcode.common.SingleScanningUseCaseViewModel;
import io.scanbot.sdk.ui_v2.barcode.configuration.BarcodeScannerConfiguration;
import io.scanbot.sdk.ui_v2.barcode.di.components.BarcodeCameraComponent;
import io.scanbot.sdk.ui_v2.barcode.di.components.BarcodeSDKUIComponent;
import io.scanbot.sdk.ui_v2.barcode.di.modules.BarcodeModule;
import io.scanbot.sdk.ui_v2.barcode.di.modules.BarcodeModule_ProvideBarcodeScannerConfiguration$rtu_ui_v2_barcode_standalone_releaseFactory;
import io.scanbot.sdk.ui_v2.barcode.di.modules.BarcodeModule_ProvideMultipleScanningUseCaseViewModelFactory;
import io.scanbot.sdk.ui_v2.barcode.di.modules.BarcodeModule_ProvideSingleScanningUseCaseViewModelFactory;
import io.scanbot.sdk.ui_v2.barcode.di.modules.DispatchersModule;
import io.scanbot.sdk.ui_v2.barcode.di.modules.DispatchersModule_ProvideBarcodeCameraViewModelFactory;
import io.scanbot.sdk.ui_v2.barcode.di.modules.ViewModelFactoryModule;
import io.scanbot.sdk.ui_v2.barcode.di.modules.ViewModelFactoryModule_BindViewModelFactoryFactory;
import io.scanbot.sdk.ui_v2.common.coroutines.IDispatchersProvider;
import io.scanbot.sdk.ui_v2.common.viewmodel.ScreenInjector;
import io.scanbot.sdk.ui_v2.common.viewmodel.ScreenInjector_MembersInjector;
import java.util.Map;
import javax.inject.Provider;

@DaggerGenerated
public final class DaggerBarcodeCameraComponent {
    private DaggerBarcodeCameraComponent() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private static final class BarcodeCameraComponentImpl
    implements BarcodeCameraComponent {
        private final ViewModelFactoryModule viewModelFactoryModule;
        private final BarcodeCameraComponentImpl barcodeCameraComponentImpl = this;
        private Provider<BarcodeScannerConfiguration> provideBarcodeScannerConfiguration$rtu_ui_v2_barcode_standalone_releaseProvider;
        private Provider<ScanbotBarcodeDetector> barcodeDetectorProvider;
        private Provider<IDispatchersProvider> provideBarcodeCameraViewModelProvider;
        private Provider<Context> provideContextProvider;
        private Provider<ViewModel> provideSingleScanningUseCaseViewModelProvider;
        private Provider<ViewModel> provideMultipleScanningUseCaseViewModelProvider;

        private BarcodeCameraComponentImpl(BarcodeModule barcodeModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam, DispatchersModule dispatchersModuleParam, BarcodeSDKUIComponent barcodeSDKUIComponentParam) {
            this.viewModelFactoryModule = viewModelFactoryModuleParam;
            this.initialize(barcodeModuleParam, viewModelFactoryModuleParam, dispatchersModuleParam, barcodeSDKUIComponentParam);
        }

        private Map<Class<? extends ViewModel>, Provider<ViewModel>> mapOfClassOfAndProviderOfViewModel() {
            return MapBuilder.newMapBuilder((int)2).put(SingleScanningUseCaseViewModel.class, this.provideSingleScanningUseCaseViewModelProvider).put(MultipleScanningUseCaseViewModel.class, this.provideMultipleScanningUseCaseViewModelProvider).build();
        }

        private ViewModelProvider.Factory viewModelProviderFactory() {
            return ViewModelFactoryModule_BindViewModelFactoryFactory.bindViewModelFactory(this.viewModelFactoryModule, this.mapOfClassOfAndProviderOfViewModel());
        }

        private void initialize(BarcodeModule barcodeModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam, DispatchersModule dispatchersModuleParam, BarcodeSDKUIComponent barcodeSDKUIComponentParam) {
            this.provideBarcodeScannerConfiguration$rtu_ui_v2_barcode_standalone_releaseProvider = DoubleCheck.provider((Provider)BarcodeModule_ProvideBarcodeScannerConfiguration$rtu_ui_v2_barcode_standalone_releaseFactory.create(barcodeModuleParam));
            this.barcodeDetectorProvider = new BarcodeDetectorProvider(barcodeSDKUIComponentParam);
            this.provideBarcodeCameraViewModelProvider = DispatchersModule_ProvideBarcodeCameraViewModelFactory.create(dispatchersModuleParam);
            this.provideContextProvider = new ProvideContextProvider(barcodeSDKUIComponentParam);
            this.provideSingleScanningUseCaseViewModelProvider = DoubleCheck.provider((Provider)BarcodeModule_ProvideSingleScanningUseCaseViewModelFactory.create(barcodeModuleParam, this.provideBarcodeScannerConfiguration$rtu_ui_v2_barcode_standalone_releaseProvider, this.barcodeDetectorProvider, this.provideBarcodeCameraViewModelProvider, this.provideContextProvider));
            this.provideMultipleScanningUseCaseViewModelProvider = DoubleCheck.provider((Provider)BarcodeModule_ProvideMultipleScanningUseCaseViewModelFactory.create(barcodeModuleParam, this.provideBarcodeScannerConfiguration$rtu_ui_v2_barcode_standalone_releaseProvider, this.barcodeDetectorProvider, this.provideBarcodeCameraViewModelProvider, this.provideContextProvider));
        }

        @Override
        public void inject(ScreenInjector component) {
            this.injectScreenInjector(component);
        }

        private ScreenInjector injectScreenInjector(ScreenInjector instance) {
            ScreenInjector_MembersInjector.injectFactory((ScreenInjector)instance, (ViewModelProvider.Factory)this.viewModelProviderFactory());
            return instance;
        }

        private static final class ProvideContextProvider
        implements Provider<Context> {
            private final BarcodeSDKUIComponent barcodeSDKUIComponent;

            ProvideContextProvider(BarcodeSDKUIComponent barcodeSDKUIComponent) {
                this.barcodeSDKUIComponent = barcodeSDKUIComponent;
            }

            public Context get() {
                return (Context)Preconditions.checkNotNullFromComponent((Object)this.barcodeSDKUIComponent.provideContext());
            }
        }

        private static final class BarcodeDetectorProvider
        implements Provider<ScanbotBarcodeDetector> {
            private final BarcodeSDKUIComponent barcodeSDKUIComponent;

            BarcodeDetectorProvider(BarcodeSDKUIComponent barcodeSDKUIComponent) {
                this.barcodeSDKUIComponent = barcodeSDKUIComponent;
            }

            public ScanbotBarcodeDetector get() {
                return (ScanbotBarcodeDetector)Preconditions.checkNotNullFromComponent((Object)this.barcodeSDKUIComponent.barcodeDetector());
            }
        }
    }

    public static final class Builder {
        private BarcodeModule barcodeModule;
        private ViewModelFactoryModule viewModelFactoryModule;
        private DispatchersModule dispatchersModule;
        private BarcodeSDKUIComponent barcodeSDKUIComponent;

        private Builder() {
        }

        public Builder barcodeModule(BarcodeModule barcodeModule) {
            this.barcodeModule = (BarcodeModule)Preconditions.checkNotNull((Object)barcodeModule);
            return this;
        }

        public Builder viewModelFactoryModule(ViewModelFactoryModule viewModelFactoryModule) {
            this.viewModelFactoryModule = (ViewModelFactoryModule)Preconditions.checkNotNull((Object)viewModelFactoryModule);
            return this;
        }

        public Builder dispatchersModule(DispatchersModule dispatchersModule) {
            this.dispatchersModule = (DispatchersModule)Preconditions.checkNotNull((Object)dispatchersModule);
            return this;
        }

        public Builder barcodeSDKUIComponent(BarcodeSDKUIComponent barcodeSDKUIComponent) {
            this.barcodeSDKUIComponent = (BarcodeSDKUIComponent)Preconditions.checkNotNull((Object)barcodeSDKUIComponent);
            return this;
        }

        public BarcodeCameraComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.barcodeModule, BarcodeModule.class);
            if (this.viewModelFactoryModule == null) {
                this.viewModelFactoryModule = new ViewModelFactoryModule();
            }
            if (this.dispatchersModule == null) {
                this.dispatchersModule = new DispatchersModule();
            }
            Preconditions.checkBuilderRequirement((Object)this.barcodeSDKUIComponent, BarcodeSDKUIComponent.class);
            return new BarcodeCameraComponentImpl(this.barcodeModule, this.viewModelFactoryModule, this.dispatchersModule, this.barcodeSDKUIComponent);
        }
    }
}

