/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui_v2.di.components;

import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import coil.fetch.Fetcher;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import io.scanbot.sdk.docprocessing.DocumentApi;
import io.scanbot.sdk.persistence.document.DocumentStorage;
import io.scanbot.sdk.persistence.fileio.FileIOProcessor;
import io.scanbot.sdk.persistence.page.PageFileStorage;
import io.scanbot.sdk.ui_v2.common.coroutines.IDispatchersProvider;
import io.scanbot.sdk.ui_v2.common.utils.ScanbotImageFetcherFactoryInjector;
import io.scanbot.sdk.ui_v2.common.utils.ScanbotImageFetcherFactoryInjector_MembersInjector;
import io.scanbot.sdk.ui_v2.common.utils.ScanbotImageUri;
import io.scanbot.sdk.ui_v2.common.viewmodel.ViewModelInjector;
import io.scanbot.sdk.ui_v2.common.viewmodel.ViewModelInjector_MembersInjector;
import io.scanbot.sdk.ui_v2.di.components.CroppingBaseComponent;
import io.scanbot.sdk.ui_v2.di.components.SDKUIComponent;
import io.scanbot.sdk.ui_v2.di.modules.CroppingBaseModule;
import io.scanbot.sdk.ui_v2.di.modules.CroppingBaseModule_ProvideCroppingBaseViewModelFactory;
import io.scanbot.sdk.ui_v2.di.modules.CroppingBaseModule_ProvideCroppingConfiguration$rtu_ui_v2_bundle_releaseFactory;
import io.scanbot.sdk.ui_v2.di.modules.DispatchersModule;
import io.scanbot.sdk.ui_v2.di.modules.DispatchersModule_ProvideBarcodeCameraViewModelFactory;
import io.scanbot.sdk.ui_v2.di.modules.ImageFetcherFactoryModule;
import io.scanbot.sdk.ui_v2.di.modules.ImageFetcherFactoryModule_BindImageFetcherFactoryFactory;
import io.scanbot.sdk.ui_v2.di.modules.ViewModelFactoryModule;
import io.scanbot.sdk.ui_v2.di.modules.ViewModelFactoryModule_BindViewModelFactoryFactory;
import io.scanbot.sdk.ui_v2.document.configuration.CroppingConfiguration;
import io.scanbot.sdk.ui_v2.document.screen.CroppingHostViewModel;
import java.util.Collections;
import java.util.Map;

@DaggerGenerated
public final class DaggerCroppingBaseComponent {
    private DaggerCroppingBaseComponent() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private CroppingBaseModule croppingBaseModule;
        private ViewModelFactoryModule viewModelFactoryModule;
        private ImageFetcherFactoryModule imageFetcherFactoryModule;
        private DispatchersModule dispatchersModule;
        private SDKUIComponent sDKUIComponent;

        private Builder() {
        }

        public Builder croppingBaseModule(CroppingBaseModule croppingBaseModule) {
            this.croppingBaseModule = (CroppingBaseModule)Preconditions.checkNotNull((Object)croppingBaseModule);
            return this;
        }

        public Builder viewModelFactoryModule(ViewModelFactoryModule viewModelFactoryModule) {
            this.viewModelFactoryModule = (ViewModelFactoryModule)Preconditions.checkNotNull((Object)viewModelFactoryModule);
            return this;
        }

        public Builder imageFetcherFactoryModule(ImageFetcherFactoryModule imageFetcherFactoryModule) {
            this.imageFetcherFactoryModule = (ImageFetcherFactoryModule)Preconditions.checkNotNull((Object)imageFetcherFactoryModule);
            return this;
        }

        public Builder dispatchersModule(DispatchersModule dispatchersModule) {
            this.dispatchersModule = (DispatchersModule)Preconditions.checkNotNull((Object)dispatchersModule);
            return this;
        }

        public Builder sDKUIComponent(SDKUIComponent sDKUIComponent) {
            this.sDKUIComponent = (SDKUIComponent)Preconditions.checkNotNull((Object)sDKUIComponent);
            return this;
        }

        public CroppingBaseComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.croppingBaseModule, CroppingBaseModule.class);
            if (this.viewModelFactoryModule == null) {
                this.viewModelFactoryModule = new ViewModelFactoryModule();
            }
            if (this.imageFetcherFactoryModule == null) {
                this.imageFetcherFactoryModule = new ImageFetcherFactoryModule();
            }
            if (this.dispatchersModule == null) {
                this.dispatchersModule = new DispatchersModule();
            }
            Preconditions.checkBuilderRequirement((Object)this.sDKUIComponent, SDKUIComponent.class);
            return new CroppingBaseComponentImpl(this.croppingBaseModule, this.viewModelFactoryModule, this.imageFetcherFactoryModule, this.dispatchersModule, this.sDKUIComponent);
        }
    }

    private static final class CroppingBaseComponentImpl
    implements CroppingBaseComponent {
        private final ViewModelFactoryModule viewModelFactoryModule;
        private final ImageFetcherFactoryModule imageFetcherFactoryModule;
        private final SDKUIComponent sDKUIComponent;
        private final CroppingBaseComponentImpl croppingBaseComponentImpl = this;
        Provider<CroppingConfiguration> provideCroppingConfiguration$rtu_ui_v2_bundle_releaseProvider;
        Provider<IDispatchersProvider> provideBarcodeCameraViewModelProvider;
        Provider<DocumentStorage> documentStorageProvider;
        Provider<DocumentApi> documentApiProvider;
        Provider<PageFileStorage> pageFileStorageProvider;
        Provider<FileIOProcessor> fileIOProcessorProvider;
        Provider<ViewModel> provideCroppingBaseViewModelProvider;

        CroppingBaseComponentImpl(CroppingBaseModule croppingBaseModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam, ImageFetcherFactoryModule imageFetcherFactoryModuleParam, DispatchersModule dispatchersModuleParam, SDKUIComponent sDKUIComponentParam) {
            this.viewModelFactoryModule = viewModelFactoryModuleParam;
            this.imageFetcherFactoryModule = imageFetcherFactoryModuleParam;
            this.sDKUIComponent = sDKUIComponentParam;
            this.initialize(croppingBaseModuleParam, viewModelFactoryModuleParam, imageFetcherFactoryModuleParam, dispatchersModuleParam, sDKUIComponentParam);
        }

        Map<Class<? extends ViewModel>, javax.inject.Provider<ViewModel>> mapOfClassOfAndProviderOfViewModel() {
            return Collections.singletonMap(CroppingHostViewModel.class, this.provideCroppingBaseViewModelProvider);
        }

        ViewModelProvider.Factory viewModelProviderFactory() {
            return ViewModelFactoryModule_BindViewModelFactoryFactory.bindViewModelFactory(this.viewModelFactoryModule, this.mapOfClassOfAndProviderOfViewModel());
        }

        Fetcher.Factory<ScanbotImageUri> fetcherFactoryOfScanbotImageUri() {
            return ImageFetcherFactoryModule_BindImageFetcherFactoryFactory.bindImageFetcherFactory(this.imageFetcherFactoryModule, (FileIOProcessor)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.fileIOProcessor()));
        }

        private void initialize(CroppingBaseModule croppingBaseModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam, ImageFetcherFactoryModule imageFetcherFactoryModuleParam, DispatchersModule dispatchersModuleParam, SDKUIComponent sDKUIComponentParam) {
            this.provideCroppingConfiguration$rtu_ui_v2_bundle_releaseProvider = DoubleCheck.provider((Provider)CroppingBaseModule_ProvideCroppingConfiguration$rtu_ui_v2_bundle_releaseFactory.create(croppingBaseModuleParam));
            this.provideBarcodeCameraViewModelProvider = DispatchersModule_ProvideBarcodeCameraViewModelFactory.create(dispatchersModuleParam);
            this.documentStorageProvider = new DocumentStorageProvider(sDKUIComponentParam);
            this.documentApiProvider = new DocumentApiProvider(sDKUIComponentParam);
            this.pageFileStorageProvider = new PageFileStorageProvider(sDKUIComponentParam);
            this.fileIOProcessorProvider = new FileIOProcessorProvider(sDKUIComponentParam);
            this.provideCroppingBaseViewModelProvider = CroppingBaseModule_ProvideCroppingBaseViewModelFactory.create(croppingBaseModuleParam, this.provideCroppingConfiguration$rtu_ui_v2_bundle_releaseProvider, this.provideBarcodeCameraViewModelProvider, this.documentStorageProvider, this.documentApiProvider, this.pageFileStorageProvider, this.fileIOProcessorProvider);
        }

        @Override
        public void inject(ViewModelInjector component) {
            this.injectViewModelInjector(component);
        }

        @Override
        public void inject(ScanbotImageFetcherFactoryInjector scanbotImageFetcherFactoryInjector) {
            this.injectScanbotImageFetcherFactoryInjector(scanbotImageFetcherFactoryInjector);
        }

        private ViewModelInjector injectViewModelInjector(ViewModelInjector instance) {
            ViewModelInjector_MembersInjector.injectFactory((ViewModelInjector)instance, (ViewModelProvider.Factory)this.viewModelProviderFactory());
            return instance;
        }

        private ScanbotImageFetcherFactoryInjector injectScanbotImageFetcherFactoryInjector(ScanbotImageFetcherFactoryInjector instance2) {
            ScanbotImageFetcherFactoryInjector_MembersInjector.injectImageFetcherFactory((ScanbotImageFetcherFactoryInjector)instance2, this.fetcherFactoryOfScanbotImageUri());
            return instance2;
        }

        private static final class DocumentStorageProvider
        implements Provider<DocumentStorage> {
            private final SDKUIComponent sDKUIComponent;

            DocumentStorageProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public DocumentStorage get() {
                return (DocumentStorage)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.documentStorage());
            }
        }

        private static final class DocumentApiProvider
        implements Provider<DocumentApi> {
            private final SDKUIComponent sDKUIComponent;

            DocumentApiProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public DocumentApi get() {
                return (DocumentApi)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.documentApi());
            }
        }

        private static final class PageFileStorageProvider
        implements Provider<PageFileStorage> {
            private final SDKUIComponent sDKUIComponent;

            PageFileStorageProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public PageFileStorage get() {
                return (PageFileStorage)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.pageFileStorage());
            }
        }

        private static final class FileIOProcessorProvider
        implements Provider<FileIOProcessor> {
            private final SDKUIComponent sDKUIComponent;

            FileIOProcessorProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public FileIOProcessor get() {
                return (FileIOProcessor)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.fileIOProcessor());
            }
        }
    }
}

