/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui_v2.di.components;

import android.content.Context;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import io.scanbot.sdk.ui_v2.common.coroutines.IDispatchersProvider;
import io.scanbot.sdk.ui_v2.common.viewmodel.ViewModelInjector;
import io.scanbot.sdk.ui_v2.common.viewmodel.ViewModelInjector_MembersInjector;
import io.scanbot.sdk.ui_v2.di.components.SDKUIComponent;
import io.scanbot.sdk.ui_v2.di.components.VinCameraComponent;
import io.scanbot.sdk.ui_v2.di.modules.DispatchersModule;
import io.scanbot.sdk.ui_v2.di.modules.DispatchersModule_ProvideBarcodeCameraViewModelFactory;
import io.scanbot.sdk.ui_v2.di.modules.ViewModelFactoryModule;
import io.scanbot.sdk.ui_v2.di.modules.ViewModelFactoryModule_BindViewModelFactoryFactory;
import io.scanbot.sdk.ui_v2.di.modules.VinModule;
import io.scanbot.sdk.ui_v2.di.modules.VinModule_ProvideConfiguration$rtu_ui_v2_bundle_releaseFactory;
import io.scanbot.sdk.ui_v2.di.modules.VinModule_ProvideViewModelFactory;
import io.scanbot.sdk.ui_v2.vin.configuration.VinScannerScreenConfiguration;
import io.scanbot.sdk.ui_v2.vin.screen.BaseVinViewModel;
import io.scanbot.sdk.vin.VinScanner;
import java.util.Collections;
import java.util.Map;

@DaggerGenerated
public final class DaggerVinCameraComponent {
    private DaggerVinCameraComponent() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private VinModule vinModule;
        private ViewModelFactoryModule viewModelFactoryModule;
        private DispatchersModule dispatchersModule;
        private SDKUIComponent sDKUIComponent;

        private Builder() {
        }

        public Builder vinModule(VinModule vinModule) {
            this.vinModule = (VinModule)Preconditions.checkNotNull((Object)vinModule);
            return this;
        }

        public Builder viewModelFactoryModule(ViewModelFactoryModule viewModelFactoryModule) {
            this.viewModelFactoryModule = (ViewModelFactoryModule)Preconditions.checkNotNull((Object)viewModelFactoryModule);
            return this;
        }

        public Builder dispatchersModule(DispatchersModule dispatchersModule) {
            this.dispatchersModule = (DispatchersModule)Preconditions.checkNotNull((Object)dispatchersModule);
            return this;
        }

        public Builder sDKUIComponent(SDKUIComponent sDKUIComponent) {
            this.sDKUIComponent = (SDKUIComponent)Preconditions.checkNotNull((Object)sDKUIComponent);
            return this;
        }

        public VinCameraComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.vinModule, VinModule.class);
            if (this.viewModelFactoryModule == null) {
                this.viewModelFactoryModule = new ViewModelFactoryModule();
            }
            if (this.dispatchersModule == null) {
                this.dispatchersModule = new DispatchersModule();
            }
            Preconditions.checkBuilderRequirement((Object)this.sDKUIComponent, SDKUIComponent.class);
            return new VinCameraComponentImpl(this.vinModule, this.viewModelFactoryModule, this.dispatchersModule, this.sDKUIComponent);
        }
    }

    private static final class VinCameraComponentImpl
    implements VinCameraComponent {
        private final ViewModelFactoryModule viewModelFactoryModule;
        private final VinCameraComponentImpl vinCameraComponentImpl = this;
        Provider<VinScannerScreenConfiguration> provideConfiguration$rtu_ui_v2_bundle_releaseProvider;
        Provider<VinScanner> vinScannerProvider;
        Provider<IDispatchersProvider> provideBarcodeCameraViewModelProvider;
        Provider<Context> provideContextProvider;
        Provider<ViewModel> provideViewModelProvider;

        VinCameraComponentImpl(VinModule vinModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam, DispatchersModule dispatchersModuleParam, SDKUIComponent sDKUIComponentParam) {
            this.viewModelFactoryModule = viewModelFactoryModuleParam;
            this.initialize(vinModuleParam, viewModelFactoryModuleParam, dispatchersModuleParam, sDKUIComponentParam);
        }

        Map<Class<? extends ViewModel>, javax.inject.Provider<ViewModel>> mapOfClassOfAndProviderOfViewModel() {
            return Collections.singletonMap(BaseVinViewModel.class, this.provideViewModelProvider);
        }

        ViewModelProvider.Factory viewModelProviderFactory() {
            return ViewModelFactoryModule_BindViewModelFactoryFactory.bindViewModelFactory(this.viewModelFactoryModule, this.mapOfClassOfAndProviderOfViewModel());
        }

        private void initialize(VinModule vinModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam, DispatchersModule dispatchersModuleParam, SDKUIComponent sDKUIComponentParam) {
            this.provideConfiguration$rtu_ui_v2_bundle_releaseProvider = DoubleCheck.provider((Provider)VinModule_ProvideConfiguration$rtu_ui_v2_bundle_releaseFactory.create(vinModuleParam));
            this.vinScannerProvider = new VinScannerProvider(sDKUIComponentParam);
            this.provideBarcodeCameraViewModelProvider = DispatchersModule_ProvideBarcodeCameraViewModelFactory.create(dispatchersModuleParam);
            this.provideContextProvider = new ProvideContextProvider(sDKUIComponentParam);
            this.provideViewModelProvider = VinModule_ProvideViewModelFactory.create(vinModuleParam, this.provideConfiguration$rtu_ui_v2_bundle_releaseProvider, this.vinScannerProvider, this.provideBarcodeCameraViewModelProvider, this.provideContextProvider);
        }

        @Override
        public void inject(ViewModelInjector component) {
            this.injectViewModelInjector(component);
        }

        private ViewModelInjector injectViewModelInjector(ViewModelInjector instance) {
            ViewModelInjector_MembersInjector.injectFactory((ViewModelInjector)instance, (ViewModelProvider.Factory)this.viewModelProviderFactory());
            return instance;
        }

        private static final class VinScannerProvider
        implements Provider<VinScanner> {
            private final SDKUIComponent sDKUIComponent;

            VinScannerProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public VinScanner get() {
                return (VinScanner)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.vinScanner());
            }
        }

        private static final class ProvideContextProvider
        implements Provider<Context> {
            private final SDKUIComponent sDKUIComponent;

            ProvideContextProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public Context get() {
                return (Context)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.provideContext());
            }
        }
    }
}

