/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui_v2.di.components;

import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import io.scanbot.sdk.documentqualityanalyzer.IDocumentQualityAnalyzerFactory;
import io.scanbot.sdk.documentscanner.IDocumentScannerFactory;
import io.scanbot.sdk.ui_v2.common.coroutines.IDispatchersProvider;
import io.scanbot.sdk.ui_v2.common.viewmodel.ViewModelInjector;
import io.scanbot.sdk.ui_v2.common.viewmodel.ViewModelInjector_MembersInjector;
import io.scanbot.sdk.ui_v2.di.components.CroppingComponent;
import io.scanbot.sdk.ui_v2.di.components.SDKUIComponent;
import io.scanbot.sdk.ui_v2.di.modules.CroppingModule;
import io.scanbot.sdk.ui_v2.di.modules.CroppingModule_ProvideBaseViewModel$rtu_ui_v2_bundle_releaseFactory;
import io.scanbot.sdk.ui_v2.di.modules.CroppingModule_ProvideConfiguration$rtu_ui_v2_bundle_releaseFactory;
import io.scanbot.sdk.ui_v2.di.modules.CroppingModule_ProvideCroppingViewModelFactory;
import io.scanbot.sdk.ui_v2.di.modules.DispatchersModule;
import io.scanbot.sdk.ui_v2.di.modules.DispatchersModule_ProvideBarcodeCameraViewModelFactory;
import io.scanbot.sdk.ui_v2.di.modules.ViewModelFactoryModule;
import io.scanbot.sdk.ui_v2.di.modules.ViewModelFactoryModule_BindViewModelFactoryFactory;
import io.scanbot.sdk.ui_v2.document.configuration.CroppingConfiguration;
import io.scanbot.sdk.ui_v2.document.screen.CroppingHostViewModel;
import io.scanbot.sdk.ui_v2.document.screen.crop.CroppingViewModel;
import java.util.Collections;
import java.util.Map;

@DaggerGenerated
public final class DaggerCroppingComponent {
    private DaggerCroppingComponent() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private CroppingModule croppingModule;
        private ViewModelFactoryModule viewModelFactoryModule;
        private DispatchersModule dispatchersModule;
        private SDKUIComponent sDKUIComponent;

        private Builder() {
        }

        public Builder croppingModule(CroppingModule croppingModule) {
            this.croppingModule = (CroppingModule)Preconditions.checkNotNull((Object)croppingModule);
            return this;
        }

        public Builder viewModelFactoryModule(ViewModelFactoryModule viewModelFactoryModule) {
            this.viewModelFactoryModule = (ViewModelFactoryModule)Preconditions.checkNotNull((Object)viewModelFactoryModule);
            return this;
        }

        public Builder dispatchersModule(DispatchersModule dispatchersModule) {
            this.dispatchersModule = (DispatchersModule)Preconditions.checkNotNull((Object)dispatchersModule);
            return this;
        }

        public Builder sDKUIComponent(SDKUIComponent sDKUIComponent) {
            this.sDKUIComponent = (SDKUIComponent)Preconditions.checkNotNull((Object)sDKUIComponent);
            return this;
        }

        public CroppingComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.croppingModule, CroppingModule.class);
            if (this.viewModelFactoryModule == null) {
                this.viewModelFactoryModule = new ViewModelFactoryModule();
            }
            if (this.dispatchersModule == null) {
                this.dispatchersModule = new DispatchersModule();
            }
            Preconditions.checkBuilderRequirement((Object)this.sDKUIComponent, SDKUIComponent.class);
            return new CroppingComponentImpl(this.croppingModule, this.viewModelFactoryModule, this.dispatchersModule, this.sDKUIComponent);
        }
    }

    private static final class CroppingComponentImpl
    implements CroppingComponent {
        private final ViewModelFactoryModule viewModelFactoryModule;
        private final CroppingComponentImpl croppingComponentImpl = this;
        private Provider<CroppingHostViewModel> provideBaseViewModel$rtu_ui_v2_bundle_releaseProvider;
        private Provider<CroppingConfiguration> provideConfiguration$rtu_ui_v2_bundle_releaseProvider;
        private Provider<IDocumentScannerFactory> documentScannerFactoryProvider;
        private Provider<IDocumentQualityAnalyzerFactory> documentQualityAnalyzerFactoryProvider;
        private Provider<IDispatchersProvider> provideBarcodeCameraViewModelProvider;
        private Provider<ViewModel> provideCroppingViewModelProvider;

        private CroppingComponentImpl(CroppingModule croppingModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam, DispatchersModule dispatchersModuleParam, SDKUIComponent sDKUIComponentParam) {
            this.viewModelFactoryModule = viewModelFactoryModuleParam;
            this.initialize(croppingModuleParam, viewModelFactoryModuleParam, dispatchersModuleParam, sDKUIComponentParam);
        }

        private Map<Class<? extends ViewModel>, javax.inject.Provider<ViewModel>> mapOfClassOfAndProviderOfViewModel() {
            return Collections.singletonMap(CroppingViewModel.class, this.provideCroppingViewModelProvider);
        }

        private ViewModelProvider.Factory viewModelProviderFactory() {
            return ViewModelFactoryModule_BindViewModelFactoryFactory.bindViewModelFactory(this.viewModelFactoryModule, this.mapOfClassOfAndProviderOfViewModel());
        }

        private void initialize(CroppingModule croppingModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam, DispatchersModule dispatchersModuleParam, SDKUIComponent sDKUIComponentParam) {
            this.provideBaseViewModel$rtu_ui_v2_bundle_releaseProvider = DoubleCheck.provider((Provider)CroppingModule_ProvideBaseViewModel$rtu_ui_v2_bundle_releaseFactory.create(croppingModuleParam));
            this.provideConfiguration$rtu_ui_v2_bundle_releaseProvider = DoubleCheck.provider((Provider)CroppingModule_ProvideConfiguration$rtu_ui_v2_bundle_releaseFactory.create(croppingModuleParam));
            this.documentScannerFactoryProvider = new DocumentScannerFactoryProvider(sDKUIComponentParam);
            this.documentQualityAnalyzerFactoryProvider = new DocumentQualityAnalyzerFactoryProvider(sDKUIComponentParam);
            this.provideBarcodeCameraViewModelProvider = DispatchersModule_ProvideBarcodeCameraViewModelFactory.create(dispatchersModuleParam);
            this.provideCroppingViewModelProvider = CroppingModule_ProvideCroppingViewModelFactory.create(croppingModuleParam, this.provideBaseViewModel$rtu_ui_v2_bundle_releaseProvider, this.provideConfiguration$rtu_ui_v2_bundle_releaseProvider, this.documentScannerFactoryProvider, this.documentQualityAnalyzerFactoryProvider, this.provideBarcodeCameraViewModelProvider);
        }

        @Override
        public void inject(ViewModelInjector component) {
            this.injectViewModelInjector(component);
        }

        private ViewModelInjector injectViewModelInjector(ViewModelInjector instance) {
            ViewModelInjector_MembersInjector.injectFactory((ViewModelInjector)instance, (ViewModelProvider.Factory)this.viewModelProviderFactory());
            return instance;
        }

        private static final class DocumentScannerFactoryProvider
        implements Provider<IDocumentScannerFactory> {
            private final SDKUIComponent sDKUIComponent;

            DocumentScannerFactoryProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public IDocumentScannerFactory get() {
                return (IDocumentScannerFactory)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.documentScannerFactory());
            }
        }

        private static final class DocumentQualityAnalyzerFactoryProvider
        implements Provider<IDocumentQualityAnalyzerFactory> {
            private final SDKUIComponent sDKUIComponent;

            DocumentQualityAnalyzerFactoryProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public IDocumentQualityAnalyzerFactory get() {
                return (IDocumentQualityAnalyzerFactory)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.documentQualityAnalyzerFactory());
            }
        }
    }
}

