/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui_v2.di.components;

import android.content.Context;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import io.scanbot.sdk.mrz.IMrzScannerFactory;
import io.scanbot.sdk.ui_v2.common.coroutines.IDispatchersProvider;
import io.scanbot.sdk.ui_v2.common.viewmodel.ViewModelInjector;
import io.scanbot.sdk.ui_v2.common.viewmodel.ViewModelInjector_MembersInjector;
import io.scanbot.sdk.ui_v2.di.components.MrzCameraComponent;
import io.scanbot.sdk.ui_v2.di.components.SDKUIComponent;
import io.scanbot.sdk.ui_v2.di.modules.DispatchersModule;
import io.scanbot.sdk.ui_v2.di.modules.DispatchersModule_ProvideBarcodeCameraViewModelFactory;
import io.scanbot.sdk.ui_v2.di.modules.MrzModule;
import io.scanbot.sdk.ui_v2.di.modules.MrzModule_ProvideMrzScannerConfiguration$rtu_ui_v2_bundle_releaseFactory;
import io.scanbot.sdk.ui_v2.di.modules.MrzModule_ProvideMrzViewModelFactory;
import io.scanbot.sdk.ui_v2.di.modules.MrzModule_ProvideNativeConfiguration$rtu_ui_v2_bundle_releaseFactory;
import io.scanbot.sdk.ui_v2.di.modules.ViewModelFactoryModule;
import io.scanbot.sdk.ui_v2.di.modules.ViewModelFactoryModule_BindViewModelFactoryFactory;
import io.scanbot.sdk.ui_v2.mrz.configuration.MrzNativeConfiguration;
import io.scanbot.sdk.ui_v2.mrz.configuration.MrzScannerScreenConfiguration;
import io.scanbot.sdk.ui_v2.mrz.screen.BaseMrzViewModel;
import java.util.Collections;
import java.util.Map;

@DaggerGenerated
public final class DaggerMrzCameraComponent {
    private DaggerMrzCameraComponent() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private MrzModule mrzModule;
        private ViewModelFactoryModule viewModelFactoryModule;
        private DispatchersModule dispatchersModule;
        private SDKUIComponent sDKUIComponent;

        private Builder() {
        }

        public Builder mrzModule(MrzModule mrzModule) {
            this.mrzModule = (MrzModule)Preconditions.checkNotNull((Object)mrzModule);
            return this;
        }

        public Builder viewModelFactoryModule(ViewModelFactoryModule viewModelFactoryModule) {
            this.viewModelFactoryModule = (ViewModelFactoryModule)Preconditions.checkNotNull((Object)viewModelFactoryModule);
            return this;
        }

        public Builder dispatchersModule(DispatchersModule dispatchersModule) {
            this.dispatchersModule = (DispatchersModule)Preconditions.checkNotNull((Object)dispatchersModule);
            return this;
        }

        public Builder sDKUIComponent(SDKUIComponent sDKUIComponent) {
            this.sDKUIComponent = (SDKUIComponent)Preconditions.checkNotNull((Object)sDKUIComponent);
            return this;
        }

        public MrzCameraComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.mrzModule, MrzModule.class);
            if (this.viewModelFactoryModule == null) {
                this.viewModelFactoryModule = new ViewModelFactoryModule();
            }
            if (this.dispatchersModule == null) {
                this.dispatchersModule = new DispatchersModule();
            }
            Preconditions.checkBuilderRequirement((Object)this.sDKUIComponent, SDKUIComponent.class);
            return new MrzCameraComponentImpl(this.mrzModule, this.viewModelFactoryModule, this.dispatchersModule, this.sDKUIComponent);
        }
    }

    private static final class MrzCameraComponentImpl
    implements MrzCameraComponent {
        private final ViewModelFactoryModule viewModelFactoryModule;
        private final MrzCameraComponentImpl mrzCameraComponentImpl = this;
        private Provider<MrzScannerScreenConfiguration> provideMrzScannerConfiguration$rtu_ui_v2_bundle_releaseProvider;
        private Provider<MrzNativeConfiguration> provideNativeConfiguration$rtu_ui_v2_bundle_releaseProvider;
        private Provider<IMrzScannerFactory> mrzScannerFactoryProvider;
        private Provider<IDispatchersProvider> provideBarcodeCameraViewModelProvider;
        private Provider<Context> provideContextProvider;
        private Provider<ViewModel> provideMrzViewModelProvider;

        private MrzCameraComponentImpl(MrzModule mrzModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam, DispatchersModule dispatchersModuleParam, SDKUIComponent sDKUIComponentParam) {
            this.viewModelFactoryModule = viewModelFactoryModuleParam;
            this.initialize(mrzModuleParam, viewModelFactoryModuleParam, dispatchersModuleParam, sDKUIComponentParam);
        }

        private Map<Class<? extends ViewModel>, javax.inject.Provider<ViewModel>> mapOfClassOfAndProviderOfViewModel() {
            return Collections.singletonMap(BaseMrzViewModel.class, this.provideMrzViewModelProvider);
        }

        private ViewModelProvider.Factory viewModelProviderFactory() {
            return ViewModelFactoryModule_BindViewModelFactoryFactory.bindViewModelFactory(this.viewModelFactoryModule, this.mapOfClassOfAndProviderOfViewModel());
        }

        private void initialize(MrzModule mrzModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam, DispatchersModule dispatchersModuleParam, SDKUIComponent sDKUIComponentParam) {
            this.provideMrzScannerConfiguration$rtu_ui_v2_bundle_releaseProvider = DoubleCheck.provider((Provider)MrzModule_ProvideMrzScannerConfiguration$rtu_ui_v2_bundle_releaseFactory.create(mrzModuleParam));
            this.provideNativeConfiguration$rtu_ui_v2_bundle_releaseProvider = DoubleCheck.provider((Provider)MrzModule_ProvideNativeConfiguration$rtu_ui_v2_bundle_releaseFactory.create(mrzModuleParam));
            this.mrzScannerFactoryProvider = new MrzScannerFactoryProvider(sDKUIComponentParam);
            this.provideBarcodeCameraViewModelProvider = DispatchersModule_ProvideBarcodeCameraViewModelFactory.create(dispatchersModuleParam);
            this.provideContextProvider = new ProvideContextProvider(sDKUIComponentParam);
            this.provideMrzViewModelProvider = MrzModule_ProvideMrzViewModelFactory.create(mrzModuleParam, this.provideMrzScannerConfiguration$rtu_ui_v2_bundle_releaseProvider, this.provideNativeConfiguration$rtu_ui_v2_bundle_releaseProvider, this.mrzScannerFactoryProvider, this.provideBarcodeCameraViewModelProvider, this.provideContextProvider);
        }

        @Override
        public void inject(ViewModelInjector component) {
            this.injectViewModelInjector(component);
        }

        private ViewModelInjector injectViewModelInjector(ViewModelInjector instance) {
            ViewModelInjector_MembersInjector.injectFactory((ViewModelInjector)instance, (ViewModelProvider.Factory)this.viewModelProviderFactory());
            return instance;
        }

        private static final class MrzScannerFactoryProvider
        implements Provider<IMrzScannerFactory> {
            private final SDKUIComponent sDKUIComponent;

            MrzScannerFactoryProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public IMrzScannerFactory get() {
                return (IMrzScannerFactory)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.mrzScannerFactory());
            }
        }

        private static final class ProvideContextProvider
        implements Provider<Context> {
            private final SDKUIComponent sDKUIComponent;

            ProvideContextProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public Context get() {
                return (Context)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.provideContext());
            }
        }
    }
}

