/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui_v2.di.components;

import android.content.Context;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import io.scanbot.sdk.documentdata.IDocumentDataExtractorFactory;
import io.scanbot.sdk.ui_v2.common.coroutines.IDispatchersProvider;
import io.scanbot.sdk.ui_v2.common.viewmodel.ViewModelInjector;
import io.scanbot.sdk.ui_v2.common.viewmodel.ViewModelInjector_MembersInjector;
import io.scanbot.sdk.ui_v2.di.components.DocumentDataCameraComponent;
import io.scanbot.sdk.ui_v2.di.components.SDKUIComponent;
import io.scanbot.sdk.ui_v2.di.modules.DispatchersModule;
import io.scanbot.sdk.ui_v2.di.modules.DispatchersModule_ProvideBarcodeCameraViewModelFactory;
import io.scanbot.sdk.ui_v2.di.modules.DocumentDataModule;
import io.scanbot.sdk.ui_v2.di.modules.DocumentDataModule_ProvideDataExtractorViewModelFactory;
import io.scanbot.sdk.ui_v2.di.modules.DocumentDataModule_ProvideExtractorConfiguration$rtu_ui_v2_bundle_releaseFactory;
import io.scanbot.sdk.ui_v2.di.modules.DocumentDataModule_ProvideNativeConfiguration$rtu_ui_v2_bundle_releaseFactory;
import io.scanbot.sdk.ui_v2.di.modules.ViewModelFactoryModule;
import io.scanbot.sdk.ui_v2.di.modules.ViewModelFactoryModule_BindViewModelFactoryFactory;
import io.scanbot.sdk.ui_v2.documentdata.configuration.DocumentDataExtractorNativeConfiguration;
import io.scanbot.sdk.ui_v2.documentdata.configuration.DocumentDataExtractorScreenConfiguration;
import io.scanbot.sdk.ui_v2.documentdata.screen.BaseDocumentDataExtractorViewModel;
import java.util.Collections;
import java.util.Map;

@DaggerGenerated
public final class DaggerDocumentDataCameraComponent {
    private DaggerDocumentDataCameraComponent() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private DocumentDataModule documentDataModule;
        private ViewModelFactoryModule viewModelFactoryModule;
        private DispatchersModule dispatchersModule;
        private SDKUIComponent sDKUIComponent;

        private Builder() {
        }

        public Builder documentDataModule(DocumentDataModule documentDataModule) {
            this.documentDataModule = (DocumentDataModule)Preconditions.checkNotNull((Object)documentDataModule);
            return this;
        }

        public Builder viewModelFactoryModule(ViewModelFactoryModule viewModelFactoryModule) {
            this.viewModelFactoryModule = (ViewModelFactoryModule)Preconditions.checkNotNull((Object)viewModelFactoryModule);
            return this;
        }

        public Builder dispatchersModule(DispatchersModule dispatchersModule) {
            this.dispatchersModule = (DispatchersModule)Preconditions.checkNotNull((Object)dispatchersModule);
            return this;
        }

        public Builder sDKUIComponent(SDKUIComponent sDKUIComponent) {
            this.sDKUIComponent = (SDKUIComponent)Preconditions.checkNotNull((Object)sDKUIComponent);
            return this;
        }

        public DocumentDataCameraComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.documentDataModule, DocumentDataModule.class);
            if (this.viewModelFactoryModule == null) {
                this.viewModelFactoryModule = new ViewModelFactoryModule();
            }
            if (this.dispatchersModule == null) {
                this.dispatchersModule = new DispatchersModule();
            }
            Preconditions.checkBuilderRequirement((Object)this.sDKUIComponent, SDKUIComponent.class);
            return new DocumentDataCameraComponentImpl(this.documentDataModule, this.viewModelFactoryModule, this.dispatchersModule, this.sDKUIComponent);
        }
    }

    private static final class DocumentDataCameraComponentImpl
    implements DocumentDataCameraComponent {
        private final ViewModelFactoryModule viewModelFactoryModule;
        private final DocumentDataCameraComponentImpl documentDataCameraComponentImpl = this;
        Provider<DocumentDataExtractorScreenConfiguration> provideExtractorConfiguration$rtu_ui_v2_bundle_releaseProvider;
        Provider<DocumentDataExtractorNativeConfiguration> provideNativeConfiguration$rtu_ui_v2_bundle_releaseProvider;
        Provider<IDocumentDataExtractorFactory> documentDataExtractorFactoryProvider;
        Provider<IDispatchersProvider> provideBarcodeCameraViewModelProvider;
        Provider<Context> provideContextProvider;
        Provider<ViewModel> provideDataExtractorViewModelProvider;

        DocumentDataCameraComponentImpl(DocumentDataModule documentDataModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam, DispatchersModule dispatchersModuleParam, SDKUIComponent sDKUIComponentParam) {
            this.viewModelFactoryModule = viewModelFactoryModuleParam;
            this.initialize(documentDataModuleParam, viewModelFactoryModuleParam, dispatchersModuleParam, sDKUIComponentParam);
        }

        Map<Class<? extends ViewModel>, javax.inject.Provider<ViewModel>> mapOfClassOfAndProviderOfViewModel() {
            return Collections.singletonMap(BaseDocumentDataExtractorViewModel.class, this.provideDataExtractorViewModelProvider);
        }

        ViewModelProvider.Factory viewModelProviderFactory() {
            return ViewModelFactoryModule_BindViewModelFactoryFactory.bindViewModelFactory(this.viewModelFactoryModule, this.mapOfClassOfAndProviderOfViewModel());
        }

        private void initialize(DocumentDataModule documentDataModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam, DispatchersModule dispatchersModuleParam, SDKUIComponent sDKUIComponentParam) {
            this.provideExtractorConfiguration$rtu_ui_v2_bundle_releaseProvider = DoubleCheck.provider((Provider)DocumentDataModule_ProvideExtractorConfiguration$rtu_ui_v2_bundle_releaseFactory.create(documentDataModuleParam));
            this.provideNativeConfiguration$rtu_ui_v2_bundle_releaseProvider = DoubleCheck.provider((Provider)DocumentDataModule_ProvideNativeConfiguration$rtu_ui_v2_bundle_releaseFactory.create(documentDataModuleParam));
            this.documentDataExtractorFactoryProvider = new DocumentDataExtractorFactoryProvider(sDKUIComponentParam);
            this.provideBarcodeCameraViewModelProvider = DispatchersModule_ProvideBarcodeCameraViewModelFactory.create(dispatchersModuleParam);
            this.provideContextProvider = new ProvideContextProvider(sDKUIComponentParam);
            this.provideDataExtractorViewModelProvider = DocumentDataModule_ProvideDataExtractorViewModelFactory.create(documentDataModuleParam, this.provideExtractorConfiguration$rtu_ui_v2_bundle_releaseProvider, this.provideNativeConfiguration$rtu_ui_v2_bundle_releaseProvider, this.documentDataExtractorFactoryProvider, this.provideBarcodeCameraViewModelProvider, this.provideContextProvider);
        }

        @Override
        public void inject(ViewModelInjector component) {
            this.injectViewModelInjector(component);
        }

        private ViewModelInjector injectViewModelInjector(ViewModelInjector instance) {
            ViewModelInjector_MembersInjector.injectFactory((ViewModelInjector)instance, (ViewModelProvider.Factory)this.viewModelProviderFactory());
            return instance;
        }

        private static final class DocumentDataExtractorFactoryProvider
        implements Provider<IDocumentDataExtractorFactory> {
            private final SDKUIComponent sDKUIComponent;

            DocumentDataExtractorFactoryProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public IDocumentDataExtractorFactory get() {
                return (IDocumentDataExtractorFactory)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.documentDataExtractorFactory());
            }
        }

        private static final class ProvideContextProvider
        implements Provider<Context> {
            private final SDKUIComponent sDKUIComponent;

            ProvideContextProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public Context get() {
                return (Context)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.provideContext());
            }
        }
    }
}

