/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui_v2.document.utils;

import android.content.ClipData;
import android.content.ContentResolver;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Build;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a.\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0018\b\u0002\u0010\t\u001a\u0012\u0012\b\u0012\u00060\u000bj\u0002`\f\u0012\u0004\u0012\u00020\r0\n\u001a\u0012\u0010\u000e\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0002\u00a8\u0006\u0013"}, d2={"getUrisFromGalleryResult", "", "Landroid/net/Uri;", "data", "Landroid/content/Intent;", "toBitmap", "Landroid/graphics/Bitmap;", "contentResolver", "Landroid/content/ContentResolver;", "onException", "Lkotlin/Function1;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "", "preprocessBitmap", "orientation", "", "exifToGrad", "exifOrientation", "rtu-ui-v2-document_release"})
@SourceDebugExtension(value={"SMAP\nGalleryUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GalleryUtils.kt\nio/scanbot/sdk/ui_v2/document/utils/GalleryUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n1#2:99\n*E\n"})
public final class GalleryUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Uri> getUrisFromGalleryResult(@NotNull Intent data) {
        List list;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (data.getClipData() != null) {
            void var3_4;
            ClipData mClipData;
            ClipData clipData = mClipData = data.getClipData();
            int count = clipData != null ? clipData.getItemCount() : 0;
            List result = new ArrayList();
            for (int i = 0; i < count; ++i) {
                Uri imageUri;
                ClipData it;
                if (mClipData == null) continue;
                boolean bl = false;
                ClipData.Item item = it.getItemAt(i);
                Object object = imageUri = item != null ? item.getUri() : null;
                if (imageUri == null) continue;
                result.add(imageUri);
            }
            list = var3_4;
        } else {
            Uri imageUri = data.getData();
            list = CollectionsKt.listOfNotNull((Object)imageUri);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final Bitmap toBitmap(@NotNull Uri $this$toBitmap, @NotNull ContentResolver contentResolver, @NotNull Function1<? super Exception, Unit> onException) {
        Intrinsics.checkNotNullParameter((Object)$this$toBitmap, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)contentResolver, (String)"contentResolver");
        Intrinsics.checkNotNullParameter(onException, (String)"onException");
        try {
            Bitmap bitmap2;
            Object object;
            Bitmap bitmap3 = null;
            InputStream input = contentResolver.openInputStream($this$toBitmap);
            int orientation = 0;
            Closeable closeable = input;
            Object object2 = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                if (Build.VERSION.SDK_INT >= 24) {
                    InputStream inputStream = input;
                    Intrinsics.checkNotNull((Object)inputStream);
                    ExifInterface exif = new ExifInterface(inputStream);
                    orientation = GalleryUtilsKt.exifToGrad(exif.getAttributeInt("Orientation", 0));
                }
                object = Unit.INSTANCE;
            }
            catch (Throwable bl) {
                object2 = bl;
                throw bl;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
            }
            InputStream inputNew = contentResolver.openInputStream($this$toBitmap);
            object2 = inputNew;
            object = null;
            try {
                InputStream it = (InputStream)object2;
                boolean bl = false;
                bitmap2 = BitmapFactory.decodeStream((InputStream)inputNew);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
            }
            bitmap3 = bitmap2;
            object2 = bitmap3;
            Intrinsics.checkNotNull((Object)object2);
            bitmap3 = GalleryUtilsKt.preprocessBitmap((Bitmap)object2, orientation);
            return bitmap3;
        }
        catch (IOException e) {
            onException.invoke((Object)e);
            return null;
        }
    }

    public static /* synthetic */ Bitmap toBitmap$default(Uri uri, ContentResolver contentResolver, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = GalleryUtilsKt::toBitmap$lambda$1;
        }
        return GalleryUtilsKt.toBitmap(uri, contentResolver, (Function1<? super Exception, Unit>)function1);
    }

    @NotNull
    public static final Bitmap preprocessBitmap(@NotNull Bitmap $this$preprocessBitmap, int orientation) {
        Bitmap bitmap2;
        Intrinsics.checkNotNullParameter((Object)$this$preprocessBitmap, (String)"<this>");
        Bitmap bitmapToProcess = $this$preprocessBitmap;
        boolean bl = false;
        int width = bitmapToProcess.getWidth();
        int height = bitmapToProcess.getHeight();
        if (orientation != 0 || width > 4096 || height > 4096) {
            Matrix matrix = new Matrix();
            if (orientation != 0) {
                matrix.setRotate((float)orientation, (float)width / 2.0f, (float)height / 2.0f);
            }
            if (width > 4096 || height > 4096) {
                float scale2 = width > height ? (float)4096 / (float)width : (float)4096 / (float)height;
                matrix.postScale(scale2, scale2);
            }
            bitmap2 = Bitmap.createBitmap((Bitmap)bitmapToProcess, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)false);
        } else {
            bitmap2 = bitmapToProcess;
        }
        Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"let(...)");
        return bitmap2;
    }

    private static final int exifToGrad(int exifOrientation) {
        return switch (exifOrientation) {
            case 6 -> 90;
            case 3 -> 180;
            case 8 -> 270;
            default -> 0;
        };
    }

    private static final Unit toBitmap$lambda$1(Exception it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }
}

