/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.barcode_scanner.di;

import android.app.Application;
import android.content.SharedPreferences;
import android.content.res.AssetManager;
import dagger.Module;
import dagger.Provides;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.barcode.DefaultScanbotBarcodeDetector;
import io.scanbot.sdk.barcode.ScanbotBarcodeDetector;
import io.scanbot.sdk.barcode.StubScanbotBarcodeDetector;
import io.scanbot.sdk.barcode_scanner.di.SapProvider;
import io.scanbot.sdk.blob.BlobFactory;
import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.connectivity.BlobsStorage;
import io.scanbot.sdk.persistence.BarcodeFileStorage;
import io.scanbot.sdk.persistence.BlobStoreStrategy;
import javax.inject.Singleton;

@Module
public class ScanbotBarcodeScannerSDKModule {
    @Provides
    @Singleton
    public SapManager providesSapManager(Application application) {
        return new SapProvider(application).get();
    }

    @Provides
    public BlobStoreStrategy providesBlobStoreStrategy(Application application, SharedPreferences sharedPreferences) {
        return new BlobStoreStrategy(application, sharedPreferences);
    }

    @Provides
    public BlobsStorage providesBlobsStorage(SharedPreferences sharedPreferences) {
        return new BlobsStorage(sharedPreferences);
    }

    @Provides
    public BlobFactory providesBlobFactory(BlobStoreStrategy blobStoreStrategy, BlobsStorage blobsStorage, AssetManager assetManager) {
        return new BlobFactory(blobStoreStrategy, blobsStorage, assetManager);
    }

    @Provides
    public BlobManager providesBlobManager(BlobStoreStrategy blobStoreStrategy, AssetManager assetManager, BlobFactory blobFactory) {
        return new BlobManager(blobStoreStrategy, assetManager, blobFactory);
    }

    @Provides
    @Singleton
    public ScanbotBarcodeDetector scanbotBarcodeDetector(SapManager sapManager) {
        if (sapManager.checkLicenseStatusSilently(SdkFeature.Barcode)) {
            return new DefaultScanbotBarcodeDetector();
        }
        return new StubScanbotBarcodeDetector(sapManager);
    }

    @Provides
    public BarcodeFileStorage providesBarcodeFileStorage(Application application) {
        return new BarcodeFileStorage(application);
    }
}

