/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.barcode_scanner.di;

import android.app.Application;
import android.content.Context;
import dagger.Module;
import dagger.Provides;
import dagger.multibindings.IntoSet;
import io.scanbot.sap.SapManager;
import io.scanbot.sdk.barcode.BarcodeDocumentParserFactory;
import io.scanbot.sdk.barcode.BarcodeScannerFactory;
import io.scanbot.sdk.barcode.IBarcodeDocumentParserFactory;
import io.scanbot.sdk.barcode.IBarcodeScannerFactory;
import io.scanbot.sdk.barcode.ui.result.BarcodeScannerUiResultInternalLruStorage;
import io.scanbot.sdk.barcode.ui.result.BarcodeScannerUiResultInternalRepository;
import io.scanbot.sdk.barcode.ui.result.model.BarcodeScannerUiResultInternal;
import io.scanbot.sdk.barcode_scanner.ScanbotBarcodeScannerSDK;
import io.scanbot.sdk.barcode_scanner.di.BarcodeDependencyCheck;
import io.scanbot.sdk.barcode_scanner.di.SapProvider;
import io.scanbot.sdk.barcode_scanner.di.SdkComponentProvider;
import io.scanbot.sdk.di.DependencyCheckUtils;
import io.scanbot.sdk.di.RequiredDependency;
import io.scanbot.sdk.exceptions.crypto.EncryptionInitException;
import io.scanbot.sdk.pdf.DefaultPdfImagesExtractor;
import io.scanbot.sdk.pdf.PdfImagesExtractor;
import io.scanbot.sdk.pdf.PdfiumPdfImagesExtractor;
import io.scanbot.sdk.persistence.BarcodeFileStorage;
import io.scanbot.sdk.persistence.fileio.DefaultFileIOProcessor;
import io.scanbot.sdk.persistence.fileio.EncryptedFileIOProcessor;
import io.scanbot.sdk.persistence.fileio.FileIOProcessor;
import io.scanbot.sdk.persistence.fileio.ImageFileIOProcessor;
import io.scanbot.sdk.ui.result.ResultRepository;
import io.scanbot.sdk.ui.result.ResultStorage;
import java.io.File;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Module
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\b\u0010\f\u001a\u00020\rH\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013H\u0007J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0007J'\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\u001a2\u0017\u0010\u001b\u001a\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u001d0\u001c\u00a2\u0006\u0002\b\u001eH\u0007J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00010\u001dH\u0007J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006$"}, d2={"Lio/scanbot/sdk/barcode_scanner/di/ScanbotBarcodeScannerSDKModule;", "", "configuration", "Lio/scanbot/sdk/barcode_scanner/ScanbotBarcodeScannerSDK$Configuration;", "<init>", "(Lio/scanbot/sdk/barcode_scanner/ScanbotBarcodeScannerSDK$Configuration;)V", "getConfiguration", "()Lio/scanbot/sdk/barcode_scanner/ScanbotBarcodeScannerSDK$Configuration;", "providesSapManager", "Lio/scanbot/sap/SapManager;", "application", "Landroid/app/Application;", "scanbotBarcodeScanner", "Lio/scanbot/sdk/barcode/IBarcodeScannerFactory;", "scanbotBarcodeDocumentParser", "Lio/scanbot/sdk/barcode/IBarcodeDocumentParserFactory;", "providesBarcodeFileStorage", "Lio/scanbot/sdk/persistence/BarcodeFileStorage;", "provideFileIOProcessor", "Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;", "provideImageFileIOProcessor", "Lio/scanbot/sdk/persistence/fileio/ImageFileIOProcessor;", "fileIOProcessor", "providePdfImagesExtractor", "Lio/scanbot/sdk/pdf/PdfImagesExtractor;", "provideBarcodeScannerUiResultInternalRepository", "Lio/scanbot/sdk/ui/result/ResultRepository;", "storages", "", "Lio/scanbot/sdk/ui/result/ResultStorage;", "Lkotlin/jvm/JvmSuppressWildcards;", "provideBarcodeScannerUiResultInternalLruStorage", "provideSdkComponentProvider", "Lio/scanbot/sdk/barcode_scanner/di/SdkComponentProvider;", "context", "Landroid/content/Context;", "scanbot-barcode-scanner-sdk_release"})
@SourceDebugExtension(value={"SMAP\nScanbotBarcodeScannerSDKModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScanbotBarcodeScannerSDKModule.kt\nio/scanbot/sdk/barcode_scanner/di/ScanbotBarcodeScannerSDKModule\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,116:1\n230#2,2:117\n*S KotlinDebug\n*F\n+ 1 ScanbotBarcodeScannerSDKModule.kt\nio/scanbot/sdk/barcode_scanner/di/ScanbotBarcodeScannerSDKModule\n*L\n97#1:117,2\n*E\n"})
public final class ScanbotBarcodeScannerSDKModule {
    @NotNull
    private final ScanbotBarcodeScannerSDK.Configuration configuration;

    /*
     * WARNING - void declaration
     */
    public ScanbotBarcodeScannerSDKModule(@NotNull ScanbotBarcodeScannerSDK.Configuration configuration) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"configuration");
        this.configuration = var1_1;
    }

    @NotNull
    public final ScanbotBarcodeScannerSDK.Configuration getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @Singleton
    @NotNull
    public final SapManager providesSapManager(@NotNull Application application) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        SapManager sapManager = new SapProvider((Application)var1_1).get();
        Intrinsics.checkNotNullExpressionValue((Object)sapManager, (String)"get(...)");
        return sapManager;
    }

    @Provides
    @NotNull
    public final IBarcodeScannerFactory scanbotBarcodeScanner() {
        return new BarcodeScannerFactory();
    }

    @Provides
    @NotNull
    public final IBarcodeDocumentParserFactory scanbotBarcodeDocumentParser() {
        return new BarcodeDocumentParserFactory();
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final BarcodeFileStorage providesBarcodeFileStorage(@NotNull Application application) {
        void var1_1;
        ScanbotBarcodeScannerSDKModule scanbotBarcodeScannerSDKModule = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"application");
        Object object = scanbotBarcodeScannerSDKModule.configuration.getSdkFilesDirectory();
        if (object == null || (object = ((File)object).getPath()) == null) {
            object = "";
        }
        ScanbotBarcodeScannerSDKModule scanbotBarcodeScannerSDKModule2 = this;
        scanbotBarcodeScannerSDKModule2((Application)var1_1, (String)object);
        return scanbotBarcodeScannerSDKModule2;
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @Singleton
    @NotNull
    public final FileIOProcessor provideFileIOProcessor(@NotNull Application application) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"application");
        if (this.configuration.getFileStorageSettings().getEncryptionEnabled()) {
            if (this.configuration.getFileStorageSettings().getCustomFileIOProcessor() != null) {
                FileIOProcessor fileIOProcessor = this.configuration.getFileStorageSettings().getCustomFileIOProcessor();
                Intrinsics.checkNotNull((Object)fileIOProcessor);
                return fileIOProcessor;
            }
            try {
                return new EncryptedFileIOProcessor((Context)var1_1);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                throw new EncryptionInitException("Could not initialize an encrypted image storage! Please, check that you added dependency on io.scanbot:sdk-crypto-persistence:VERSION");
            }
        }
        return new DefaultFileIOProcessor((Context)var1_1);
    }

    @Provides
    @NotNull
    public final ImageFileIOProcessor provideImageFileIOProcessor(@NotNull FileIOProcessor fileIOProcessor) {
        FileIOProcessor fileIOProcessor2 = fileIOProcessor;
        Intrinsics.checkNotNullParameter((Object)fileIOProcessor2, (String)"fileIOProcessor");
        return fileIOProcessor2;
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @NotNull
    public final PdfImagesExtractor providePdfImagesExtractor(@NotNull FileIOProcessor fileIOProcessor, @NotNull Application application) {
        void var2_3;
        void var1_2;
        Intrinsics.checkNotNullParameter((Object)var1_2, (String)"fileIOProcessor");
        Intrinsics.checkNotNullParameter((Object)var2_3, (String)"application");
        ScanbotBarcodeScannerSDKModule this_ = this_.configuration.getPdfImagesExtractorSettings();
        this_ = this_ != null ? this_.getExtractorType() : null;
        int n = this_ == null ? -1 : WhenMappings.$EnumSwitchMapping$0[((Enum)((Object)this_)).ordinal()];
        if (n != -1) {
            if (n != 1) {
                if (n != 2) {
                    throw new NoWhenBranchMatchedException();
                }
            } else {
                DependencyCheckUtils.INSTANCE.checkDependency((RequiredDependency)BarcodeDependencyCheck.PDFIUM_IMAGES);
                return new PdfiumPdfImagesExtractor((FileIOProcessor)var1_2, (Context)var2_3);
            }
        }
        return new DefaultPdfImagesExtractor((FileIOProcessor)var1_2);
    }

    @Provides
    @IntoSet
    @NotNull
    public final ResultRepository<Object> provideBarcodeScannerUiResultInternalRepository(@NotNull Set<ResultStorage<Object>> storages) {
        Set<ResultStorage<Object>> set = storages;
        Intrinsics.checkNotNullParameter(set, (String)"storages");
        for (Object e : set) {
            ResultStorage resultStorage = (ResultStorage)e;
            if (!Intrinsics.areEqual((Object)resultStorage.getAcceptedType(), BarcodeScannerUiResultInternal.class)) continue;
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type io.scanbot.sdk.ui.result.ResultStorage<io.scanbot.sdk.barcode.ui.result.model.BarcodeScannerUiResultInternal>");
            return new BarcodeScannerUiResultInternalRepository(resultStorage);
        }
        throw new NoSuchElementException("Collection contains no element matching the predicate.");
    }

    @Provides
    @Singleton
    @IntoSet
    @NotNull
    public final ResultStorage<Object> provideBarcodeScannerUiResultInternalLruStorage() {
        return new BarcodeScannerUiResultInternalLruStorage();
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @Singleton
    @NotNull
    public final SdkComponentProvider provideSdkComponentProvider(@NotNull Context context) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new SdkComponentProvider((Context)var1_1);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PdfImagesExtractor.Type.values().length];
            int[] nArray2 = nArray;
            try {
                nArray[PdfImagesExtractor.Type.PDFIUM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[PdfImagesExtractor.Type.ANDROID_PDF_WRITER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray2;
        }
    }
}

