/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.persistence.fileio;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import io.scanbot.sdk.exceptions.crypto.SourceFileDoesNotExistException;
import io.scanbot.sdk.persistence.fileio.FileIOProcessor;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010.\u001a\u00020)\u00a2\u0006\u0004\b5\u00106J/\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ#\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J#\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u00122\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0014J\u0019\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\r\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001f\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001f\u0010\u001b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010#\u001a\u00020\"2\u0006\u0010!\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b#\u0010$R\u0016\u0010(\u001a\u00020%8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u0019\u0010.\u001a\u00020)8\u0006@\u0006\u00a2\u0006\f\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-R\u001c\u00104\u001a\u00020/8\u0016@\u0016X\u0096D\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b2\u00103\u00a8\u00067"}, d2={"Lio/scanbot/sdk/persistence/fileio/DefaultFileIOProcessor;", "Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;", "Landroid/graphics/Bitmap;", "bitmap", "Landroid/graphics/Bitmap$CompressFormat;", "compressFormat", "", "quality", "Ljava/io/File;", "destination", "", "writeImage", "(Landroid/graphics/Bitmap;Landroid/graphics/Bitmap$CompressFormat;ILjava/io/File;)V", "source", "Landroid/graphics/BitmapFactory$Options;", "options", "readImage", "(Ljava/io/File;Landroid/graphics/BitmapFactory$Options;)Landroid/graphics/Bitmap;", "Landroid/net/Uri;", "sourceUri", "(Landroid/net/Uri;Landroid/graphics/BitmapFactory$Options;)Landroid/graphics/Bitmap;", "", "read", "(Ljava/io/File;)[B", "byteArray", "write", "([BLjava/io/File;)V", "copyRaw", "(Ljava/io/File;Ljava/io/File;)V", "destinationFile", "Ljava/io/OutputStream;", "openFileOutputStream", "(Ljava/io/File;)Ljava/io/OutputStream;", "sourceFile", "Ljava/io/InputStream;", "openFileInputStream", "(Ljava/io/File;)Ljava/io/InputStream;", "Lio/scanbot/sdk/util/log/Logger;", "b", "Lio/scanbot/sdk/util/log/Logger;", "logger", "Landroid/content/Context;", "c", "Landroid/content/Context;", "getContext", "()Landroid/content/Context;", "context", "", "a", "Z", "getUseEncryption", "()Z", "useEncryption", "<init>", "(Landroid/content/Context;)V", "sdk-base_release"})
public final class DefaultFileIOProcessor
implements FileIOProcessor {
    private final boolean a;
    private final Logger b;
    @NotNull
    private final Context c;

    /*
     * WARNING - void declaration
     */
    public DefaultFileIOProcessor(@NotNull Context context) {
        void var1_1;
        DefaultFileIOProcessor defaultFileIOProcessor = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"context");
        defaultFileIOProcessor.c = var1_1;
        defaultFileIOProcessor.b = LoggerProvider.getLogger();
    }

    @Override
    public boolean getUseEncryption() {
        return this.a;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void writeImage(@NotNull Bitmap bitmap, @NotNull Bitmap.CompressFormat compressFormat, int quality, @NotNull File destination) {
        Throwable throwable2;
        Object object;
        block6: {
            Object object2;
            void v4;
            void v3;
            void v2;
            FileOutputStream fileOutputStream;
            void var4_4;
            void var2_2;
            void var1_1;
            File file = destination;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"bitmap");
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"compressFormat");
            Intrinsics.checkNotNullParameter((Object)file, (String)"destination");
            if (file.exists()) {
                FileUtils.deleteQuietly((File)var4_4);
            }
            DefaultFileIOProcessor defaultFileIOProcessor = null;
            object = fileOutputStream;
            try {
                void var3_3;
                v2 = var1_1;
                v3 = var2_2;
                v4 = var3_3;
                Object object3 = object;
                object2 = object3;
                ((FileOutputStream)object3)((File)var4_4);
            }
            catch (Throwable throwable2) {
                object = defaultFileIOProcessor;
                break block6;
            }
            try {
                v2.compress((Bitmap.CompressFormat)v3, (int)v4, (OutputStream)object2);
            }
            catch (Throwable throwable2) {
                break block6;
            }
            IOUtils.closeQuietly((OutputStream)fileOutputStream);
            return;
        }
        IOUtils.closeQuietly((OutputStream)object);
        throw throwable2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Bitmap readImage(@NotNull File source, @Nullable BitmapFactory.Options options) {
        void var2_2;
        void var1_1;
        void v0 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v0, (String)"source");
        Uri uri = Uri.fromFile((File)v0);
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"Uri.fromFile(source)");
        return this.readImage(uri, (BitmapFactory.Options)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Bitmap readImage(@NotNull Uri sourceUri, @Nullable BitmapFactory.Options options) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)sourceUri, (String)"sourceUri");
        if (new File(var1_1.getPath()).exists()) {
            void var2_2;
            return BitmapFactory.decodeFile((String)var1_1.getPath(), (BitmapFactory.Options)var2_2);
        }
        throw new SourceFileDoesNotExistException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public byte[] read(@NotNull File source) {
        File file = source;
        Intrinsics.checkNotNullParameter((Object)file, (String)"source");
        if (file.exists()) {
            void var1_1;
            return FileUtils.readFileToByteArray((File)var1_1);
        }
        throw new SourceFileDoesNotExistException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(@NotNull byte[] byteArray, @NotNull File destination) {
        void var2_2;
        void var1_1;
        File file = destination;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"byteArray");
        Intrinsics.checkNotNullParameter((Object)file, (String)"destination");
        if (file.exists()) {
            FileUtils.deleteQuietly((File)var2_2);
        }
        FileUtils.writeByteArrayToFile((File)var2_2, (byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void copyRaw(@NotNull File source, @NotNull File destination) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"source");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"destination");
        if (source.exists()) {
            FileUtils.copyFile((File)var1_1, (File)var2_2);
            return;
        }
        throw new SourceFileDoesNotExistException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OutputStream openFileOutputStream(@NotNull File destinationFile) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)destinationFile, (String)"destinationFile");
        return new FileOutputStream((File)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public InputStream openFileInputStream(@NotNull File sourceFile) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        return new FileInputStream((File)var1_1);
    }

    @NotNull
    public final Context getContext() {
        return this.c;
    }
}

