/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.camera;

import android.content.Context;
import android.graphics.PointF;
import android.hardware.Camera;
import com.commonsware.cwac.camera.CameraHost;
import com.commonsware.cwac.camera.PictureTransaction;
import com.commonsware.cwac.camera.SimpleCameraHost;
import io.scanbot.sdk.camera.BasePictureCallback;
import io.scanbot.sdk.camera.CameraModule;
import io.scanbot.sdk.camera.CameraPreviewMode;
import io.scanbot.sdk.exceptions.camera.CameraParametersException;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import io.scanbot.sdk.util.snap.Utils;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010a\u001a\u00020`\u00a2\u0006\u0004\bb\u0010cJ7\u0010\n\u001a\u00060\tR\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00022\n\u0010\b\u001a\u00060\u0006R\u00020\u0007H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\f\u001a\u00060\u0006R\u00020\u00072\n\u0010\b\u001a\u00060\u0006R\u00020\u0007H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ7\u0010\u000e\u001a\u00060\tR\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00022\n\u0010\b\u001a\u00060\u0006R\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000bJ\u0015\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0011\u0010\u0014\u001a\u0004\u0018\u00010\u000fH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J)\u0010\u0018\u001a\u00060\tR\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u00162\n\u0010\b\u001a\u00060\u0006R\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001b\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001d\u001a\u00020\u001aH\u0014\u00a2\u0006\u0004\b\u001d\u0010\u001cJ\u000f\u0010\u001f\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J'\u0010$\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b$\u0010%J\u001f\u0010(\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b(\u0010)J\u0015\u0010,\u001a\u00020\u00112\u0006\u0010+\u001a\u00020*\u00a2\u0006\u0004\b,\u0010-J\u0015\u0010.\u001a\u00020\u00112\u0006\u0010+\u001a\u00020*\u00a2\u0006\u0004\b.\u0010-J\u001b\u00100\u001a\u00020\u00112\f\u0010/\u001a\b\u0018\u00010\tR\u00020\u0007\u00a2\u0006\u0004\b0\u00101J\u001b\u00103\u001a\u00020\u00112\f\u00102\u001a\b\u0018\u00010\tR\u00020\u0007\u00a2\u0006\u0004\b3\u00101J\u0015\u00105\u001a\u00020\u00112\u0006\u00104\u001a\u00020\u001a\u00a2\u0006\u0004\b5\u00106J\u0015\u00108\u001a\u00020\u00112\u0006\u00107\u001a\u00020\u001a\u00a2\u0006\u0004\b8\u00106J\u001b\u0010<\u001a\u00020\u00112\f\u0010;\u001a\b\u0012\u0004\u0012\u00020:09\u00a2\u0006\u0004\b<\u0010=R\u0016\u00104\u001a\u00020\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b>\u0010?R\u0016\u0010C\u001a\u00020@8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bA\u0010BR\"\u0010K\u001a\u00020D8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bE\u0010F\u001a\u0004\bG\u0010H\"\u0004\bI\u0010JR\u001c\u00102\u001a\b\u0018\u00010\tR\u00020\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bL\u0010MR\u0016\u0010P\u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bN\u0010OR\u001c\u0010/\u001a\b\u0018\u00010\tR\u00020\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bQ\u0010MR\u0016\u00107\u001a\u00020\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bR\u0010?R\u001c\u0010U\u001a\b\u0012\u0004\u0012\u00020*0S8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010TR\u001c\u0010;\u001a\b\u0012\u0004\u0012\u00020:098\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bV\u0010WR\"\u0010_\u001a\u00020X8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bY\u0010Z\u001a\u0004\b[\u0010\\\"\u0004\b]\u0010^\u00a8\u0006d"}, d2={"Lio/scanbot/sdk/camera/CameraHost;", "Lcom/commonsware/cwac/camera/SimpleCameraHost;", "", "displayOrientation", "width", "height", "Landroid/hardware/Camera$Parameters;", "Landroid/hardware/Camera;", "parameters", "Landroid/hardware/Camera$Size;", "a", "(IIILandroid/hardware/Camera$Parameters;)Landroid/hardware/Camera$Size;", "adjustPreviewParameters", "(Landroid/hardware/Camera$Parameters;)Landroid/hardware/Camera$Parameters;", "getPreviewSize", "Landroid/hardware/Camera$ShutterCallback;", "shutterCallback", "", "setShutterCallback", "(Landroid/hardware/Camera$ShutterCallback;)V", "getShutterCallback", "()Landroid/hardware/Camera$ShutterCallback;", "Lcom/commonsware/cwac/camera/PictureTransaction;", "xact", "getPictureSize", "(Lcom/commonsware/cwac/camera/PictureTransaction;Landroid/hardware/Camera$Parameters;)Landroid/hardware/Camera$Size;", "", "useFullBleedPreview", "()Z", "useFrontFacingCamera", "Lcom/commonsware/cwac/camera/CameraHost$RecordingHint;", "getRecordingHint", "()Lcom/commonsware/cwac/camera/CameraHost$RecordingHint;", "", "image", "imageOrientation", "saveImage", "(Lcom/commonsware/cwac/camera/PictureTransaction;[BI)V", "success", "camera", "onAutoFocus", "(ZLandroid/hardware/Camera;)V", "Lio/scanbot/sdk/camera/BasePictureCallback;", "pictureCallback", "addPictureCallback", "(Lio/scanbot/sdk/camera/BasePictureCallback;)V", "removePictureCallback", "defaultPictureSize", "setDefaultPictureSize", "(Landroid/hardware/Camera$Size;)V", "defaultPreviewSize", "setDefaultPreviewSize", "autoFocusSoundEnabled", "setAutoFocusSound", "(Z)V", "shutterSoundEnabled", "setShutterSound", "", "Landroid/graphics/PointF;", "currentFinderRectF", "setCurrentFinderRectF", "(Ljava/util/List;)V", "e", "Z", "Lio/scanbot/sdk/util/log/Logger;", "b", "Lio/scanbot/sdk/util/log/Logger;", "logger", "Lio/scanbot/sdk/camera/CameraModule;", "i", "Lio/scanbot/sdk/camera/CameraModule;", "getCameraModule", "()Lio/scanbot/sdk/camera/CameraModule;", "setCameraModule", "(Lio/scanbot/sdk/camera/CameraModule;)V", "cameraModule", "d", "Landroid/hardware/Camera$Size;", "g", "Landroid/hardware/Camera$ShutterCallback;", "shutterListener", "c", "f", "", "Ljava/util/Set;", "pictureCallbacks", "h", "Ljava/util/List;", "Lio/scanbot/sdk/camera/CameraPreviewMode;", "j", "Lio/scanbot/sdk/camera/CameraPreviewMode;", "getPreviewMode", "()Lio/scanbot/sdk/camera/CameraPreviewMode;", "setPreviewMode", "(Lio/scanbot/sdk/camera/CameraPreviewMode;)V", "previewMode", "Landroid/content/Context;", "context", "<init>", "(Landroid/content/Context;)V", "sdk-base_release"})
public final class CameraHost
extends SimpleCameraHost {
    private final Set<BasePictureCallback> a;
    private final Logger b;
    private Camera.Size c;
    private Camera.Size d;
    private boolean e;
    private boolean f;
    private Camera.ShutterCallback g;
    private List<? extends PointF> h;
    @NotNull
    private CameraModule i;
    @NotNull
    private CameraPreviewMode j;

    private final Camera.Size a(int displayOrientation, int width, int height, Camera.Parameters parameters) {
        Camera.Parameters parameters2 = parameters;
        cameraHost.b.logMethod();
        CameraHost cameraHost = Utils.getLargestPictureSize(parameters2);
        List list = parameters2.getSupportedPreviewSizes();
        if (list != null && !list.isEmpty()) {
            return Utils.getLargestSizeWithAspectRatioMatch(list, (double)((Camera.Size)cameraHost).width / (double)((Camera.Size)cameraHost).height);
        }
        throw new CameraParametersException("Could not get a list of camera preview sizes. Camera parameters are invalid.");
    }

    /*
     * WARNING - void declaration
     */
    public CameraHost(@NotNull Context context) {
        void var1_1;
        void v0 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v0, (String)"context");
        super((Context)v0);
        this.a = new LinkedHashSet<BasePictureCallback>();
        this.b = LoggerProvider.getLogger();
        this.e = true;
        this.f = true;
        this.g = io.scanbot.sdk.camera.CameraHost$a.a;
        this.h = CollectionsKt.emptyList();
        this.i = CameraModule.BACK;
        this.j = CameraPreviewMode.FILL_IN;
    }

    @NotNull
    public final CameraModule getCameraModule() {
        return this.i;
    }

    /*
     * WARNING - void declaration
     */
    public final void setCameraModule(@NotNull CameraModule cameraModule) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"<set-?>");
        this.i = var1_1;
    }

    @NotNull
    public final CameraPreviewMode getPreviewMode() {
        return this.j;
    }

    /*
     * WARNING - void declaration
     */
    public final void setPreviewMode(@NotNull CameraPreviewMode cameraPreviewMode) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"<set-?>");
        this.j = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Camera.Parameters adjustPreviewParameters(@NotNull Camera.Parameters parameters) {
        void var1_1;
        Camera.Parameters parameters2 = parameters;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"parameters");
        this.b.logMethod();
        super.adjustPreviewParameters((Camera.Parameters)var1_1);
        parameters2.setPreviewFormat(17);
        return parameters2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Camera.Size getPreviewSize(int displayOrientation, int width, int height, @NotNull Camera.Parameters parameters) {
        void var4_4;
        CameraHost cameraHost = this;
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"parameters");
        cameraHost.b.logMethod();
        Camera.Size size = cameraHost.d;
        if (size == null) {
            void var3_3;
            void var2_2;
            void var1_1;
            size = this.a((int)var1_1, (int)var2_2, (int)var3_3, (Camera.Parameters)var4_4);
        }
        return size;
    }

    /*
     * WARNING - void declaration
     */
    public final void setShutterCallback(@NotNull Camera.ShutterCallback shutterCallback) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"shutterCallback");
        this.g = var1_1;
    }

    @Nullable
    public Camera.ShutterCallback getShutterCallback() {
        return this.f ? this.g : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Camera.Size getPictureSize(@Nullable PictureTransaction xact, @NotNull Camera.Parameters parameters) {
        void var2_2;
        CameraHost cameraHost = this_;
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"parameters");
        cameraHost.b.logMethod();
        CameraHost this_ = cameraHost.c;
        if (this_ == null) {
            this_ = Utils.getLargestPictureSize((Camera.Parameters)var2_2);
        }
        return this_;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean useFullBleedPreview() {
        int n = this.j.ordinal();
        if (n == 0) return false;
        if (n != 1) throw new NoWhenBranchMatchedException();
        return true;
    }

    public boolean useFrontFacingCamera() {
        boolean bl;
        int n = this.i.ordinal();
        if (n != 0) {
            if (n != 1 && n != 2) {
                throw new NoWhenBranchMatchedException();
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public CameraHost.RecordingHint getRecordingHint() {
        return CameraHost.RecordingHint.STILL_ONLY;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveImage(@NotNull PictureTransaction xact, @NotNull byte[] image, int imageOrientation) {
        void var2_2;
        Set<BasePictureCallback> set;
        CameraHost cameraHost = this;
        Intrinsics.checkNotNullParameter((Object)set, (String)"xact");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"image");
        cameraHost.b.logMethod();
        set = cameraHost.a;
        synchronized (set) {
            Iterator<BasePictureCallback> iterator = cameraHost.a.iterator();
            while (true) {
                void var3_3;
                if (!iterator.hasNext()) {
                    return;
                }
                iterator.next().onPictureTakenInternal((byte[])var2_2, (int)var3_3, this.h);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onAutoFocus(boolean success, @NotNull Camera camera) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"camera");
        if (this.e) {
            void var1_1;
            super.onAutoFocus((boolean)var1_1, (Camera)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void addPictureCallback(@NotNull BasePictureCallback pictureCallback) {
        void var1_1;
        CameraHost cameraHost = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"pictureCallback");
        cameraHost.b.logMethod();
        Set<BasePictureCallback> set = cameraHost.a;
        synchronized (set) {
            this.a.add((BasePictureCallback)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void removePictureCallback(@NotNull BasePictureCallback pictureCallback) {
        void var1_1;
        CameraHost cameraHost = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"pictureCallback");
        cameraHost.b.logMethod();
        Set<BasePictureCallback> set = cameraHost.a;
        synchronized (set) {
            this.a.remove(var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setDefaultPictureSize(@Nullable Camera.Size defaultPictureSize) {
        void var1_1;
        this.c = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setDefaultPreviewSize(@Nullable Camera.Size defaultPreviewSize) {
        void var1_1;
        this.d = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setAutoFocusSound(boolean autoFocusSoundEnabled) {
        void var1_1;
        this.e = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setShutterSound(boolean shutterSoundEnabled) {
        void var1_1;
        this.f = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setCurrentFinderRectF(@NotNull List<? extends PointF> currentFinderRectF) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"currentFinderRectF");
        this.h = var1_1;
    }
}

