/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.util;

import android.content.Context;
import android.os.Environment;
import android.text.TextUtils;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileUtils {
    private static final String FILE_NAME_EXCEPTIONS_REGULAR_EXPRESSION = "[\\\\|?*<\\\">+\\[\\]/':]";
    private static final Pattern FILE_NAME_ANTIPATTERN = Pattern.compile("[\\\\|?*<\\\">+\\[\\]/':]", 2);
    private static final int MAX_FILE_NAME_LENGTH = 250;
    public static final String SCANBOT_SDK_FILES_DIR = "scanbot-sdk";

    public static boolean isFileNameSafe(CharSequence name) {
        if (TextUtils.isEmpty((CharSequence)name) || name.length() > 250) {
            return false;
        }
        Matcher matcher = FILE_NAME_ANTIPATTERN.matcher(name);
        return !matcher.find();
    }

    public static File getExternalFilesDirOrShowError(Context context, String directoryName) throws IOException {
        File externalFilesDir = null;
        try {
            externalFilesDir = context.getExternalFilesDir(null);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (externalFilesDir == null) {
            return FileUtils.fail();
        }
        File result = new File(externalFilesDir, directoryName);
        if (!result.exists() && !result.mkdir()) {
            return FileUtils.fail();
        }
        return result;
    }

    public static File getExternalStorageDirOrShowError(Context context, String directoryName) throws IOException {
        File externalFilesDir = Environment.getExternalStorageDirectory();
        if (externalFilesDir == null) {
            return FileUtils.fail();
        }
        File result = new File(externalFilesDir, directoryName);
        if (!result.exists() && !result.mkdir()) {
            return FileUtils.fail();
        }
        return result;
    }

    public static File getAppFilesDirOrShowError(Context context, String directoryName) throws IOException {
        File internalFilesDir = null;
        try {
            internalFilesDir = context.getFilesDir();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (internalFilesDir == null) {
            return FileUtils.fail();
        }
        File result = new File(internalFilesDir, directoryName);
        if (!result.exists() && !result.mkdir()) {
            return FileUtils.fail();
        }
        return result;
    }

    public static File getExternalCacheDirOrShowError(Context context, String directoryName) throws IOException {
        File externalCacheDir = context.getExternalCacheDir();
        if (externalCacheDir == null) {
            return FileUtils.fail();
        }
        File result = new File(externalCacheDir, directoryName);
        if (!result.exists() && !result.mkdir()) {
            return FileUtils.fail();
        }
        return result;
    }

    public static boolean ensureDirExists(String directoryPath) {
        if (TextUtils.isEmpty((CharSequence)directoryPath)) {
            return false;
        }
        File dir = new File(directoryPath);
        return dir.exists() || dir.mkdirs();
    }

    public static File getFilesDirOrShowError(String parentDirPath, String directoryName) throws IOException {
        File filesDir = new File(parentDirPath);
        File result = new File(filesDir, directoryName);
        if (!result.exists() && !result.mkdir()) {
            return FileUtils.fail();
        }
        return result;
    }

    private static File fail() throws IOException {
        throw new IOException("can't get external directory");
    }
}

