/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.blob;

import android.content.res.AssetManager;
import io.scanbot.sdk.blob.BlobType;
import io.scanbot.sdk.connectivity.BlobsStorage;
import io.scanbot.sdk.entity.Blob;
import io.scanbot.sdk.persistence.BlobStoreStrategy;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/scanbot/sdk/blob/BlobFactory;", "", "blobStoreStrategy", "Lio/scanbot/sdk/persistence/BlobStoreStrategy;", "blobsStorage", "Lio/scanbot/sdk/connectivity/BlobsStorage;", "assetManager", "Landroid/content/res/AssetManager;", "(Lio/scanbot/sdk/persistence/BlobStoreStrategy;Lio/scanbot/sdk/connectivity/BlobsStorage;Landroid/content/res/AssetManager;)V", "getBlobsForType", "", "Lio/scanbot/sdk/entity/Blob;", "blobType", "Lio/scanbot/sdk/blob/BlobType;", "getRemoteFile", "Ljava/io/File;", "isAvailableInAssets", "", "sdk-base_release"})
public final class BlobFactory {
    private final BlobStoreStrategy blobStoreStrategy;
    private final BlobsStorage blobsStorage;
    private final AssetManager assetManager;

    @NotNull
    public final Collection<Blob> getBlobsForType(@NotNull BlobType blobType) throws IOException {
        Collection collection;
        Intrinsics.checkParameterIsNotNull((Object)((Object)blobType), (String)"blobType");
        String remotePath = this.getRemoteFile(blobType).getPath();
        File localFile = this.blobStoreStrategy.getLocalFileFor(blobType);
        if (blobType.isFolder()) {
            HashSet<Blob> blobs = new HashSet<Blob>();
            String[] models = this.assetManager.list(remotePath);
            if (models != null) {
                for (String model : models) {
                    File modelRemotePath = new File(remotePath, model);
                    String string = new File(localFile, model).getPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"File(localFile, model).path");
                    String string2 = modelRemotePath.getPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"modelRemotePath.path");
                    blobs.add(new Blob(string, string2));
                }
            }
            collection = blobs;
        } else {
            String string = localFile.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localFile.path");
            String string3 = remotePath;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"remotePath");
            collection = SetsKt.setOf((Object)new Blob(string, string3));
        }
        return collection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isAvailableInAssets(@NotNull BlobType blobType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)blobType), (String)"blobType");
        try {
            if (blobType.isFolder()) {
                String[] list = this.assetManager.list(blobType.getFilename());
                if (list == null) return false;
                String[] stringArray = list;
                boolean bl = false;
                String[] stringArray2 = stringArray;
                boolean bl2 = false;
                if (stringArray2.length != 0) return true;
                return false;
            }
            Object[] list = this.assetManager.list("");
            if (list == null) return false;
            if (!ArraysKt.contains((Object[])list, (Object)blobType.getFilename())) return false;
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private final File getRemoteFile(BlobType blobType) {
        return blobType == BlobType.OCR_BLOBS ? new File(this.blobsStorage.ocrBlobsPath().toString()) : new File("", blobType.getFilename());
    }

    public BlobFactory(@NotNull BlobStoreStrategy blobStoreStrategy, @NotNull BlobsStorage blobsStorage, @NotNull AssetManager assetManager) {
        Intrinsics.checkParameterIsNotNull((Object)blobStoreStrategy, (String)"blobStoreStrategy");
        Intrinsics.checkParameterIsNotNull((Object)blobsStorage, (String)"blobsStorage");
        Intrinsics.checkParameterIsNotNull((Object)assetManager, (String)"assetManager");
        this.blobStoreStrategy = blobStoreStrategy;
        this.blobsStorage = blobsStorage;
        this.assetManager = assetManager;
    }
}

