/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.camera;

import android.content.Context;
import android.hardware.Camera;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.RequiresApi;
import com.commonsware.cwac.camera.PictureTransaction;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.camera.CameraHost;
import io.scanbot.sdk.camera.CameraOpenCallback;
import io.scanbot.sdk.camera.CameraPreviewMode;
import io.scanbot.sdk.camera.CameraStateCallback;
import io.scanbot.sdk.camera.CameraTakePictureCallback;
import io.scanbot.sdk.camera.CameraView;
import io.scanbot.sdk.camera.FrameHandler;
import io.scanbot.sdk.camera.PictureCallback;
import io.scanbot.sdk.camera.PreviewBuffer;
import io.scanbot.sdk.security.SapSingleton;
import io.scanbot.sdk.ui.camera.IScanbotCameraView;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import io.scanbot.sdk.util.snap.Utils;
import io.scanbot.sdk.util.thread.ExecutionUtils;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScanbotCameraView
extends FrameLayout
implements IScanbotCameraView {
    private static final int TAKE_PICTURE_DELAY_MS = 500;
    private CameraView cameraView;
    private CameraHost cameraHost;
    private boolean resumed = false;
    private State state = State.IDLE;
    private final Set<CameraStateCallback> stateCallbacks = new LinkedHashSet<CameraStateCallback>();
    private final Set<CameraTakePictureCallback> takePictureCallbacks = new LinkedHashSet<CameraTakePictureCallback>();
    private final Logger logger = LoggerProvider.getLogger();

    public ScanbotCameraView(Context context) {
        super(context);
        this.initView(context);
    }

    public ScanbotCameraView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    private void initView(Context context) {
        SapSingleton.getInstance().checkLicenseStatus(SdkFeature.NoSdkFeature);
        this.cameraView = new CameraView(context);
        this.cameraHost = new CameraHost(context);
        this.cameraView.setCameraHost((com.commonsware.cwac.camera.CameraHost)this.cameraHost);
        this.cameraView.setAutofocusCallback(new AutofocusCallbackImpl());
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        layoutParams.gravity = 17;
        this.addView((View)this.cameraView, 0, (ViewGroup.LayoutParams)layoutParams);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.logger.logMethod();
        super.onLayout(changed, left, top, right, bottom);
        View cameraSurface = this.cameraView.getChildAt(0);
        if (cameraSurface == null) {
            return;
        }
        int childCount = this.getChildCount();
        int surfaceWidthSpec = View.MeasureSpec.makeMeasureSpec((int)cameraSurface.getWidth(), (int)Integer.MIN_VALUE);
        int surfaceHeightSpec = View.MeasureSpec.makeMeasureSpec((int)cameraSurface.getHeight(), (int)Integer.MIN_VALUE);
        for (int i = 1; i < childCount; ++i) {
            View view = this.getChildAt(i);
            if (view instanceof CameraView) continue;
            view.measure(surfaceWidthSpec, surfaceHeightSpec);
            view.layout(cameraSurface.getLeft(), cameraSurface.getTop(), cameraSurface.getRight(), cameraSurface.getBottom());
        }
    }

    public PreviewBuffer getPreviewBuffer() {
        return this.cameraView.getPreviewBuffer();
    }

    public void onResume() {
        ExecutionUtils.ensureMainThread();
        this.logger.logMethod();
        if (this.resumed) {
            return;
        }
        this.resumed = SapSingleton.getInstance().checkLicenseStatusSilently(SdkFeature.NoSdkFeature);
        this.state = State.IDLE;
        this.cameraView.onResume();
        this.notifyResumedState();
    }

    public void onPause() {
        ExecutionUtils.ensureMainThread();
        this.logger.logMethod();
        if (!this.resumed) {
            return;
        }
        this.resumed = false;
        this.state = State.IDLE;
        this.cameraView.onPause();
        this.notifyPausedState();
    }

    private void notifyResumedState() {
        for (CameraStateCallback callback : this.stateCallbacks) {
            callback.onResume();
        }
    }

    private void notifyPausedState() {
        for (CameraStateCallback callback : this.stateCallbacks) {
            callback.onPause();
        }
    }

    private void notifyTakePictureCancelled() {
        for (CameraTakePictureCallback callback : this.takePictureCallbacks) {
            callback.onTakePictureCancelled();
        }
    }

    public void startPreview() {
        this.logger.logMethod();
        if (!this.resumed) {
            return;
        }
        this.state = State.IDLE;
        this.cameraView.startPreview();
    }

    public void stopPreview() {
        this.logger.logMethod();
        if (!this.resumed) {
            return;
        }
        this.state = State.IDLE;
        this.cameraView.stopPreview();
    }

    @Override
    public void takePicture(boolean aquireFocus) {
        this.logger.logMethod();
        if (!SapSingleton.getInstance().checkLicenseStatus(SdkFeature.NoSdkFeature).booleanValue()) {
            return;
        }
        if (this.state != State.IDLE) {
            this.state = State.IDLE;
            this.notifyTakePictureCancelled();
            if (!this.resumed) {
                return;
            }
        }
        if (aquireFocus) {
            this.state = State.PENDING_SHOOT;
            this.autoFocus();
        } else {
            this.performSnapping();
        }
    }

    private void performSnapping() {
        this.state = State.SHOOTING;
        try {
            Camera.Parameters cameraParameters = this.cameraView.getCameraParameters();
            PictureTransaction pictureTransaction = new PictureTransaction((com.commonsware.cwac.camera.CameraHost)this.cameraHost).needBitmap(false).needByteArray(true).useSingleShotMode(true);
            if (cameraParameters != null) {
                pictureTransaction = pictureTransaction.flashMode(cameraParameters.getFlashMode());
            }
            this.cameraView.takePicture(pictureTransaction);
        }
        catch (IllegalStateException e) {
            this.state = State.IDLE;
            this.notifyTakePictureCancelled();
        }
    }

    @Override
    public void useFlash(boolean useFlash) {
        this.logger.logMethod();
        if (!this.resumed) {
            return;
        }
        Camera.Parameters parameters = this.cameraView.getCameraParameters();
        if (Utils.isFlashSupported(parameters)) {
            this.cameraView.setFlashMode(useFlash ? "torch" : "off");
        }
    }

    @Override
    public void setAutoFocusOnTouch(boolean autoFocusOnTouch) {
        this.cameraView.setAutoFocusOnTouch(autoFocusOnTouch);
    }

    @Override
    public void autoFocus() {
        this.logger.logMethod();
        if (!this.resumed) {
            return;
        }
        this.cameraView.autoFocus();
    }

    @Override
    public void continuousFocus() {
        this.logger.logMethod();
        if (!this.resumed) {
            return;
        }
        this.cameraView.continuousFocus();
    }

    @Override
    public void addPictureCallback(PictureCallback pictureCallback) {
        this.logger.logMethod();
        this.cameraView.addPictureCallback(pictureCallback);
    }

    @Override
    public void removePictureCallback(PictureCallback pictureCallback) {
        this.logger.logMethod();
        this.cameraView.removePictureCallback(pictureCallback);
    }

    @Override
    public void addCameraStateCallback(CameraStateCallback cameraStateCallback) {
        this.logger.logMethod();
        this.stateCallbacks.add(cameraStateCallback);
    }

    @Override
    public void removeCameraStateCallback(CameraStateCallback cameraStateCallback) {
        this.logger.logMethod();
        this.stateCallbacks.remove(cameraStateCallback);
    }

    @Override
    public void addTakePictureCallback(CameraTakePictureCallback cameraTakePictureCallback) {
        this.logger.logMethod();
        this.takePictureCallbacks.add(cameraTakePictureCallback);
    }

    @Override
    public void removeTakePictureCallback(CameraTakePictureCallback cameraTakePictureCallback) {
        this.logger.logMethod();
        this.takePictureCallbacks.remove(cameraTakePictureCallback);
    }

    @Override
    public void setCameraOpenCallback(CameraOpenCallback cameraOpenCallback) {
        this.logger.logMethod();
        this.cameraView.setCameraOpenCallback(cameraOpenCallback);
    }

    public List<Camera.Size> getSupportedPictureSizes() {
        this.logger.logMethod();
        Camera.Parameters cameraParameters = this.cameraView.getCameraParameters();
        if (cameraParameters != null) {
            return cameraParameters.getSupportedPictureSizes();
        }
        return Collections.EMPTY_LIST;
    }

    public List<Camera.Size> getSupportedPreviewSizes() {
        this.logger.logMethod();
        Camera.Parameters cameraParameters = this.cameraView.getCameraParameters();
        if (cameraParameters != null) {
            return cameraParameters.getSupportedPreviewSizes();
        }
        return Collections.EMPTY_LIST;
    }

    public void setPictureSize(Camera.Size pictureSize) {
        this.logger.logMethod();
        this.cameraHost.setDefaultPictureSize(pictureSize);
        Camera.Parameters cameraParameters = this.cameraView.getCameraParameters();
        if (cameraParameters != null) {
            cameraParameters.setPictureSize(pictureSize.width, pictureSize.height);
            this.cameraView.setCameraParameters(cameraParameters);
        }
    }

    public void setPreviewSize(Camera.Size previewSize) {
        this.logger.logMethod();
        this.cameraHost.setDefaultPreviewSize(previewSize);
        Camera.Parameters cameraParameters = this.cameraView.getCameraParameters();
        if (cameraParameters != null) {
            cameraParameters.setPreviewSize(previewSize.width, previewSize.height);
            this.cameraView.setCameraParameters(cameraParameters);
        }
    }

    public void setAutoFocusSound(boolean enabled) {
        this.logger.logMethod();
        this.cameraHost.setAutoFocusSound(enabled);
    }

    @RequiresApi(api=17)
    public void setShutterSound(boolean enabled) {
        this.logger.logMethod();
        this.cameraHost.setShutterSound(enabled);
        this.cameraView.setShutterSound(enabled);
    }

    @Override
    public void setPreviewMode(CameraPreviewMode mode) {
        this.logger.logMethod();
        this.cameraHost.setPreviewMode(mode);
    }

    @Deprecated
    public void lockToPortrait() {
        this.logger.logMethod();
        this.cameraView.lockToPortrait();
    }

    @Deprecated
    public void lockToLandscape() {
        this.logger.logMethod();
        this.cameraView.lockToLandscape();
    }

    @Override
    public void lockToPortrait(boolean lockPicture) {
        this.logger.logMethod();
        this.cameraView.lockToPortrait(lockPicture);
    }

    @Override
    public void lockToLandscape(boolean lockPicture) {
        this.logger.logMethod();
        this.cameraView.lockToLandscape(lockPicture);
    }

    @Override
    public void unlockOrientation() {
        this.logger.logMethod();
        this.cameraView.unlockOrientation();
    }

    @Override
    public void addFrameHandler(@NotNull FrameHandler frameHandler) {
        this.cameraView.getPreviewBuffer().addFrameHandler(frameHandler);
    }

    @Override
    public void removeFrameHandler(@Nullable FrameHandler frameHandler) {
        this.cameraView.getPreviewBuffer().removeFrameHandler(frameHandler);
    }

    private static enum State {
        IDLE,
        PENDING_SHOOT,
        SHOOTING;

    }

    private class AutofocusCallbackImpl
    implements CameraView.AutofocusCallback {
        private AutofocusCallbackImpl() {
        }

        @Override
        public void onAutoFocusCompleted() {
            ScanbotCameraView.this.logger.logMethod();
            ScanbotCameraView.this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (ScanbotCameraView.this.state == State.PENDING_SHOOT) {
                        ScanbotCameraView.this.performSnapping();
                    } else {
                        ScanbotCameraView.this.state = State.IDLE;
                        ScanbotCameraView.this.notifyTakePictureCancelled();
                    }
                }
            }, 500L);
        }
    }
}

