/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.camera.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.ImageFormat;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.YuvImage;
import androidx.camera.core.ImageProxy;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\bH\u0007J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\rH\u0007\u00a8\u0006\u000e"}, d2={"Lio/scanbot/sdk/ui/camera/util/PreviewImageUtil;", "", "()V", "convertNV21ToBitmap", "Landroid/graphics/Bitmap;", "nv21Image", "", "imageWidth", "", "imageHeight", "imageOrientation", "convertYUV420toNV21", "image", "Landroidx/camera/core/ImageProxy;", "sdk-base_release"})
public final class PreviewImageUtil {
    public static final PreviewImageUtil INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final Bitmap convertNV21ToBitmap(@NotNull byte[] nv21Image, int imageWidth, int imageHeight, int imageOrientation) {
        Intrinsics.checkParameterIsNotNull((Object)nv21Image, (String)"nv21Image");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Closeable closeable = outputStream;
        boolean bl = false;
        Throwable throwable = null;
        try {
            ByteArrayOutputStream os = (ByteArrayOutputStream)closeable;
            boolean bl2 = false;
            YuvImage yuvImage = new YuvImage(nv21Image, 17, imageWidth, imageHeight, null);
            yuvImage.compressToJpeg(new Rect(0, 0, imageWidth, imageHeight), 100, (OutputStream)os);
            byte[] previewByteArray = os.toByteArray();
            Bitmap resultBitmap = BitmapFactory.decodeByteArray((byte[])previewByteArray, (int)0, (int)previewByteArray.length);
            if (imageOrientation != 0) {
                Matrix matrix = new Matrix();
                matrix.postRotate((float)imageOrientation);
                resultBitmap = Bitmap.createBitmap((Bitmap)resultBitmap, (int)0, (int)0, (int)imageWidth, (int)imageHeight, (Matrix)matrix, (boolean)false);
            }
            Bitmap bitmap = resultBitmap;
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"resultBitmap");
            Bitmap bitmap2 = bitmap;
            return bitmap2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ Bitmap convertNV21ToBitmap$default(byte[] byArray, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 8) != 0) {
            n3 = 0;
        }
        return PreviewImageUtil.convertNV21ToBitmap(byArray, n, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final byte[] convertYUV420toNV21(@NotNull ImageProxy image) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        Rect rect = image.getCropRect();
        Intrinsics.checkExpressionValueIsNotNull((Object)rect, (String)"image.cropRect");
        Rect crop = rect;
        int format = image.getFormat();
        int width = crop.width();
        int height = crop.height();
        ImageProxy.PlaneProxy[] planeProxyArray = image.getPlanes();
        Intrinsics.checkExpressionValueIsNotNull((Object)planeProxyArray, (String)"image.planes");
        ImageProxy.PlaneProxy[] planes = planeProxyArray;
        byte[] data = new byte[width * height * ImageFormat.getBitsPerPixel((int)format) / 8];
        ImageProxy.PlaneProxy planeProxy = planes[0];
        Intrinsics.checkExpressionValueIsNotNull((Object)planeProxy, (String)"planes[0]");
        byte[] rowData = new byte[planeProxy.getRowStride()];
        int channelOffset = 0;
        int outputStride = 1;
        int n = 0;
        int n2 = planes.length;
        while (n < n2) {
            ByteBuffer buffer;
            void i;
            switch (i) {
                case 0: {
                    channelOffset = 0;
                    outputStride = 1;
                    break;
                }
                case 1: {
                    channelOffset = width * height + 1;
                    outputStride = 2;
                    break;
                }
                case 2: {
                    channelOffset = width * height;
                    outputStride = 2;
                    break;
                }
            }
            ImageProxy.PlaneProxy planeProxy2 = planes[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)planeProxy2, (String)"planes[i]");
            Intrinsics.checkExpressionValueIsNotNull((Object)planeProxy2.getBuffer(), (String)"planes[i].buffer");
            ImageProxy.PlaneProxy planeProxy3 = planes[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)planeProxy3, (String)"planes[i]");
            int rowStride = planeProxy3.getRowStride();
            ImageProxy.PlaneProxy planeProxy4 = planes[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)planeProxy4, (String)"planes[i]");
            int pixelStride = planeProxy4.getPixelStride();
            int shift = i == false ? 0 : 1;
            int w = width >> shift;
            int h = height >> shift;
            buffer.position(rowStride * (crop.top >> shift) + pixelStride * (crop.left >> shift));
            int n3 = 0;
            int n4 = h;
            while (n3 < n4) {
                void row;
                int length = 0;
                if (pixelStride == 1 && outputStride == 1) {
                    length = w;
                    buffer.get(data, channelOffset, length);
                    channelOffset += length;
                } else {
                    length = (w - 1) * pixelStride + 1;
                    buffer.get(rowData, 0, length);
                    int n5 = 0;
                    int n6 = w;
                    while (n5 < n6) {
                        void col;
                        data[channelOffset] = rowData[col * pixelStride];
                        channelOffset += outputStride;
                        ++col;
                    }
                }
                if (row < h - 1) {
                    buffer.position(buffer.position() + rowStride - length);
                }
                ++row;
            }
            ++i;
        }
        return data;
    }

    private PreviewImageUtil() {
    }

    static {
        PreviewImageUtil previewImageUtil;
        INSTANCE = previewImageUtil = new PreviewImageUtil();
    }
}

