/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.camera;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ImageFormat;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.Camera;
import android.os.Handler;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.annotation.RequiresApi;
import androidx.core.content.ContextCompat;
import com.commonsware.cwac.camera.DeviceProfile;
import com.commonsware.cwac.camera.PictureTransaction;
import io.scanbot.sdk.base.R;
import io.scanbot.sdk.camera.CameraHost;
import io.scanbot.sdk.camera.CameraOpenCallback;
import io.scanbot.sdk.camera.CameraPreviewMode;
import io.scanbot.sdk.camera.CameraView;
import io.scanbot.sdk.camera.FrameHandler;
import io.scanbot.sdk.camera.IFinderView;
import io.scanbot.sdk.camera.PictureCallback;
import io.scanbot.sdk.camera.PreviewBuffer;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import io.scanbot.sdk.util.snap.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 ]2\u00020\u0001:\u0003\\]^B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*J\u0014\u0010+\u001a\u00020(2\n\u0010,\u001a\u00060-R\u00020\u0011H\u0002J\u0014\u0010.\u001a\u00020(2\n\u0010/\u001a\u000600R\u00020\u0011H\u0002J\u0014\u00101\u001a\u00020(2\n\u0010/\u001a\u000600R\u00020\u0011H\u0002J\b\u00102\u001a\u00020(H\u0016J\u0010\u0010\f\u001a\u00020(2\u0006\u00103\u001a\u000204H\u0002J\"\u00105\u001a\u0004\u0018\u0001062\u0006\u00107\u001a\u00020\u00182\u0006\u00108\u001a\u00020\u00182\u0006\u00109\u001a\u00020:H\u0002J\"\u0010;\u001a\u0004\u0018\u0001062\u0006\u00107\u001a\u00020\u00182\u0006\u00108\u001a\u00020\u00182\u0006\u00109\u001a\u00020:H\u0002J\b\u0010<\u001a\u00020(H\u0016J\u0006\u0010=\u001a\u00020(J\u0010\u0010>\u001a\u00020(2\u0006\u0010?\u001a\u00020@H\u0014J\b\u0010A\u001a\u00020(H\u0002J\u0006\u0010B\u001a\u00020CJ\b\u0010D\u001a\u00020\rH\u0016J\u0018\u0010E\u001a\u00020(2\u0006\u0010F\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010G\u001a\u00020(2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010H\u001a\u00020(H\u0014J\b\u0010I\u001a\u00020(H\u0016J\b\u0010J\u001a\u00020(H\u0016J\u0010\u0010K\u001a\u00020\r2\u0006\u00103\u001a\u000204H\u0016J\u0010\u0010L\u001a\u00020\u00182\u0006\u0010M\u001a\u00020NH\u0002J\u0010\u0010O\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*J\u000e\u0010P\u001a\u00020(2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010Q\u001a\u00020(2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010R\u001a\u00020(2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0010\u0010S\u001a\u00020(2\u0006\u0010T\u001a\u00020\rH\u0007J\b\u0010U\u001a\u00020(H\u0016J\b\u0010V\u001a\u00020(H\u0014J\b\u0010W\u001a\u00020(H\u0016J\u0010\u0010X\u001a\u00020(2\u0006\u0010Y\u001a\u00020ZH\u0016J\u0010\u0010[\u001a\u00020(2\u0006\u0010F\u001a\u00020\rH\u0002R\u001c\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010!\u001a\u00060\"R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006_"}, d2={"Lio/scanbot/sdk/camera/CameraView;", "Lcom/commonsware/cwac/camera/CameraView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "areas", "", "Landroid/hardware/Camera$Area;", "getAreas", "()Ljava/util/List;", "autoFocusHandler", "Landroid/os/Handler;", "autoFocusOnTouch", "", "autofocusCallback", "Lio/scanbot/sdk/camera/CameraView$AutofocusCallback;", "camera", "Landroid/hardware/Camera;", "cameraAvailable", "cameraOpenCallback", "Lio/scanbot/sdk/camera/CameraOpenCallback;", "cancelAutoFocusAndStartContinuousRunnable", "Ljava/lang/Runnable;", "finderInnerThresholdPx", "", "finderOuterThresholdPx", "isAutoFocusing", "lastFocusedTime", "", "logger", "Lio/scanbot/sdk/util/log/Logger;", "polygon", "Landroid/graphics/PointF;", "previewBuffer", "Lio/scanbot/sdk/camera/CameraView$PreviewBufferImpl;", "touchFocusPaint", "Landroid/graphics/Paint;", "touchRect", "Landroid/graphics/Rect;", "addPictureCallback", "", "pictureCallback", "Lio/scanbot/sdk/camera/PictureCallback;", "adjustFinderView", "previewSize", "Landroid/hardware/Camera$Size;", "applyAdvancedParameter", "parameters", "Landroid/hardware/Camera$Parameters;", "applyFocusAndMeteringArea", "autoFocus", "event", "Landroid/view/MotionEvent;", "calculateFinderRectF", "Landroid/graphics/RectF;", "previewWidth", "previewHeight", "previewMode", "Lio/scanbot/sdk/camera/CameraPreviewMode;", "calculateVisibleRectF", "cancelAutoFocus", "continuousFocus", "dispatchDraw", "canvas", "Landroid/graphics/Canvas;", "enableContinuousFocusWithDelay", "getPreviewBuffer", "Lio/scanbot/sdk/camera/PreviewBuffer;", "isAutoFocusAvailable", "onAutoFocus", "success", "onCameraOpen", "onDetachedFromWindow", "onPause", "onResume", "onTouchEvent", "polygonCoordToAreaCoord", "coordinate", "", "removePictureCallback", "setAutoFocusOnTouch", "setAutofocusCallback", "setCameraOpenCallback", "setShutterSound", "enabled", "startPreview", "startPreviewSync", "stopPreview", "takePicture", "xact", "Lcom/commonsware/cwac/camera/PictureTransaction;", "updateTouchRect", "AutofocusCallback", "Companion", "PreviewBufferImpl", "sdk-base_release"})
public final class CameraView
extends com.commonsware.cwac.camera.CameraView {
    private Camera camera;
    private final Handler autoFocusHandler;
    private final Runnable cancelAutoFocusAndStartContinuousRunnable;
    private long lastFocusedTime;
    private List<? extends PointF> polygon;
    private boolean autoFocusOnTouch;
    private boolean isAutoFocusing;
    private boolean cameraAvailable;
    private final Paint touchFocusPaint;
    private Rect touchRect;
    private final PreviewBufferImpl previewBuffer;
    private final Logger logger;
    private AutofocusCallback autofocusCallback;
    private CameraOpenCallback cameraOpenCallback;
    private final int finderInnerThresholdPx;
    private final int finderOuterThresholdPx;
    private static final int AUTO_FOCUS_TIMEOUT_MS = 5000;
    private static final int DELAY_REFOCUSING_NEEDED_MS = 3000;
    private static final int DELAY_HIDE_TOUCH_FOCUS_MS = 1000;
    private static final int DELAY_ENABLE_CONTINUOUS_FOCUS_MS = 1000;
    private static final int DEFAULT_FOCUS_AREA_SIZE = 75;
    private static final int AREA_WEIGHT = 1000;
    private static final int MIN_AREA_COORD = -1000;
    private static final int MAX_AREA_COORD = 1000;
    private static final String SAMSUNG_SCENE_MODE_TEXT = "text";
    private static final int MAX_FRAMES_IN_PROCESSING = 1;
    public static final Companion Companion = new Companion(null);

    public void onCameraOpen(@NotNull Camera camera) throws RuntimeException {
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        this.logger.logMethod();
        super.onCameraOpen(camera);
        this.camera = camera;
        this.post(new Runnable(this){
            final /* synthetic */ CameraView this$0;

            public final void run() {
                CameraView.access$getCameraOpenCallback$p(this.this$0).onCameraOpened();
            }
            {
                this.this$0 = cameraView;
            }
        });
    }

    public void autoFocus() {
        this.logger.logMethod();
        this.post(new Runnable(this){
            final /* synthetic */ CameraView this$0;

            public final void run() {
                if (System.currentTimeMillis() - CameraView.access$getLastFocusedTime$p(this.this$0) < (long)3000 || !this.this$0.isAutoFocusAvailable()) {
                    CameraView.access$getAutofocusCallback$p(this.this$0).onAutoFocusCompleted();
                    return;
                }
                CameraView.access$getAutoFocusHandler$p(this.this$0).removeCallbacks(CameraView.access$getCancelAutoFocusAndStartContinuousRunnable$p(this.this$0));
                CameraView.access$getAutoFocusHandler$p(this.this$0).postDelayed(CameraView.access$getCancelAutoFocusAndStartContinuousRunnable$p(this.this$0), (long)5000);
                CameraView.access$setAutoFocusing$p(this.this$0, true);
                try {
                    Camera.Parameters params = this.this$0.getCameraParameters();
                    Utils.enableAutoFocus(params);
                    Camera.Parameters parameters = params;
                    Intrinsics.checkNotNullExpressionValue((Object)parameters, (String)"params");
                    CameraView.access$applyFocusAndMeteringArea(this.this$0, parameters);
                    this.this$0.setCameraParameters(params);
                    CameraView.access$autoFocus$s-18599030(this.this$0);
                }
                catch (RuntimeException e) {
                    CameraView.access$getLogger$p(this.this$0).logException(e);
                }
            }
            {
                this.this$0 = cameraView;
            }
        });
    }

    public void cancelAutoFocus() {
        this.logger.logMethod();
        super.cancelAutoFocus();
        this.isAutoFocusing = false;
        this.autoFocusHandler.removeCallbacks(this.cancelAutoFocusAndStartContinuousRunnable);
        this.post(new Runnable(this){
            final /* synthetic */ CameraView this$0;

            public final void run() {
                CameraView.access$updateTouchRect(this.this$0, false);
            }
            {
                this.this$0 = cameraView;
            }
        });
    }

    public boolean isAutoFocusAvailable() {
        this.logger.logMethod();
        return super.isAutoFocusAvailable() && !this.isAutoFocusing;
    }

    public final void setAutofocusCallback(@Nullable AutofocusCallback autofocusCallback) {
        this.logger.logMethod();
        AutofocusCallback autofocusCallback2 = autofocusCallback;
        if (autofocusCallback2 == null) {
            autofocusCallback2 = AutofocusCallback.Companion.getNULL();
        }
        this.autofocusCallback = autofocusCallback2;
    }

    public final void setCameraOpenCallback(@Nullable CameraOpenCallback cameraOpenCallback) {
        this.logger.logMethod();
        CameraOpenCallback cameraOpenCallback2 = cameraOpenCallback;
        if (cameraOpenCallback2 == null) {
            cameraOpenCallback2 = CameraOpenCallback.NULL;
        }
        this.cameraOpenCallback = cameraOpenCallback2;
    }

    private final void applyFocusAndMeteringArea(Camera.Parameters parameters) {
        if (parameters.getMaxNumFocusAreas() > 0) {
            parameters.setFocusAreas(this.getAreas());
        }
        if (parameters.getMaxNumMeteringAreas() > 0) {
            parameters.setMeteringAreas(this.getAreas());
        }
    }

    private final List<Camera.Area> getAreas() {
        Rect areaRect = null;
        List areas = null;
        if (this.touchRect != null) {
            Rect rect = this.touchRect;
            Intrinsics.checkNotNull((Object)rect);
            int n = this.polygonCoordToAreaCoord((float)rect.left / (float)this.getWidth());
            Rect rect2 = this.touchRect;
            Intrinsics.checkNotNull((Object)rect2);
            int n2 = this.polygonCoordToAreaCoord((float)rect2.top / (float)this.getHeight());
            Rect rect3 = this.touchRect;
            Intrinsics.checkNotNull((Object)rect3);
            int n3 = this.polygonCoordToAreaCoord((float)rect3.right / (float)this.getWidth());
            Rect rect4 = this.touchRect;
            Intrinsics.checkNotNull((Object)rect4);
            areaRect = new Rect(n, n2, n3, this.polygonCoordToAreaCoord((float)rect4.bottom / (float)this.getHeight()));
        } else {
            Collection collection = this.polygon;
            boolean bl = false;
            if (!collection.isEmpty()) {
                float minX = 1.0f;
                float maxX = 0.0f;
                float minY = 1.0f;
                float maxY = 0.0f;
                for (PointF pointF : this.polygon) {
                    float f = pointF.x;
                    boolean bl2 = false;
                    minX = Math.min(f, minX);
                    f = pointF.x;
                    bl2 = false;
                    maxX = Math.max(f, maxX);
                    f = pointF.y;
                    bl2 = false;
                    minY = Math.min(f, minY);
                    f = pointF.y;
                    bl2 = false;
                    maxY = Math.max(f, maxY);
                }
                float f = (maxX - minX) / (float)2 - 0.075f;
                float right = (maxX - minX) / (float)2 + 0.075f;
                float top = minY;
                float bottom = maxY;
                areaRect = new Rect(this.polygonCoordToAreaCoord(f), this.polygonCoordToAreaCoord(top), this.polygonCoordToAreaCoord(right), this.polygonCoordToAreaCoord(bottom));
            } else {
                areaRect = new Rect(-75, -75, 75, 75);
            }
        }
        Camera.Area area = new Camera.Area(areaRect, 1000);
        areas = new ArrayList();
        areas.add(area);
        return areas;
    }

    private final int polygonCoordToAreaCoord(float coordinate) {
        int result = MathKt.roundToInt((float)(coordinate * (float)1000 * (float)2 + (float)-1000));
        if (result > 1000) {
            result = 1000;
        }
        if (result < -1000) {
            result = -1000;
        }
        return result;
    }

    public void onAutoFocus(boolean success, @NotNull Camera camera) {
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        this.logger.logMethod();
        this.post(new Runnable(this, success, camera){
            final /* synthetic */ CameraView this$0;
            final /* synthetic */ boolean $success;
            final /* synthetic */ Camera $camera;

            public final void run() {
                if (CameraView.access$isAutoFocusing$p(this.this$0)) {
                    CameraView.access$updateTouchRect(this.this$0, this.$success);
                    CameraView.access$getAutoFocusHandler$p(this.this$0).removeCallbacks(CameraView.access$getCancelAutoFocusAndStartContinuousRunnable$p(this.this$0));
                    CameraView.access$setAutoFocusing$p(this.this$0, false);
                    CameraView.access$onAutoFocus$s-18599030(this.this$0, this.$success, this.$camera);
                }
                CameraView.access$setLastFocusedTime$p(this.this$0, this.$success ? System.currentTimeMillis() : 0L);
                CameraView.access$getAutofocusCallback$p(this.this$0).onAutoFocusCompleted();
            }
            {
                this.this$0 = cameraView;
                this.$success = bl;
                this.$camera = camera;
            }
        });
    }

    private final void updateTouchRect(boolean success) {
        if (this.touchRect != null) {
            if (this.touchFocusPaint.getColor() != -1) {
                this.touchFocusPaint.setAlpha(0);
                this.invalidate();
                return;
            }
            this.touchFocusPaint.setColor(ContextCompat.getColor((Context)this.getContext(), (int)(success ? 17170452 : 0x1060016)));
            this.invalidate();
            this.postDelayed(new Runnable(this){
                final /* synthetic */ CameraView this$0;

                public final void run() {
                    if (CameraView.access$getTouchFocusPaint$p(this.this$0).getColor() != -1) {
                        CameraView.access$getTouchFocusPaint$p(this.this$0).setAlpha(0);
                        this.this$0.invalidate();
                    }
                }
                {
                    this.this$0 = cameraView;
                }
            }, 1000);
        }
    }

    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getAction() == 0 && this.isAutoFocusAvailable() && this.autoFocusOnTouch) {
            this.autoFocusOnTouch(event);
            return true;
        }
        return super.onTouchEvent(event);
    }

    private final void autoFocusOnTouch(MotionEvent event) {
        this.touchFocusPaint.setColor(this.getResources().getColor(17170443));
        float x = event.getX();
        float y = event.getY();
        this.touchRect = new Rect((int)(x - (float)75), (int)(y - (float)75), (int)(x + (float)75), (int)(y + (float)75));
        this.invalidate();
        this.autoFocus();
    }

    protected void dispatchDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.dispatchDraw(canvas);
        if (this.touchRect != null) {
            canvas.drawRect(this.touchRect, this.touchFocusPaint);
        }
    }

    public void onResume() {
        this.logger.logMethod();
        super.onResume();
        this.cameraAvailable = true;
    }

    public void onPause() {
        this.logger.logMethod();
        this.removeCallbacks(this.cancelAutoFocusAndStartContinuousRunnable);
        super.onPause();
        this.cameraAvailable = false;
        this.previewBuffer.deleteFrame();
    }

    public void startPreview() {
        Camera.Parameters parameters;
        this.logger.logMethod();
        if (this.cameraAvailable && (parameters = this.getCameraParameters()) != null) {
            super.startPreview();
        }
    }

    protected void startPreviewSync() {
        this.logger.logMethod();
        if (this.cameraAvailable) {
            this.polygon = CollectionsKt.emptyList();
            this.touchRect = null;
            this.isAutoFocusing = false;
            Camera.Parameters parameters = this.getCameraParameters();
            if (parameters != null) {
                this.applyAdvancedParameter(parameters);
                this.applyFocusAndMeteringArea(parameters);
                this.setCameraParametersSync(parameters);
                Camera.Size previewSize = this.getPreviewSize();
                if (previewSize != null) {
                    this.previewBuffer.allocateFrame(previewSize.width, previewSize.height);
                    this.adjustFinderView(previewSize);
                }
                super.startPreviewSync();
            }
            this.enableContinuousFocusWithDelay();
        }
    }

    private final void enableContinuousFocusWithDelay() {
        this.postDelayed(this.cancelAutoFocusAndStartContinuousRunnable, 1000);
    }

    public void takePicture(@NotNull PictureTransaction xact) {
        Intrinsics.checkNotNullParameter((Object)xact, (String)"xact");
        this.logger.logMethod();
        super.takePicture(xact);
    }

    private final void applyAdvancedParameter(Camera.Parameters parameters) {
        List sceneModes;
        Camera.Size pictureSize = this.getCameraHost().getPictureSize(null, parameters);
        parameters.setPictureSize(pictureSize.width, pictureSize.height);
        parameters.setPictureFormat(256);
        com.commonsware.cwac.camera.CameraHost cameraHost = this.getCameraHost();
        Intrinsics.checkNotNullExpressionValue((Object)cameraHost, (String)"cameraHost");
        DeviceProfile deviceProfile = cameraHost.getDeviceProfile();
        Intrinsics.checkNotNullExpressionValue((Object)deviceProfile, (String)"cameraHost.deviceProfile");
        if (!deviceProfile.isCustomRom()) {
            parameters.setJpegQuality(100);
        }
        if ((sceneModes = parameters.getSupportedSceneModes()) != null && sceneModes.contains(SAMSUNG_SCENE_MODE_TEXT)) {
            parameters.setSceneMode(SAMSUNG_SCENE_MODE_TEXT);
        }
    }

    private final void adjustFinderView(Camera.Size previewSize) {
        if (this.getParent() != null) {
            ViewParent viewParent = this.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)viewParent, (String)"this@CameraView.parent");
            if (viewParent.getParent() != null) {
                ViewParent viewParent2 = this.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)viewParent2, (String)"this@CameraView.parent");
                ViewParent viewParent3 = viewParent2.getParent();
                if (!(viewParent3 instanceof ViewGroup)) {
                    viewParent3 = null;
                }
                ViewGroup viewGroup = (ViewGroup)viewParent3;
                if (viewGroup == null) {
                    return;
                }
                ViewGroup parent = viewGroup;
                View view = parent.findViewById(R.id.finder_overlay);
                if (view == null) {
                    return;
                }
                View finderOverlay = view;
                int displayOrientation = this.getDisplayOrientation();
                int previewWidth = 0;
                int previewHeight = 0;
                if (displayOrientation == 0 || displayOrientation == 180) {
                    previewWidth = previewSize.width < previewSize.height ? previewSize.height : previewSize.width;
                    previewHeight = previewSize.width < previewSize.height ? previewSize.width : previewSize.height;
                } else {
                    previewWidth = previewSize.width > previewSize.height ? previewSize.height : previewSize.width;
                    int n = previewHeight = previewSize.width > previewSize.height ? previewSize.width : previewSize.height;
                }
                if (finderOverlay instanceof IFinderView) {
                    com.commonsware.cwac.camera.CameraHost cameraHost = this.getCameraHost();
                    if (cameraHost == null) {
                        throw new NullPointerException("null cannot be cast to non-null type io.scanbot.sdk.camera.CameraHost");
                    }
                    CameraPreviewMode previewMode = ((CameraHost)cameraHost).getPreviewMode();
                    ((IFinderView)finderOverlay).setCameraParameters(previewWidth, previewHeight, previewMode);
                }
            }
        }
    }

    public void stopPreview() {
        this.logger.logMethod();
        if (this.cameraAvailable) {
            super.stopPreview();
        }
    }

    protected void onDetachedFromWindow() {
        this.logger.logMethod();
        super.onDetachedFromWindow();
        this.previewBuffer.dispose();
    }

    public final void setAutoFocusOnTouch(boolean autoFocusOnTouch) {
        this.autoFocusOnTouch = autoFocusOnTouch;
    }

    public final void continuousFocus() {
        this.logger.logMethod();
        this.cancelAutoFocus();
        try {
            Camera.Parameters params = this.getCameraParameters();
            Utils.enableContinuousFocus(params);
            this.setCameraParameters(params);
        }
        catch (RuntimeException e) {
            this.logger.logException(e);
        }
    }

    @NotNull
    public final PreviewBuffer getPreviewBuffer() {
        return this.previewBuffer;
    }

    public final void addPictureCallback(@Nullable PictureCallback pictureCallback) {
        this.logger.logMethod();
        com.commonsware.cwac.camera.CameraHost cameraHost = this.getCameraHost();
        if (cameraHost == null) {
            throw new NullPointerException("null cannot be cast to non-null type io.scanbot.sdk.camera.CameraHost");
        }
        CameraHost cameraHost2 = (CameraHost)cameraHost;
        PictureCallback pictureCallback2 = pictureCallback;
        Intrinsics.checkNotNull((Object)pictureCallback2);
        cameraHost2.addPictureCallback(pictureCallback2);
    }

    public final void removePictureCallback(@Nullable PictureCallback pictureCallback) {
        this.logger.logMethod();
        com.commonsware.cwac.camera.CameraHost cameraHost = this.getCameraHost();
        if (cameraHost == null) {
            throw new NullPointerException("null cannot be cast to non-null type io.scanbot.sdk.camera.CameraHost");
        }
        CameraHost cameraHost2 = (CameraHost)cameraHost;
        PictureCallback pictureCallback2 = pictureCallback;
        Intrinsics.checkNotNull((Object)pictureCallback2);
        cameraHost2.removePictureCallback(pictureCallback2);
    }

    @RequiresApi(api=17)
    public final void setShutterSound(boolean enabled) {
        this.logger.logMethod();
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)0, (Camera.CameraInfo)info);
        if (info.canDisableShutterSound) {
            try {
                Camera camera = this.camera;
                if (camera == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"camera");
                }
                camera.enableShutterSound(enabled);
            }
            catch (RuntimeException exception) {
                Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"Could not work with camera?", (Throwable)exception);
            }
        }
    }

    private final RectF calculateVisibleRectF(int previewWidth, int previewHeight, CameraPreviewMode previewMode) {
        if (this.getParent() != null) {
            ViewParent viewParent = this.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)viewParent, (String)"this@CameraView.parent");
            if (viewParent.getParent() != null) {
                RectF rectF;
                ViewGroup parent;
                ViewParent viewParent2 = this.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)viewParent2, (String)"this@CameraView.parent");
                ViewParent viewParent3 = viewParent2.getParent();
                if (!(viewParent3 instanceof ViewGroup)) {
                    viewParent3 = null;
                }
                ViewGroup viewGroup = (ViewGroup)viewParent3;
                if (viewGroup == null) {
                    return null;
                }
                ViewGroup viewGroup2 = parent = viewGroup;
                if (viewGroup2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.view.View");
                }
                int parentWidth = ((View)viewGroup2).getMeasuredWidth();
                int parentHeight = ((View)parent).getMeasuredHeight();
                double heightScale = (double)parentHeight / (double)previewHeight;
                double widthScale = (double)parentWidth / (double)previewWidth;
                int scaledPreviewWidth = 0;
                int scaledPreviewHeight = 0;
                if (previewMode == CameraPreviewMode.FILL_IN) {
                    if (heightScale > widthScale) {
                        scaledPreviewWidth = (int)((double)previewWidth * heightScale);
                        scaledPreviewHeight = parentHeight;
                    } else {
                        scaledPreviewWidth = parentWidth;
                        scaledPreviewHeight = (int)((double)previewHeight * widthScale);
                    }
                    int previewOffsetWidth = (scaledPreviewWidth - parentWidth) / 2;
                    int previewOffsetHeight = (scaledPreviewHeight - parentHeight) / 2;
                    float overlayTop = RangesKt.coerceIn((float)((float)previewOffsetHeight / (float)scaledPreviewHeight), (float)0.0f, (float)1.0f);
                    float overlayLeft = RangesKt.coerceIn((float)((float)previewOffsetWidth / (float)scaledPreviewWidth), (float)0.0f, (float)1.0f);
                    float overlayBottom = RangesKt.coerceIn((float)((float)(scaledPreviewHeight - previewOffsetHeight) / (float)scaledPreviewHeight), (float)0.0f, (float)1.0f);
                    float overlayRight = RangesKt.coerceIn((float)((float)(scaledPreviewWidth - previewOffsetWidth) / (float)scaledPreviewWidth), (float)0.0f, (float)1.0f);
                    rectF = new RectF(overlayLeft, overlayTop, overlayRight, overlayBottom);
                } else {
                    rectF = new RectF(0.0f, 0.0f, 1.0f, 1.0f);
                }
                return rectF;
            }
        }
        return null;
    }

    private final RectF calculateFinderRectF(int previewWidth, int previewHeight, CameraPreviewMode previewMode) {
        if (this.getParent() != null) {
            ViewParent viewParent = this.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)viewParent, (String)"this@CameraView.parent");
            if (viewParent.getParent() != null) {
                ViewParent viewParent2 = this.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)viewParent2, (String)"this@CameraView.parent");
                ViewParent viewParent3 = viewParent2.getParent();
                if (!(viewParent3 instanceof ViewGroup)) {
                    viewParent3 = null;
                }
                ViewGroup viewGroup = (ViewGroup)viewParent3;
                if (viewGroup == null) {
                    return null;
                }
                ViewGroup parent = viewGroup;
                View finderOverlay = parent.findViewById(R.id.finder_overlay);
                if (finderOverlay == null || finderOverlay.getVisibility() != 0) {
                    return null;
                }
                ViewGroup viewGroup2 = parent;
                if (viewGroup2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.view.View");
                }
                int parentWidth = ((View)viewGroup2).getMeasuredWidth();
                int parentHeight = ((View)parent).getMeasuredHeight();
                Rect overlayRect = new Rect();
                finderOverlay.getDrawingRect(overlayRect);
                parent.offsetDescendantRectToMyCoords(finderOverlay, overlayRect);
                overlayRect = new Rect(overlayRect.left + finderOverlay.getPaddingLeft(), overlayRect.top + finderOverlay.getPaddingTop(), overlayRect.right - finderOverlay.getPaddingRight(), overlayRect.bottom - finderOverlay.getPaddingBottom());
                double heightScale = (double)parentHeight / (double)previewHeight;
                double widthScale = (double)parentWidth / (double)previewWidth;
                int scaledPreviewWidth = 0;
                int scaledPreviewHeight = 0;
                if (previewMode == CameraPreviewMode.FILL_IN) {
                    if (heightScale > widthScale) {
                        scaledPreviewWidth = (int)((double)previewWidth * heightScale);
                        scaledPreviewHeight = parentHeight;
                    } else {
                        scaledPreviewWidth = parentWidth;
                        scaledPreviewHeight = (int)((double)previewHeight * widthScale);
                    }
                } else if (heightScale > widthScale) {
                    scaledPreviewWidth = parentWidth;
                    scaledPreviewHeight = (int)((double)previewHeight * widthScale);
                } else {
                    scaledPreviewWidth = (int)((double)previewWidth * heightScale);
                    scaledPreviewHeight = parentHeight;
                }
                int previewOffsetWidth = (scaledPreviewWidth - parentWidth) / 2;
                int previewOffsetHeight = (scaledPreviewHeight - parentHeight) / 2;
                float overlayTop = RangesKt.coerceIn((float)((float)(previewOffsetHeight + overlayRect.top) / (float)scaledPreviewHeight), (float)0.0f, (float)1.0f);
                float overlayLeft = RangesKt.coerceIn((float)((float)(previewOffsetWidth + overlayRect.left) / (float)scaledPreviewWidth), (float)0.0f, (float)1.0f);
                float overlayBottom = RangesKt.coerceIn((float)((float)(previewOffsetHeight + overlayRect.bottom) / (float)scaledPreviewHeight), (float)0.0f, (float)1.0f);
                float overlayRight = RangesKt.coerceIn((float)((float)(previewOffsetWidth + overlayRect.right) / (float)scaledPreviewWidth), (float)0.0f, (float)1.0f);
                return new RectF(overlayLeft, overlayTop, overlayRight, overlayBottom);
            }
        }
        return null;
    }

    public CameraView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.autoFocusHandler = new Handler();
        this.cancelAutoFocusAndStartContinuousRunnable = new Runnable(this){
            final /* synthetic */ CameraView this$0;

            public final void run() {
                this.this$0.continuousFocus();
            }
            {
                this.this$0 = cameraView;
            }
        };
        this.polygon = CollectionsKt.emptyList();
        this.autoFocusOnTouch = true;
        this.touchFocusPaint = new Paint();
        this.previewBuffer = new PreviewBufferImpl();
        this.logger = LoggerProvider.getLogger();
        this.autofocusCallback = AutofocusCallback.Companion.getNULL();
        this.cameraOpenCallback = CameraOpenCallback.NULL;
        this.touchFocusPaint.setColor(this.getResources().getColor(17170443));
        this.touchFocusPaint.setStyle(Paint.Style.STROKE);
        this.touchFocusPaint.setStrokeWidth(this.getResources().getDimension(R.dimen.touch_focus_polygon_width));
        this.touchFocusPaint.setAntiAlias(true);
        this.finderInnerThresholdPx = context.getResources().getDimensionPixelSize(R.dimen.default_finder_inner_threshold);
        this.finderOuterThresholdPx = context.getResources().getDimensionPixelSize(R.dimen.default_finder_outer_threshold);
    }

    public static final /* synthetic */ RectF access$calculateFinderRectF(CameraView $this, int previewWidth, int previewHeight, CameraPreviewMode previewMode) {
        return $this.calculateFinderRectF(previewWidth, previewHeight, previewMode);
    }

    public static final /* synthetic */ RectF access$calculateVisibleRectF(CameraView $this, int previewWidth, int previewHeight, CameraPreviewMode previewMode) {
        return $this.calculateVisibleRectF(previewWidth, previewHeight, previewMode);
    }

    public static final /* synthetic */ int access$getFinderInnerThresholdPx$p(CameraView $this) {
        return $this.finderInnerThresholdPx;
    }

    public static final /* synthetic */ int access$getFinderOuterThresholdPx$p(CameraView $this) {
        return $this.finderOuterThresholdPx;
    }

    public static final /* synthetic */ CameraOpenCallback access$getCameraOpenCallback$p(CameraView $this) {
        return $this.cameraOpenCallback;
    }

    public static final /* synthetic */ void access$setCameraOpenCallback$p(CameraView $this, CameraOpenCallback cameraOpenCallback) {
        $this.cameraOpenCallback = cameraOpenCallback;
    }

    public static final /* synthetic */ long access$getLastFocusedTime$p(CameraView $this) {
        return $this.lastFocusedTime;
    }

    public static final /* synthetic */ void access$setLastFocusedTime$p(CameraView $this, long l) {
        $this.lastFocusedTime = l;
    }

    public static final /* synthetic */ AutofocusCallback access$getAutofocusCallback$p(CameraView $this) {
        return $this.autofocusCallback;
    }

    public static final /* synthetic */ void access$setAutofocusCallback$p(CameraView $this, AutofocusCallback autofocusCallback) {
        $this.autofocusCallback = autofocusCallback;
    }

    public static final /* synthetic */ Handler access$getAutoFocusHandler$p(CameraView $this) {
        return $this.autoFocusHandler;
    }

    public static final /* synthetic */ Runnable access$getCancelAutoFocusAndStartContinuousRunnable$p(CameraView $this) {
        return $this.cancelAutoFocusAndStartContinuousRunnable;
    }

    public static final /* synthetic */ boolean access$isAutoFocusing$p(CameraView $this) {
        return $this.isAutoFocusing;
    }

    public static final /* synthetic */ void access$setAutoFocusing$p(CameraView $this, boolean bl) {
        $this.isAutoFocusing = bl;
    }

    public static final /* synthetic */ void access$applyFocusAndMeteringArea(CameraView $this, Camera.Parameters parameters) {
        $this.applyFocusAndMeteringArea(parameters);
    }

    public static final /* synthetic */ void access$autoFocus$s-18599030(CameraView $this) {
        super.autoFocus();
    }

    public static final /* synthetic */ void access$updateTouchRect(CameraView $this, boolean success) {
        $this.updateTouchRect(success);
    }

    public static final /* synthetic */ void access$onAutoFocus$s-18599030(CameraView $this, boolean p0, Camera p1) {
        super.onAutoFocus(p0, p1);
    }

    public static final /* synthetic */ Paint access$getTouchFocusPaint$p(CameraView $this) {
        return $this.touchFocusPaint;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\bf\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0005"}, d2={"Lio/scanbot/sdk/camera/CameraView$AutofocusCallback;", "", "onAutoFocusCompleted", "", "Companion", "sdk-base_release"})
    public static interface AutofocusCallback {
        public static final Companion Companion = Companion.$$INSTANCE;

        public void onAutoFocusCompleted();

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/scanbot/sdk/camera/CameraView$AutofocusCallback$Companion;", "", "()V", "NULL", "Lio/scanbot/sdk/camera/CameraView$AutofocusCallback;", "getNULL", "()Lio/scanbot/sdk/camera/CameraView$AutofocusCallback;", "sdk-base_release"})
        public static final class Companion {
            @NotNull
            private static final AutofocusCallback NULL;
            static final /* synthetic */ Companion $$INSTANCE;

            @NotNull
            public final AutofocusCallback getNULL() {
                return NULL;
            }

            private Companion() {
            }

            static {
                Companion companion;
                $$INSTANCE = companion = new Companion();
                NULL = new AutofocusCallback(){

                    public void onAutoFocusCompleted() {
                    }
                };
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\tH\u0016J\u0016\u0010\u0016\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0006\u0010\u0019\u001a\u00020\u0014J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0018H\u0002J\u0006\u0010\u001c\u001a\u00020\u0014J'\u0010\u001d\u001a\u0004\u0018\u0001H\u001e\"\b\b\u0000\u0010\u001e*\u00020\t2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001e0 H\u0016\u00a2\u0006\u0002\u0010!J\u0018\u0010\"\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\tH\u0016J\u0018\u0010&\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010'\u001a\u00020(H\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0011\u00a8\u0006)"}, d2={"Lio/scanbot/sdk/camera/CameraView$PreviewBufferImpl;", "Lio/scanbot/sdk/camera/PreviewBuffer;", "Landroid/hardware/Camera$PreviewCallback;", "(Lio/scanbot/sdk/camera/CameraView;)V", "frameDispatcher", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "frameHandlers", "", "Lio/scanbot/sdk/camera/FrameHandler;", "frameHeight", "", "frameWidth", "framesInProcessing", "Ljava/util/concurrent/atomic/AtomicInteger;", "isPreviewBufferSupported", "", "()Z", "isUnderBackpressure", "addFrameHandler", "", "frameHandler", "allocateFrame", "allocateFrameBuffer", "", "deleteFrame", "dispatchFrame", "frame", "dispose", "getAttachedFrameHandler", "T", "clazz", "Ljava/lang/Class;", "(Ljava/lang/Class;)Lio/scanbot/sdk/camera/FrameHandler;", "onPreviewFrame", "camera", "Landroid/hardware/Camera;", "removeFrameHandler", "returnFrameToCamera", "handled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "sdk-base_release"})
    private final class PreviewBufferImpl
    implements PreviewBuffer,
    Camera.PreviewCallback {
        private int frameWidth;
        private int frameHeight;
        private final AtomicInteger framesInProcessing = new AtomicInteger(0);
        private final Set<FrameHandler> frameHandlers = new LinkedHashSet();
        private final ExecutorService frameDispatcher = Executors.newSingleThreadExecutor(frameDispatcher.1.INSTANCE);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addFrameHandler(@NotNull FrameHandler frameHandler) {
            Intrinsics.checkNotNullParameter((Object)frameHandler, (String)"frameHandler");
            CameraView.this.logger.logMethod();
            Set<FrameHandler> set = this.frameHandlers;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (set) {
                boolean bl3 = false;
                bl2 = this.frameHandlers.add(frameHandler);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeFrameHandler(@NotNull FrameHandler frameHandler) {
            Intrinsics.checkNotNullParameter((Object)frameHandler, (String)"frameHandler");
            CameraView.this.logger.logMethod();
            Set<FrameHandler> set = this.frameHandlers;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (set) {
                boolean bl3 = false;
                bl2 = this.frameHandlers.remove(frameHandler);
            }
        }

        @Override
        @Nullable
        public <T extends FrameHandler> T getAttachedFrameHandler(@NotNull Class<T> clazz) {
            Object v1;
            Object v0;
            block2: {
                Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                CameraView.this.logger.logMethod();
                Iterable $this$firstOrNull$iv = this.frameHandlers;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    FrameHandler it = (FrameHandler)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getClass(), clazz)) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = v1 = null;
            }
            if (!(v0 instanceof FrameHandler)) {
                v1 = null;
            }
            return (T)((FrameHandler)v1);
        }

        public final synchronized void allocateFrame(int frameWidth, int frameHeight) {
            this.deleteFrame();
            this.frameWidth = frameWidth;
            this.frameHeight = frameHeight;
            if (this.isPreviewBufferSupported()) {
                CameraView.this.setPreviewCallback(this);
                CameraView.this.addPreviewCallbackBuffer(this.allocateFrameBuffer(frameWidth, frameHeight));
                CameraView.this.addPreviewCallbackBuffer(this.allocateFrameBuffer(frameWidth, frameHeight));
            }
        }

        private final boolean isPreviewBufferSupported() {
            DeviceProfile deviceProfile = DeviceProfile.getInstance((Context)CameraView.this.getContext());
            Intrinsics.checkNotNullExpressionValue((Object)deviceProfile, (String)"DeviceProfile.getInstance(context)");
            return !deviceProfile.isCustomRom();
        }

        public final synchronized void deleteFrame() {
            CameraView.this.setPreviewCallback(null);
        }

        private final byte[] allocateFrameBuffer(int frameWidth, int frameHeight) {
            return new byte[frameWidth * frameHeight * ImageFormat.getBitsPerPixel((int)17) / 8];
        }

        public final void dispose() {
            this.frameDispatcher.shutdown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void onPreviewFrame(@NotNull byte[] frame, @NotNull Camera camera) {
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
            if (this.isUnderBackpressure()) {
                CameraView.this.addPreviewCallbackBuffer(frame);
                CameraView.this.logger.e("Camera", "Frame rejected - too many frames in processing");
                return;
            }
            Set<FrameHandler> set = this.frameHandlers;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (set) {
                boolean bl3 = false;
                this.dispatchFrame(frame);
                Unit unit = Unit.INSTANCE;
            }
        }

        private final boolean isUnderBackpressure() {
            return this.framesInProcessing.get() >= 1;
        }

        private final void dispatchFrame(byte[] frame) {
            ExecutorService executorService = this.frameDispatcher;
            Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"frameDispatcher");
            if (executorService.isShutdown()) {
                return;
            }
            this.frameDispatcher.execute(new Runnable(this){
                final /* synthetic */ PreviewBufferImpl this$0;

                public final void run() {
                    CameraView.access$getLogger$p(this.this$0.CameraView.this).logMethod();
                    PreviewBufferImpl.access$getFramesInProcessing$p(this.this$0).incrementAndGet();
                }
                {
                    this.this$0 = previewBufferImpl;
                }
            });
            this.frameDispatcher.execute(new Runnable(this, frame){
                final /* synthetic */ PreviewBufferImpl this$0;
                final /* synthetic */ byte[] $frame;

                public final void run() {
                    AtomicBoolean handled = new AtomicBoolean(false);
                    int frameWidthCopy = PreviewBufferImpl.access$getFrameWidth$p(this.this$0);
                    int frameHeightCopy = PreviewBufferImpl.access$getFrameHeight$p(this.this$0);
                    int displayOrientation = this.this$0.CameraView.this.getDisplayOrientation();
                    Rect finderRect = null;
                    RectF visibleRectF = new RectF(0.0f, 0.0f, 1.0f, 1.0f);
                    Camera.Parameters cameraParameters = this.this$0.CameraView.this.getCameraParameters();
                    if (cameraParameters != null) {
                        int previewWidth = 0;
                        int previewHeight = 0;
                        Camera.Size previewSize = cameraParameters.getPreviewSize();
                        if (displayOrientation == 0 || displayOrientation == 180) {
                            previewWidth = previewSize.width < previewSize.height ? previewSize.height : previewSize.width;
                            previewHeight = previewSize.width < previewSize.height ? previewSize.width : previewSize.height;
                        } else {
                            previewWidth = previewSize.width > previewSize.height ? previewSize.height : previewSize.width;
                            previewHeight = previewSize.width > previewSize.height ? previewSize.width : previewSize.height;
                        }
                        com.commonsware.cwac.camera.CameraHost cameraHost = this.this$0.CameraView.this.getCameraHost();
                        if (cameraHost == null) {
                            throw new NullPointerException("null cannot be cast to non-null type io.scanbot.sdk.camera.CameraHost");
                        }
                        CameraPreviewMode previewMode = ((CameraHost)cameraHost).getPreviewMode();
                        RectF overlayRectF = CameraView.access$calculateFinderRectF(this.this$0.CameraView.this, previewWidth, previewHeight, previewMode);
                        visibleRectF = CameraView.access$calculateVisibleRectF(this.this$0.CameraView.this, previewWidth, previewHeight, previewMode);
                        if (overlayRectF != null) {
                            finderRect = new Rect((int)((float)previewWidth * overlayRectF.left), (int)((float)previewHeight * overlayRectF.top), (int)((float)previewWidth * overlayRectF.right), (int)((float)previewHeight * overlayRectF.bottom));
                            if (finderRect.left < 0 || finderRect.left > previewWidth || finderRect.top < 0 || finderRect.top > previewHeight || finderRect.right < 0 || finderRect.right > previewWidth || finderRect.bottom < 0 || finderRect.bottom > previewHeight || finderRect.width() <= 0 || finderRect.height() <= 0) {
                                CameraView.access$getLogger$p(this.this$0.CameraView.this).e("Camera", "Finder overlay layout does not fit to the Camera preview frame.");
                                PreviewBufferImpl.access$returnFrameToCamera(this.this$0, this.$frame, handled);
                                return;
                            }
                        }
                    }
                    Rect resultFinderRect = finderRect;
                    RectF resultVisibleRectF = visibleRectF;
                    for (FrameHandler frameHandler : PreviewBufferImpl.access$getFrameHandlers$p(this.this$0)) {
                        PreviewBufferImpl.access$getFrameDispatcher$p(this.this$0).execute(new Runnable(this, handled, frameHandler, frameWidthCopy, frameHeightCopy, displayOrientation, resultFinderRect, resultVisibleRectF){
                            final /* synthetic */ dispatchFrame.2 this$0;
                            final /* synthetic */ AtomicBoolean $handled;
                            final /* synthetic */ FrameHandler $frameHandler;
                            final /* synthetic */ int $frameWidthCopy;
                            final /* synthetic */ int $frameHeightCopy;
                            final /* synthetic */ int $displayOrientation;
                            final /* synthetic */ Rect $resultFinderRect;
                            final /* synthetic */ RectF $resultVisibleRectF;

                            public final void run() {
                                if (this.$handled.get()) {
                                    return;
                                }
                                boolean result = this.$frameHandler.handleFrame(new FrameHandler.Frame(this.this$0.$frame, this.$frameWidthCopy, this.$frameHeightCopy, this.$displayOrientation, this.$resultFinderRect, this.$resultVisibleRectF, CameraView.access$getFinderInnerThresholdPx$p(this.this$0.this$0.CameraView.this), CameraView.access$getFinderOuterThresholdPx$p(this.this$0.this$0.CameraView.this)));
                                this.$handled.set(result);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$handled = atomicBoolean;
                                this.$frameHandler = frameHandler;
                                this.$frameWidthCopy = n;
                                this.$frameHeightCopy = n2;
                                this.$displayOrientation = n3;
                                this.$resultFinderRect = rect;
                                this.$resultVisibleRectF = rectF;
                            }
                        });
                    }
                    PreviewBufferImpl.access$returnFrameToCamera(this.this$0, this.$frame, handled);
                }
                {
                    this.this$0 = previewBufferImpl;
                    this.$frame = byArray;
                }
            });
        }

        private final void returnFrameToCamera(byte[] frame, AtomicBoolean handled) {
            this.frameDispatcher.execute(new Runnable(this, handled, frame){
                final /* synthetic */ PreviewBufferImpl this$0;
                final /* synthetic */ AtomicBoolean $handled;
                final /* synthetic */ byte[] $frame;

                public final void run() {
                    CameraView.access$getLogger$p(this.this$0.CameraView.this).logMethod();
                    PreviewBufferImpl.access$getFramesInProcessing$p(this.this$0).decrementAndGet();
                    if (this.$handled.get()) {
                        return;
                    }
                    this.this$0.CameraView.this.addPreviewCallbackBuffer(this.$frame);
                }
                {
                    this.this$0 = previewBufferImpl;
                    this.$handled = atomicBoolean;
                    this.$frame = byArray;
                }
            });
        }

        public static final /* synthetic */ AtomicInteger access$getFramesInProcessing$p(PreviewBufferImpl $this) {
            return $this.framesInProcessing;
        }

        public static final /* synthetic */ int access$getFrameWidth$p(PreviewBufferImpl $this) {
            return $this.frameWidth;
        }

        public static final /* synthetic */ void access$setFrameWidth$p(PreviewBufferImpl $this, int n) {
            $this.frameWidth = n;
        }

        public static final /* synthetic */ int access$getFrameHeight$p(PreviewBufferImpl $this) {
            return $this.frameHeight;
        }

        public static final /* synthetic */ void access$setFrameHeight$p(PreviewBufferImpl $this, int n) {
            $this.frameHeight = n;
        }

        public static final /* synthetic */ void access$returnFrameToCamera(PreviewBufferImpl $this, byte[] frame, AtomicBoolean handled) {
            $this.returnFrameToCamera(frame, handled);
        }

        public static final /* synthetic */ Set access$getFrameHandlers$p(PreviewBufferImpl $this) {
            return $this.frameHandlers;
        }

        public static final /* synthetic */ ExecutorService access$getFrameDispatcher$p(PreviewBufferImpl $this) {
            return $this.frameDispatcher;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/scanbot/sdk/camera/CameraView$Companion;", "", "()V", "AREA_WEIGHT", "", "AUTO_FOCUS_TIMEOUT_MS", "DEFAULT_FOCUS_AREA_SIZE", "DELAY_ENABLE_CONTINUOUS_FOCUS_MS", "DELAY_HIDE_TOUCH_FOCUS_MS", "DELAY_REFOCUSING_NEEDED_MS", "MAX_AREA_COORD", "MAX_FRAMES_IN_PROCESSING", "MIN_AREA_COORD", "SAMSUNG_SCENE_MODE_TEXT", "", "sdk-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

