/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.util.snap;

import android.hardware.Camera;
import io.scanbot.sdk.exceptions.camera.CameraParametersException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002%\u001fB\t\b\u0002\u00a2\u0006\u0004\b#\u0010$J\u001d\u0010\u0006\u001a\u00020\u00052\f\u0010\u0004\u001a\b\u0018\u00010\u0002R\u00020\u0003H\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\t\u001a\u00060\bR\u00020\u00032\n\u0010\u0004\u001a\u00060\u0002R\u00020\u0003H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ-\u0010\u000f\u001a\u00060\bR\u00020\u00032\u0010\u0010\f\u001a\f\u0012\b\u0012\u00060\bR\u00020\u00030\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J1\u0010\u0014\u001a\b\u0018\u00010\bR\u00020\u00032\n\u0010\u0004\u001a\u00060\u0002R\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015JA\u0010\u0018\u001a\b\u0018\u00010\bR\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\n\u0010\u0004\u001a\u00060\u0002R\u00020\u00032\u0006\u0010\u0017\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001d\u0010\u001b\u001a\u00020\u001a2\f\u0010\u0004\u001a\b\u0018\u00010\u0002R\u00020\u0003H\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001d\u0010\u001d\u001a\u00020\u001a2\f\u0010\u0004\u001a\b\u0018\u00010\u0002R\u00020\u0003H\u0007\u00a2\u0006\u0004\b\u001d\u0010\u001cJ#\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u000b2\f\u0010\u0004\u001a\b\u0018\u00010\u0002R\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u001f\u0010 R\u0016\u0010\"\u001a\u00020\r8\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001f\u0010!\u00a8\u0006&"}, d2={"Lio/scanbot/sdk/util/snap/Utils;", "", "Landroid/hardware/Camera$Parameters;", "Landroid/hardware/Camera;", "parameters", "", "isFlashSupported", "(Landroid/hardware/Camera$Parameters;)Z", "Landroid/hardware/Camera$Size;", "getLargestPictureSize", "(Landroid/hardware/Camera$Parameters;)Landroid/hardware/Camera$Size;", "", "sizes", "", "targetAspect", "getLargestSizeWithAspectRatioMatch", "(Ljava/util/List;D)Landroid/hardware/Camera$Size;", "", "width", "height", "findByWidthAndHeight", "(Landroid/hardware/Camera$Parameters;II)Landroid/hardware/Camera$Size;", "displayOrientation", "closeEnough", "getBestAspectPictureSize", "(IIILandroid/hardware/Camera$Parameters;D)Landroid/hardware/Camera$Size;", "", "enableContinuousFocus", "(Landroid/hardware/Camera$Parameters;)V", "enableAutoFocus", "", "a", "(Landroid/hardware/Camera$Parameters;)Ljava/util/List;", "D", "ASPECT_TOLERANCE", "<init>", "()V", "AspectRatioComparator", "sdk-base_release"})
public final class Utils {
    private static final double a = 0.1;
    @NotNull
    public static final Utils INSTANCE = new Utils();

    @JvmStatic
    public static final boolean isFlashSupported(@Nullable Camera.Parameters parameters) {
        Object object;
        if (parameters == null) {
            return false;
        }
        return (object = object.getSupportedFlashModes()) != null && !object.isEmpty() && (object.size() != 1 || !Intrinsics.areEqual((Object)((String)object.get(0)), (Object)"off"));
    }

    @JvmStatic
    @NotNull
    public static final Camera.Size getLargestPictureSize(@NotNull Camera.Parameters parameters) throws CameraParametersException {
        Camera.Parameters parameters2 = parameters;
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        Camera.Parameters parameters3 = null;
        Object object = parameters2.getSupportedPictureSizes();
        if (object != null && !object.isEmpty()) {
            object = object.iterator();
            while (object.hasNext()) {
                int n;
                Camera.Size size = (Camera.Size)object.next();
                if (parameters3 != null && size.width * size.height <= (n = parameters3.width * parameters3.height)) {
                    size = parameters3;
                }
                parameters3 = size;
            }
            Camera.Parameters parameters4 = parameters3;
            Intrinsics.checkNotNull((Object)parameters4);
            return parameters4;
        }
        throw new CameraParametersException("Could not get a list of camera picture sizes. Camera parameters are invalid.");
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Camera.Size getLargestSizeWithAspectRatioMatch(@NotNull List<? extends Camera.Size> sizes, double targetAspect) {
        void var1_1;
        ArrayList<Camera.Size> arrayList;
        a a2;
        List<? extends Camera.Size> list = sizes;
        Intrinsics.checkNotNullParameter(list, (String)"sizes");
        a a3 = a2;
        a2 = new a();
        ArrayList<Camera.Size> arrayList2 = arrayList;
        arrayList = new ArrayList<Camera.Size>();
        for (Camera.Size size : list) {
            Camera.Size size2;
            if (!(Math.abs((double)(var1_1 - (double)size2.width / (double)size.height)) < 0.1)) continue;
            arrayList2.add(size);
        }
        if (arrayList2.isEmpty()) {
            List<? extends Camera.Size> list2;
            Camera.Size size = Collections.min(list2, new AspectRatioComparator((double)var1_1));
            Intrinsics.checkNotNullExpressionValue((Object)size, (String)"Collections.min(sizes, aspectRatioComparator)");
            return size;
        }
        Camera.Size size = Collections.max(arrayList2, a3);
        Intrinsics.checkNotNullExpressionValue((Object)size, (String)"Collections.max(matchedPictureSizes, comparator)");
        return size;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final Camera.Size findByWidthAndHeight(@NotNull Camera.Parameters parameters, int width, int height) {
        Camera.Parameters parameters2 = parameters;
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        for (Camera.Size size : parameters2.getSupportedPictureSizes()) {
            void var2_2;
            void var1_1;
            if (size.width != var1_1 || size.height != var2_2) continue;
            return size;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final Camera.Size getBestAspectPictureSize(int displayOrientation, int width, int height, @NotNull Camera.Parameters parameters, double closeEnough) {
        Camera.Size size3;
        block5: {
            int n;
            void var2_5;
            void var1_2;
            void var3_7;
            Intrinsics.checkNotNullParameter((Object)var3_7, (String)"parameters");
            double d = (double)var1_2;
            double d2 = (double)var2_5;
            double d3 = d / d2;
            Camera.Size size2 = null;
            double d4 = Double.MAX_VALUE;
            if (displayOrientation == 90 || n == 270) {
                d3 = d2 / d;
            }
            List list = var3_7.getSupportedPictureSizes();
            Collections.sort(list, Collections.reverseOrder(new a()));
            for (Camera.Size size3 : list) {
                void var4_8;
                double d5;
                double d6 = (double)size3.width / (double)size3.height - d3;
                if (Math.abs(d5) < d4) {
                    d4 = Math.abs(d6);
                } else {
                    size3 = size2;
                }
                if (!(d4 < var4_8)) {
                    size2 = size3;
                    continue;
                }
                break block5;
            }
            size3 = size2;
        }
        return size3;
    }

    @JvmStatic
    public static final void enableContinuousFocus(@Nullable Camera.Parameters parameters) {
        Camera.Parameters parameters2;
        if (parameters == null) {
            return;
        }
        List<String> list = INSTANCE.a(parameters2);
        if (list.contains("continuous-picture")) {
            parameters2.setFocusMode("continuous-picture");
        } else if (list.contains("continuous-video")) {
            parameters2.setFocusMode("continuous-video");
        } else if (list.contains("auto")) {
            parameters2.setFocusMode("auto");
        }
    }

    @JvmStatic
    public static final void enableAutoFocus(@Nullable Camera.Parameters parameters) {
        Camera.Parameters parameters2;
        if (parameters == null) {
            return;
        }
        if (INSTANCE.a(parameters2).contains("auto") && Intrinsics.areEqual((Object)parameters2.getFocusMode(), (Object)"auto") ^ true) {
            parameters2.setFocusMode("auto");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> a(Camera.Parameters parameters) {
        void var1_1;
        if (parameters == null) {
            return CollectionsKt.emptyList();
        }
        Object object = var1_1.getSupportedFocusModes();
        if (object == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private Utils() {
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0002\u0018\u00002\f\u0012\b\u0012\u00060\u0002R\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\t\u0010\nJ'\u0010\u0007\u001a\u00020\u00062\n\u0010\u0004\u001a\u00060\u0002R\u00020\u00032\n\u0010\u0005\u001a\u00060\u0002R\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"io/scanbot/sdk/util/snap/Utils$a", "Ljava/util/Comparator;", "Landroid/hardware/Camera$Size;", "Landroid/hardware/Camera;", "lhs", "rhs", "", "a", "(Landroid/hardware/Camera$Size;Landroid/hardware/Camera$Size;)I", "<init>", "()V", "sdk-base_release"})
    public static final class a
    implements Comparator<Camera.Size> {
        /*
         * WARNING - void declaration
         */
        public int a(@NotNull Camera.Size lhs, @NotNull Camera.Size rhs) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"lhs");
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"rhs");
            return lhs.width * var1_1.height - var2_2.width * var2_2.height;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\u0018\u00002\f\u0012\b\u0012\u00060\u0002R\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\f\u001a\u00020\t\u00a2\u0006\u0004\b\r\u0010\u000eJ'\u0010\u0007\u001a\u00020\u00062\n\u0010\u0004\u001a\u00060\u0002R\u00020\u00032\n\u0010\u0005\u001a\u00060\u0002R\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bR\u0016\u0010\f\u001a\u00020\t8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lio/scanbot/sdk/util/snap/Utils$AspectRatioComparator;", "Ljava/util/Comparator;", "Landroid/hardware/Camera$Size;", "Landroid/hardware/Camera;", "lhs", "rhs", "", "compare", "(Landroid/hardware/Camera$Size;Landroid/hardware/Camera$Size;)I", "", "a", "D", "targetRatio", "<init>", "(D)V", "sdk-base_release"})
    public static final class AspectRatioComparator
    implements Comparator<Camera.Size> {
        private final double a;

        /*
         * WARNING - void declaration
         */
        public AspectRatioComparator(double targetRatio) {
            void var1_1;
            this.a = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int compare(@NotNull Camera.Size lhs, @NotNull Camera.Size rhs) {
            void var2_3;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"lhs");
            Intrinsics.checkNotNullParameter((Object)var2_3, (String)"rhs");
            double d = (double)var2_3.width / (double)var2_3.height;
            return Math.abs((double)lhs.width / (double)var1_1.height - this.a) - Math.abs(d - this.a) >= 0.0 ? 1 : -1;
        }
    }
}

