/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.persistence.fileio;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import io.scanbot.sdk.exceptions.crypto.SourceFileDoesNotExistException;
import io.scanbot.sdk.persistence.fileio.FileIOProcessor;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, bv={}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\"\u001a\u00020\u001d\u00a2\u0006\u0004\b-\u0010.J(\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016J\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0016J\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020\u00102\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\f\u001a\u00020\bH\u0016J\u0018\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\bH\u0016J\u0018\u0010\u0016\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\bH\u0016R\u0017\u0010\"\u001a\u00020\u001d8\u0006\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!R\u001a\u0010(\u001a\u00020#8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'R\u0014\u0010,\u001a\u00020)8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+\u00a8\u0006/"}, d2={"Lio/scanbot/sdk/persistence/fileio/DefaultFileIOProcessor;", "Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;", "Landroid/graphics/Bitmap;", "bitmap", "Landroid/graphics/Bitmap$CompressFormat;", "compressFormat", "", "quality", "Ljava/io/File;", "destination", "", "writeImage", "source", "Landroid/graphics/BitmapFactory$Options;", "options", "readImage", "Landroid/net/Uri;", "sourceUri", "", "read", "byteArray", "write", "copyRaw", "destinationFile", "Ljava/io/OutputStream;", "openFileOutputStream", "sourceFile", "Ljava/io/InputStream;", "openFileInputStream", "Landroid/content/Context;", "a", "Landroid/content/Context;", "getContext", "()Landroid/content/Context;", "context", "", "b", "Z", "getUseEncryption", "()Z", "useEncryption", "Lio/scanbot/sdk/util/log/Logger;", "c", "Lio/scanbot/sdk/util/log/Logger;", "logger", "<init>", "(Landroid/content/Context;)V", "sdk-base_release"})
public final class DefaultFileIOProcessor
implements FileIOProcessor {
    @NotNull
    public final Context a;
    public final boolean b;
    @NotNull
    public final Logger c;

    /*
     * WARNING - void declaration
     */
    public DefaultFileIOProcessor(@NotNull Context context) {
        void var1_1;
        DefaultFileIOProcessor defaultFileIOProcessor = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"context");
        defaultFileIOProcessor.a = var1_1;
        defaultFileIOProcessor.c = LoggerProvider.getLogger();
    }

    @NotNull
    public final Context getContext() {
        return this.a;
    }

    @Override
    public boolean getUseEncryption() {
        return this.b;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeImage(@NotNull Bitmap bitmap, @NotNull Bitmap.CompressFormat compressFormat, int quality, @NotNull File destination) {
        FileOutputStream fileOutputStream;
        void var4_4;
        void var2_2;
        Throwable throwable;
        File file = destination;
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"bitmap");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"compressFormat");
        Intrinsics.checkNotNullParameter((Object)file, (String)"destination");
        if (file.exists()) {
            var4_4.delete();
        }
        FileOutputStream fileOutputStream2 = fileOutputStream;
        void v2 = throwable;
        fileOutputStream2((File)var4_4);
        throwable = null;
        try {
            void var3_3;
            v2.compress((Bitmap.CompressFormat)var2_2, (int)var3_3, (OutputStream)fileOutputStream2);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            try {
                throw throwable2;
            }
            catch (Throwable throwable3) {
                CloseableKt.closeFinally((Closeable)fileOutputStream2, (Throwable)throwable);
                throw throwable3;
            }
        }
        CloseableKt.closeFinally((Closeable)fileOutputStream, (Throwable)throwable);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Bitmap readImage(@NotNull File source, @Nullable BitmapFactory.Options options) {
        void var2_2;
        void var1_1;
        void v0 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v0, (String)"source");
        Uri uri = Uri.fromFile((File)v0);
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"fromFile(source)");
        return this.readImage(uri, (BitmapFactory.Options)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Bitmap readImage(@NotNull Uri sourceUri, @Nullable BitmapFactory.Options options) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)sourceUri, (String)"sourceUri");
        if (new File(var1_1.getPath()).exists()) {
            void var2_2;
            return BitmapFactory.decodeFile((String)var1_1.getPath(), (BitmapFactory.Options)var2_2);
        }
        throw new SourceFileDoesNotExistException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public byte[] read(@NotNull File source) {
        File file = source;
        Intrinsics.checkNotNullParameter((Object)file, (String)"source");
        if (file.exists()) {
            void var1_1;
            return FilesKt.readBytes((File)var1_1);
        }
        throw new SourceFileDoesNotExistException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(@NotNull byte[] byteArray, @NotNull File destination) {
        void var2_2;
        void var1_1;
        File file = destination;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"byteArray");
        Intrinsics.checkNotNullParameter((Object)file, (String)"destination");
        if (file.exists()) {
            var2_2.delete();
        }
        FilesKt.writeBytes((File)var2_2, (byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void copyRaw(@NotNull File source, @NotNull File destination) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"source");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"destination");
        if (source.exists()) {
            FilesKt.copyTo$default((File)var1_1, (File)var2_2, (boolean)true, (int)0, (int)4, null);
            return;
        }
        throw new SourceFileDoesNotExistException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OutputStream openFileOutputStream(@NotNull File destinationFile) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)destinationFile, (String)"destinationFile");
        return new FileOutputStream((File)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public InputStream openFileInputStream(@NotNull File sourceFile) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        return new FileInputStream((File)var1_1);
    }
}

