/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.camera;

import android.content.Context;
import android.graphics.PointF;
import android.hardware.Camera;
import com.commonsware.cwac.camera.CameraHost;
import com.commonsware.cwac.camera.c;
import io.scanbot.sdk.camera.BasePictureCallback;
import io.scanbot.sdk.camera.CameraModule;
import io.scanbot.sdk.camera.CameraPreviewMode;
import io.scanbot.sdk.exceptions.camera.CameraParametersException;
import io.scanbot.sdk.scanbotsdkcamera.e;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import io.scanbot.sdk.util.snap.Utils;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, bv={}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010Y\u001a\u00020X\u00a2\u0006\u0004\bZ\u0010[J\u0018\u0010\u0005\u001a\u00060\u0002R\u00020\u00032\n\u0010\u0004\u001a\u00060\u0002R\u00020\u0003H\u0016J0\u0010\u000b\u001a\u00060\nR\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\n\u0010\u0004\u001a\u00060\u0002R\u00020\u0003H\u0016J\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\fJ\n\u0010\u0010\u001a\u0004\u0018\u00010\fH\u0016J\"\u0010\u0013\u001a\u00060\nR\u00020\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u00112\n\u0010\u0004\u001a\u00060\u0002R\u00020\u0003H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0014H\u0014J\b\u0010\u0018\u001a\u00020\u0017H\u0016J \u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0006H\u0016J\u0018\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u0003H\u0016J\u000e\u0010\"\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020 J\u000e\u0010#\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020 J\u0014\u0010%\u001a\u00020\u000e2\f\u0010$\u001a\b\u0018\u00010\nR\u00020\u0003J\u0014\u0010'\u001a\u00020\u000e2\f\u0010&\u001a\b\u0018\u00010\nR\u00020\u0003J\u000e\u0010)\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020\u0014J\u000e\u0010+\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\u0014J\u0014\u0010/\u001a\u00020\u000e2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020-0,J\u000e\u00101\u001a\u00020\u000e2\u0006\u00100\u001a\u00020\u0014J0\u00102\u001a\u00060\nR\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\n\u0010\u0004\u001a\u00060\u0002R\u00020\u0003H\u0002R\u001a\u00106\u001a\b\u0012\u0004\u0012\u00020 038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b4\u00105R\u0014\u0010:\u001a\u0002078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b8\u00109R\u001c\u0010$\u001a\b\u0018\u00010\nR\u00020\u00038\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b;\u0010<R\u001c\u0010&\u001a\b\u0018\u00010\nR\u00020\u00038\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b=\u0010<R\u0016\u0010(\u001a\u00020\u00148\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b>\u0010?R\u0016\u0010*\u001a\u00020\u00148\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b@\u0010?R\u0016\u0010B\u001a\u00020\u00148\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bA\u0010?R\u0016\u0010E\u001a\u00020\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bC\u0010DR\u001c\u0010.\u001a\b\u0012\u0004\u0012\u00020-0,8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bF\u0010GR\"\u0010O\u001a\u00020H8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bI\u0010J\u001a\u0004\bK\u0010L\"\u0004\bM\u0010NR\"\u0010W\u001a\u00020P8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bQ\u0010R\u001a\u0004\bS\u0010T\"\u0004\bU\u0010V\u00a8\u0006\\"}, d2={"Lio/scanbot/sdk/camera/CameraHost;", "Lcom/commonsware/cwac/camera/c;", "Landroid/hardware/Camera$Parameters;", "Landroid/hardware/Camera;", "parameters", "adjustPreviewParameters", "", "displayOrientation", "width", "height", "Landroid/hardware/Camera$Size;", "getPreviewSize", "Landroid/hardware/Camera$ShutterCallback;", "shutterCallback", "", "setShutterCallback", "getShutterCallback", "Lio/scanbot/sdk/scanbotsdkcamera/e;", "xact", "getPictureSize", "", "useFullBleedPreview", "useFrontFacingCamera", "Lcom/commonsware/cwac/camera/CameraHost$RecordingHint;", "getRecordingHint", "", "image", "imageOrientation", "saveImage", "success", "camera", "onAutoFocus", "Lio/scanbot/sdk/camera/BasePictureCallback;", "pictureCallback", "addPictureCallback", "removePictureCallback", "defaultPictureSize", "setDefaultPictureSize", "defaultPreviewSize", "setDefaultPreviewSize", "autoFocusSoundEnabled", "setAutoFocusSound", "shutterSoundEnabled", "setShutterSound", "", "Landroid/graphics/PointF;", "currentFinderRectF", "setCurrentFinderRectF", "isCapturedAutomatically", "setIsCapturedAutomatically", "a", "", "m", "Ljava/util/Set;", "pictureCallbacks", "Lio/scanbot/sdk/util/log/Logger;", "n", "Lio/scanbot/sdk/util/log/Logger;", "logger", "o", "Landroid/hardware/Camera$Size;", "p", "q", "Z", "r", "s", "isPictureCapturedAutomatically", "t", "Landroid/hardware/Camera$ShutterCallback;", "shutterListener", "u", "Ljava/util/List;", "Lio/scanbot/sdk/camera/CameraModule;", "v", "Lio/scanbot/sdk/camera/CameraModule;", "getCameraModule", "()Lio/scanbot/sdk/camera/CameraModule;", "setCameraModule", "(Lio/scanbot/sdk/camera/CameraModule;)V", "cameraModule", "Lio/scanbot/sdk/camera/CameraPreviewMode;", "w", "Lio/scanbot/sdk/camera/CameraPreviewMode;", "getPreviewMode", "()Lio/scanbot/sdk/camera/CameraPreviewMode;", "setPreviewMode", "(Lio/scanbot/sdk/camera/CameraPreviewMode;)V", "previewMode", "Landroid/content/Context;", "context", "<init>", "(Landroid/content/Context;)V", "sdk-camera_release"})
public final class CameraHost
extends c {
    @NotNull
    public final Set<BasePictureCallback> m;
    @NotNull
    public final Logger n;
    @Nullable
    public Camera.Size o;
    @Nullable
    public Camera.Size p;
    public boolean q;
    public boolean r;
    public boolean s;
    @NotNull
    public Camera.ShutterCallback t;
    @NotNull
    public List<? extends PointF> u;
    @NotNull
    public CameraModule v;
    @NotNull
    public CameraPreviewMode w;

    /*
     * WARNING - void declaration
     */
    public CameraHost(@NotNull Context context) {
        void var1_1;
        void v0 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v0, (String)"context");
        super((Context)v0);
        this.m = new LinkedHashSet<BasePictureCallback>();
        this.n = LoggerProvider.getLogger();
        this.q = true;
        this.r = true;
        this.t = CameraHost::e;
        this.u = CollectionsKt.emptyList();
        this.v = CameraModule.BACK;
        this.w = CameraPreviewMode.FILL_IN;
    }

    public static final void e() {
    }

    @NotNull
    public final CameraModule getCameraModule() {
        return this.v;
    }

    /*
     * WARNING - void declaration
     */
    public final void setCameraModule(@NotNull CameraModule cameraModule) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"<set-?>");
        this.v = var1_1;
    }

    @NotNull
    public final CameraPreviewMode getPreviewMode() {
        return this.w;
    }

    /*
     * WARNING - void declaration
     */
    public final void setPreviewMode(@NotNull CameraPreviewMode cameraPreviewMode) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"<set-?>");
        this.w = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Camera.Parameters adjustPreviewParameters(@NotNull Camera.Parameters parameters) {
        void var1_1;
        Camera.Parameters parameters2 = parameters;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"parameters");
        this.n.logMethod();
        super.adjustPreviewParameters((Camera.Parameters)var1_1);
        parameters2.setPreviewFormat(17);
        return parameters2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Camera.Size getPreviewSize(int displayOrientation, int width, int height, @NotNull Camera.Parameters parameters) {
        void var4_4;
        CameraHost cameraHost = this;
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"parameters");
        cameraHost.n.logMethod();
        Camera.Size size = cameraHost.p;
        if (size == null) {
            void var3_3;
            void var2_2;
            void var1_1;
            size = this.a((int)var1_1, (int)var2_2, (int)var3_3, (Camera.Parameters)var4_4);
        }
        return size;
    }

    /*
     * WARNING - void declaration
     */
    public final void setShutterCallback(@NotNull Camera.ShutterCallback shutterCallback) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"shutterCallback");
        this.t = var1_1;
    }

    @Override
    @Nullable
    public Camera.ShutterCallback getShutterCallback() {
        return this.t;
    }

    @Override
    @NotNull
    public Camera.Size getPictureSize(@Nullable e e2, @NotNull Camera.Parameters parameters) {
        CameraHost cameraHost = cameraHost2;
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        cameraHost.n.logMethod();
        CameraHost cameraHost2 = cameraHost.o;
        if (cameraHost2 == null) {
            cameraHost2 = Utils.getLargestPictureSize((Camera.Parameters)parameters);
        }
        return cameraHost2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean useFullBleedPreview() {
        int n2 = WhenMappings.$EnumSwitchMapping$0[this.w.ordinal()];
        if (n2 == 1) return false;
        if (n2 != 2) throw new NoWhenBranchMatchedException();
        return true;
    }

    @Override
    public boolean useFrontFacingCamera() {
        boolean bl;
        int n2 = WhenMappings.$EnumSwitchMapping$1[this.v.ordinal()];
        if (n2 != 1) {
            if (n2 != 2 && n2 != 3) {
                throw new NoWhenBranchMatchedException();
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public CameraHost.RecordingHint getRecordingHint() {
        return CameraHost.RecordingHint.STILL_ONLY;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void saveImage(@NotNull e set, @NotNull byte[] byArray, int n2) {
        CameraHost cameraHost = this;
        Intrinsics.checkNotNullParameter(set, (String)"xact");
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"image");
        cameraHost.n.logMethod();
        set = cameraHost.m;
        synchronized (set) {
            Iterator<BasePictureCallback> iterator = cameraHost.m.iterator();
            while (iterator.hasNext()) {
                CameraHost cameraHost2 = this;
                List<? extends PointF> list = cameraHost2.u;
                iterator.next().onPictureTakenInternal(byArray, n2, list, cameraHost2.s);
            }
            Set<BasePictureCallback> set2 = set;
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onAutoFocus(boolean success, @NotNull Camera camera) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"camera");
        if (this.q) {
            void var1_1;
            super.onAutoFocus((boolean)var1_1, (Camera)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void addPictureCallback(@NotNull BasePictureCallback pictureCallback) {
        void var1_1;
        CameraHost cameraHost = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"pictureCallback");
        cameraHost.n.logMethod();
        Set<BasePictureCallback> set = cameraHost.m;
        synchronized (set) {
            this.m.add((BasePictureCallback)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void removePictureCallback(@NotNull BasePictureCallback pictureCallback) {
        void var1_1;
        CameraHost cameraHost = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"pictureCallback");
        cameraHost.n.logMethod();
        Set<BasePictureCallback> set = cameraHost.m;
        synchronized (set) {
            this.m.remove(var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setDefaultPictureSize(@Nullable Camera.Size defaultPictureSize) {
        void var1_1;
        this.o = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setDefaultPreviewSize(@Nullable Camera.Size defaultPreviewSize) {
        void var1_1;
        this.p = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setAutoFocusSound(boolean autoFocusSoundEnabled) {
        void var1_1;
        this.q = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setShutterSound(boolean shutterSoundEnabled) {
        void var1_1;
        this.r = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setCurrentFinderRectF(@NotNull List<? extends PointF> currentFinderRectF) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"currentFinderRectF");
        this.u = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setIsCapturedAutomatically(boolean isCapturedAutomatically) {
        void var1_1;
        this.s = var1_1;
    }

    public final Camera.Size a(int displayOrientation, int width, int height, Camera.Parameters parameters) {
        Camera.Parameters parameters2 = parameters;
        cameraHost.n.logMethod();
        CameraHost cameraHost = Utils.getLargestPictureSize((Camera.Parameters)parameters2);
        List list = parameters2.getSupportedPreviewSizes();
        if (list != null && !list.isEmpty()) {
            return Utils.getLargestSizeWithAspectRatioMatch((List)list, (double)((double)((Camera.Size)cameraHost).width / (double)((Camera.Size)cameraHost).height));
        }
        throw new CameraParametersException("Could not get a list of camera preview sizes. Camera parameters are invalid.");
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[CameraPreviewMode.values().length];
            nArray[CameraPreviewMode.FIT_IN.ordinal()] = 1;
            nArray[CameraPreviewMode.FILL_IN.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
            int[] nArray2 = new int[CameraModule.values().length];
            nArray2[CameraModule.BACK.ordinal()] = 1;
            nArray2[CameraModule.FRONT.ordinal()] = 2;
            nArray2[CameraModule.FRONT_MIRRORED.ordinal()] = 3;
            $EnumSwitchMapping$1 = nArray2;
        }
    }
}

