/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.chequescanner;

import android.content.Context;
import io.scanbot.chequescanner.model.Result;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.camera.BaseResultHandler;
import io.scanbot.sdk.camera.FrameHandlerResult;
import java.util.LinkedHashSet;
import java.util.Set;
import net.doo.snap.camera.PreviewBuffer;
import net.doo.snap.camera.ScanbotCameraView;
import net.doo.snap.chequescanner.ChequeScanner;
import net.doo.snap.security.SapSingleton;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public class ChequeScannerFrameHandler
implements PreviewBuffer.FrameHandler {
    private ChequeScanner chequeScanner;
    private final Set<ResultHandler> handlers = new LinkedHashSet<ResultHandler>();
    private final SapManager sapManager;
    private final Logger logger = LoggerProvider.getLogger();
    private boolean enabled = true;

    public static ChequeScannerFrameHandler attach(ScanbotCameraView cameraView, ChequeScanner chequeScanner) {
        ChequeScannerFrameHandler frameHandler = new ChequeScannerFrameHandler(cameraView.getContext(), chequeScanner);
        cameraView.getPreviewBuffer().addFrameHandler((PreviewBuffer.FrameHandler)frameHandler);
        return frameHandler;
    }

    public ChequeScannerFrameHandler(Context context, ChequeScanner chequeScanner) {
        this.chequeScanner = chequeScanner;
        this.sapManager = SapSingleton.getInstance();
    }

    public synchronized boolean handleFrame(PreviewBuffer.FrameHandler.Frame previewFrame) {
        this.logger.logMethod();
        if (!this.enabled) {
            return false;
        }
        if (!this.sapManager.checkLicenseStatus(SdkFeature.Cheque).booleanValue()) {
            this.notifyHandlers((FrameHandlerResult<Result, SdkLicenseError>)new FrameHandlerResult.Failure((Object)new SdkLicenseError()));
            return false;
        }
        Result recognitionResult = this.chequeScanner.recognizeCheque(previewFrame.frame, previewFrame.width, previewFrame.height, previewFrame.frameOrientation);
        return this.notifyHandlers((FrameHandlerResult<Result, SdkLicenseError>)new FrameHandlerResult.Success((Object)recognitionResult));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResultHandler(ResultHandler handler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResultHandler(ResultHandler handler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.remove(handler);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean notifyHandlers(FrameHandlerResult<Result, SdkLicenseError> result) {
        boolean handled = false;
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            for (ResultHandler handler : this.handlers) {
                handled |= handler.handle(result);
            }
        }
        return handled;
    }

    public static interface ResultHandler
    extends BaseResultHandler<Result, SdkLicenseError> {
    }
}

