/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.chequescanner;

import android.graphics.Bitmap;
import io.scanbot.chequescanner.ChequeRecognizer;
import io.scanbot.chequescanner.model.Result;
import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.chequescanner.ChequeScanner;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0016J*\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0016J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\fH\u0016J*\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/scanbot/sdk/chequescanner/DefaultChequeScanner;", "Lio/scanbot/sdk/chequescanner/ChequeScanner;", "blobManager", "Lio/scanbot/sdk/blob/BlobManager;", "(Lio/scanbot/sdk/blob/BlobManager;)V", "chequeRecognizer", "Lio/scanbot/chequescanner/ChequeRecognizer;", "recognizeCheque", "Lio/scanbot/chequescanner/model/Result;", "nv21", "", "width", "", "height", "orientation", "recognizeChequeBGR", "bgr", "recognizeChequeBitmap", "image", "Landroid/graphics/Bitmap;", "recognizeChequeJPEG", "sdk-cheque_release"})
public final class DefaultChequeScanner
implements ChequeScanner {
    private final ChequeRecognizer chequeRecognizer;

    @Override
    @Nullable
    public Result recognizeCheque(@NotNull byte[] nv21, int width, int height, int orientation) {
        Intrinsics.checkNotNullParameter((Object)nv21, (String)"nv21");
        return this.chequeRecognizer.recognizeCheque(nv21, width, height, orientation);
    }

    @Override
    @Nullable
    public Result recognizeChequeBGR(@NotNull byte[] bgr, int width, int height, int orientation) {
        Intrinsics.checkNotNullParameter((Object)bgr, (String)"bgr");
        return this.chequeRecognizer.recognizeChequeBGR(bgr, width, height, orientation);
    }

    @Override
    @Nullable
    public Result recognizeChequeJPEG(@NotNull byte[] image, int width, int height, int orientation) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        return this.chequeRecognizer.recognizeChequeJPEG(image, width, height, orientation);
    }

    @Override
    @Nullable
    public Result recognizeChequeBitmap(@NotNull Bitmap image, int orientation) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        return this.chequeRecognizer.recognizeChequeBitmap(image, orientation);
    }

    public DefaultChequeScanner(@NotNull BlobManager blobManager) {
        String string;
        Intrinsics.checkNotNullParameter((Object)blobManager, (String)"blobManager");
        String modelFilePath = "";
        try {
            String string2 = blobManager.getChequeDigitPredictionModelFile().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"blobManager.chequeDigitPredictionModelFile.path");
            string = string2;
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException("Cheque blob is not available.");
        }
        modelFilePath = string;
        this.chequeRecognizer = new ChequeRecognizer(modelFilePath);
    }
}

