/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.util.bitmap;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0007J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002J,\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0007J,\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004H\u0007J$\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004H\u0007J$\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004H\u0007J\u001e\u0010\u001c\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010 \u001a\u00020!H\u0007J\u0012\u0010\"\u001a\u00020#2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0007J\u0012\u0010$\u001a\u00020#2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J\u0012\u0010%\u001a\u00020&2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J \u0010'\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u0004H\u0007\u00a8\u0006*"}, d2={"Lio/scanbot/sdk/util/bitmap/BitmapUtils;", "", "()V", "calculateInSampleSize", "", "options", "Landroid/graphics/BitmapFactory$Options;", "reqWidth", "reqHeight", "width", "height", "compress", "", "bitmap", "Landroid/graphics/Bitmap;", "format", "Landroid/graphics/Bitmap$CompressFormat;", "quality", "file", "Ljava/io/File;", "createPreview", "res", "Landroid/content/res/Resources;", "imageRes", "targetWidth", "targetHeight", "image", "", "decodeQuietly", "path", "", "drawableToBitmap", "drawable", "Landroid/graphics/drawable/Drawable;", "getBitmapBounds", "Landroid/graphics/Rect;", "getContentBounds", "isBitmapValid", "", "scaleIfNeeded", "maxHeight", "maxWidth", "sdk-common_release"})
public final class BitmapUtils {
    public static final BitmapUtils INSTANCE;

    @JvmStatic
    @NotNull
    public static final Rect getBitmapBounds(@Nullable String path) {
        Rect bounds = new Rect();
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        bounds.set(0, 0, options.outWidth, options.outHeight);
        return bounds;
    }

    @JvmStatic
    public static final boolean isBitmapValid(@Nullable Bitmap bitmap) {
        return bitmap != null && !bitmap.isRecycled();
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Rect getContentBounds(@Nullable Bitmap bitmap) throws NullPointerException {
        if (bitmap == null) {
            throw (Throwable)new NullPointerException("Bitmap is null");
        }
        int minX = bitmap.getWidth();
        int minY = bitmap.getHeight();
        int maxX = 0;
        int maxY = 0;
        int n = 0;
        int n2 = bitmap.getHeight();
        while (n < n2) {
            void y;
            int n3 = 0;
            int n4 = bitmap.getWidth();
            while (n3 < n4) {
                void x;
                int pixel = bitmap.getPixel((int)x, (int)y);
                if (pixel != 0) {
                    if (x < minX) {
                        minX = x;
                    }
                    if (y < minY) {
                        minY = y;
                    }
                    if (x > maxX) {
                        maxX = x;
                    }
                    if (y > maxY) {
                        maxY = y;
                    }
                }
                ++x;
            }
            ++y;
        }
        return new Rect(minX, minY, maxX, maxY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void compress(@NotNull Bitmap bitmap, @Nullable Bitmap.CompressFormat format, int quality, @Nullable File file) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            bitmap.compress(format, quality, (OutputStream)fos);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)fos);
        }
    }

    @JvmStatic
    @Nullable
    public static final Bitmap createPreview(@Nullable Resources res, int imageRes, int targetWidth, int targetHeight) {
        if (imageRes <= 0) {
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)res, (int)imageRes, (BitmapFactory.Options)options);
        options.inSampleSize = BitmapUtils.calculateInSampleSize(options, targetWidth, targetHeight);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeResource((Resources)res, (int)imageRes, (BitmapFactory.Options)options);
    }

    @JvmStatic
    @Nullable
    public static final Bitmap createPreview(@Nullable byte[] image, int targetWidth, int targetHeight) {
        if (image == null) {
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray((byte[])image, (int)0, (int)image.length, (BitmapFactory.Options)options);
        options.inSampleSize = BitmapUtils.calculateInSampleSize(options, targetWidth, targetHeight);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeByteArray((byte[])image, (int)0, (int)image.length, (BitmapFactory.Options)options);
    }

    @JvmStatic
    @Nullable
    public static final Bitmap createPreview(@Nullable Bitmap image, int targetWidth, int targetHeight) {
        if (image == null) {
            return null;
        }
        int inSampleSize = INSTANCE.calculateInSampleSize(targetWidth, targetHeight, image.getWidth(), image.getHeight());
        return Bitmap.createScaledBitmap((Bitmap)image, (int)(image.getWidth() / inSampleSize), (int)(image.getHeight() / inSampleSize), (boolean)false);
    }

    @JvmStatic
    public static final int calculateInSampleSize(@NotNull BitmapFactory.Options options, int reqWidth, int reqHeight) {
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        int height = options.outHeight;
        int width = options.outWidth;
        return INSTANCE.calculateInSampleSize(reqWidth, reqHeight, width, height);
    }

    private final int calculateInSampleSize(int reqWidth, int reqHeight, int width, int height) {
        boolean desiredLandscape;
        int srcWidth = width;
        int srcHeight = height;
        boolean imageLandscape = srcWidth > srcHeight;
        boolean bl = desiredLandscape = reqWidth > reqHeight;
        if (imageLandscape != desiredLandscape) {
            srcHeight = width;
            srcWidth = height;
        }
        int inSampleSize = 1;
        if (srcHeight > reqHeight || srcWidth > reqWidth) {
            int halfHeight = srcHeight / 2;
            int halfWidth = srcWidth / 2;
            while (halfHeight / inSampleSize > reqHeight && halfWidth / inSampleSize > reqWidth) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }

    @JvmStatic
    @Nullable
    public static final Bitmap decodeQuietly(@Nullable String path, @Nullable BitmapFactory.Options options) {
        if (StringUtils.isEmpty((String)path)) {
            return null;
        }
        File file = new File(path);
        return !file.exists() || !file.isFile() ? null : BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
    }

    @JvmStatic
    @Nullable
    public static final Bitmap drawableToBitmap(@NotNull Drawable drawable) {
        Bitmap bitmap;
        Drawable bitmapDrawable;
        Intrinsics.checkParameterIsNotNull((Object)drawable, (String)"drawable");
        if (drawable instanceof BitmapDrawable && ((BitmapDrawable)(bitmapDrawable = drawable)).getBitmap() != null) {
            return ((BitmapDrawable)bitmapDrawable).getBitmap().copy(Bitmap.Config.ARGB_8888, true);
        }
        if (drawable.getIntrinsicWidth() <= 0 || drawable.getIntrinsicHeight() <= 0) {
            Bitmap bitmap2 = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap = bitmap2;
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"Bitmap.createBitmap(1, 1, Bitmap.Config.ARGB_8888)");
        } else {
            Bitmap bitmap3 = Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap = bitmap3;
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap3, (String)"Bitmap.createBitmap(draw\u2026 Bitmap.Config.ARGB_8888)");
        }
        Bitmap bitmap4 = bitmap;
        Canvas canvas = new Canvas(bitmap4);
        drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable.draw(canvas);
        return bitmap4;
    }

    @JvmStatic
    @NotNull
    public static final Bitmap scaleIfNeeded(@NotNull Bitmap image, int maxHeight, int maxWidth) {
        Bitmap bitmap;
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        if (maxHeight < image.getHeight() || maxWidth < image.getWidth()) {
            float f = (float)maxWidth / (float)image.getWidth();
            float f2 = (float)maxHeight / (float)image.getHeight();
            boolean bl = false;
            float ratio = Math.min(f, f2);
            int width = MathKt.roundToInt((float)(ratio * (float)image.getWidth()));
            int height = MathKt.roundToInt((float)(ratio * (float)image.getHeight()));
            Bitmap bitmap2 = Bitmap.createScaledBitmap((Bitmap)image, (int)width, (int)height, (boolean)false);
            bitmap = bitmap2;
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"Bitmap.createScaledBitma\u2026           height, false)");
        } else {
            bitmap = image;
        }
        return bitmap;
    }

    private BitmapUtils() {
    }

    static {
        BitmapUtils bitmapUtils;
        INSTANCE = bitmapUtils = new BitmapUtils();
    }
}

