/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.util.bitmap;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b5\u00106J\u0019\u0010\u0005\u001a\u00020\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0019\u0010\n\u001a\u00020\t2\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0019\u0010\f\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0007\u00a2\u0006\u0004\b\f\u0010\rJ3\u0010\u0015\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J3\u0010\u001c\u001a\u0004\u0018\u00010\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001dJ+\u0010\u001c\u001a\u0004\u0018\u00010\u00072\b\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u001c\u0010 J+\u0010\u001c\u001a\u0004\u0018\u00010\u00072\b\u0010\u001f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u001c\u0010!J'\u0010&\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b&\u0010'J/\u0010*\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u00102\u0006\u0010)\u001a\u00020\u0010H\u0003\u00a2\u0006\u0004\b*\u0010+J%\u0010,\u001a\u0004\u0018\u00010\u00072\b\u0010\u0003\u001a\u0004\u0018\u00010\u00022\b\u0010#\u001a\u0004\u0018\u00010\"H\u0007\u00a2\u0006\u0004\b,\u0010-J\u0019\u00100\u001a\u0004\u0018\u00010\u00072\u0006\u0010/\u001a\u00020.H\u0007\u00a2\u0006\u0004\b0\u00101J'\u00104\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u00102\u001a\u00020\u00102\u0006\u00103\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b4\u0010!\u00a8\u00067"}, d2={"Lio/scanbot/sdk/util/bitmap/BitmapUtils;", "", "", "path", "Landroid/graphics/Rect;", "getBitmapBounds", "(Ljava/lang/String;)Landroid/graphics/Rect;", "Landroid/graphics/Bitmap;", "bitmap", "", "isBitmapValid", "(Landroid/graphics/Bitmap;)Z", "getContentBounds", "(Landroid/graphics/Bitmap;)Landroid/graphics/Rect;", "Landroid/graphics/Bitmap$CompressFormat;", "format", "", "quality", "Ljava/io/File;", "file", "", "compress", "(Landroid/graphics/Bitmap;Landroid/graphics/Bitmap$CompressFormat;ILjava/io/File;)V", "Landroid/content/res/Resources;", "res", "imageRes", "targetWidth", "targetHeight", "createPreview", "(Landroid/content/res/Resources;III)Landroid/graphics/Bitmap;", "", "image", "([BII)Landroid/graphics/Bitmap;", "(Landroid/graphics/Bitmap;II)Landroid/graphics/Bitmap;", "Landroid/graphics/BitmapFactory$Options;", "options", "reqWidth", "reqHeight", "calculateInSampleSize", "(Landroid/graphics/BitmapFactory$Options;II)I", "width", "height", "a", "(IIII)I", "decodeQuietly", "(Ljava/lang/String;Landroid/graphics/BitmapFactory$Options;)Landroid/graphics/Bitmap;", "Landroid/graphics/drawable/Drawable;", "drawable", "drawableToBitmap", "(Landroid/graphics/drawable/Drawable;)Landroid/graphics/Bitmap;", "maxHeight", "maxWidth", "scaleIfNeeded", "<init>", "()V", "sdk-common_release"})
public final class BitmapUtils {
    public static final BitmapUtils INSTANCE = new BitmapUtils();

    @JvmStatic
    @NotNull
    public static final Rect getBitmapBounds(@Nullable String string) {
        BitmapFactory.Options options;
        Rect rect = new Rect();
        BitmapFactory.Options options2 = options;
        options2();
        options2.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)string, (BitmapFactory.Options)options2);
        int n = options.outWidth;
        int n2 = options.outHeight;
        rect.set(0, 0, n, n2);
        return rect;
    }

    @JvmStatic
    public static final boolean isBitmapValid(@Nullable Bitmap bitmap) {
        return bitmap != null && !bitmap.isRecycled();
    }

    @JvmStatic
    @NotNull
    public static final Rect getContentBounds(@Nullable Bitmap bitmap) throws NullPointerException {
        if (bitmap != null) {
            Bitmap bitmap2 = bitmap;
            int n = bitmap2.getWidth();
            int n2 = bitmap2.getHeight();
            int n3 = 0;
            int n4 = 0;
            int n5 = bitmap2.getHeight();
            for (int i = 0; i < n5; ++i) {
                int n6 = bitmap.getWidth();
                for (int j = 0; j < n6; ++j) {
                    if (bitmap.getPixel(j, i) == 0) continue;
                    if (j < n) {
                        n = j;
                    }
                    if (i < n2) {
                        n2 = i;
                    }
                    if (j > n3) {
                        n3 = j;
                    }
                    if (i <= n4) continue;
                    n4 = i;
                }
            }
            return new Rect(n, n2, n3, n4);
        }
        throw new NullPointerException("Bitmap is null");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JvmStatic
    public static final void compress(@NotNull Bitmap bitmap, @Nullable Bitmap.CompressFormat compressFormat, int n, @Nullable File file) throws IOException {
        Throwable throwable2;
        FileOutputStream fileOutputStream;
        block5: {
            FileOutputStream fileOutputStream2;
            int n2;
            Bitmap.CompressFormat compressFormat2;
            Bitmap bitmap2;
            FileOutputStream fileOutputStream3;
            Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
            Object var4_4 = null;
            fileOutputStream = fileOutputStream3;
            try {
                bitmap2 = bitmap;
                compressFormat2 = compressFormat;
                n2 = n;
                FileOutputStream fileOutputStream4 = fileOutputStream;
                fileOutputStream2 = fileOutputStream4;
                fileOutputStream4(file);
            }
            catch (Throwable throwable2) {
                fileOutputStream = var4_4;
                break block5;
            }
            try {
                bitmap2.compress(compressFormat2, n2, (OutputStream)fileOutputStream2);
            }
            catch (Throwable throwable2) {
                break block5;
            }
            IOUtils.closeQuietly((OutputStream)fileOutputStream3);
            return;
        }
        IOUtils.closeQuietly((OutputStream)fileOutputStream);
        throw throwable2;
    }

    @JvmStatic
    @Nullable
    public static final Bitmap createPreview(@Nullable Resources resources, int n, int n2, int n3) {
        BitmapFactory.Options options;
        if (n <= 0) {
            return null;
        }
        BitmapFactory.Options options2 = options;
        options2();
        options2.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)resources, (int)n, (BitmapFactory.Options)options2);
        options.inSampleSize = BitmapUtils.calculateInSampleSize(options, n2, n3);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeResource((Resources)resources, (int)n, (BitmapFactory.Options)options2);
    }

    @JvmStatic
    @Nullable
    public static final Bitmap createPreview(@Nullable byte[] byArray, int n, int n2) {
        BitmapFactory.Options options;
        if (byArray == null) {
            return null;
        }
        BitmapFactory.Options options2 = options;
        options2();
        options2.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length, (BitmapFactory.Options)options2);
        options.inSampleSize = BitmapUtils.calculateInSampleSize(options, n, n2);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length, (BitmapFactory.Options)options2);
    }

    @JvmStatic
    @Nullable
    public static final Bitmap createPreview(@Nullable Bitmap bitmap, int n, int n2) {
        if (bitmap == null) {
            return null;
        }
        Bitmap bitmap2 = bitmap;
        int n3 = n;
        Bitmap bitmap3 = bitmap;
        n = bitmap3.getWidth();
        n = BitmapUtils.a(n3, n2, n, bitmap3.getHeight());
        return Bitmap.createScaledBitmap((Bitmap)bitmap2, (int)(bitmap2.getWidth() / n), (int)(bitmap.getHeight() / n), (boolean)false);
    }

    @JvmStatic
    public static final int calculateInSampleSize(@NotNull BitmapFactory.Options options, int n, int n2) {
        BitmapFactory.Options options2 = options;
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        int n3 = options2.outHeight;
        return BitmapUtils.a(n, n2, options2.outWidth, n3);
    }

    @JvmStatic
    private static final int a(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n3 > n4 ? 1 : 0;
        if (n6 != (n5 = n > n2)) {
            int n7 = n3;
            n3 = n4;
            n4 = n7;
        }
        n6 = 1;
        if (n4 > n2 || n3 > n) {
            int n8 = n3;
            n3 = n4 / 2;
            n4 = n8 / 2;
            while (n3 / n6 > n2 && n4 / n6 > n) {
                n6 *= 2;
            }
        }
        return n6;
    }

    @JvmStatic
    @Nullable
    public static final Bitmap decodeQuietly(@Nullable String string, @Nullable BitmapFactory.Options options) {
        File file;
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        File file2 = file;
        return new File(string).exists() && file2.isFile() ? BitmapFactory.decodeFile((String)string, (BitmapFactory.Options)options) : null;
    }

    @JvmStatic
    @Nullable
    public static final Bitmap drawableToBitmap(@NotNull Drawable drawable) {
        Canvas canvas;
        BitmapDrawable bitmapDrawable;
        Drawable drawable2 = drawable;
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"drawable");
        if (drawable2 instanceof BitmapDrawable && (bitmapDrawable = (BitmapDrawable)drawable).getBitmap() != null) {
            return bitmapDrawable.getBitmap().copy(Bitmap.Config.ARGB_8888, true);
        }
        if (drawable.getIntrinsicWidth() > 0 && drawable.getIntrinsicHeight() > 0) {
            bitmapDrawable = Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Intrinsics.checkNotNullExpressionValue((Object)bitmapDrawable, (String)"Bitmap.createBitmap(draw\u2026 Bitmap.Config.ARGB_8888)");
        } else {
            bitmapDrawable = Bitmap.Config.ARGB_8888;
            bitmapDrawable = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)bitmapDrawable);
            Intrinsics.checkNotNullExpressionValue((Object)bitmapDrawable, (String)"Bitmap.createBitmap(1, 1, Bitmap.Config.ARGB_8888)");
        }
        Drawable drawable3 = drawable;
        drawable = canvas;
        int n = new Canvas((Bitmap)bitmapDrawable).getWidth();
        int n2 = drawable.getHeight();
        drawable3.setBounds(0, 0, n, n2);
        drawable3.draw((Canvas)drawable);
        return bitmapDrawable;
    }

    @JvmStatic
    @NotNull
    public static final Bitmap scaleIfNeeded(@NotNull Bitmap bitmap, int n, int n2) {
        Bitmap bitmap2 = bitmap;
        Intrinsics.checkNotNullParameter((Object)bitmap2, (String)"image");
        if (n < bitmap2.getHeight() || n2 < bitmap.getWidth()) {
            float f = Math.min((float)n2 / (float)bitmap.getWidth(), (float)n / (float)bitmap.getHeight());
            int n3 = MathKt.roundToInt((float)(f * (float)bitmap.getWidth()));
            bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)n3, (int)MathKt.roundToInt((float)(f * (float)bitmap.getHeight())), (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"Bitmap.createScaledBitma\u2026           height, false)");
        }
        return bitmap;
    }

    private BitmapUtils() {
    }
}

