/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.util.view;

import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.PointF;
import io.scanbot.sdk.core.contourdetector.Line2D;
import java.util.ArrayList;
import java.util.List;

public class PolygonHelper {
    private static final int j = 35;
    private float[] a = new float[8];
    private Matrix b = new Matrix();
    private int c = 0;
    private int d = 0;
    private int e;
    private int f;
    private int g;
    private int h;
    private int i = 0;

    public static boolean checkPolygonSize(List<Point> list) {
        return !list.isEmpty() && Math.abs(list.get((int)1).x - list.get((int)0).x) > 35 && Math.abs(list.get((int)2).x - list.get((int)3).x) > 35 && Math.abs(list.get((int)3).y - list.get((int)0).y) > 35 && Math.abs(list.get((int)2).y - list.get((int)1).y) > 35;
    }

    public void setRotation(int n) {
        if (this.i == n) {
            return;
        }
        this.i = n;
        this.b.setRotate((float)n, 0.5f, 0.5f);
    }

    public void setImageSize(int n, int n2) {
        PolygonHelper polygonHelper = this;
        polygonHelper.c = n;
        polygonHelper.d = n2;
    }

    public void setLayout(int n, int n2, int n3, int n4) {
        this.e = n;
        this.f = n2;
        this.g = n3;
        this.h = n4;
        this.c = n3 - n;
        this.d = n4 - n2;
    }

    public void polygonToLinePoints(List<PointF> list, float[] fArray) {
        int n;
        int n2;
        for (n2 = 0; n2 < list.size(); ++n2) {
            PolygonHelper polygonHelper = this;
            int n3 = n2;
            n = n3 * 2;
            polygonHelper.a[n] = list.get((int)n3).x;
            polygonHelper.a[++n] = list.get((int)n2).y;
        }
        this.b.mapPoints(this.a);
        for (n2 = 0; n2 < list.size(); ++n2) {
            float[] fArray2 = fArray;
            n = n2 * 4;
            int n4 = this.e;
            int n5 = this.c;
            float[] fArray3 = this.a;
            int n6 = n2 * 2;
            fArray[n] = (float)n4 + (float)n5 * this.a[n6];
            int n7 = n + 1;
            int n8 = this.f;
            int n9 = n7;
            n7 = this.d;
            fArray2[n9] = (float)n8 + (float)n7 * fArray3[n6 + 1];
            fArray2[n + 2] = (float)n4 + (float)n5 * fArray3[(n6 + 2) % 8];
            fArray[n + 3] = (float)n8 + (float)n7 * fArray3[(n6 + 3) % 8];
        }
    }

    public void polygonToPoints(List<PointF> list, float[] fArray) {
        int n;
        int n2;
        for (n2 = 0; n2 < list.size(); ++n2) {
            PolygonHelper polygonHelper = this;
            int n3 = n2;
            n = n3 * 2;
            polygonHelper.a[n] = list.get((int)n3).x;
            polygonHelper.a[++n] = list.get((int)n2).y;
        }
        this.b.mapPoints(this.a);
        for (n2 = 0; n2 < list.size(); ++n2) {
            n = n2 * 2;
            float[] fArray2 = this.a;
            fArray[n] = (float)this.e + (float)this.c * this.a[n];
            fArray[++n] = (float)this.f + (float)this.d * fArray2[n];
        }
    }

    public void getDrawingPolygon(List<PointF> list, List<PointF> list2) {
        for (int i = 0; i < list2.size(); ++i) {
            PointF pointF = list.get(i);
            PointF pointF2 = list2.get(i);
            pointF2.x = pointF.x * (float)this.c;
            pointF2.y = pointF.y * (float)this.d;
        }
    }

    public void getPolygonFromDrawingPolygon(List<PointF> list, List<PointF> list2) {
        if (this.c <= 0 && this.d <= 0) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            PointF pointF = list2.get(i);
            PointF pointF2 = list.get(i);
            pointF.x = pointF2.x / (float)this.c;
            pointF.y = pointF2.y / (float)this.d;
        }
    }

    public List<Line2D> scaleLines(List<Line2D> arrayList) {
        ArrayList<Line2D> arrayList2;
        ArrayList<Line2D> arrayList3 = arrayList;
        arrayList = arrayList2;
        arrayList2 = new ArrayList<Line2D>();
        for (Line2D line2D : arrayList3) {
            PointF pointF = line2D.start;
            int n = this.e;
            int n2 = this.c;
            pointF.x = (float)n + (float)n2 * pointF.x;
            int n3 = this.f;
            int n4 = this.d;
            line2D.start.y = (float)n3 + (float)n4 * pointF.y;
            pointF = line2D.end;
            pointF.x = (float)n + (float)n2 * pointF.x;
            line2D.end.y = (float)n3 + (float)n4 * pointF.y;
            arrayList.add(line2D);
        }
        return arrayList;
    }

    public static class Line {
        private double a;
        private double b;
        private double c;
        private PointF d;

        public Line() {
            PointF pointF;
            Line line = pointF;
            pointF = new PointF();
            v1.d = line;
        }

        public PointF getIntersectionPoint(Line line) {
            PointF pointF = this.d;
            Line line2 = this;
            double d2 = line2.c;
            double d3 = line.b;
            double d4 = d2 * d3;
            double d5 = line2.b;
            double d6 = line.c;
            double d7 = line.a;
            double d8 = d5 * d7;
            double d9 = line2.a;
            pointF.x = (float)((d4 -= d5 * d6) / (d8 - d9 * d3));
            pointF.y = (float)((d9 * d6 - d2 * d7) / (d5 * d7 - d9 * d3));
            return pointF;
        }

        public void calculateLine(PointF pointF, PointF pointF2) {
            float f2 = pointF.y;
            float f3 = pointF2.y;
            this.a = f2 - f3;
            float f4 = pointF2.x;
            float f5 = pointF.x;
            this.b = f4 - f5;
            this.c = (f5 - f4) * f2 + (f3 - f2) * f5;
        }

        public double getDistanceToPoint(PointF pointF) {
            double d2 = this.a;
            if (d2 == 0.0 && this.b == 0.0) {
                return 0.0;
            }
            double d3 = this.a;
            double d4 = this.b;
            return Math.abs(d2 * (double)pointF.x + this.b * (double)pointF.y + this.c) / Math.sqrt(d3 * d3 + d4 * d4);
        }
    }

    public static class Edge {
        public PointF pointA;
        public PointF pointB;
        public PointF pointFarA;
        public PointF pointFarB;
        public Line edgeLine;
        public Line lineA;
        public Line lineB;
        private PointF a;
        public float prevX;
        public float prevY;
        public boolean isDetectedLine;

        public Edge() {
            PointF pointF;
            Line line;
            Line line2;
            Line line3;
            Object object = line3;
            line3 = new Line();
            v1.edgeLine = object;
            object = line2;
            line2 = new Line();
            v1.lineA = object;
            object = line;
            line = new Line();
            v1.lineB = object;
            object = pointF;
            pointF = new PointF();
            v1.a = object;
            v1.isDetectedLine = false;
        }

        public float getAngleInDegrees() {
            PointF pointF = edge.pointB;
            Edge edge = edge.pointA;
            float f2 = pointF.x - ((PointF)edge).x;
            return (float)(Math.toDegrees(Math.atan2(pointF.y - ((PointF)edge).y, f2)) + 90.0);
        }

        public PointF getHandle() {
            PointF pointF = edge.pointA;
            Edge edge = edge.pointB;
            edge.a.x = (pointF.x + ((PointF)edge).x) / 2.0f;
            edge.a.y = (pointF.y + ((PointF)edge).y) / 2.0f;
            return edge.a;
        }

        public boolean isHorizontal() {
            PointF pointF = edge.pointB;
            Edge edge = edge.pointA;
            float f2 = pointF.y - ((PointF)edge).y;
            return Math.abs(pointF.x - ((PointF)edge).x) > Math.abs(f2);
        }
    }
}

