/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.camera;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.LayoutTransition;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.PointF;
import android.util.AttributeSet;
import androidx.core.graphics.Insets;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.camera.FrameHandlerResult;
import io.scanbot.sdk.contourdetector.ContourDetectorFrameHandler;
import io.scanbot.sdk.core.contourdetector.DetectionStatus;
import io.scanbot.sdk.ui.camera.AdaptiveFinderOverlayViewKt;
import io.scanbot.sdk.ui.camera.FinderAspectRatio;
import io.scanbot.sdk.ui.camera.FinderOverlayView;
import io.scanbot.sdk.util.PolygonHelper;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u001e\u001a\u00020\u001d\u0012\b\u0010 \u001a\u0004\u0018\u00010\u001f\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006JK\u0010\u0012\u001a\u00020\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0007H\u0004\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0019\u0010\u0019\u001a\u00020\u00148\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u001c\u001a\u00020\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001b\u00a8\u0006#"}, d2={"Lio/scanbot/sdk/ui/camera/AdaptiveFinderOverlayView;", "Lio/scanbot/sdk/ui/camera/FinderOverlayView;", "Landroidx/core/graphics/Insets;", "insets", "", "a", "(Landroidx/core/graphics/Insets;)V", "", "Lio/scanbot/sdk/ui/camera/FinderAspectRatio;", "requiredAspectRatios", "Lio/scanbot/sdk/core/contourdetector/DetectionStatus;", "detectionStatus", "", "frameWidth", "frameHeight", "frameOrientation", "Landroid/graphics/PointF;", "polygon", "handleDetectionResult", "(Ljava/util/List;Lio/scanbot/sdk/core/contourdetector/DetectionStatus;IIILjava/util/List;)V", "Lio/scanbot/sdk/contourdetector/ContourDetectorFrameHandler$ResultHandler;", "b", "Lio/scanbot/sdk/contourdetector/ContourDetectorFrameHandler$ResultHandler;", "getContourDetectorFrameHandler", "()Lio/scanbot/sdk/contourdetector/ContourDetectorFrameHandler$ResultHandler;", "contourDetectorFrameHandler", "Landroid/animation/AnimatorSet;", "Landroid/animation/AnimatorSet;", "finderAnimation", "Landroid/content/Context;", "context", "Landroid/util/AttributeSet;", "attr", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "sdk-docdetection_release"})
public class AdaptiveFinderOverlayView
extends FinderOverlayView {
    private AnimatorSet a;
    @NotNull
    private final ContourDetectorFrameHandler.ResultHandler b;

    private final void a(Insets insets) {
        ValueAnimator valueAnimator;
        if (this.getOverlayRightPadding() == valueAnimator.right && this.getOverlayLeftPadding() == valueAnimator.left && this.getOverlayTopPadding() == valueAnimator.top && this.getOverlayBottomPadding() == valueAnimator.bottom) {
            return;
        }
        AdaptiveFinderOverlayView adaptiveFinderOverlayView = this;
        ValueAnimator valueAnimator2 = ValueAnimator.ofInt((int[])new int[]{this.getOverlayRightPadding(), valueAnimator.right});
        valueAnimator2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public final void onAnimationUpdate(ValueAnimator valueAnimator) {
                ValueAnimator valueAnimator2 = valueAnimator;
                Object object = object.this;
                Intrinsics.checkNotNullExpressionValue((Object)valueAnimator2, (String)"valueAnimator");
                Object object2 = valueAnimator2.getAnimatedValue();
                if (object2 != null) {
                    object.setOverlayRightPadding((Integer)object2);
                    return;
                }
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
            }
        });
        ValueAnimator valueAnimator3 = ValueAnimator.ofInt((int[])new int[]{this.getOverlayLeftPadding(), valueAnimator.left});
        valueAnimator3.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public final void onAnimationUpdate(ValueAnimator valueAnimator) {
                ValueAnimator valueAnimator2 = valueAnimator;
                Object object = object.this;
                Intrinsics.checkNotNullExpressionValue((Object)valueAnimator2, (String)"valueAnimator");
                Object object2 = valueAnimator2.getAnimatedValue();
                if (object2 != null) {
                    object.setOverlayLeftPadding((Integer)object2);
                    return;
                }
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
            }
        });
        ValueAnimator valueAnimator4 = ValueAnimator.ofInt((int[])new int[]{this.getOverlayTopPadding(), valueAnimator.top});
        valueAnimator4.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public final void onAnimationUpdate(ValueAnimator valueAnimator) {
                ValueAnimator valueAnimator2 = valueAnimator;
                Object object = object.this;
                Intrinsics.checkNotNullExpressionValue((Object)valueAnimator2, (String)"valueAnimator");
                Object object2 = valueAnimator2.getAnimatedValue();
                if (object2 != null) {
                    object.setOverlayTopPadding((Integer)object2);
                    return;
                }
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
            }
        });
        valueAnimator = ValueAnimator.ofInt((int[])new int[]{this.getOverlayBottomPadding(), valueAnimator.bottom});
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public final void onAnimationUpdate(ValueAnimator valueAnimator) {
                ValueAnimator valueAnimator2 = valueAnimator;
                AdaptiveFinderOverlayView adaptiveFinderOverlayView = this;
                Intrinsics.checkNotNullExpressionValue((Object)valueAnimator2, (String)"valueAnimator");
                Object object = valueAnimator2.getAnimatedValue();
                if (object != null) {
                    d d2 = this;
                    adaptiveFinderOverlayView.setOverlayBottomPadding((Integer)object);
                    d2.this.initPaintAndRect();
                    d2.this.invalidate();
                    d2.this.resizeContentViews();
                    return;
                }
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
            }
        });
        adaptiveFinderOverlayView.a.end();
        adaptiveFinderOverlayView.a.cancel();
        this.a = new AnimatorSet();
        this.a.playTogether(new Animator[]{valueAnimator2, valueAnimator3, valueAnimator4, valueAnimator});
        this.a.setDuration(200L);
        this.a.start();
    }

    /*
     * WARNING - void declaration
     */
    public AdaptiveFinderOverlayView(@NotNull Context context, @Nullable AttributeSet attr) {
        ContourDetectorFrameHandler.ResultHandler resultHandler;
        LayoutTransition layoutTransition;
        AnimatorSet animatorSet;
        void var2_2;
        Object object;
        AdaptiveFinderOverlayView adaptiveFinderOverlayView = this;
        Intrinsics.checkNotNullParameter((Object)object, (String)"context");
        super((Context)object, (AttributeSet)var2_2);
        object = animatorSet;
        animatorSet = new AnimatorSet();
        adaptiveFinderOverlayView.a = object;
        object = layoutTransition;
        new LayoutTransition().enableTransitionType(4);
        adaptiveFinderOverlayView.setLayoutTransition((LayoutTransition)object);
        object = resultHandler;
        resultHandler = new ContourDetectorFrameHandler.ResultHandler(){

            public final boolean handle(@NotNull FrameHandlerResult<ContourDetectorFrameHandler.DetectedFrame, SdkLicenseError> result) {
                FrameHandlerResult<ContourDetectorFrameHandler.DetectedFrame, SdkLicenseError> frameHandlerResult = result;
                Intrinsics.checkNotNullParameter(frameHandlerResult, (String)"result");
                if (frameHandlerResult instanceof FrameHandlerResult.Success) {
                    ContourDetectorFrameHandler.DetectedFrame detectedFrame;
                    detectedFrame = (ContourDetectorFrameHandler.DetectedFrame)((FrameHandlerResult.Success)detectedFrame).getValue();
                    Object object = object.this;
                    List<FinderAspectRatio> list = detectedFrame.requiredPageAspectRatios;
                    if (list == null || (list = AdaptiveFinderOverlayViewKt.toFinderAspectRatios(list)) == null) {
                        list = CollectionsKt.emptyList();
                    }
                    Object object2 = object;
                    ContourDetectorFrameHandler.DetectedFrame detectedFrame2 = detectedFrame;
                    object = detectedFrame2.detectionStatus;
                    int n = detectedFrame2.frameWidth;
                    int n2 = detectedFrame2.frameHeight;
                    int n3 = detectedFrame2.frameOrientation;
                    List<PointF> list2 = detectedFrame2.polygon;
                    ((AdaptiveFinderOverlayView)((Object)object2)).handleDetectionResult(list, (DetectionStatus)object, n, n2, n3, list2);
                }
                return false;
            }
        };
        adaptiveFinderOverlayView.b = object;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$animatePaddingChanges(AdaptiveFinderOverlayView $this, Insets insets) {
        void var1_1;
        $this.a((Insets)var1_1);
    }

    @NotNull
    public final ContourDetectorFrameHandler.ResultHandler getContourDetectorFrameHandler() {
        return this.b;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public final void handleDetectionResult(@NotNull List<FinderAspectRatio> requiredAspectRatios, @NotNull DetectionStatus detectionStatus, int frameWidth, int frameHeight, int frameOrientation, @NotNull List<? extends PointF> polygon) {
        void var3_15;
        void var5_22;
        void var4_19;
        void var3_6;
        FinderAspectRatio finderAspectRatio;
        void var2_4;
        List list;
        Intrinsics.checkNotNullParameter((Object)list, (String)"requiredAspectRatios");
        Intrinsics.checkNotNullParameter((Object)var2_4, (String)"detectionStatus");
        Intrinsics.checkNotNullParameter((Object)finderAspectRatio, (String)"polygon");
        if (this.getFixedFinderWidthInPx() > 0 && this.getFixedFinderHeightInPx() > 0) {
            return;
        }
        if (list.isEmpty() ^ true) {
            this.setRequiredAspectRatiosInternal(list);
        }
        if ((list = this.getRequiredAspectRatios()) == null) return;
        if (list.isEmpty()) return;
        if (this.a.isRunning()) {
            return;
        }
        if (!(finderAspectRatio.isEmpty() ^ true)) return;
        if (var2_4 != DetectionStatus.OK && var2_4 != DetectionStatus.OK_BUT_BAD_ANGLES && var2_4 != DetectionStatus.OK_BUT_BAD_ASPECT_RATIO && var2_4 != DetectionStatus.OK_BUT_TOO_SMALL) {
            if (var2_4 != DetectionStatus.OK_OFF_CENTER) return;
        }
        Pair pair = this.calculatePreviewFrameSize();
        int n = ((Number)pair.component1()).intValue();
        int n2 = ((Number)pair.component2()).intValue();
        int n3 = n2;
        int n4 = n;
        AdaptiveFinderOverlayView adaptiveFinderOverlayView = this;
        n3 = (adaptiveFinderOverlayView.getMeasuredHeight() - n3) / 2;
        n = (adaptiveFinderOverlayView.getMeasuredWidth() - n) / 2;
        Pair pair2 = adaptiveFinderOverlayView.calculateTotalPaddings(n, n3);
        int n5 = ((Number)pair2.component2()).intValue();
        int n6 = n4 - ((Number)pair2.component1()).intValue();
        n5 = n2 - n5;
        double d2 = (double)n6 / (double)n5;
        float f2 = PolygonHelper.Companion.approximatePolygonAspectRatio((List)finderAspectRatio, (int)var3_6, (int)var4_19, (int)var5_22);
        Iterator iterator = list.iterator();
        if (!iterator.hasNext()) {
            Object var3_8 = null;
        } else {
            Iterator iterator2 = iterator;
            Object t = iterator2.next();
            if (!iterator2.hasNext()) {
                Object t2 = t;
            } else {
                FinderAspectRatio finderAspectRatio2 = (FinderAspectRatio)t;
                double d3 = f2;
                double d4 = Math.abs(d3 - finderAspectRatio2.getWidth() / finderAspectRatio2.getHeight());
                while (true) {
                    void var3_14;
                    Object t3;
                    double d5;
                    if (Double.compare(d4, d5 = Math.abs(d3 - (finderAspectRatio = (FinderAspectRatio)(t3 = iterator.next())).getWidth() / finderAspectRatio.getHeight())) <= 0) {
                        void var5_24;
                        void var3_13 = var5_24;
                        d5 = d4;
                    }
                    if (!iterator.hasNext()) break;
                    void var5_26 = var3_14;
                    d4 = d5;
                }
            }
        }
        FinderAspectRatio finderAspectRatio3 = (FinderAspectRatio)var3_15;
        if (finderAspectRatio3 != null) {
            d2 = finderAspectRatio3.getWidth() / finderAspectRatio3.getHeight();
        }
        AdaptiveFinderOverlayView adaptiveFinderOverlayView2 = this;
        Pair pair3 = adaptiveFinderOverlayView2.calculateTargetSize(d2, n5, n6);
        int n7 = ((Number)pair3.component1()).intValue();
        int n8 = ((Number)pair3.component2()).intValue();
        n8 = (n5 - n8) / 2;
        int n9 = adaptiveFinderOverlayView2.getFinderInsets().top + n8 + Math.max(this.getSafeAreaInsets().top, n3);
        n3 = adaptiveFinderOverlayView2.getFinderInsets().bottom + n8 + Math.max(this.getSafeAreaInsets().bottom, n3);
        int n10 = (n6 - n7) / 2;
        int n11 = adaptiveFinderOverlayView2.getFinderInsets().left + n10 + Math.max(this.getSafeAreaInsets().left, n);
        n = this.getFinderInsets().right + n10 + Math.max(this.getSafeAreaInsets().right, n);
        Insets.of((int)n11, (int)n9, (int)n, (int)n3);
        final Insets insets = Insets.of((int)n11, (int)n9, (int)n, (int)n3);
        Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"Insets.of(paddingLeft, p\u2026dingRight, paddingBottom)");
        adaptiveFinderOverlayView2.post(new Runnable(){

            @Override
            public final void run() {
                AdaptiveFinderOverlayView.access$animatePaddingChanges(this, insets);
            }
        });
    }
}

