/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.docprocessing;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import io.scanbot.sdk.docdetection.R;
import io.scanbot.sdk.docprocessing.DocumentProcessingResult;
import io.scanbot.sdk.docprocessing.ProcessorMonitor;
import io.scanbot.sdk.docprocessing.compose.Composer;
import io.scanbot.sdk.docprocessing.compose.ComposerFactory;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.DocumentDraft;
import io.scanbot.sdk.entity.Page;
import io.scanbot.sdk.persistence.DocumentStoreStrategy;
import io.scanbot.sdk.persistence.PageStoreStrategy;
import io.scanbot.sdk.persistence.cleanup.Cleaner;
import io.scanbot.sdk.util.bitmap.BitmapLruCache;
import io.scanbot.sdk.util.bitmap.BitmapUtils;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

public class DocumentProcessor {
    private final DocumentStoreStrategy documentStoreStrategy;
    private final BitmapLruCache bitmapLruCache;
    private final ComposerFactory composerFactory;
    private final ThumbnailGenerator thumbnailGenerator;
    private final ProcessorMonitor<Document> documentProcessorMonitor;
    private final Cleaner cleaner;
    private final Logger logger = LoggerProvider.getLogger();

    @Inject
    public DocumentProcessor(DocumentStoreStrategy documentStoreStrategy, PageStoreStrategy pageStoreStrategy, Resources resources, BitmapLruCache bitmapLruCache, ComposerFactory composerFactory, ProcessorMonitor<Document> documentProcessorMonitor, Cleaner cleaner) {
        this.documentStoreStrategy = documentStoreStrategy;
        this.bitmapLruCache = bitmapLruCache;
        this.composerFactory = composerFactory;
        this.documentProcessorMonitor = documentProcessorMonitor;
        this.cleaner = cleaner;
        this.thumbnailGenerator = new ThumbnailGenerator(resources, documentStoreStrategy, pageStoreStrategy);
    }

    public DocumentProcessingResult processDocument(@NotNull DocumentDraft documentDraft) throws IOException {
        Document document = documentDraft.getDocument();
        Page[] pages = documentDraft.getPages();
        this.performProcessing(document, pages);
        this.documentProcessorMonitor.onProcessed(document);
        this.bitmapLruCache.evictAll();
        this.cleaner.cleanUpPagesData(pages);
        return new DocumentProcessingResult(document, Arrays.asList(pages), this.documentStoreStrategy.getDocumentFile(document.getId(), document.getName()));
    }

    private void performProcessing(Document document, Page[] pages) throws IOException {
        this.documentStoreStrategy.ensureDocumentDirectory(document.getId());
        if (document.getSize() < 0L) {
            for (int i = 0; i < pages.length; ++i) {
                Page page = pages[i];
                if (i != 0) continue;
                this.thumbnailGenerator.generateThumbnail(document, page);
            }
        }
        Composer composer = this.composerFactory.composerForDocument(document);
        this.logger.d("Processing", "(" + document.getName() + ") Using composer: " + composer.getClass().getSimpleName());
        composer.composeDocument(document, pages);
    }

    private static class ThumbnailGenerator {
        private final Resources resources;
        private final DocumentStoreStrategy documentStoreStrategy;
        private PageStoreStrategy pageStoreStrategy;

        ThumbnailGenerator(Resources resources, DocumentStoreStrategy documentStoreStrategy, PageStoreStrategy pageStoreStrategy) {
            this.resources = resources;
            this.documentStoreStrategy = documentStoreStrategy;
            this.pageStoreStrategy = pageStoreStrategy;
        }

        private void generateThumbnail(Document document, Page page) throws IOException {
            int thumbnailSize = (int)this.resources.getDimension(R.dimen.document_thumbnail_size);
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            String imageFilePath = this.pageStoreStrategy.getImageFile(page.getId(), Page.ImageType.OPTIMIZED).getPath();
            BitmapFactory.decodeFile((String)imageFilePath, (BitmapFactory.Options)options);
            int maxSize = Math.max(options.outHeight, options.outWidth);
            int scaleFactor = maxSize / thumbnailSize;
            if (scaleFactor < 1) {
                scaleFactor = 1;
            }
            BitmapFactory.Options downscaledOptions = new BitmapFactory.Options();
            downscaledOptions.inSampleSize = scaleFactor;
            Bitmap optimized = BitmapFactory.decodeFile((String)imageFilePath, (BitmapFactory.Options)downscaledOptions);
            if (BitmapUtils.isBitmapValid((Bitmap)optimized)) {
                this.saveRotatedAndScaledBitmap(page.getRotationType().getDegrees(), thumbnailSize, optimized, this.documentStoreStrategy.getThumbnailFile(document.getId()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void saveRotatedAndScaledBitmap(int rotation, int maxDimension, Bitmap original, File file) throws FileNotFoundException {
            float scale = (float)maxDimension / (float)Math.max(original.getWidth(), original.getHeight());
            Matrix matrix = new Matrix();
            matrix.preRotate((float)rotation, (float)(original.getWidth() / 2), (float)(original.getHeight() / 2));
            matrix.postScale(scale, scale);
            Bitmap thumbnail = Bitmap.createBitmap((Bitmap)original, (int)0, (int)0, (int)original.getWidth(), (int)original.getHeight(), (Matrix)matrix, (boolean)true);
            FileOutputStream stream = new FileOutputStream(file);
            try {
                thumbnail.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)stream);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)stream);
            }
        }
    }
}

