/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.docprocessing.draft;

import android.content.SharedPreferences;
import io.scanbot.sdk.docprocessing.draft.DocumentDraftExtractor;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.DocumentDraft;
import io.scanbot.sdk.entity.OcrStatus;
import io.scanbot.sdk.entity.Page;
import io.scanbot.sdk.entity.SnappingDraft;
import java.util.UUID;
import javax.inject.Inject;

public class MultipleDocumentsDraftExtractor
implements DocumentDraftExtractor {
    private final String extension;

    public static MultipleDocumentsDraftExtractor forPdf() {
        return new MultipleDocumentsDraftExtractor(".pdf");
    }

    public static MultipleDocumentsDraftExtractor forJpeg() {
        return new MultipleDocumentsDraftExtractor(".jpg");
    }

    @Inject
    public MultipleDocumentsDraftExtractor(SharedPreferences sharedPreferences) {
        this(sharedPreferences.getBoolean("SAVE_SINGLE_AS_JPEG", false) ? ".jpg" : ".pdf");
    }

    private MultipleDocumentsDraftExtractor(String extension) {
        this.extension = extension;
    }

    @Override
    public DocumentDraft[] extract(SnappingDraft draft) {
        DocumentDraft[] documentMetadatas = new DocumentDraft[draft.size()];
        for (int i = 0; i < documentMetadatas.length; ++i) {
            Document document = this.createDocument(draft.getDocumentName() + this.extension, 1);
            documentMetadatas[i] = new DocumentDraft(document, new Page[]{draft.getPage(i)});
        }
        return documentMetadatas;
    }

    private Document createDocument(String name, int size) {
        Document document = new Document();
        document.setId(UUID.randomUUID().toString());
        document.setName(name);
        document.setPagesCount(size);
        document.setOcrStatus(OcrStatus.NOT_SCHEDULED);
        return document;
    }
}

